/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm.portability;

import com.ibm.ejs.cm.DataSourceProperties;
import com.ibm.ejs.cm.pool.ConnectO;
import com.ibm.ejs.cm.portability.DB2390LocalPortabilityLayer;
import com.ibm.ejs.cm.portability.DB2ConnectPortabilityLayer;
import com.ibm.ejs.cm.portability.DuplicateKeyException;
import com.ibm.ejs.cm.portability.PortabilityLayer;
import com.ibm.ejs.cm.portability.PortabilityLayerImpl;
import com.ibm.ejs.cm.portability.PrimarykeyAlreadyDefinedException;
import com.ibm.ejs.cm.portability.ResourceAllocationException;
import com.ibm.ejs.cm.portability.TableAlreadyExistsException;
import com.ibm.ejs.cm.portability.TableDoesNotExistException;
import com.ibm.ejs.cm.proxy.ConnectionProxy;
import com.ibm.ejs.cm.proxy.DB2ConnectionProxy;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;

class DB2PortabilityLayer
extends PortabilityLayerImpl {
    private static DB2PortabilityLayer instance;
    private static final TraceComponent tc;

    protected DB2PortabilityLayer() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.errorMap.put(new Integer(-803), DuplicateKeyException.class);
        this.errorMap.put(new Integer(-601), TableAlreadyExistsException.class);
        this.errorMap.put(new Integer(-954), ResourceAllocationException.class);
        this.errorMap.put(new Integer(-1040), ResourceAllocationException.class);
        this.errorMap.put(new Integer(-624), PrimarykeyAlreadyDefinedException.class);
        this.errorMap.put(new Integer(-204), TableDoesNotExistException.class);
        this.errorMap.put(new Integer(-1015), StaleConnectionException.class);
        this.errorMap.put(new Integer(-1034), StaleConnectionException.class);
        this.errorMap.put(new Integer(-1035), StaleConnectionException.class);
        this.errorMap.put(new Integer(-6036), StaleConnectionException.class);
        this.errorMap.put(new Integer(-30081), StaleConnectionException.class);
        this.errorMap.put(new Integer(-1224), StaleConnectionException.class);
        this.errorMap.put(new Integer(-1229), StaleConnectionException.class);
        this.errorMap.put("08506", StaleConnectionException.class);
        this.errorMap.put("58004", StaleConnectionException.class);
        this.errorMap.put("08S01", StaleConnectionException.class);
        this.typeMap.setElementAt(" BLOB(1M) ", 9);
        this.typeMap.setElementAt(" BLOB(2K) ", 10);
        if (!System.getProperty("os.name").equals("OS/400")) {
            this.defaultDataSourceProps.setProperty("connectionAttribute", "cursorhold=0");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    static PortabilityLayer getPortabilityLayer(Connection connection) throws SQLException {
        String string;
        DatabaseMetaData databaseMetaData;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPortabilityLayer", connection);
        }
        if ((databaseMetaData = connection.getMetaData()) != null && (string = databaseMetaData.getDatabaseProductName()) != null) {
            if (string.equalsIgnoreCase("DB2")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getPortabilityLayer", "DB2ConnectPortabilityLayer - 390");
                }
                PortabilityLayer portabilityLayer = DB2ConnectPortabilityLayer.getInstance();
                ((DB2ConnectPortabilityLayer)portabilityLayer).setIs390(1);
                return portabilityLayer;
            }
            if (string.equalsIgnoreCase("AS")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getPortabilityLayer", "DB2ConnectPortabilityLayer - AS");
                }
                PortabilityLayer portabilityLayer = DB2ConnectPortabilityLayer.getInstance();
                ((DB2ConnectPortabilityLayer)portabilityLayer).setIs390(-1);
                return portabilityLayer;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPortabilityLayer", "DB2PortabilityLayer");
        }
        return DB2PortabilityLayer.getInstance();
    }

    public static PortabilityLayer getInstance(DataSourceProperties dataSourceProperties) throws SQLException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance", dataSourceProperties);
        }
        PortabilityLayer portabilityLayer = null;
        String string2 = dataSourceProperties.getDataSourceClassName();
        portabilityLayer = string2.equals("com.ibm.db2.jcc.DB2ConnectionPoolDataSource") ? ((string = dataSourceProperties.getProperty("driverType")) == null ? DB2390LocalPortabilityLayer.getInstance() : PortabilityLayerImpl.getInstance(dataSourceProperties)) : PortabilityLayerImpl.getInstance(dataSourceProperties);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance", portabilityLayer);
        }
        return portabilityLayer;
    }

    public static PortabilityLayer getInstance() throws SQLException {
        if (instance == null) {
            instance = new DB2PortabilityLayer();
        }
        return instance;
    }

    public ConnectionProxy createConnectionProxy(ConnectO connectO) {
        return new DB2ConnectionProxy(connectO);
    }

    static {
        tc = Tr.register(DB2PortabilityLayer.class);
    }
}

