/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm.portability;

import com.ibm.ejs.cm.portability.DB2ConnectPortabilityLayer;
import com.ibm.ejs.cm.portability.DB2PortabilityLayer;
import com.ibm.ejs.cm.portability.DB2UniversalConnectPortabilityLayer;
import com.ibm.ejs.cm.portability.PortabilityLayer;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;

class DB2UniversalPortabilityLayer
extends DB2PortabilityLayer {
    private static DB2UniversalPortabilityLayer instance;
    private static final TraceComponent tc;

    protected DB2UniversalPortabilityLayer() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.errorMap.remove(new Integer(-30081));
        this.errorMap.put(new Integer(-4499), StaleConnectionException.class);
        this.defaultDataSourceProps.remove("connectionAttribute");
        this.defaultDataSourceProps.setProperty("resultSetHoldability", "2");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    static PortabilityLayer getPortabilityLayer(Connection connection) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPortabilityLayer", connection);
        }
        PortabilityLayer portabilityLayer = null;
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String string = databaseMetaData.getDatabaseProductName();
        if (tc.isEventEnabled()) {
            Tr.event(tc, "getPortabilityLayer", string);
        }
        if (string != null) {
            if ((string = string.toUpperCase()).equals("DB2") || string.startsWith("DSN")) {
                portabilityLayer = DB2UniversalConnectPortabilityLayer.getInstance();
                ((DB2ConnectPortabilityLayer)portabilityLayer).setIs390(1);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getPortabilityLayer", "DB2UniversalConnectPortabilityLayer - 390");
                }
                return portabilityLayer;
            }
            if (string.startsWith("AS") || string.startsWith("QSQ")) {
                portabilityLayer = DB2UniversalConnectPortabilityLayer.getInstance();
                ((DB2ConnectPortabilityLayer)portabilityLayer).setIs390(-1);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getPortabilityLayer", "DB2UniversalConnectPortabilityLayer - AS");
                }
                return portabilityLayer;
            }
        }
        portabilityLayer = DB2UniversalPortabilityLayer.getInstance();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPortabilityLayer - DB2UniversalPortabilityLayer");
        }
        return portabilityLayer;
    }

    public static PortabilityLayer getInstance() throws SQLException {
        if (instance == null) {
            instance = new DB2UniversalPortabilityLayer();
        }
        return instance;
    }

    static {
        tc = Tr.register(DB2UniversalPortabilityLayer.class);
    }
}

