/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm.portability;

import com.ibm.ejs.cm.portability.PortabilityLayer;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.sql.SQLException;
import java.util.Hashtable;

public class ErrorMap {
    private static final TraceComponent tc = Tr.register(ErrorMap.class, null, "com.ibm.ejs.resources.CONMMessages");
    Hashtable customErrorMap = null;
    PortabilityLayer portabilityLayer;

    public static ErrorMap createErrorMap(PortabilityLayer portabilityLayer) {
        return new ErrorMap(portabilityLayer);
    }

    public static ErrorMap createErrorMap(PortabilityLayer portabilityLayer, Hashtable hashtable) {
        return new ErrorMap(portabilityLayer, hashtable);
    }

    private ErrorMap() {
    }

    private ErrorMap(PortabilityLayer portabilityLayer) {
        this(portabilityLayer, null);
    }

    private ErrorMap(PortabilityLayer portabilityLayer, Hashtable hashtable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{portabilityLayer, hashtable});
        }
        if (portabilityLayer == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "<init> - Invalid PortabilityLayer");
            }
            throw new IllegalArgumentException();
        }
        this.portabilityLayer = portabilityLayer;
        if (hashtable != null) {
            this.customErrorMap = (Hashtable)hashtable.clone();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public void addMap(String string, Class clazz) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addMap: " + string + ", " + clazz.getName());
        }
        if (this.customErrorMap == null) {
            this.customErrorMap = new Hashtable();
        }
        this.customErrorMap.put(string, clazz);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addMap");
        }
    }

    public void addMap(Hashtable hashtable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addMap: ", hashtable);
        }
        if (this.customErrorMap == null) {
            this.customErrorMap = (Hashtable)hashtable.clone();
        } else {
            this.customErrorMap.putAll(hashtable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addMap");
        }
    }

    public void removeMap(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeMap: " + string);
        }
        if (this.customErrorMap == null) {
            this.customErrorMap = new Hashtable();
        }
        this.customErrorMap.put(string, Void.class);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeMap");
        }
    }

    public final SQLException translateException(SQLException sQLException) throws SQLException {
        return this.portabilityLayer.translateException(sQLException, this.customErrorMap);
    }
}

