/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm.portability;

import com.ibm.ejs.cm.portability.IDBPooledConnection;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;

public class IDBConnectionHandle
implements Connection {
    private static final TraceComponent tc = Tr.register(IDBConnectionHandle.class, null, "com.ibm.ejs.resources.CONMMessages");
    private IDBPooledConnection pooledConn;
    private boolean closed = false;

    public void setHoldability(int n) throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "setHoldability(int)");
        throw new SQLException("This method is not supported.");
    }

    public int getHoldability() throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "getHoldability()");
        throw new SQLException("This method is not supported.");
    }

    public Savepoint setSavepoint() throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "setSavepoint()");
        throw new SQLException("This method is not supported.");
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "setSavepoint(String)");
        throw new SQLException("This method is not supported.");
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "rollback(Savepoint)");
        throw new SQLException("This method is not supported.");
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "releaseSavepoint(Savepoint)");
        throw new SQLException("This method is not supported.");
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "createStatement(int, int, int)");
        throw new SQLException("This method is not supported.");
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "prepareStatement(String, int, int, int)");
        throw new SQLException("This method is not supported.");
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "prepareCall(String, int, int, int)");
        throw new SQLException("This method is not supported.");
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "prepareStatement(String, int)");
        throw new SQLException("This method is not supported.");
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "prepareStatement(String, int)");
        throw new SQLException("This method is not supported.");
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "prepareStatement(String, String[])");
        throw new SQLException("This method is not supported.");
    }

    IDBConnectionHandle(IDBPooledConnection iDBPooledConnection) {
        this.pooledConn = iDBPooledConnection;
    }

    public Statement createStatement() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection already closed");
        }
        try {
            return this.pooledConn.getUnderlyingConnection().createStatement();
        }
        catch (SQLException sQLException) {
            this.pooledConn.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection already closed");
        }
        try {
            return this.pooledConn.getUnderlyingConnection().prepareStatement(string);
        }
        catch (SQLException sQLException) {
            this.pooledConn.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection already closed");
        }
        try {
            return this.pooledConn.getUnderlyingConnection().prepareCall(string);
        }
        catch (SQLException sQLException) {
            this.pooledConn.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public String nativeSQL(String string) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection already closed");
        }
        try {
            return this.pooledConn.getUnderlyingConnection().nativeSQL(string);
        }
        catch (SQLException sQLException) {
            this.pooledConn.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection already closed");
        }
        try {
            this.pooledConn.getUnderlyingConnection().setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            this.pooledConn.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean getAutoCommit() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection already closed");
        }
        try {
            return this.pooledConn.getUnderlyingConnection().getAutoCommit();
        }
        catch (SQLException sQLException) {
            this.pooledConn.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void commit() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection already closed");
        }
        try {
            this.pooledConn.getUnderlyingConnection().commit();
        }
        catch (SQLException sQLException) {
            this.pooledConn.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void rollback() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection already closed");
        }
        try {
            this.pooledConn.getUnderlyingConnection().rollback();
        }
        catch (SQLException sQLException) {
            this.pooledConn.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void close() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection already closed");
        }
        this.closed = true;
        this.pooledConn.connectionHandleClosed();
    }

    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection already closed");
        }
        try {
            return this.pooledConn.getUnderlyingConnection().getMetaData();
        }
        catch (SQLException sQLException) {
            this.pooledConn.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void setReadOnly(boolean bl) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection already closed");
        }
        try {
            this.pooledConn.getUnderlyingConnection().setReadOnly(bl);
        }
        catch (SQLException sQLException) {
            this.pooledConn.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean isReadOnly() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection already closed");
        }
        try {
            return this.pooledConn.getUnderlyingConnection().isReadOnly();
        }
        catch (SQLException sQLException) {
            this.pooledConn.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void setCatalog(String string) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection already closed");
        }
        try {
            this.pooledConn.getUnderlyingConnection().setCatalog(string);
        }
        catch (SQLException sQLException) {
            this.pooledConn.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public String getCatalog() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection already closed");
        }
        try {
            return this.pooledConn.getUnderlyingConnection().getCatalog();
        }
        catch (SQLException sQLException) {
            this.pooledConn.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void setTransactionIsolation(int n) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection already closed");
        }
        try {
            this.pooledConn.getUnderlyingConnection().setTransactionIsolation(n);
        }
        catch (SQLException sQLException) {
            this.pooledConn.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getTransactionIsolation() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection already closed");
        }
        try {
            return this.pooledConn.getUnderlyingConnection().getTransactionIsolation();
        }
        catch (SQLException sQLException) {
            this.pooledConn.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection already closed");
        }
        try {
            return this.pooledConn.getUnderlyingConnection().getWarnings();
        }
        catch (SQLException sQLException) {
            this.pooledConn.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void clearWarnings() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection already closed");
        }
        try {
            this.pooledConn.getUnderlyingConnection().clearWarnings();
        }
        catch (SQLException sQLException) {
            this.pooledConn.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection already closed");
        }
        try {
            return this.pooledConn.getUnderlyingConnection().createStatement(n, n2);
        }
        catch (SQLException sQLException) {
            this.pooledConn.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection already closed");
        }
        try {
            return this.pooledConn.getUnderlyingConnection().prepareStatement(string, n, n2);
        }
        catch (SQLException sQLException) {
            this.pooledConn.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection already closed");
        }
        try {
            return this.pooledConn.getUnderlyingConnection().prepareCall(string, n, n2);
        }
        catch (SQLException sQLException) {
            this.pooledConn.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public Map getTypeMap() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection already closed");
        }
        try {
            return this.pooledConn.getUnderlyingConnection().getTypeMap();
        }
        catch (SQLException sQLException) {
            this.pooledConn.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection already closed");
        }
        try {
            this.pooledConn.getUnderlyingConnection().setTypeMap(map);
        }
        catch (SQLException sQLException) {
            this.pooledConn.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    void autoClose() {
        this.closed = true;
    }
}

