/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm.portability;

import com.ibm.ejs.cm.portability.IDBConnectionHandle;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Enumeration;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class IDBPooledConnection
implements PooledConnection {
    private static final TraceComponent tc = Tr.register(IDBPooledConnection.class);
    private Connection conn;
    private Vector listeners;
    private IDBConnectionHandle lastConnectionCreated;

    IDBPooledConnection(Connection connection) {
        this.conn = connection;
    }

    public Connection getConnection() throws SQLException {
        if (this.lastConnectionCreated != null) {
            this.lastConnectionCreated.autoClose();
        }
        this.lastConnectionCreated = new IDBConnectionHandle(this);
        return this.lastConnectionCreated;
    }

    public void close() throws SQLException {
        this.conn.close();
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(connectionEventListener);
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(connectionEventListener);
    }

    Connection getUnderlyingConnection() {
        return this.conn;
    }

    void exceptionOccurred(SQLException sQLException) {
        if (sQLException instanceof SQLWarning) {
            return;
        }
        if (this.listeners != null) {
            ConnectionEvent connectionEvent = new ConnectionEvent(this, sQLException);
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                ((ConnectionEventListener)enumeration.nextElement()).connectionErrorOccurred(connectionEvent);
            }
        }
    }

    void connectionHandleClosed() {
        if (this.listeners != null) {
            ConnectionEvent connectionEvent = new ConnectionEvent(this);
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                ((ConnectionEventListener)enumeration.nextElement()).connectionClosed(connectionEvent);
            }
        }
    }
}

