/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm.portability;

import com.ibm.ejs.cm.DataSourceProperties;
import com.ibm.ejs.cm.portability.DuplicateKeyException;
import com.ibm.ejs.cm.portability.PortabilityLayer;
import com.ibm.ejs.cm.portability.PortabilityLayerImpl;
import com.ibm.ejs.cm.portability.PortableSQLException;
import com.ibm.ejs.cm.portability.TableAlreadyExistsException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.lang.reflect.Constructor;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;

final class IDBPortabilityLayer
extends PortabilityLayerImpl {
    private static IDBPortabilityLayer instance;
    private static final TraceComponent tc;

    protected IDBPortabilityLayer() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.typeMap.setElementAt(" VARCHAR(4096) NOT NULL ", 7);
        this.typeMap.setElementAt(" VARCHAR(4096) ", 8);
        this.typeMap.setElementAt(" BINARY ", 9);
        this.typeMap.setElementAt(" BINARY ", 10);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public SQLException translateException(SQLException sQLException, Hashtable hashtable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "translateException", sQLException);
        }
        if (sQLException instanceof PortableSQLException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "translateException: Already translated");
            }
            return sQLException;
        }
        if (sQLException instanceof BatchUpdateException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "translateException: Not translating java.sql.BatchUpdateException");
            }
            return sQLException;
        }
        Class clazz = null;
        String string = sQLException.getMessage();
        if (string != null) {
            if (string.startsWith("Table already exists:") || string.startsWith("Table alreacy exists:")) {
                Class clazz2 = clazz = TableAlreadyExistsException.class;
            }
            if (string.indexOf("already exists in column") >= 0 || string.indexOf("Row already exists:") >= 0) {
                Class clazz3 = clazz = DuplicateKeyException.class;
            }
        }
        if (clazz != null) {
            try {
                Class[] classArray = new Class[]{SQLException.class};
                Constructor constructor = clazz.getDeclaredConstructor(classArray);
                PortableSQLException portableSQLException = (PortableSQLException)constructor.newInstance(sQLException);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "translateException", portableSQLException);
                }
                return portableSQLException;
            }
            catch (Exception exception) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Exception instantiating exception", exception);
                }
                throw new Error(exception.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "translateException: No translation found");
        }
        return sQLException;
    }

    public void createTableForPersister(Connection connection, String string, String string2, String string3) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTableForPersister", new Object[]{connection, string, string2, string3});
        }
        String string4 = string3;
        String string5 = null;
        String string6 = null;
        if (string.endsWith(".")) {
            string5 = string + string2;
            string6 = string.substring(0, string.length() - 1);
        } else {
            string5 = string + "." + string2;
            string6 = string;
        }
        int n = string3.indexOf(string5);
        if (n != -1) {
            string4 = string3.substring(0, n) + string3.substring(n + string6.length() + 1);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "newsql: ", string4);
        }
        super.createTableForPersister(connection, string, string2, string4);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTableForPersister");
        }
    }

    public void setTransactionIsolation(Connection connection, int n) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTransactionIsolation", new Object[]{connection, new Integer(n)});
        }
        try {
            connection.setTransactionIsolation(n);
        }
        catch (SQLException sQLException) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "upgrade the isolationLevel to serializable");
            }
            try {
                connection.setTransactionIsolation(8);
            }
            catch (SQLException sQLException2) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setTransactionIsolation", sQLException2);
                }
                throw this.translateException(sQLException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTransactionIsolation");
        }
    }

    public String addRowLockHint(String string) {
        return string;
    }

    public boolean supportsRowLockHint() {
        return false;
    }

    public boolean supportsSchema() {
        return false;
    }

    public static PortabilityLayer getInstance(DataSourceProperties dataSourceProperties) throws SQLException {
        if (instance == null) {
            instance = new IDBPortabilityLayer();
        }
        return instance;
    }

    static {
        tc = Tr.register(IDBPortabilityLayer.class);
    }
}

