/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm.portability;

import com.ibm.ejs.cm.CMPropertiesImpl;
import com.ibm.ejs.cm.portability.DuplicateKeyException;
import com.ibm.ejs.cm.portability.HugeString;
import com.ibm.ejs.cm.portability.Informix7PortabilityLayer;
import com.ibm.ejs.cm.portability.PortabilityLayer;
import com.ibm.ejs.cm.portability.PortabilityLayerImpl;
import com.ibm.ejs.cm.portability.PrimarykeyAlreadyDefinedException;
import com.ibm.ejs.cm.portability.TableAlreadyExistsException;
import com.ibm.ejs.cm.portability.TableDoesNotExistException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

class InformixPortabilityLayer
extends PortabilityLayerImpl {
    private static InformixPortabilityLayer instance;
    private static final TraceComponent tc;

    protected InformixPortabilityLayer() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.typeMap.setElementAt(" TEXT NOT NULL", 5);
        this.typeMap.setElementAt(" TEXT ", 8);
        this.typeMap.setElementAt(" TEXT NOT NULL", 7);
        this.typeMap.setElementAt(" BYTE ", 9);
        this.typeMap.setElementAt(" BYTE ", 10);
        this.typeMap.setElementAt(" VARCHAR(255) NOT NULL ", 3);
        this.typeMap.setElementAt(" VARCHAR(255) ", 4);
        this.typeMap.setElementAt(" VARCHAR(255) NOT NULL ", 11);
        this.typeMap.setElementAt(" VARCHAR(255) ", 12);
        this.errorMap.put(new Integer(43012), StaleConnectionException.class);
        this.errorMap.put(new Integer(-908), StaleConnectionException.class);
        this.errorMap.put(new Integer(-25580), StaleConnectionException.class);
        this.errorMap.put(new Integer(-27002), StaleConnectionException.class);
        this.errorMap.put(new Integer(-43207), StaleConnectionException.class);
        this.errorMap.put(new Integer(-79716), StaleConnectionException.class);
        this.errorMap.put(new Integer(-79735), StaleConnectionException.class);
        this.errorMap.put(new Integer(-268), DuplicateKeyException.class);
        this.errorMap.put(new Integer(-310), TableAlreadyExistsException.class);
        this.errorMap.put(new Integer(-704), PrimarykeyAlreadyDefinedException.class);
        this.errorMap.put(new Integer(-206), TableDoesNotExistException.class);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public void configureConnection(Connection connection, CMPropertiesImpl cMPropertiesImpl) throws SQLException {
        Statement statement;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configureConnection", cMPropertiesImpl);
        }
        if ((n = cMPropertiesImpl.getInformixLockModeWait()) > 0) {
            statement = connection.createStatement();
            statement.execute("SET LOCK MODE TO WAIT " + n);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Lock mode set to wait " + n + " seconds");
            }
        } else if (n < 0) {
            statement = connection.createStatement();
            statement.execute("SET LOCK MODE TO WAIT");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Lock mode set to wait indefinately");
            }
        } else if (n == 0) {
            statement = connection.createStatement();
            statement.execute("SET LOCK MODE TO NOT WAIT");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Lock mode set to not wait");
            }
        }
        boolean bl = cMPropertiesImpl.getInformixAllowNewLine();
        if (bl) {
            Statement statement2 = connection.createStatement();
            statement2.execute("EXECUTE PROCEDURE IFX_ALLOW_NEWLINE('T')");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Allow New Line set to True.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configureConnection");
        }
    }

    public void setHugeStringForPreparedStatement(HugeString hugeString, PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setBytes(n, hugeString.getString().getBytes());
    }

    static PortabilityLayer getPortabilityLayer(Connection connection) throws SQLException {
        String string;
        DatabaseMetaData databaseMetaData;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPortabilityLayer in InformixPBL");
        }
        if ((databaseMetaData = connection.getMetaData()) != null && (string = databaseMetaData.getDatabaseProductName()) != null && string.equals("INFORMIX-OnLine")) {
            return Informix7PortabilityLayer.getInstance();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPortabilityLayer in InformixPBL");
        }
        return InformixPortabilityLayer.getInstance();
    }

    public static PortabilityLayer getInstance() throws SQLException {
        if (instance == null) {
            instance = new InformixPortabilityLayer();
        }
        return instance;
    }

    static {
        tc = Tr.register(InformixPortabilityLayer.class);
    }
}

