/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm.portability;

import com.ibm.ejs.cm.portability.DuplicateKeyException;
import com.ibm.ejs.cm.portability.PortabilityLayer;
import com.ibm.ejs.cm.portability.PortabilityLayerImpl;
import com.ibm.ejs.cm.portability.PrimarykeyAlreadyDefinedException;
import com.ibm.ejs.cm.portability.ResourceAllocationException;
import com.ibm.ejs.cm.portability.TableAlreadyExistsException;
import com.ibm.ejs.cm.portability.TableDoesNotExistException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.StringTokenizer;

class MSSQLPortabilityLayer
extends PortabilityLayerImpl {
    private static MSSQLPortabilityLayer instance;
    protected static final String FOR_UPDATE = "FOR UPDATE";
    protected static final String HOLDLOCK = "(UPDLOCK)";
    protected static final String WHERE = "WHERE";
    protected static final int CHAR_COUNT = 10;
    private static final TraceComponent tc;

    protected MSSQLPortabilityLayer() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.errorMap.put(new Integer(2714), TableAlreadyExistsException.class);
        this.errorMap.put(new Integer(2627), DuplicateKeyException.class);
        this.errorMap.put(new Integer(4), ResourceAllocationException.class);
        this.errorMap.put("08S01", StaleConnectionException.class);
        this.errorMap.put(new Integer(230), StaleConnectionException.class);
        this.errorMap.put(new Integer(1779), PrimarykeyAlreadyDefinedException.class);
        this.errorMap.put(new Integer(3701), TableDoesNotExistException.class);
        this.errorMap.put(new Integer(208), TableDoesNotExistException.class);
        this.errorMap.put(new Integer(4902), TableDoesNotExistException.class);
        this.typeMap.setElementAt(" TEXT NOT NULL ", 7);
        this.typeMap.setElementAt(" TEXT ", 8);
        this.typeMap.setElementAt(" IMAGE ", 9);
        this.typeMap.setElementAt(" VARBINARY(2048) ", 10);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public void createTable(Connection connection, String string, String string2) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTable", new Object[]{connection, string, string2});
        }
        String string3 = MSSQLPortabilityLayer.replaceString(string2, "BLOB(1M)", "IMAGE");
        super.createTable(connection, string, string3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTable");
        }
    }

    public void createTableForPersister(Connection connection, String string, String string2, String string3) throws SQLException {
        String string4;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTableForPersister", new Object[]{connection, string, string3});
        }
        if ((string4 = MSSQLPortabilityLayer.replaceString(string3, "BLOB(1M)", "IMAGE")).indexOf(" DOUBLE") > 0) {
            string4 = MSSQLPortabilityLayer.replaceString(string4, " DOUBLE ", " FLOAT ");
            string4 = MSSQLPortabilityLayer.replaceString(string4, " DOUBLE,", " FLOAT,");
            string4 = MSSQLPortabilityLayer.replaceString(string4, " DOUBLE(", " FLOAT(");
            string4 = MSSQLPortabilityLayer.replaceString(string4, " DOUBLE)", " FLOAT)");
        }
        if (string4.indexOf(" DATE") > 0) {
            string4 = MSSQLPortabilityLayer.replaceString(string4, " DATE ", " DATETIME ");
            string4 = MSSQLPortabilityLayer.replaceString(string4, " DATE,", " DATETIME,");
            string4 = MSSQLPortabilityLayer.replaceString(string4, " DATE)", " DATETIME)");
        }
        if (string4.indexOf(" TIME") > 0) {
            string4 = MSSQLPortabilityLayer.replaceString(string4, " TIME ", " DATETIME ");
            string4 = MSSQLPortabilityLayer.replaceString(string4, " TIME,", " DATETIME,");
            string4 = MSSQLPortabilityLayer.replaceString(string4, " TIME)", " DATETIME)");
        }
        super.createTableForPersister(connection, string, string2, string4);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTableForPersister");
        }
    }

    public String addRowLockHint(String string) {
        return string + FOR_UPDATE;
    }

    public boolean supportsRowLockHint() {
        return true;
    }

    public void setDate(PreparedStatement preparedStatement, int n, Date date, Calendar calendar) throws SQLException {
        Timestamp timestamp;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDate", new Object[]{preparedStatement, new Integer(n), date, calendar});
        }
        if ((timestamp = this.DateToTimestamp(date)) == null) {
            preparedStatement.setNull(n, 93);
        } else {
            preparedStatement.setTimestamp(n, timestamp, calendar);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDate");
        }
    }

    public void setDate(PreparedStatement preparedStatement, int n, Date date) throws SQLException {
        Timestamp timestamp;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDate", new Object[]{preparedStatement, new Integer(n), date});
        }
        if ((timestamp = this.DateToTimestamp(date)) == null) {
            preparedStatement.setNull(n, 93);
        } else {
            preparedStatement.setTimestamp(n, timestamp);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDate");
        }
    }

    public void setTime(PreparedStatement preparedStatement, int n, Time time, Calendar calendar) throws SQLException {
        Timestamp timestamp;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTime", new Object[]{preparedStatement, new Integer(n), time, calendar});
        }
        if ((timestamp = this.TimeToTimestamp(time)) == null) {
            preparedStatement.setNull(n, 93);
        } else {
            preparedStatement.setTimestamp(n, timestamp, calendar);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTime");
        }
    }

    public void setTime(PreparedStatement preparedStatement, int n, Time time) throws SQLException {
        Timestamp timestamp;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTime", new Object[]{preparedStatement, new Integer(n), time});
        }
        if ((timestamp = this.TimeToTimestamp(time)) == null) {
            preparedStatement.setNull(n, 93);
        } else {
            preparedStatement.setTimestamp(n, timestamp);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTime");
        }
    }

    public Date getDate(ResultSet resultSet, int n, Calendar calendar) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDate", new Object[]{resultSet, new Integer(n), calendar});
        }
        Timestamp timestamp = resultSet.getTimestamp(n, calendar);
        Date date = this.TimestampToDate(timestamp);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDate");
        }
        return date;
    }

    public Date getDate(ResultSet resultSet, String string, Calendar calendar) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDate", new Object[]{resultSet, string, calendar});
        }
        Timestamp timestamp = resultSet.getTimestamp(string, calendar);
        Date date = this.TimestampToDate(timestamp);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDate");
        }
        return date;
    }

    public Date getDate(ResultSet resultSet, int n) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDate", new Object[]{resultSet, new Integer(n)});
        }
        Timestamp timestamp = resultSet.getTimestamp(n);
        Date date = this.TimestampToDate(timestamp);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDate");
        }
        return date;
    }

    public Date getDate(ResultSet resultSet, String string) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDate", new Object[]{resultSet, string});
        }
        Timestamp timestamp = resultSet.getTimestamp(string);
        Date date = this.TimestampToDate(timestamp);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDate");
        }
        return date;
    }

    public Time getTime(ResultSet resultSet, int n, Calendar calendar) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTime", new Object[]{resultSet, new Integer(n), calendar});
        }
        Timestamp timestamp = resultSet.getTimestamp(n, calendar);
        Time time = this.TimestampToTime(timestamp);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTime");
        }
        return time;
    }

    public Time getTime(ResultSet resultSet, String string, Calendar calendar) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTime", new Object[]{resultSet, string, calendar});
        }
        Timestamp timestamp = resultSet.getTimestamp(string, calendar);
        Time time = this.TimestampToTime(timestamp);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTime");
        }
        return time;
    }

    public Time getTime(ResultSet resultSet, int n) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTime", new Object[]{resultSet, new Integer(n)});
        }
        Timestamp timestamp = resultSet.getTimestamp(n);
        Time time = this.TimestampToTime(timestamp);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTime");
        }
        return time;
    }

    public Time getTime(ResultSet resultSet, String string) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTime", new Object[]{resultSet, string});
        }
        Timestamp timestamp = resultSet.getTimestamp(string);
        Time time = this.TimestampToTime(timestamp);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTime");
        }
        return time;
    }

    public String scanSQL(String string) {
        int n;
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        string = string.toUpperCase();
        int n2 = 0;
        int n3 = 0;
        while ((n = string.indexOf(FOR_UPDATE, n2)) > 0) {
            int n4 = string.indexOf(WHERE, n2);
            if (n4 < 0 || n4 > n) {
                n4 = n;
            }
            n2 = n + 10;
            stringBuffer.delete(n + 14 * n3, n2 + 14 * n3);
            stringBuffer.insert(n4 + 14 * n3, "WITH (UPDLOCK, ROWLOCK) ");
            ++n3;
        }
        return stringBuffer.toString();
    }

    public String processSQL(String string, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processSQL - sqlString, isolevel, addForUpdate, addextendedforupdate: ", new Object[]{string, new Integer(n), new Boolean(bl), new Boolean(bl2)});
        }
        if (!bl || string == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processSQL - no change");
            }
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 24);
        stringBuffer.append(string);
        string = string.toUpperCase();
        int n2 = string.indexOf(WHERE, 0);
        if (n2 == -1) {
            stringBuffer.append(" WITH (UPDLOCK, ROWLOCK)");
        } else {
            stringBuffer.insert(n2, "WITH (UPDLOCK, ROWLOCK) ");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processSQL - The modified sqlString is: ", stringBuffer);
        }
        return new String(stringBuffer);
    }

    private Timestamp DateToTimestamp(Date date) {
        if (date == null) {
            return null;
        }
        final Date date2 = date;
        Timestamp timestamp = (Timestamp)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return Timestamp.valueOf(date2.toString() + " 00:00:00.0");
            }
        });
        return timestamp;
    }

    private Timestamp TimeToTimestamp(Time time) {
        if (time == null) {
            return null;
        }
        final Date date = new Date(System.currentTimeMillis());
        final Time time2 = time;
        Timestamp timestamp = (Timestamp)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return Timestamp.valueOf(date.toString() + " " + time2.toString() + ".0");
            }
        });
        return timestamp;
    }

    private Date TimestampToDate(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(timestamp.toString());
        String string = null;
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
        }
        final String string2 = string;
        return (Date)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return Date.valueOf(string2);
            }
        });
    }

    private Time TimestampToTime(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(timestamp.toString());
        String string = null;
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
        }
        int n = string.indexOf(46);
        final String string2 = string.substring(0, n);
        return (Time)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return Time.valueOf(string2);
            }
        });
    }

    public static PortabilityLayer getInstance() {
        if (instance == null) {
            instance = new MSSQLPortabilityLayer();
        }
        return instance;
    }

    static {
        tc = Tr.register(MSSQLPortabilityLayer.class);
    }
}

