/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm.portability;

import com.ibm.ejs.cm.CMPropertiesImpl;
import com.ibm.ejs.cm.DataSourceProperties;
import com.ibm.ejs.cm.pool.ConnectO;
import com.ibm.ejs.cm.portability.DuplicateKeyException;
import com.ibm.ejs.cm.portability.PortabilityLayer;
import com.ibm.ejs.cm.portability.PortabilityLayerImpl;
import com.ibm.ejs.cm.portability.PrimarykeyAlreadyDefinedException;
import com.ibm.ejs.cm.portability.ResourceAllocationException;
import com.ibm.ejs.cm.portability.TableAlreadyExistsException;
import com.ibm.ejs.cm.portability.TableDoesNotExistException;
import com.ibm.ejs.cm.proxy.ConnectionProxy;
import com.ibm.ejs.cm.proxy.OracleConnectionProxy;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;

public class OraclePortabilityLayer
extends PortabilityLayerImpl {
    private static OraclePortabilityLayer instance;
    private static Method stmtCacheSizeMethod;
    private static final TraceComponent tc;

    protected OraclePortabilityLayer() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.errorMap.put(new Integer(1), DuplicateKeyException.class);
        this.errorMap.put(new Integer(955), TableAlreadyExistsException.class);
        this.errorMap.put(new Integer(2260), PrimarykeyAlreadyDefinedException.class);
        this.errorMap.put(new Integer(942), TableDoesNotExistException.class);
        this.errorMap.put(new Integer(1000), ResourceAllocationException.class);
        this.errorMap.put(new Integer(20), ResourceAllocationException.class);
        this.errorMap.put(new Integer(28), StaleConnectionException.class);
        this.errorMap.put(new Integer(1012), StaleConnectionException.class);
        this.errorMap.put(new Integer(1014), StaleConnectionException.class);
        this.errorMap.put(new Integer(1033), StaleConnectionException.class);
        this.errorMap.put(new Integer(1034), StaleConnectionException.class);
        this.errorMap.put(new Integer(1035), StaleConnectionException.class);
        this.errorMap.put(new Integer(1089), StaleConnectionException.class);
        this.errorMap.put(new Integer(1090), StaleConnectionException.class);
        this.errorMap.put(new Integer(1092), StaleConnectionException.class);
        this.errorMap.put(new Integer(2068), StaleConnectionException.class);
        this.errorMap.put(new Integer(3113), StaleConnectionException.class);
        this.errorMap.put(new Integer(3114), StaleConnectionException.class);
        this.errorMap.put(new Integer(12541), StaleConnectionException.class);
        this.errorMap.put(new Integer(12560), StaleConnectionException.class);
        this.errorMap.put(new Integer(12571), StaleConnectionException.class);
        this.errorMap.put(new Integer(17002), StaleConnectionException.class);
        this.errorMap.put(new Integer(17008), StaleConnectionException.class);
        this.errorMap.put(new Integer(17009), StaleConnectionException.class);
        this.errorMap.put(new Integer(17410), StaleConnectionException.class);
        this.errorMap.put(new Integer(17401), StaleConnectionException.class);
        this.errorMap.put(new Integer(17430), StaleConnectionException.class);
        this.errorMap.put(new Integer(25408), StaleConnectionException.class);
        this.errorMap.put("Connection reset by peer", StaleConnectionException.class);
        this.typeMap.setElementAt(" LONG NOT NULL ", 7);
        this.typeMap.setElementAt(" LONG ", 8);
        this.typeMap.setElementAt(" LONG RAW ", 9);
        this.typeMap.setElementAt(" RAW(2000) ", 10);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public boolean checkCMPStoreOperation(String string, Connection connection, boolean bl) throws SQLException {
        boolean bl2 = false;
        if (!bl && connection.getTransactionIsolation() == 2) {
            bl2 = true;
            Tr.service(tc, "MSG_CONM_7009W", string);
        }
        return bl2;
    }

    public void setTransactionIsolation(Connection connection, int n) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTransactionIsolation", new Object[]{connection, new Integer(n)});
        }
        switch (n) {
            case 1: {
                n = 2;
                break;
            }
            case 4: {
                n = 8;
                break;
            }
        }
        super.setTransactionIsolation(connection, n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTransactionIsolation");
        }
    }

    public void configurePooledConnection(PooledConnection pooledConnection, CMPropertiesImpl cMPropertiesImpl) throws SQLException {
        this.setStmtCacheSize(pooledConnection, cMPropertiesImpl);
    }

    public void configureXAConnection(XAConnection xAConnection, CMPropertiesImpl cMPropertiesImpl) throws SQLException {
        this.setStmtCacheSize(xAConnection, cMPropertiesImpl);
    }

    private void setStmtCacheSize(Object object, CMPropertiesImpl cMPropertiesImpl) throws SQLException {
        int n = cMPropertiesImpl.getOracleStmtCacheSize();
        if (n == 0) {
            return;
        }
        try {
            if (stmtCacheSizeMethod == null) {
                Class<?> clazz = object.getClass();
                stmtCacheSizeMethod = clazz.getMethod("setStmtCacheSize", Integer.TYPE);
            }
            stmtCacheSizeMethod.invoke(object, new Integer(n));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Tr.error(tc, "MSG_CONM_7003W", new Object[]{"stmtCacheSize", object.getClass()});
            throw new SQLException("NoSuchMethodException: " + noSuchMethodException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            Tr.error(tc, "MSG_CONM_7004W", new Object[]{"stmtCacheSize", object.getClass(), "IllegalAccessException: " + illegalAccessException.getMessage()});
            throw new SQLException("IllegalAccessException: " + illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            String string = throwable.getClass().getName() + ": " + throwable.getMessage();
            Tr.error(tc, "MSG_CONM_7004W", new Object[]{"stmtCacheSize", object.getClass(), string});
            throw new SQLException(string);
        }
    }

    public int getPreferredIsolationLevel() {
        return 2;
    }

    public ConnectionProxy createConnectionProxy(ConnectO connectO) {
        return new OracleConnectionProxy(connectO);
    }

    public static PortabilityLayer getInstance(DataSourceProperties dataSourceProperties) throws SQLException {
        if (instance == null) {
            instance = new OraclePortabilityLayer();
        }
        return instance;
    }

    public static PortabilityLayer getInstance() throws SQLException {
        if (instance == null) {
            instance = new OraclePortabilityLayer();
        }
        return instance;
    }

    static {
        stmtCacheSizeMethod = null;
        tc = Tr.register(OraclePortabilityLayer.class, null, "com.ibm.ejs.resources.CONMMessages");
    }
}

