/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm.portability;

import com.ibm.ejs.cm.CMProperties;
import com.ibm.ejs.cm.CMPropertiesImpl;
import com.ibm.ejs.cm.DataSourceProperties;
import com.ibm.ejs.cm.cache.CachedStatement;
import com.ibm.ejs.cm.pool.ConnectO;
import com.ibm.ejs.cm.portability.ConnectionProxyFactory;
import com.ibm.ejs.cm.portability.DuplicateKeyException;
import com.ibm.ejs.cm.portability.GenericPortabilityLayer;
import com.ibm.ejs.cm.portability.HugeString;
import com.ibm.ejs.cm.portability.PortabilityLayer;
import com.ibm.ejs.cm.portability.PortabilityLayerFactory;
import com.ibm.ejs.cm.portability.PortableSQLException;
import com.ibm.ejs.cm.portability.ResourceAllocationException;
import com.ibm.ejs.cm.proxy.ConnectionProxy;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.ws.security.util.AccessController;
import java.lang.reflect.Constructor;
import java.security.PrivilegedAction;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

abstract class PortabilityLayerImpl
implements PortabilityLayer,
ConnectionProxyFactory {
    private static final Class[] setterParamList = new Class[]{String.class};
    protected Hashtable errorMap = new Hashtable();
    protected Vector typeMap = new Vector(13);
    protected String namedColumnSpec_cosnaming_name = "VARCHAR(255) not null";
    private static final int PROCESS_TYPE_ERROR_CODE = 0;
    private static final int PROCESS_TYPE_SQL_STATE = 1;
    protected final Properties defaultDataSourceProps = new Properties();
    private static final String bundleName = "com.ibm.ejs.resources.CONMMessages";
    private static final TraceComponent tc = Tr.register(PortabilityLayerImpl.class, null, "com.ibm.ejs.resources.CONMMessages");

    protected PortabilityLayerImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.typeMap.setSize(13);
        this.typeMap.setElementAt(" VARCHAR(64) NOT NULL ", 0);
        this.typeMap.setElementAt(" VARCHAR(64) NOT NULL ", 1);
        this.typeMap.setElementAt(" VARCHAR(64) ", 2);
        this.typeMap.setElementAt(" VARCHAR(256) NOT NULL ", 3);
        this.typeMap.setElementAt(" VARCHAR(256) ", 4);
        this.typeMap.setElementAt(" VARCHAR(1024) NOT NULL ", 5);
        this.typeMap.setElementAt(" VARCHAR(1024) ", 6);
        this.typeMap.setElementAt(" LONG VARCHAR NOT NULL ", 7);
        this.typeMap.setElementAt(" LONG VARCHAR ", 8);
        this.typeMap.setElementAt(" LONG VARBINARY ", 9);
        this.typeMap.setElementAt(" LONG VARBINARY ", 10);
        this.typeMap.setElementAt(" VARCHAR(256) NOT NULL ", 11);
        this.typeMap.setElementAt(" VARCHAR(256) ", 12);
        this.errorMap.put("57011", ResourceAllocationException.class);
        this.errorMap.put("57030", ResourceAllocationException.class);
        this.errorMap.put("55032", StaleConnectionException.class);
        this.errorMap.put("08001", StaleConnectionException.class);
        this.errorMap.put("08003", StaleConnectionException.class);
        this.errorMap.put("40003", StaleConnectionException.class);
        this.errorMap.put("S1000", StaleConnectionException.class);
        this.errorMap.put("08S01", StaleConnectionException.class);
        this.errorMap.put("23505", DuplicateKeyException.class);
        this.errorMap.put("08006", StaleConnectionException.class);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public SQLException translateException(SQLException sQLException) {
        return this.translateException(sQLException, null);
    }

    public SQLException translateException(SQLException sQLException, Hashtable hashtable) {
        Class[] classArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "translateException", new Object[]{"Error Code = " + sQLException.getErrorCode(), "SQL State  = " + sQLException.getSQLState(), sQLException});
        }
        if (sQLException instanceof PortableSQLException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "translateException: Already translated");
            }
            return sQLException;
        }
        if (sQLException instanceof BatchUpdateException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "translateException: Not translating java.sql.BatchUpdateException");
            }
            return sQLException;
        }
        SQLException sQLException2 = sQLException;
        Class clazz = null;
        Integer n = new Integer(sQLException.getErrorCode());
        String string = sQLException.getSQLState();
        String string2 = sQLException.getMessage();
        if (hashtable != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Trying vendor code in CUSTOM map");
            }
            clazz = this.processListOfExceptions(sQLException, hashtable, 0);
        }
        if (clazz == null && string != null && hashtable != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Trying SQL State in CUSTOM map");
            }
            clazz = this.processListOfExceptions(sQLException, hashtable, 1);
        }
        if (clazz == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Trying vendor code in DEFAULT map");
            }
            clazz = this.processListOfExceptions(sQLException, this.errorMap, 0);
        }
        if (clazz == null && string != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Trying SQL State in DEFAULT map");
            }
            clazz = this.processListOfExceptions(sQLException, this.errorMap, 1);
        }
        if (clazz == null) {
            classArray = null;
            classArray = sQLException.getNextException();
            if (classArray != null) {
                sQLException = classArray;
                n = new Integer(sQLException.getErrorCode());
                string = sQLException.getSQLState();
                string2 = sQLException.getMessage();
                if (hashtable != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Trying vendor code in CUSTOM map after get next exception");
                    }
                    clazz = this.processListOfExceptions(sQLException, hashtable, 0);
                }
                if (clazz == null && string != null && hashtable != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Trying SQL State in CUSTOM map afer get next exception");
                    }
                    clazz = this.processListOfExceptions(sQLException, hashtable, 1);
                }
                if (clazz == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Trying vendor code in DEFAULT map after get next exception");
                    }
                    clazz = this.processListOfExceptions(sQLException, this.errorMap, 0);
                }
                if (clazz == null && string != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Trying SQL State in DEFAULT map after get next exception");
                    }
                    clazz = this.processListOfExceptions(sQLException, this.errorMap, 1);
                }
            }
        }
        if (clazz == null && string2 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Trying detail message in DEFAULT map");
            }
            clazz = (Class)this.errorMap.get(string2);
        }
        if (clazz != null && !clazz.equals(Void.class)) {
            try {
                classArray = new Class[]{SQLException.class};
                Constructor constructor = clazz.getDeclaredConstructor(classArray);
                PortableSQLException portableSQLException = (PortableSQLException)constructor.newInstance(sQLException);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "translateException", portableSQLException);
                }
                return portableSQLException;
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "Exception instantiating exception", exception);
                }
                throw new Error(exception.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "translateException: No translation found");
        }
        return sQLException2;
    }

    private Class processListOfExceptions(SQLException sQLException, Hashtable hashtable, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processListOfExceptions");
        }
        SQLException sQLException2 = sQLException;
        Object object = null;
        String string = null;
        Integer n2 = null;
        while (true) {
            if (sQLException2 != null) {
                if (n == 1) {
                    string = sQLException2.getSQLState();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Processing SQLState", string);
                    }
                    object = hashtable.get(string);
                } else {
                    n2 = new Integer(sQLException2.getErrorCode());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Processing errorCode", n2);
                    }
                    object = hashtable.get(n2);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No next exception to translate, do not translate");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "processListOfExceptions", null);
                }
                return null;
            }
            if (object == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No translatable exception found, do not translate");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "processListOfExceptions", null);
                }
                return null;
            }
            if (object.equals(class$java$lang$Void == null ? PortabilityLayerImpl.class$("java.lang.Void") : class$java$lang$Void)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Void translate found, no further translation required");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "processListOfExceptions", null);
                }
                return (Class)object;
            }
            if (!(object instanceof String) || !((String)object).equals("MaybeStale")) break;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Possible translation for exception, continue through chain");
            }
            sQLException2 = sQLException2.getNextException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Exception Translated");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processListOfExceptions", (Class)object);
        }
        return (Class)object;
    }

    public void createTable(Connection connection, String string, String string2, String string3) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTable", new Object[]{connection, string, string2, string3});
        }
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.executeUpdate(string3);
        }
        catch (SQLException sQLException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTable", sQLException);
            }
            throw this.translateException(sQLException);
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTable");
        }
    }

    public void createTable(Connection connection, String string, String string2) throws SQLException {
        Object[] objectArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTable", new Object[]{connection, string, string2});
        }
        if (this.supportsSchema()) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = string;
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = "";
        }
        final Object[] objectArray4 = objectArray;
        final String string3 = string2;
        String string4 = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return MessageFormat.format(string3, objectArray4);
            }
        });
        this.createTable(connection, string, null, string4);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTable");
        }
    }

    public void createTableForPersister(Connection connection, String string, String string2, String string3) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTableForPersister", new Object[]{connection, string, string2, string3});
        }
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.executeUpdate(string3);
        }
        catch (SQLException sQLException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTableForPersister", sQLException);
            }
            throw this.translateException(sQLException);
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTableForPersister");
        }
    }

    public void setTransactionIsolation(Connection connection, int n) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTransactionIsolation", new Object[]{connection, new Integer(n)});
        }
        try {
            connection.setTransactionIsolation(n);
        }
        catch (SQLException sQLException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setTransactionIsolation", sQLException);
            }
            throw this.translateException(sQLException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTransactionIsolation");
        }
    }

    public void setDate(PreparedStatement preparedStatement, int n, Date date, Calendar calendar) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDate", new Object[]{preparedStatement, new Integer(n), date, calendar});
        }
        if (date == null) {
            preparedStatement.setNull(n, 91);
        } else {
            preparedStatement.setDate(n, date, calendar);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDate");
        }
    }

    public void setDate(PreparedStatement preparedStatement, int n, Date date) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDate", new Object[]{preparedStatement, new Integer(n), date});
        }
        if (date == null) {
            preparedStatement.setNull(n, 91);
        } else {
            preparedStatement.setDate(n, date);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDate");
        }
    }

    public void setTime(PreparedStatement preparedStatement, int n, Time time, Calendar calendar) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTime", new Object[]{preparedStatement, new Integer(n), time, calendar});
        }
        if (time == null) {
            preparedStatement.setNull(n, 92);
        } else {
            preparedStatement.setTime(n, time, calendar);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTime");
        }
    }

    public void setTime(PreparedStatement preparedStatement, int n, Time time) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTime", new Object[]{preparedStatement, new Integer(n), time});
        }
        if (time == null) {
            preparedStatement.setNull(n, 92);
        } else {
            preparedStatement.setTime(n, time);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTime");
        }
    }

    public Date getDate(ResultSet resultSet, int n, Calendar calendar) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDate", new Object[]{resultSet, new Integer(n), calendar});
        }
        Date date = resultSet.getDate(n, calendar);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDate");
        }
        return date;
    }

    public Date getDate(ResultSet resultSet, String string, Calendar calendar) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDate", new Object[]{resultSet, string, calendar});
        }
        Date date = resultSet.getDate(string, calendar);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDate");
        }
        return date;
    }

    public Date getDate(ResultSet resultSet, int n) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDate", new Object[]{resultSet, new Integer(n)});
        }
        Date date = resultSet.getDate(n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDate");
        }
        return date;
    }

    public Date getDate(ResultSet resultSet, String string) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDate", new Object[]{resultSet, string});
        }
        Date date = resultSet.getDate(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDate");
        }
        return date;
    }

    public Time getTime(ResultSet resultSet, int n, Calendar calendar) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTime", new Object[]{resultSet, new Integer(n), calendar});
        }
        Time time = resultSet.getTime(n, calendar);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTime");
        }
        return time;
    }

    public Time getTime(ResultSet resultSet, String string, Calendar calendar) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTime", new Object[]{resultSet, string, calendar});
        }
        Time time = resultSet.getTime(string, calendar);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTime");
        }
        return time;
    }

    public Time getTime(ResultSet resultSet, int n) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTime", new Object[]{resultSet, new Integer(n)});
        }
        Time time = resultSet.getTime(n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTime");
        }
        return time;
    }

    public Time getTime(ResultSet resultSet, String string) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTime", new Object[]{resultSet, string});
        }
        Time time = resultSet.getTime(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTime");
        }
        return time;
    }

    public String scanSQL(String string) {
        return string;
    }

    public String getColumnTypeSpec(int n) {
        return (String)this.typeMap.elementAt(n);
    }

    public String getNamedColumnSpec(int n) {
        return this.namedColumnSpec_cosnaming_name;
    }

    public final Hashtable getErrorMap() {
        return this.errorMap;
    }

    public ConnectionPoolDataSource getDataSource(DataSourceProperties dataSourceProperties) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDataSource", dataSourceProperties);
        }
        this.addDefaultProperties(dataSourceProperties);
        ConnectionPoolDataSource connectionPoolDataSource = dataSourceProperties.getConnectionPoolDataSource();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDataSource", connectionPoolDataSource);
        }
        return connectionPoolDataSource;
    }

    public XADataSource getXADataSource(DataSourceProperties dataSourceProperties) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getXADataSource", dataSourceProperties);
        }
        this.addDefaultProperties(dataSourceProperties);
        XADataSource xADataSource = dataSourceProperties.getXADataSource();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getXADataSource", xADataSource);
        }
        return xADataSource;
    }

    private void addDefaultProperties(DataSourceProperties dataSourceProperties) {
        Properties properties = this.getDefaultDataSourceProps();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.keyIsSpecial(string)) {
                this.handleSpecialKey(dataSourceProperties, properties, string);
                continue;
            }
            if (dataSourceProperties.getProperty(string) != null) continue;
            dataSourceProperties.setProperty(string, properties.getProperty(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PortabilityLayer getInstance(DataSourceProperties dataSourceProperties) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance", dataSourceProperties);
        }
        PortabilityLayer portabilityLayer = null;
        Connection connection = null;
        PooledConnection pooledConnection = null;
        PooledConnection pooledConnection2 = null;
        try {
            String string = dataSourceProperties.getProperty("user");
            if ((dataSourceProperties.getDataSourceType() & 1) != 0) {
                String string2;
                connection = string == null ? ((string2 = dataSourceProperties.getProperty("tmpUser")) != null ? dataSourceProperties.getDataSource().getConnection(string2, dataSourceProperties.getProperty("tmpPassword")) : dataSourceProperties.getDataSource().getConnection()) : dataSourceProperties.getDataSource().getConnection(string, dataSourceProperties.getProperty("password"));
                portabilityLayer = PortabilityLayerFactory.getPortabilityLayer(dataSourceProperties.getDataSourceClassName(), connection);
            } else if ((dataSourceProperties.getDataSourceType() & 2) != 0) {
                String string3;
                pooledConnection = string == null ? ((string3 = dataSourceProperties.getProperty("tmpUser")) != null ? dataSourceProperties.getConnectionPoolDataSource().getPooledConnection(string3, dataSourceProperties.getProperty("tmpPassword")) : dataSourceProperties.getConnectionPoolDataSource().getPooledConnection()) : dataSourceProperties.getConnectionPoolDataSource().getPooledConnection(string, dataSourceProperties.getProperty("password"));
                connection = pooledConnection.getConnection();
                portabilityLayer = PortabilityLayerFactory.getPortabilityLayer(dataSourceProperties.getDataSourceClassName(), connection);
            } else if ((dataSourceProperties.getDataSourceType() & 4) != 0) {
                String string4;
                pooledConnection2 = string == null ? ((string4 = dataSourceProperties.getProperty("tmpUser")) != null ? dataSourceProperties.getXADataSource().getXAConnection(string4, dataSourceProperties.getProperty("tmpPassword")) : dataSourceProperties.getXADataSource().getXAConnection()) : dataSourceProperties.getXADataSource().getXAConnection(string, dataSourceProperties.getProperty("password"));
                connection = pooledConnection2.getConnection();
                portabilityLayer = PortabilityLayerFactory.getPortabilityLayer(dataSourceProperties.getDataSourceClassName(), connection);
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
            if (pooledConnection != null) {
                try {
                    pooledConnection.close();
                }
                catch (SQLException sQLException) {}
            }
            if (pooledConnection2 != null) {
                try {
                    pooledConnection2.close();
                }
                catch (SQLException sQLException) {}
            }
            if (portabilityLayer == null) {
                portabilityLayer = GenericPortabilityLayer.getInstance(dataSourceProperties);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance", portabilityLayer);
        }
        return portabilityLayer;
    }

    static PortabilityLayer getPortabilityLayer(Connection connection) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPortabilityLayer", connection);
            Tr.exit(tc, "getPortabilityLayer", null);
        }
        return null;
    }

    public Properties getDefaultDataSourceProps() {
        return this.defaultDataSourceProps;
    }

    public String addRowLockHint(String string) {
        return string + " FOR UPDATE";
    }

    public boolean supportsRowLockHint() {
        return true;
    }

    public boolean supportsSchema() {
        return true;
    }

    public ConnectionProxy createConnectionProxy(ConnectO connectO) {
        return new ConnectionProxy(connectO);
    }

    protected static String replaceString(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equals(string2 + ",")) {
                stringBuffer.append(string3 + ", ");
                continue;
            }
            stringBuffer.append(string4 + " ");
        }
        string = stringBuffer.toString();
        return string;
    }

    public void configureConnection(Connection connection, CMPropertiesImpl cMPropertiesImpl) throws SQLException {
    }

    public void configurePooledConnection(PooledConnection pooledConnection, CMProperties cMProperties) throws SQLException {
    }

    public void configureXAConnection(XAConnection xAConnection, CMProperties cMProperties) throws SQLException {
    }

    public void setHugeStringForPreparedStatement(HugeString hugeString, PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setString(n, hugeString.getString());
    }

    public boolean checkCMPStoreOperation(String string, Connection connection, boolean bl) throws SQLException {
        boolean bl2 = false;
        int n = connection.getTransactionIsolation();
        if (n == 2 || n == 1) {
            bl2 = true;
            Tr.service(tc, "MSG_CONM_7008W", string);
        } else if (!bl) {
            bl2 = true;
            Tr.service(tc, "MSG_CONM_7010W", string);
        }
        return bl2;
    }

    public int getPreferredIsolationLevel() {
        return 4;
    }

    public boolean supportsExtendedForUpdate(Connection connection) throws SQLException {
        return false;
    }

    public synchronized Object extendedForUpdateInfo(Connection connection) throws SQLException {
        return null;
    }

    public void resetStatement(CachedStatement cachedStatement) throws SQLException {
        cachedStatement.setMaxRows(0);
    }

    protected boolean keyIsSpecial(String string) {
        return false;
    }

    protected void handleSpecialKey(DataSourceProperties dataSourceProperties, Properties properties, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleSpecialKey", string);
            Tr.exit(tc, "handleSpecialKey");
        }
    }

    public synchronized String processSQLForExtendedUpdate(String string, int n) {
        return string;
    }

    public String processSQL(String string, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processSQL - sqlString, isolevel, addForUpdate, addextendedforupdate: ", new Object[]{string, new Integer(n), new Boolean(bl), new Boolean(bl2)});
        }
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer(250);
            stringBuffer.append(string).append(" FOR UPDATE");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processSQL - modified sqlString is: " + stringBuffer);
            }
            return new String(stringBuffer);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processSQL - no change: ", string);
        }
        return string;
    }
}

