/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm.portability;

import com.ibm.ejs.cm.portability.PortabilityLayer;
import com.ibm.ejs.cm.portability.SybasePortabilityLayer;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.sql.Connection;
import java.sql.SQLException;

class Sybase11PortabilityLayer
extends SybasePortabilityLayer {
    private static Sybase11PortabilityLayer instance;
    private static final TraceComponent tc;

    protected Sybase11PortabilityLayer() {
    }

    public void setTransactionIsolation(Connection connection, int n) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTransactionIsolation", new Object[]{connection, new Integer(n)});
        }
        switch (n) {
            case 1: {
                n = 2;
                break;
            }
            case 4: {
                n = 8;
                break;
            }
        }
        super.setTransactionIsolation(connection, n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTransactionIsolation");
        }
    }

    public int getPreferredIsolationLevel() {
        return 2;
    }

    public static PortabilityLayer getInstance() throws SQLException {
        if (instance == null) {
            instance = new Sybase11PortabilityLayer();
        }
        return instance;
    }

    static {
        tc = Tr.register(Sybase11PortabilityLayer.class);
    }
}

