/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm.portability;

import com.ibm.ejs.cm.CMProperties;
import com.ibm.ejs.cm.DataSourceProperties;
import com.ibm.ejs.cm.portability.DuplicateKeyException;
import com.ibm.ejs.cm.portability.GenericPortabilityLayer;
import com.ibm.ejs.cm.portability.PortabilityLayer;
import com.ibm.ejs.cm.portability.PortabilityLayerImpl;
import com.ibm.ejs.cm.portability.PrimarykeyAlreadyDefinedException;
import com.ibm.ejs.cm.portability.Sybase11PortabilityLayer;
import com.ibm.ejs.cm.portability.TableAlreadyExistsException;
import com.ibm.ejs.cm.portability.TableDoesNotExistException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.sql.PooledConnection;

class SybasePortabilityLayer
extends PortabilityLayerImpl {
    private static SybasePortabilityLayer instance = null;
    private static final TraceComponent tc = Tr.register(SybasePortabilityLayer.class);
    private static String dataBaseVersion = "0";
    private static final String[] SPECIAL_KEYS = new String[]{"connectionProperties"};

    protected SybasePortabilityLayer() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.errorMap.put(new Integer(2601), DuplicateKeyException.class);
        this.errorMap.put(new Integer(2714), TableAlreadyExistsException.class);
        this.errorMap.put("JZ006", "MaybeStale");
        this.errorMap.put("JZ0C1", StaleConnectionException.class);
        this.errorMap.put("JZ0C0", StaleConnectionException.class);
        this.errorMap.put(new Integer(1923), PrimarykeyAlreadyDefinedException.class);
        this.errorMap.put(new Integer(3701), TableDoesNotExistException.class);
        this.errorMap.put(new Integer(208), TableDoesNotExistException.class);
        this.typeMap.setElementAt(" VARCHAR(64) NULL ", 2);
        this.typeMap.setElementAt(" VARCHAR(255) NOT NULL ", 3);
        this.typeMap.setElementAt(" VARCHAR(255) NULL ", 4);
        this.typeMap.setElementAt(" TEXT NOT NULL ", 5);
        this.typeMap.setElementAt(" TEXT NULL ", 6);
        this.typeMap.setElementAt(" TEXT NOT NULL ", 7);
        this.typeMap.setElementAt(" TEXT NULL ", 8);
        this.typeMap.setElementAt(" IMAGE NULL ", 9);
        this.typeMap.setElementAt(" IMAGE NULL ", 10);
        this.typeMap.setElementAt(" VARCHAR(64) NOT NULL ", 11);
        this.typeMap.setElementAt(" VARCHAR(64) NULL ", 12);
        this.defaultDataSourceProps.setProperty("connectionProperties", "SELECT_OPENS_CURSOR=true");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public void createTable(Connection connection, String string, String string2) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTable", new Object[]{connection, string, string2});
        }
        String string3 = SybasePortabilityLayer.replaceString(string2, "BLOB(1M)", "IMAGE NULL");
        super.createTable(connection, string, string3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PortabilityLayer getInstance(DataSourceProperties dataSourceProperties) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance", dataSourceProperties);
        }
        if (instance != null) {
            return instance;
        }
        PortabilityLayer portabilityLayer = null;
        Connection connection = null;
        PooledConnection pooledConnection = null;
        PooledConnection pooledConnection2 = null;
        try {
            String string = dataSourceProperties.getProperty("user");
            if ((dataSourceProperties.getDataSourceType() & 2) != 0) {
                pooledConnection = string == null ? dataSourceProperties.getConnectionPoolDataSource().getPooledConnection(dataSourceProperties.getProperty("tmpUser"), dataSourceProperties.getProperty("tmpPassword")) : dataSourceProperties.getConnectionPoolDataSource().getPooledConnection(string, dataSourceProperties.getProperty("password"));
                connection = pooledConnection.getConnection();
                portabilityLayer = SybasePortabilityLayer.getPortabilityLayer(connection);
            } else if ((dataSourceProperties.getDataSourceType() & 4) != 0) {
                pooledConnection2 = string == null ? dataSourceProperties.getXADataSource().getXAConnection(dataSourceProperties.getProperty("tmpUser"), dataSourceProperties.getProperty("tmpPassword")) : dataSourceProperties.getXADataSource().getXAConnection(string, dataSourceProperties.getProperty("password"));
                connection = pooledConnection2.getConnection();
                portabilityLayer = SybasePortabilityLayer.getPortabilityLayer(connection);
            } else if ((dataSourceProperties.getDataSourceType() & 1) != 0) {
                connection = string == null ? dataSourceProperties.getDataSource().getConnection(dataSourceProperties.getProperty("tmpUser"), dataSourceProperties.getProperty("tmpPassword")) : dataSourceProperties.getDataSource().getConnection(string, dataSourceProperties.getProperty("password"));
                portabilityLayer = SybasePortabilityLayer.getPortabilityLayer(connection);
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
            if (pooledConnection != null) {
                try {
                    pooledConnection.close();
                }
                catch (SQLException sQLException) {}
            }
            if (pooledConnection2 != null) {
                try {
                    pooledConnection2.close();
                }
                catch (SQLException sQLException) {}
            }
            if (portabilityLayer == null) {
                portabilityLayer = GenericPortabilityLayer.getInstance(dataSourceProperties);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance", portabilityLayer);
        }
        return portabilityLayer;
    }

    static PortabilityLayer getPortabilityLayer(Connection connection) throws SQLException {
        DatabaseMetaData databaseMetaData;
        String string;
        block5: {
            string = null;
            databaseMetaData = null;
            try {
                databaseMetaData = connection.getMetaData();
            }
            catch (SQLException sQLException) {
                if (!tc.isEventEnabled()) break block5;
                Tr.event(tc, "getPortabilityLayer - exception getting metaData, using property", sQLException);
            }
        }
        string = databaseMetaData != null ? databaseMetaData.getDatabaseProductVersion() : dataBaseVersion;
        if (string != null && string.indexOf("11.") != -1) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "getPortabilityLayer - returning Sybase11PortabilityLayer", string);
            }
            return Sybase11PortabilityLayer.getInstance();
        }
        if (tc.isEventEnabled()) {
            Tr.event(tc, "getPortabilityLayer - returning SybasePortabilityLayer", string);
        }
        return SybasePortabilityLayer.getInstance();
    }

    public static PortabilityLayer getInstance() throws SQLException {
        if (instance == null) {
            instance = new SybasePortabilityLayer();
        }
        return instance;
    }

    public void configureConnection(Connection connection, CMProperties cMProperties) throws SQLException {
        dataBaseVersion = cMProperties.getDataBaseVersion();
    }

    protected boolean keyIsSpecial(String string) {
        for (int i = 0; i < SPECIAL_KEYS.length; ++i) {
            if (!string.equals(SPECIAL_KEYS[i])) continue;
            return true;
        }
        return false;
    }

    protected void handleSpecialKey(DataSourceProperties dataSourceProperties, Properties properties, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleSpecialKey", string);
        }
        if (string.equals(SPECIAL_KEYS[0])) {
            String string2 = dataSourceProperties.getProperty(string);
            String string3 = properties.getProperty(string);
            StringTokenizer stringTokenizer = null;
            StringTokenizer stringTokenizer2 = null;
            if (string2 != null) {
                stringTokenizer = new StringTokenizer(string2, ";");
            }
            if (string3 != null) {
                stringTokenizer2 = new StringTokenizer(string3, ";");
            }
            if (string2 == null && string3 == null) {
                return;
            }
            if (string3 == null) {
                return;
            }
            if (string2 == null) {
                dataSourceProperties.setProperty(string, string3);
            }
            if (string2 != null && string3 != null) {
                int n;
                String string4;
                Properties properties2 = new Properties();
                String string5 = null;
                int n2 = 0;
                while (stringTokenizer2.hasMoreTokens()) {
                    string4 = stringTokenizer2.nextToken();
                    try {
                        n = string4.indexOf("=");
                        if (n == -1) {
                            properties2.setProperty(string4, "");
                        } else {
                            properties2.setProperty(string4.substring(0, n), string4.substring(n + 1));
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    ++n2;
                }
                n2 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    string4 = stringTokenizer.nextToken();
                    try {
                        n = string4.indexOf("=");
                        if (n == -1) {
                            properties2.setProperty(string4, "");
                        } else {
                            properties2.setProperty(string4.substring(0, n), string4.substring(n + 1));
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    ++n2;
                }
                Enumeration<?> enumeration = properties2.propertyNames();
                if (enumeration.hasMoreElements()) {
                    string4 = (String)enumeration.nextElement();
                    String string6 = properties2.getProperty(string4);
                    string5 = string4 + "=" + string6;
                }
                while (enumeration.hasMoreElements()) {
                    string4 = (String)enumeration.nextElement();
                    String string7 = properties2.getProperty(string4);
                    string5 = string5 + ";" + string4 + "=" + string7;
                }
                dataSourceProperties.setProperty(string, string5);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleSpecialKey", dataSourceProperties);
        }
    }
}

