/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm.proxy;

import com.ibm.ejs.cm.CMPropertiesImpl;
import com.ibm.ejs.cm.pool.ConnectO;
import com.ibm.ejs.cm.pool.ConnectOEventListener;
import com.ibm.ejs.cm.pool.ExtendedConnection;
import com.ibm.ejs.cm.portability.PortabilityLayer;
import com.ibm.ejs.cm.portability.PortabilityLayerExt;
import com.ibm.ejs.cm.proxy.CallableStatementProxy;
import com.ibm.ejs.cm.proxy.PreparedStatementProxy;
import com.ibm.ejs.cm.proxy.Proxy;
import com.ibm.ejs.cm.proxy.StatementProxy;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;

public class ConnectionProxy
extends Proxy
implements ExtendedConnection,
ConnectOEventListener {
    protected ConnectO connection;
    protected boolean disableCleanup;
    private static final TraceComponent tc = Tr.register(ConnectionProxy.class, null, "com.ibm.ejs.resources.CONMMessages");

    public void setHoldability(int n) throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "setHoldability(int)");
        throw new SQLException("This method is not supported.");
    }

    public int getHoldability() throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "getHoldability()");
        throw new SQLException("This method is not supported.");
    }

    public Savepoint setSavepoint() throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "setSavepoint()");
        throw new SQLException("This method is not supported.");
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "setSavepoint(String)");
        throw new SQLException("This method is not supported.");
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "rollback(Savepoint)");
        throw new SQLException("This method is not supported.");
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "releaseSavepoint(Savepoint)");
        throw new SQLException("This method is not supported.");
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "createStatement(int, int, int)");
        throw new SQLException("This method is not supported.");
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "prepareStatement(String, int, int, int)");
        throw new SQLException("This method is not supported.");
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "prepareCall(String, int, int, int)");
        throw new SQLException("This method is not supported.");
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "prepareStatement(String, int)");
        throw new SQLException("This method is not supported.");
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "prepareStatement(String, int[])");
        throw new SQLException("This method is not supported.");
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        Tr.error(tc, "MSG_CONM_8000E", "prepareStatement(String, String[])");
        throw new SQLException("This method is not supported.");
    }

    public ConnectionProxy(ConnectO connectO) {
        super(connectO);
        this.lockObject = new Object();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", connectO);
        }
        this.connection = connectO;
        this.disableCleanup = ((CMPropertiesImpl)connectO.getPool().getAttributes()).isAutoConnCleanupDisabled();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public void connectionEnlisted(ConnectO connectO, Object object) {
    }

    public void connectionDestroyed(ConnectO connectO) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "connectionDestroyed", connectO);
            }
            try {
                this.close();
            }
            catch (SQLException sQLException) {
                if (!tc.isEventEnabled()) break block4;
                Tr.event(tc, "connectionDestroyed error", sQLException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "connectionDestroyed");
        }
    }

    public void setDestroyed(ConnectO connectO) {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "setDestroyed", connectO);
        }
        super.setDestroyedProxy();
    }

    public boolean connectionIdleTimeout(ConnectO connectO) {
        return true;
    }

    public boolean connectionAgedTimeout(ConnectO connectO) {
        return true;
    }

    public void connectionTxComplete(ConnectO connectO, int n, Object object) {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "connectionTxComplete", new Object[]{connectO, new Integer(n), object});
            }
            try {
                if (!this.disableCleanup) {
                    this.close();
                }
            }
            catch (SQLException sQLException) {
                if (!tc.isEventEnabled()) break block5;
                Tr.event(tc, "connectionTxComplete - error", sQLException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "connectionTxComplete");
        }
    }

    public void connectionOrphaned(ConnectO connectO) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "connectionOrphaned", connectO);
            }
            try {
                this.close();
            }
            catch (SQLException sQLException) {
                if (!tc.isEventEnabled()) break block4;
                Tr.event(tc, "connectionOrphaned error", sQLException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "connectionOrphaned");
        }
    }

    public PortabilityLayerExt getPortabilityLayer() throws SQLException {
        return this.getConnection().getPortabilityLayer();
    }

    public SQLException translateException(SQLException sQLException) throws SQLException {
        return this.getConnection().translateException(sQLException);
    }

    public String getColumnTypeSpec(int n) throws SQLException {
        try {
            return this.getConnection().getColumnTypeSpec(n);
        }
        catch (SQLException sQLException) {
            throw this.translateException(sQLException);
        }
    }

    public String addRowLockHint(String string) throws SQLException {
        try {
            return this.getConnection().addRowLockHint(string);
        }
        catch (SQLException sQLException) {
            throw this.translateException(sQLException);
        }
    }

    public Connection getPhysicalConnection() throws SQLException {
        try {
            return this.getConnection().getPhysicalConnection();
        }
        catch (SQLException sQLException) {
            throw this.translateException(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unilateralCommit() throws SQLException {
        SQLException sQLException = null;
        if (!this.isClosed()) {
            Object object = this.getLockObject();
            synchronized (object) {
                try {
                    this.__preInvoke(false);
                    this.getConnection().unilateralCommit();
                }
                catch (SQLException sQLException2) {
                    sQLException = sQLException2;
                    throw this.translateException(sQLException2);
                }
                finally {
                    this.__postInvoke(sQLException);
                    this.close();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Statement createStatement(int n, int n2) throws SQLException {
        SQLException sQLException = null;
        if (this.isClosed()) {
            throw new StaleConnectionException(this.getClass() + " is closed");
        }
        Object object = this.getLockObject();
        synchronized (object) {
            try {
                this.__preInvoke();
                Statement statement = this.getConnection().createStatement(n, n2);
                if (statement != null) {
                    StatementProxy statementProxy = new StatementProxy(this, statement);
                    return statementProxy;
                }
                statement = null;
                return statement;
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
                throw this.translateException(sQLException2);
            }
            finally {
                this.__postInvoke(sQLException);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        SQLException sQLException = null;
        if (this.isClosed()) {
            throw new StaleConnectionException(this.getClass() + " is closed");
        }
        Object object = this.getLockObject();
        synchronized (object) {
            try {
                this.__preInvoke();
                PreparedStatement preparedStatement = this.getConnection().prepareStatement(((PortabilityLayer)this.getPortabilityLayer()).scanSQL(string), n, n2);
                if (preparedStatement != null) {
                    PreparedStatementProxy preparedStatementProxy = new PreparedStatementProxy(this, preparedStatement);
                    return preparedStatementProxy;
                }
                preparedStatement = null;
                return preparedStatement;
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
                throw this.translateException(sQLException2);
            }
            finally {
                this.__postInvoke(sQLException);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        SQLException sQLException = null;
        if (this.isClosed()) {
            throw new StaleConnectionException(this.getClass() + " is closed");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Preparing call for " + string);
        }
        Object object = this.getLockObject();
        synchronized (object) {
            try {
                this.__preInvoke();
                CallableStatement callableStatement = this.getConnection().prepareCall(((PortabilityLayer)this.getPortabilityLayer()).scanSQL(string), n, n2);
                if (callableStatement != null) {
                    CallableStatementProxy callableStatementProxy = new CallableStatementProxy(this, callableStatement);
                    return callableStatementProxy;
                }
                callableStatement = null;
                return callableStatement;
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
                throw this.translateException(sQLException2);
            }
            finally {
                this.__postInvoke(sQLException);
            }
        }
    }

    public final Map getTypeMap() throws SQLException {
        try {
            return this.getConnection().getTypeMap();
        }
        catch (SQLException sQLException) {
            throw this.translateException(sQLException);
        }
    }

    public final void setTypeMap(Map map) throws SQLException {
        try {
            this.getConnection().setTypeMap(map);
        }
        catch (SQLException sQLException) {
            throw this.translateException(sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Statement createStatement() throws SQLException {
        SQLException sQLException = null;
        if (this.isClosed()) {
            throw new StaleConnectionException(this.getClass() + " is closed");
        }
        Object object = this.getLockObject();
        synchronized (object) {
            try {
                this.__preInvoke();
                Statement statement = this.getConnection().createStatement();
                if (statement != null) {
                    StatementProxy statementProxy = new StatementProxy(this, statement);
                    return statementProxy;
                }
                statement = null;
                return statement;
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
                throw this.translateException(sQLException2);
            }
            finally {
                this.__postInvoke(sQLException);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PreparedStatement prepareStatement(String string) throws SQLException {
        SQLException sQLException = null;
        if (this.isClosed()) {
            throw new StaleConnectionException(this.getClass() + " is closed");
        }
        Object object = this.getLockObject();
        synchronized (object) {
            try {
                this.__preInvoke();
                PreparedStatement preparedStatement = this.getConnection().prepareStatement(((PortabilityLayer)this.getPortabilityLayer()).scanSQL(string));
                if (preparedStatement != null) {
                    PreparedStatementProxy preparedStatementProxy = new PreparedStatementProxy(this, preparedStatement);
                    return preparedStatementProxy;
                }
                preparedStatement = null;
                return preparedStatement;
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
                throw this.translateException(sQLException2);
            }
            finally {
                this.__postInvoke(sQLException);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CallableStatement prepareCall(String string) throws SQLException {
        SQLException sQLException = null;
        if (this.isClosed()) {
            throw new StaleConnectionException(this.getClass() + " is closed");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Preparing call for " + string);
        }
        Object object = this.getLockObject();
        synchronized (object) {
            try {
                this.__preInvoke();
                CallableStatement callableStatement = this.getConnection().prepareCall(((PortabilityLayer)this.getPortabilityLayer()).scanSQL(string));
                if (callableStatement != null) {
                    CallableStatementProxy callableStatementProxy = new CallableStatementProxy(this, callableStatement);
                    return callableStatementProxy;
                }
                callableStatement = null;
                return callableStatement;
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
                throw this.translateException(sQLException2);
            }
            finally {
                this.__postInvoke(sQLException);
            }
        }
    }

    public final String nativeSQL(String string) throws SQLException {
        SQLException sQLException = null;
        if (!this.isClosed()) {
            Object object = this.getLockObject();
            synchronized (object) {
                String string2;
                try {
                    this.__preInvoke();
                    String string3 = ((PortabilityLayer)this.getPortabilityLayer()).scanSQL(string);
                    string2 = this.getConnection().nativeSQL(string3);
                }
                catch (SQLException sQLException2) {
                    try {
                        sQLException = sQLException2;
                        throw this.translateException(sQLException2);
                    }
                    catch (Throwable throwable) {
                        this.__postInvoke(sQLException);
                        throw throwable;
                    }
                }
                this.__postInvoke(sQLException);
                return string2;
            }
        }
        throw new StaleConnectionException(this.getClass() + " is closed");
    }

    public final void setAutoCommit(boolean bl) throws SQLException {
        try {
            this.getConnection().setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            throw this.translateException(sQLException);
        }
    }

    public final boolean getAutoCommit() throws SQLException {
        try {
            return this.getConnection().getAutoCommit();
        }
        catch (SQLException sQLException) {
            throw this.translateException(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commit() throws SQLException {
        SQLException sQLException = null;
        if (!this.isClosed()) {
            Object object = this.getLockObject();
            synchronized (object) {
                try {
                    this.__preInvoke();
                    this.getConnection().commit();
                }
                catch (SQLException sQLException2) {
                    sQLException = sQLException2;
                    throw this.translateException(sQLException2);
                }
                finally {
                    this.__postInvoke(sQLException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rollback() throws SQLException {
        SQLException sQLException = null;
        if (!this.isClosed()) {
            Object object = this.getLockObject();
            synchronized (object) {
                try {
                    this.__preInvoke();
                    this.getConnection().rollback();
                }
                catch (SQLException sQLException2) {
                    sQLException = sQLException2;
                    throw this.translateException(sQLException2);
                }
                finally {
                    this.__postInvoke(sQLException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        if (ConnectionProxy.tc.isEntryEnabled()) {
            Tr.entry(ConnectionProxy.tc, "close");
        }
        var1_1 = null;
        var2_2 = this.getLockObject();
        synchronized (var2_2) {
            block39: {
                super.setisConnClosing(true);
                super.close();
                super.setisConnClosing(false);
                var5_3 = null;
                try {
                    if (this.connection == null) ** GOTO lbl96
                    this.connection.removeEventListener(this);
                    this.connection.getPool().freeConnection(this.connection);
                }
                catch (SQLException var6_6) {
                    if (var1_1 == null) {
                        var1_1 = var6_6;
                        if (!ConnectionProxy.tc.isEventEnabled()) ** GOTO lbl96
                        Tr.event(ConnectionProxy.tc, "Exception closing connection", var1_1);
                    }
                    if (!ConnectionProxy.tc.isEventEnabled()) ** GOTO lbl96
                    Tr.event(ConnectionProxy.tc, "Secondary exception closing connection", var6_6);
                }
                finally {
                    this.connection = null;
                    if (ConnectionProxy.tc.isEntryEnabled()) {
                        Tr.exit(ConnectionProxy.tc, "close");
                    }
                }
                {
                    catch (SQLException var3_12) {
                        var1_1 = var3_12;
                        var5_4 = null;
                        try {
                            if (this.connection != null) {
                                this.connection.removeEventListener(this);
                                this.connection.getPool().freeConnection(this.connection);
                            }
                            this.connection = null;
                        }
                        catch (SQLException var6_7) {
                            try {}
                            catch (Throwable var7_10) {
                                this.connection = null;
                                if (ConnectionProxy.tc.isEntryEnabled()) {
                                    Tr.exit(ConnectionProxy.tc, "close");
                                }
                                throw var7_10;
                            }
                            if (var1_1 == null) {
                                var1_1 = var6_7;
                                if (ConnectionProxy.tc.isEventEnabled()) {
                                    Tr.event(ConnectionProxy.tc, "Exception closing connection", var1_1);
                                }
                            } else if (ConnectionProxy.tc.isEventEnabled()) {
                                Tr.event(ConnectionProxy.tc, "Secondary exception closing connection", var6_7);
                            }
                            this.connection = null;
                            if (ConnectionProxy.tc.isEntryEnabled()) {
                                Tr.exit(ConnectionProxy.tc, "close");
                            }
                            break block39;
                        }
                        if (ConnectionProxy.tc.isEntryEnabled()) {
                            Tr.exit(ConnectionProxy.tc, "close");
                        }
                        break block39;
                    }
                }
                catch (Throwable var4_14) {
                    var5_5 = null;
                    try {
                        if (this.connection != null) {
                            this.connection.removeEventListener(this);
                            this.connection.getPool().freeConnection(this.connection);
                        }
                        this.connection = null;
                    }
                    catch (SQLException var6_8) {
                        try {}
                        catch (Throwable var7_11) {
                            this.connection = null;
                            if (ConnectionProxy.tc.isEntryEnabled()) {
                                Tr.exit(ConnectionProxy.tc, "close");
                            }
                            throw var7_11;
                        }
                        if (var1_1 == null) {
                            var1_1 = var6_8;
                            if (ConnectionProxy.tc.isEventEnabled()) {
                                Tr.event(ConnectionProxy.tc, "Exception closing connection", var1_1);
                            }
                        } else if (ConnectionProxy.tc.isEventEnabled()) {
                            Tr.event(ConnectionProxy.tc, "Secondary exception closing connection", var6_8);
                        }
                        this.connection = null;
                        if (ConnectionProxy.tc.isEntryEnabled()) {
                            Tr.exit(ConnectionProxy.tc, "close");
                        } else {
                            ** GOTO lbl94
                        }
                    }
                    if (ConnectionProxy.tc.isEntryEnabled()) {
                        Tr.exit(ConnectionProxy.tc, "close");
                    }
                    throw var4_14;
                }
            }
            if (var1_1 != null) {
                throw var1_1;
            }
            if (this.connection != null) {
                var3_13 = this.connection;
                this.connection = null;
                var3_13.removeEventListener(this);
                var3_13.getPool().freeConnection(var3_13);
            }
        }
        if (ConnectionProxy.tc.isEntryEnabled()) {
            Tr.exit(ConnectionProxy.tc, "close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DatabaseMetaData getMetaData() throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMetaData");
        }
        SQLException sQLException = null;
        if (!this.isClosed()) {
            DatabaseMetaData databaseMetaData = null;
            Object object = this.getLockObject();
            synchronized (object) {
                try {
                    this.__preInvoke();
                    databaseMetaData = this.getConnection().getMetaData();
                    return databaseMetaData;
                }
                catch (SQLException sQLException2) {
                    sQLException = sQLException2;
                    return sQLException;
                }
                finally {
                    this.__postInvoke(sQLException);
                    if (sQLException != null) {
                        sQLException = this.translateException(sQLException);
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getMetaData - SQLException", sQLException);
                        }
                        throw sQLException;
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getMetaData", databaseMetaData);
                    }
                    return databaseMetaData;
                }
            }
        }
        throw new StaleConnectionException(this.getClass() + " is closed");
    }

    public final void setReadOnly(boolean bl) throws SQLException {
        try {
            this.getConnection().setReadOnly(bl);
        }
        catch (SQLException sQLException) {
            throw this.translateException(sQLException);
        }
    }

    public final boolean isReadOnly() throws SQLException {
        try {
            return this.getConnection().isReadOnly();
        }
        catch (SQLException sQLException) {
            throw this.translateException(sQLException);
        }
    }

    public final void setCatalog(String string) throws SQLException {
        try {
            this.getConnection().setCatalog(string);
        }
        catch (SQLException sQLException) {
            throw this.translateException(sQLException);
        }
    }

    public final String getCatalog() throws SQLException {
        try {
            return this.getConnection().getCatalog();
        }
        catch (SQLException sQLException) {
            throw this.translateException(sQLException);
        }
    }

    public final void setTransactionIsolation(int n) throws SQLException {
        try {
            this.getConnection().setTransactionIsolation(n);
        }
        catch (SQLException sQLException) {
            throw this.translateException(sQLException);
        }
    }

    public final int getTransactionIsolation() throws SQLException {
        try {
            return this.getConnection().getTransactionIsolation();
        }
        catch (SQLException sQLException) {
            throw this.translateException(sQLException);
        }
    }

    public final SQLWarning getWarnings() throws SQLException {
        try {
            return this.getConnection().getWarnings();
        }
        catch (SQLException sQLException) {
            throw this.translateException(sQLException);
        }
    }

    public final void clearWarnings() throws SQLException {
        try {
            this.getConnection().clearWarnings();
        }
        catch (SQLException sQLException) {
            throw this.translateException(sQLException);
        }
    }

    protected final ConnectO getConnection() throws SQLException {
        if (this.isClosed()) {
            throw new StaleConnectionException("Connection is closed");
        }
        return this.connection;
    }

    protected Object getLockObject() {
        return this.lockObject;
    }
}

