/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm.proxy;

import com.ibm.db2.jcc.DB2Wrapper;
import com.ibm.ejs.cm.pool.ConnectO;
import com.ibm.ejs.cm.portability.DB2390LocalPortabilityLayer;
import com.ibm.ejs.cm.portability.DB2UniversalConnectPortabilityLayer;
import com.ibm.ejs.cm.proxy.ConnectionProxy;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.sql.Connection;
import java.sql.SQLException;

public final class DB2ConnectionProxy
extends ConnectionProxy
implements DB2Wrapper {
    private static final TraceComponent tc = Tr.register(DB2ConnectionProxy.class);

    public DB2ConnectionProxy(ConnectO connectO) {
        super(connectO);
    }

    public Object getDB2Object() {
        Connection connection;
        try {
            if (this.invoker.getPortabilityLayer() instanceof DB2390LocalPortabilityLayer || this.invoker.getPortabilityLayer() instanceof DB2UniversalConnectPortabilityLayer) {
                connection = this.invoker.getPhysicalConnection();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getDB2Object() returned DB2 390 Local connection.");
                }
            } else {
                connection = null;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getDB2Object() returned null.The Connection managed by the ConnectO is not a DB2 390 Local connection.");
                }
            }
        }
        catch (SQLException sQLException) {
            connection = null;
            Tr.error(tc, "SQLException occured during getDB2Object(). A null object was returned to the caller.");
        }
        return connection;
    }
}

