/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm.proxy;

import com.ibm.ejs.cm.exception.ConnectionPoolInternalErrorException;
import com.ibm.ejs.cm.exception.IllegalConnectionUseException;
import com.ibm.ejs.cm.pool.ConnectO;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import java.sql.SQLException;
import java.util.ArrayList;

public abstract class Proxy {
    protected final ConnectO invoker;
    private ArrayList children;
    protected Proxy parent;
    private int state = 0;
    private Boolean proxyInUse = Boolean.FALSE;
    private boolean isConnClosing = false;
    private boolean isParentClosing = false;
    private boolean isRolledBack = false;
    private boolean isDestroyed = false;
    private static final int OPEN = 0;
    private static final int CLOSED = 1;
    protected Object lockObject = null;
    private static final String[] stateStrings = new String[]{"OPEN", "CLOSED"};
    private static final TraceComponent tc = Tr.register(Proxy.class);

    protected Proxy(ConnectO connectO) {
        this.invoker = connectO;
    }

    protected Proxy(Proxy proxy) {
        this.parent = proxy;
        proxy.addChild(this);
        this.invoker = proxy.invoker;
    }

    public boolean isClosed() throws SQLException {
        return this.state == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "close");
        }
        SQLException sQLException = null;
        if (this.isClosed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "close");
            }
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        try {
            if (this.children != null) {
                this.isParentClosing = true;
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Closing a proxy's children proxies");
                }
                int n = this.children.size();
                for (int i = 0; i < n; ++i) {
                    try {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Close child proxy", (Proxy)this.children.get(i));
                        }
                        ((Proxy)this.children.get(i)).closeFromParent();
                        if (!tc.isEventEnabled()) continue;
                        Tr.event(tc, "Done closing child proxy");
                        continue;
                    }
                    catch (SQLException sQLException2) {
                        if (sQLException != null) continue;
                        sQLException = this.translateException(sQLException2);
                        continue;
                    }
                    catch (Exception exception) {
                        bl = true;
                        if (!tc.isEventEnabled()) continue;
                        Tr.event(tc, "Internal error", exception);
                    }
                }
                this.isParentClosing = false;
            }
        }
        finally {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Mark proxy closed");
            }
            this.state = 1;
            this.children = null;
            if (this.parent != null && !this.parent.isConnClosing && !this.parent.isParentClosing) {
                this.parent.removeChild(this);
            }
        }
        if (sQLException != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "close");
            }
            throw sQLException;
        }
        if (bl) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "close");
            }
            throw new ConnectionPoolInternalErrorException("Error occurred while closing Proxy children");
        }
        if (bl2) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "close");
            }
            throw new IllegalConnectionUseException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "close");
        }
    }

    protected void closeFromParent() throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "in closeFromParent on Proxy, you should never get here!!");
        }
    }

    public final String toString() {
        return this.getClass().getName() + "@" + System.identityHashCode(this) + " [" + this.getStateString() + "]";
    }

    protected final void __preInvoke() throws SQLException {
        this.__preInvoke(false);
    }

    protected final void __preInvoke(boolean bl) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "__preInvoke", new Boolean(bl));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "state: ", this.getStateString());
        }
        switch (this.state) {
            case 0: {
                this.invoker.preInvoke(bl);
                this.proxyInUse = Boolean.TRUE;
                break;
            }
            case 1: {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "__preInvoke: Proxy is closed");
                }
                throw new StaleConnectionException(this.getClass() + " is closed");
            }
            default: {
                throw new Error("Illegal state");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "__preInvoke");
        }
    }

    protected final void __postInvoke(SQLException sQLException) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "__postInvoke");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "state: ", this.getStateString());
        }
        switch (this.state) {
            case 0: {
                this.invoker.postInvoke(sQLException);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "__postInvoke: Proxy is no longer in use " + new Object[]{this});
                }
                this.proxyInUse = Boolean.FALSE;
                break;
            }
            case 1: {
                if (!tc.isEntryEnabled()) break;
                Tr.exit(tc, "__postInvoke: Proxy is closed");
                break;
            }
            default: {
                if (!tc.isEntryEnabled()) break;
                Tr.exit(tc, "__postInvoke - Illegal state");
            }
        }
    }

    protected final Proxy getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addChild(Proxy proxy) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (this.children == null) {
                this.children = new ArrayList(5);
            }
            this.children.add(proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeChild(Proxy proxy) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (this.children != null) {
                this.children.remove(proxy);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "remove child from parent's array list !");
                }
            }
        }
    }

    public SQLException translateException(SQLException sQLException) throws SQLException {
        return this.invoker.translateException(sQLException);
    }

    private final String getStateString() {
        return stateStrings[this.state];
    }

    protected final void setisRolledBack(boolean bl) {
        this.isRolledBack = bl;
    }

    public void setDestroyedProxy() {
        this.isDestroyed = true;
        if (tc.isEventEnabled()) {
            Tr.event(tc, "setDestroyedProxy ");
        }
    }

    protected Object getLockObject() {
        return this.parent.getLockObject();
    }

    public void setisConnClosing(boolean bl) {
        this.isConnClosing = bl;
        if (tc.isEventEnabled()) {
            Tr.event(tc, "isConnClosing is being set to " + bl);
        }
    }
}

