/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm.proxy;

import com.ibm.ejs.cm.cache.CachedStatement;
import com.ibm.ejs.cm.proxy.CallableStatementProxy;
import com.ibm.ejs.cm.proxy.ConnectionProxy;
import com.ibm.ejs.cm.proxy.PreparedStatementProxy;
import com.ibm.ejs.cm.proxy.Proxy;
import com.ibm.ejs.cm.proxy.ResultSetProxy;
import com.ibm.ejs.cm.proxy.StatementProxy;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.ws.ffdc.FFDCFilter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Vector;

public class WSJdbcUtil {
    private static final TraceComponent tc = Tr.register(WSJdbcUtil.class, null, "com.ibm.ejs.resources.CONMMessages");
    private static Hashtable vendorMethods = new Hashtable();
    private static Vector forbiddenMethods = new Vector();
    public static final int CONNECTION = 1;
    public static final int STATEMENT = 2;
    public static final int PREPARED_STATEMENT = 3;
    public static final int CALLABLE_STATEMENT = 4;
    public static final int RESULT_SET = 5;
    public static final int IGNORE = -1;
    public static final String CONSTRUCTOR = "<init>";

    private WSJdbcUtil() {
    }

    public static final Object jdbcCall(Class clazz, Object object, String string, Object[] objectArray, Class[] classArray) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "jdbcCall: underlyingObjectType, caller, methodName, args, types", new Object[]{clazz, object, string, objectArray, classArray});
        }
        AutoCloseable autoCloseable = null;
        if (object == null) {
            throw new SQLException("Caller cannot be null");
        }
        if (object instanceof Proxy && ((Proxy)object).isClosed()) {
            throw new StaleConnectionException(object.getClass() + " is closed");
        }
        if (object instanceof ResultSetProxy) {
            autoCloseable = ((ResultSetProxy)object).getResultSet();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caller is ResultSetProxy, newCaller is " + autoCloseable.getClass().getName());
            }
        } else if (object instanceof StatementProxy) {
            autoCloseable = ((StatementProxy)object).getStatement();
            if (autoCloseable instanceof CachedStatement) {
                autoCloseable = ((CachedStatement)autoCloseable).getPreparedStatement();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caller is Statement, newCaller is " + autoCloseable.getClass().getName());
            }
        } else if (object instanceof ConnectionProxy) {
            autoCloseable = ((ConnectionProxy)object).getPhysicalConnection();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caller is ConnectionProxy, newCaller is " + autoCloseable.getClass().getName());
            }
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "jdbcCall, throwing SQLException: Invalid Caller Type!");
            }
            throw new SQLException("Invalid Caller Type: " + object.getClass().getName());
        }
        if (autoCloseable != null) {
            SQLException sQLException = null;
            Object object2 = ((Proxy)object).getLockObject();
            synchronized (object2) {
                Object object3;
                try {
                    ((Proxy)object).__preInvoke();
                    Object object4 = WSJdbcUtil.invokeMethod(autoCloseable, autoCloseable.getClass(), string, objectArray, classArray);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "jdbcCall, returned Object:", object4);
                    }
                    object3 = object4;
                }
                catch (SQLException sQLException2) {
                    try {
                        FFDCFilter.processException(sQLException2, "com.ibm.ejs.cm.proxy.WSJdbcUtil.jdbcCall", "183");
                        sQLException = sQLException2;
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "jdbcCall, SQLException during invokeMethod:", sQLException2);
                        }
                        throw ((Proxy)object).translateException(sQLException2);
                    }
                    catch (Throwable throwable) {
                        ((Proxy)object).__postInvoke(sQLException);
                        throw throwable;
                    }
                }
                ((Proxy)object).__postInvoke(sQLException);
                return object3;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "jdbcCall, throwing SQLException: Invalid Caller Type, newCaller is null");
        }
        throw new SQLException("Invalid Caller Type, newCaller is null");
    }

    public static final Object jdbcPass(Object object, String string, Object[] objectArray, Class[] classArray, int[] nArray) throws SQLException {
        return WSJdbcUtil.jdbcPass(object, object.getClass(), string, objectArray, classArray, nArray);
    }

    public static final Object jdbcPass(Class clazz, String string, Object[] objectArray, Class[] classArray, int[] nArray) throws SQLException {
        return WSJdbcUtil.jdbcPass(null, clazz, string, objectArray, classArray, nArray);
    }

    private static final Object jdbcPass(Object object, Class clazz, String string, Object[] objectArray, Class[] classArray, int[] nArray) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "jdbcPass: callOn, ofCaller, methodName, args, types, replace", new Object[]{object, clazz, string, objectArray, classArray, nArray});
        }
        Proxy proxy = null;
        Object[] objectArray2 = (Object[])objectArray.clone();
        for (int i = 0; i < nArray.length; ++i) {
            switch (nArray[i]) {
                case 1: {
                    proxy = (Proxy)objectArray2[i];
                    objectArray2[i] = ((ConnectionProxy)objectArray2[i]).getPhysicalConnection();
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "Replacing ConnectionProxy with Connection " + (Connection)objectArray2[i]);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    proxy = (Proxy)objectArray2[i];
                    objectArray2[i] = ((StatementProxy)objectArray2[i]).getStatement();
                    if (objectArray2[i] instanceof CachedStatement) {
                        objectArray2[i] = ((CachedStatement)objectArray2[i]).getPreparedStatement();
                    }
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "Replacing StatementProxy with Statement " + (Statement)objectArray2[i]);
                    break;
                }
                case 5: {
                    proxy = (Proxy)objectArray2[i];
                    objectArray2[i] = ((ResultSetProxy)objectArray2[i]).getResultSet();
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "Replacing ResultSetProxy with ResultSet " + (ResultSet)objectArray2[i]);
                }
            }
            if (proxy == null || !proxy.isClosed()) continue;
            throw new StaleConnectionException(proxy.getClass() + " is closed");
        }
        if (proxy != null) {
            SQLException sQLException = null;
            Object object2 = proxy.getLockObject();
            synchronized (object2) {
                Object object3;
                try {
                    proxy.__preInvoke();
                    Object object4 = WSJdbcUtil.invokeMethod(object, clazz, string, objectArray2, classArray);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "jdbcPass returning", object4);
                    }
                    object3 = object4;
                }
                catch (SQLException sQLException2) {
                    try {
                        FFDCFilter.processException(sQLException2, "com.ibm.ejs.cm.proxy.WSJdbcUtil.jdbcPass", "387");
                        sQLException = sQLException2;
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "jdbcPass, caught and translating SQLException:", sQLException2);
                        }
                        throw proxy.translateException(sQLException2);
                    }
                    catch (Throwable throwable) {
                        proxy.__postInvoke(sQLException);
                        throw throwable;
                    }
                }
                proxy.__postInvoke(sQLException);
                return object3;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "jdbcPass, throwing SQLException, Proxied object not found!");
        }
        throw new SQLException("Proxied object not found!");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object invokeMethod(Object object, Class clazz, String string, Object[] objectArray, Class[] classArray) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeMethod: caller, ofCaller, methodName, args, types", new Object[]{object, clazz, string, objectArray, classArray});
        }
        try {
            void var5_10;
            String string2;
            block24: {
                Object var5_5 = null;
                StringBuffer stringBuffer = new StringBuffer(100);
                stringBuffer.append(clazz.getName());
                stringBuffer.append(".");
                stringBuffer.append(string);
                for (int i = 0; i < classArray.length; ++i) {
                    stringBuffer.append(",");
                    stringBuffer.append(classArray[i]);
                }
                string2 = stringBuffer.toString();
                AccessibleObject accessibleObject = (AccessibleObject)vendorMethods.get(string2);
                if (accessibleObject == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Method " + string2 + " is not in the vendorMethods cache");
                    }
                    if (WSJdbcUtil.canCallMethod(string2, clazz, string, classArray)) {
                        void var5_9;
                        if (string.equals(CONSTRUCTOR)) {
                            Constructor constructor = clazz.getConstructor(classArray);
                        } else {
                            Method method2 = clazz.getMethod(string, classArray);
                        }
                        vendorMethods.put(string2, var5_9);
                        break block24;
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Method " + string2 + " is a forbidden method");
                        }
                        throw new SQLException(string2 + " call not allowed.  WSCallHelper methods should only be used for proprietary, non-JDBC methods.");
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Method " + string2 + " is in the vendorMethods cache");
                }
            }
            if (var5_10 != null) {
                Object object2 = null;
                if (var5_10 instanceof Method) {
                    object2 = ((Method)var5_10).invoke(object, objectArray);
                } else if (var5_10 instanceof Constructor) {
                    object2 = ((Constructor)var5_10).newInstance(objectArray);
                } else {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "invokeMethod, not a Method or constructor: ", var5_10);
                    }
                    throw new SQLException(string2 + " call not allowed.  WSCallHelper methods should only be used for proprietary, non-JDBC methods or constructors.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "invokeMethod, returning ", object2);
                }
                return object2;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Null method trying to invoke " + string2);
            }
            throw new SQLException(string2 + " method not found.");
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
            Tr.audit(tc, "MSG_CONM_6014I", new Object[]{"InstantiationException", "invokeMethod", "SQLException", instantiationException});
            throw new SQLException("Method " + string + " does not exist on class " + object.getClass().getName());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            FFDCFilter.processException(noSuchMethodException, "com.ibm.ejs.cm.proxy.WSJdbcUtil.invokeMethod", "459");
            noSuchMethodException.printStackTrace();
            Tr.audit(tc, "MSG_CONM_6014I", new Object[]{"NoSuchMethodException", "invokeMethod", "SQLException", noSuchMethodException});
            throw new SQLException("Method " + string + " does not exist on class " + object.getClass().getName());
        }
        catch (IllegalAccessException illegalAccessException) {
            FFDCFilter.processException(illegalAccessException, "com.ibm.ejs.cm.proxy.WSJdbcUtil.invokeMethod", "472");
            illegalAccessException.printStackTrace();
            Tr.audit(tc, "MSG_CONM_6014I", new Object[]{"IllegalAccessException", "invokeMethod", "SQLException", illegalAccessException});
            throw new SQLException("Illegal Access to method " + string + " on class " + object.getClass().getName());
        }
        catch (InvocationTargetException invocationTargetException) {
            FFDCFilter.processException(invocationTargetException, "com.ibm.ejs.cm.proxy.WSJdbcUtil.invokeMethod", "485");
            invocationTargetException.printStackTrace();
            Tr.audit(tc, "MSG_CONM_6014I", new Object[]{"InvocationTargetException", "invokeMethod", "SQLException", invocationTargetException});
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof SQLException) {
                throw (SQLException)throwable;
            }
            throw new SQLException("Invocation Target Exception on method " + string + " on class " + object.getClass().getName() + " exception: " + throwable.toString());
        }
    }

    private static boolean canCallMethod(String string, Class clazz, String string2, Class[] classArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "canCallMethod: key, ofCaller, methodName, types", new Object[]{string, clazz, string2, classArray});
        }
        boolean bl = true;
        if (forbiddenMethods.contains(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Method " + string + " is already on the list of forbidden methods");
            }
            bl = false;
        } else {
            if (Connection.class.isAssignableFrom(clazz)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ofCaller isAssignableFrom Connection");
                }
                boolean bl2 = bl = !WSJdbcUtil.methodExists(ConnectionProxy.class, string2, classArray);
            }
            if (bl && CallableStatement.class.isAssignableFrom(clazz)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ofCaller isAssignableFrom CallableStatement");
                }
                boolean bl3 = bl = !WSJdbcUtil.methodExists(CallableStatementProxy.class, string2, classArray);
            }
            if (bl && PreparedStatement.class.isAssignableFrom(clazz)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ofCaller isAssignableFrom PreparedStatement");
                }
                boolean bl4 = bl = !WSJdbcUtil.methodExists(PreparedStatementProxy.class, string2, classArray);
            }
            if (bl && Statement.class.isAssignableFrom(clazz)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ofCaller isAssignableFrom Statement");
                }
                boolean bl5 = bl = !WSJdbcUtil.methodExists(StatementProxy.class, string2, classArray);
            }
            if (bl && ResultSet.class.isAssignableFrom(clazz)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ofCaller isAssignableFrom ResultSet");
                }
                boolean bl6 = bl = !WSJdbcUtil.methodExists(ResultSetProxy.class, string2, classArray);
            }
            if (!bl) {
                forbiddenMethods.add(string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "canCallMethod", new Boolean(bl));
        }
        return bl;
    }

    private static int getInterfaces(Class clazz) {
        Class clazz2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInterfaces", clazz);
        }
        int n = -1;
        Class<?>[] classArray = clazz.getInterfaces();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, classArray.length + " interfaces for class");
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (n != -1) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking interface " + classArray[i]);
            }
            if (classArray[i].getName().equals("java.sql.ResultSet")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found ResultSet");
                }
                return 5;
            }
            if (classArray[i].getName().equals("java.sql.CallableStatement")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found CallableStatement");
                }
                return 4;
            }
            if (classArray[i].getName().equals("java.sql.PreparedStatement")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found PreparedStatement");
                }
                return 3;
            }
            if (classArray[i].getName().equals("java.sql.Statement")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found Statement");
                }
                return 2;
            }
            if (classArray[i].getName().equals("java.sql.Connection")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found Connection");
                }
                return 1;
            }
            n = WSJdbcUtil.getInterfaces(classArray[i]);
        }
        if (n == -1 && (clazz2 = clazz.getSuperclass()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking interfaces on superclass " + clazz2);
            }
            n = WSJdbcUtil.getInterfaces(clazz2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInterfaces", new Integer(n));
        }
        return n;
    }

    private static boolean methodExists(Class clazz, String string, Class[] classArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "methodExists: caller, methodName, types", new Object[]{clazz, string, classArray});
        }
        if (string.equals(CONSTRUCTOR)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "methodExists: (constructor) true");
            }
            return true;
        }
        try {
            Method method2 = clazz.getMethod(string, classArray);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "methodExists: true");
            }
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            FFDCFilter.processException(noSuchMethodException, "com.ibm.ejs.cm.proxy.WSJdbcUtil.methodExists", "623");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "methodExists: false");
            }
            return false;
        }
    }
}

