/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.EJBNotFoundException;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.ExternalizedBeanId;
import com.ibm.ejs.container.HomeInternal;
import com.ibm.ejs.container.activator.ActivationStrategy;
import com.ibm.ejs.container.util.ByteArray;
import com.ibm.ejs.container.util.EJSPlatformHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.CSIRuntimeException;
import com.ibm.websphere.csi.EJBKey;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.StatefulSessionKey;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.WsObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class BeanId
implements EJBKey,
Serializable {
    private static final TraceComponent tc = Tr.register(BeanId.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.BeanId";
    private static final long serialVersionUID = -7591924738493976976L;
    boolean _isHome;
    Serializable pkey;
    transient J2EEName j2eeName;
    transient ByteArray byteArray;
    byte[] j2eeNameBytes = null;
    transient byte[] serialized;
    transient HomeInternal home;
    transient ActivationStrategy activationStrategy;
    transient int hashValue;
    private static final byte HOME_BEAN = 0;
    private static final byte STATELESS_BEAN = 1;
    private static final byte STATEFUL_BEAN = 2;
    private static final byte ENTITY_BEAN = 3;
    private static final byte MESSAGEDRIVEN_BEAN = 4;
    private static final byte USES_BEAN_MANAGED_TX = 16;
    private static final byte SERIALIZED_PKEY = 0;
    private static final byte INTEGER_PKEY = 1;
    private static final byte STRING_PKEY = 3;
    private static final byte LONG_PKEY = 4;
    private static final byte BYTE_ARRAY_PKEY = 8;
    private static final int BEAN_TYPE_LEN = 1;
    private static final int J2EE_NAME_LEN = 4;
    private static final int PKEY_TYPE_LEN = 1;
    private static final byte[] header = new byte[]{-84, -84, 0, 2, 0, 1};
    private static final int HEADER_LEN = header.length;
    private static final ByteArrayOutputStream[] svBAOSs = new ByteArrayOutputStream[50];
    private static int svBAOSsSize = 0;

    public BeanId() {
        this.pkey = null;
        this.j2eeName = null;
        this._isHome = false;
    }

    public BeanId(HomeInternal homeInternal, Serializable serializable) {
        this(homeInternal, serializable, false);
    }

    public BeanId(HomeInternal homeInternal, Serializable serializable, boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "BeanId", new Object[]{homeInternal, serializable, new Boolean(bl)});
        }
        if (homeInternal == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Home given for BeanId is null, this is most likely an internal PM or container issue");
            }
            throw new CSIRuntimeException("Home given for BeanId is null, this is most likely an internal PM or container issue");
        }
        this.home = homeInternal;
        this._isHome = bl;
        this.j2eeName = homeInternal.getJ2EEName();
        this.j2eeNameBytes = this.j2eeName.getBytes();
        this.pkey = serializable;
        this.hashValue = BeanId.computeHashValue(this.j2eeName, serializable, this._isHome);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "BeanId");
        }
    }

    public BeanId(J2EEName j2EEName, Serializable serializable) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "BeanId", new Object[]{j2EEName, serializable});
        }
        this.home = null;
        this._isHome = true;
        this.j2eeName = j2EEName;
        this.j2eeNameBytes = j2EEName.getBytes();
        this.pkey = serializable;
        this.hashValue = BeanId.computeHashValue(j2EEName, serializable, this._isHome);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "BeanId");
        }
    }

    public final String getJNDIName() {
        return this.home.getJNDIName(this.pkey);
    }

    public final HomeInternal getHome() {
        return this.home;
    }

    public final BeanMetaData getBeanMetaData() {
        return this.home.getBeanMetaData(this);
    }

    public final Serializable getPrimaryKey() {
        return this.pkey;
    }

    public final J2EEName getJ2EEName() {
        return this._isHome ? (J2EEName)this.pkey : this.j2eeName;
    }

    public final ActivationStrategy getActivationStrategy() {
        if (this.activationStrategy == null) {
            this.activationStrategy = this.home.getActivationStrategy();
        }
        return this.activationStrategy;
    }

    public final int hashCode() {
        return this.hashValue;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof BeanId) {
            BeanId beanId = (BeanId)object;
            if (beanId.hashValue == this.hashValue) {
                if (this._isHome) {
                    return this.pkey == beanId.pkey || this.pkey != null && this.pkey.equals(beanId.pkey);
                }
                return this.j2eeName == beanId.j2eeName && (this.pkey == beanId.pkey || this.pkey != null && this.pkey.equals(beanId.pkey));
            }
        }
        return false;
    }

    public final boolean equals(BeanId beanId) {
        if (this == beanId) {
            return true;
        }
        if (beanId != null && beanId.hashValue == this.hashValue) {
            if (this._isHome) {
                return this.pkey == beanId.pkey || this.pkey != null && this.pkey.equals(beanId.pkey);
            }
            return this.j2eeName == beanId.j2eeName && (this.pkey == beanId.pkey || this.pkey != null && this.pkey.equals(beanId.pkey));
        }
        return false;
    }

    public final boolean equals(HomeInternal homeInternal, Serializable serializable, boolean bl) {
        if (bl) {
            return this.pkey == serializable || this.pkey != null && this.pkey.equals(serializable);
        }
        J2EEName j2EEName = homeInternal.getJ2EEName();
        return (this.j2eeName == j2EEName || this.j2eeName.equals(j2EEName)) && (this.pkey == serializable || this.pkey != null && this.pkey.equals(serializable));
    }

    public String toString() {
        return "BeanId(" + this.j2eeName + ", " + this.pkey + ")";
    }

    public final String getIdString() {
        return this.j2eeName + ":" + this.pkey;
    }

    public final byte[] getBytes() {
        if (this.serialized != null) {
            return this.serialized;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = this.getByteArrayStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
            this.serialized = byteArrayOutputStream.toByteArray();
            this.byteArray = new ByteArray(this.serialized);
            this.freeByteArrayStream(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ejs.container.BeanId.getBytes", "492", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Unable to create serialized representation of BeanId: " + this, iOException);
            }
            return null;
        }
        return this.serialized;
    }

    public final ByteArray getByteArray() {
        if (this.byteArray != null) {
            return this.byteArray;
        }
        this.getByteArrayBytes();
        return this.byteArray;
    }

    public final byte[] getByteArrayBytes() {
        if (this.byteArray != null) {
            return this.byteArray.getBytes();
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = this.getByteArrayStream();
            byteArrayOutputStream.write(header);
            byteArrayOutputStream.write(this.getBeanType());
            int n = this.j2eeNameBytes.length;
            if (EJSPlatformHelper.isZOS()) {
                byteArrayOutputStream.write((byte)(n >> 24));
                byteArrayOutputStream.write((byte)(n >> 16));
                byteArrayOutputStream.write((byte)(n >> 8));
                byteArrayOutputStream.write((byte)n);
            } else {
                for (int i = 0; i < 4; ++i) {
                    byteArrayOutputStream.write(n >> i * 8);
                }
            }
            byteArrayOutputStream.write(this.j2eeNameBytes);
            this.writePKeyBytes(byteArrayOutputStream);
            this.serialized = byteArrayOutputStream.toByteArray();
            this.byteArray = new ByteArray(this.serialized);
            this.freeByteArrayStream(byteArrayOutputStream);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.container.BeanId.getByteArrayBytes", "550", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Unable to serialize primary key for bean", new Object[]{this, exception});
            }
            return null;
        }
        return this.serialized;
    }

    private final byte getBeanType() {
        if (this._isHome) {
            return 0;
        }
        if (this.home.isStatelessSessionHome()) {
            if (this.home.getBeanMetaData((Object)this.j2eeName).usesBeanManagedTx) {
                return 17;
            }
            return 1;
        }
        if (this.home.isStatefulSessionHome()) {
            if (this.home.getBeanMetaData((Object)this.j2eeName).usesBeanManagedTx) {
                return 18;
            }
            return 2;
        }
        if (this.home.isMessageDrivenHome()) {
            if (this.home.getBeanMetaData((Object)this.j2eeName).usesBeanManagedTx) {
                return 20;
            }
            return 4;
        }
        return 3;
    }

    public static BeanId deserialize(byte[] byArray, EJSContainer eJSContainer) throws ClassNotFoundException, IOException {
        BeanId beanId;
        block3: {
            final WsObjectInputStream wsObjectInputStream = new WsObjectInputStream(new ByteArrayInputStream(byArray), EJSContainer.classLoader);
            beanId = null;
            try {
                beanId = (BeanId)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException, IOException {
                        return wsObjectInputStream.readObject();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException(privilegedActionException, "com.ibm.ejs.container.BeanId.deserialize", "619");
                Exception exception = privilegedActionException.getException();
                if (exception instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)exception;
                }
                if (!(exception instanceof IOException)) break block3;
                throw (IOException)exception;
            }
        }
        beanId.j2eeName = EJSContainer.getJ2EENameFactory().create(beanId.j2eeNameBytes);
        beanId.home = eJSContainer.getHomeOfHomes().getHome(beanId.j2eeName);
        beanId.j2eeName = beanId.home.getJ2EEName();
        beanId.hashValue = BeanId.computeHashValue(beanId.j2eeName, beanId.pkey, beanId._isHome);
        return beanId;
    }

    public static BeanId getBeanId(ByteArray byteArray, EJSContainer eJSContainer) throws IOException, ClassNotFoundException {
        BeanId beanId = null;
        Serializable serializable = null;
        boolean bl = false;
        J2EEName j2EEName = null;
        byte[] byArray = byteArray.getBytes();
        for (int i = 0; i < HEADER_LEN; ++i) {
            if (byArray[i] == header[i]) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Header mismatch, attempting to deserialize BeanId");
            }
            return BeanId.deserialize(byArray, eJSContainer);
        }
        switch (byArray[HEADER_LEN]) {
            case 0: {
                bl = true;
            }
            case 2: 
            case 3: 
            case 18: {
                byte[] byArray2 = BeanId.readJ2EENameBytes(byArray);
                j2EEName = EJSContainer.getJ2EENameFactory().create(byArray2);
                int n = HEADER_LEN + 1 + 4 + byArray2.length;
                serializable = BeanId.readPKey(byArray, n, j2EEName);
                break;
            }
            case 1: 
            case 4: 
            case 17: 
            case 20: {
                byte[] byArray3 = BeanId.readJ2EENameBytes(byArray);
                j2EEName = EJSContainer.getJ2EENameFactory().create(byArray3);
                serializable = null;
                break;
            }
            default: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Unable to parse bean id: unsupported EJB type: " + byArray[HEADER_LEN]);
                }
                throw new IOException("Unsupported EJB Type: " + byArray[HEADER_LEN]);
            }
        }
        HomeInternal homeInternal = eJSContainer.getHomeOfHomes().getHome(j2EEName);
        if (homeInternal == null) {
            Tr.warning(tc, "HOME_NOT_FOUND_CNTR0092W", ((Object)j2EEName).toString());
            throw new EJBNotFoundException(((Object)j2EEName).toString());
        }
        if (homeInternal.isStatefulSessionHome()) {
            serializable = EJSContainer.sessionKeyFactory.create((byte[])serializable);
        }
        if (bl) {
            serializable = EJSContainer.getJ2EENameFactory().create((byte[])serializable);
        }
        beanId = new BeanId(homeInternal, serializable, bl);
        beanId.byteArray = byteArray;
        return beanId;
    }

    private static byte[] readJ2EENameBytes(byte[] byArray) {
        int n;
        int n2 = 0;
        int n3 = HEADER_LEN + 1;
        if (EJSPlatformHelper.isZOS()) {
            n = n3;
            n2 = (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
        } else {
            for (n = 3; n >= 0; --n) {
                n2 ^= byArray[n3 + n] & 0xFF;
                if (n <= 0) continue;
                n2 <<= 8;
            }
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n3 += 4, byArray2, 0, n2);
        return byArray2;
    }

    private static Serializable readPKey(byte[] byArray, int n, J2EEName j2EEName) throws IOException, ClassNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "readPKey", new Object[]{new Integer(n), j2EEName});
        }
        Object object = null;
        int n2 = byArray.length - n - 1;
        int n3 = n++;
        byte by = byArray[n3++];
        switch (by) {
            case 0: {
                object = BeanId.readSerializedPKey(byArray, n, n2, j2EEName);
                break;
            }
            case 1: {
                int n4 = 0;
                for (int i = 3; i >= 0; --i) {
                    n4 ^= byArray[n3 + i] & 0xFF;
                    if (i <= 0) continue;
                    n4 <<= 8;
                }
                object = new Integer(n4);
                break;
            }
            case 4: {
                long l = 0L;
                for (int i = 7; i >= 0; --i) {
                    l ^= (long)byArray[n3 + i] & 0xFFL;
                    if (i <= 0) continue;
                    l <<= 8;
                }
                object = new Long(l);
                break;
            }
            case 3: {
                object = new String(byArray, n, n2);
                break;
            }
            case 8: {
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, n, byArray2, 0, n2);
                object = byArray2;
                break;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "readPKey", object);
        }
        return object;
    }

    private static Serializable readSerializedPKey(byte[] byArray, int n, int n2, J2EEName j2EEName) throws IOException, ClassNotFoundException {
        Serializable serializable;
        block3: {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
            final WsObjectInputStream wsObjectInputStream = new WsObjectInputStream(byteArrayInputStream, EJSContainer.getClassLoader(j2EEName));
            serializable = null;
            try {
                serializable = (Serializable)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException, IOException {
                        return wsObjectInputStream.readObject();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException(privilegedActionException, "com.ibm.ejs.container.BeanId.readSerializedPKey", "863");
                Exception exception = privilegedActionException.getException();
                if (exception instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)exception;
                }
                if (!(exception instanceof IOException)) break block3;
                throw (IOException)exception;
            }
        }
        return serializable;
    }

    protected static byte[] getJ2EENameBytes(byte[] byArray) throws CSIException {
        int n;
        boolean bl = false;
        byte[] byArray2 = null;
        for (n = 0; n < HEADER_LEN; ++n) {
            if (byArray[n] == header[n]) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Header mismatch, attempting to deserialize BeanId");
            }
            throw new CSIException("Parser Error: header mismatch");
        }
        switch (byArray[HEADER_LEN]) {
            case 0: {
                bl = true;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 17: 
            case 18: 
            case 20: {
                byArray2 = BeanId.readJ2EENameBytes(byArray);
                break;
            }
            default: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Unable to parse bean id: unsupported EJB type: " + byArray[HEADER_LEN]);
                }
                throw new CSIException("Unsupported EJB Type: " + byArray[HEADER_LEN]);
            }
        }
        if (bl) {
            try {
                n = HEADER_LEN + 1 + 4 + byArray2.length;
                byArray2 = (byte[])BeanId.readPKey(byArray, n, null);
            }
            catch (Throwable throwable) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Unable to parse bean id: home j2eeName: " + throwable);
                }
                throw new CSIException("Unable to read j2eeName bytes", throwable);
            }
        }
        return byArray2;
    }

    protected static Serializable getPrimaryKey(byte[] byArray) throws CSIException {
        boolean bl = false;
        Serializable serializable = null;
        byte[] byArray2 = null;
        J2EEName j2EEName = null;
        for (int i = 0; i < HEADER_LEN; ++i) {
            if (byArray[i] == header[i]) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Header mismatch, attempting to deserialize BeanId");
            }
            throw new CSIException("Parser Error: header mismatch");
        }
        switch (byArray[HEADER_LEN]) {
            case 0: 
            case 1: 
            case 4: 
            case 17: 
            case 20: {
                break;
            }
            case 2: 
            case 18: {
                bl = true;
            }
            case 3: {
                byArray2 = BeanId.readJ2EENameBytes(byArray);
                j2EEName = EJSContainer.getJ2EENameFactory().create(byArray2);
                int n = HEADER_LEN + 1 + 4 + byArray2.length;
                try {
                    serializable = BeanId.readPKey(byArray, n, j2EEName);
                    break;
                }
                catch (Throwable throwable) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Unable to parse bean id: primary key: " + throwable);
                    }
                    throw new CSIException("Unable to read primary key", throwable);
                }
            }
            default: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Unable to parse bean id: unsupported EJB type: " + byArray[HEADER_LEN]);
                }
                throw new CSIException("Unsupported EJB Type: " + byArray[HEADER_LEN]);
            }
        }
        if (bl) {
            serializable = EJSContainer.sessionKeyFactory.create((byte[])serializable);
        }
        return serializable;
    }

    public final Object getSecurityMetaData() {
        return this.home.getSecurityMetaData(this.pkey);
    }

    public final String getMethodName(int n) {
        return this.home.getMethodName(this.pkey, n, this._isHome);
    }

    public final boolean isHome() {
        return this._isHome;
    }

    public final String getEnterpriseBeanClassName() {
        return this.home.getEnterpriseBeanClassName(this.pkey);
    }

    protected static int computeHashValue(J2EEName j2EEName, Serializable serializable, boolean bl) {
        return j2EEName.hashCode() + (serializable == null ? 0 : serializable.hashCode()) + (bl ? 1 : 0);
    }

    private Object writeReplace() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "writeReplace");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "writeReplace");
        }
        return new ExternalizedBeanId(this.pkey, this.j2eeName, this._isHome);
    }

    public final boolean useLSD() {
        if (this._isHome) {
            return true;
        }
        BeanMetaData beanMetaData = this.home.getBeanMetaData(this.j2eeName);
        return beanMetaData.type == 5 || beanMetaData.type == 2 || beanMetaData.type == 4 || beanMetaData.ivSFSBFailover;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ByteArrayOutputStream getByteArrayStream() {
        ByteArrayOutputStream byteArrayOutputStream = null;
        ByteArrayOutputStream[] byteArrayOutputStreamArray = svBAOSs;
        synchronized (svBAOSs) {
            if (svBAOSsSize > 0) {
                byteArrayOutputStream = svBAOSs[--svBAOSsSize];
                BeanId.svBAOSs[BeanId.svBAOSsSize] = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (byteArrayOutputStream == null) {
                byteArrayOutputStream = new ByteArrayOutputStream();
            } else {
                byteArrayOutputStream.reset();
            }
            return byteArrayOutputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void freeByteArrayStream(ByteArrayOutputStream byteArrayOutputStream) {
        ByteArrayOutputStream[] byteArrayOutputStreamArray = svBAOSs;
        synchronized (svBAOSs) {
            if (svBAOSsSize < svBAOSs.length) {
                BeanId.svBAOSs[BeanId.svBAOSsSize] = byteArrayOutputStream;
                ++svBAOSsSize;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private final void writePKeyBytes(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        if (this.pkey != null) {
            if (this._isHome) {
                byteArrayOutputStream.write(8);
                byteArrayOutputStream.write(((J2EEName)this.pkey).getBytes());
            } else if (this.home.isStatefulSessionHome()) {
                byteArrayOutputStream.write(8);
                byteArrayOutputStream.write(((StatefulSessionKey)this.pkey).getBytes());
            } else if (this.pkey.getClass().getName().startsWith("java.lang")) {
                if (this.pkey instanceof Integer) {
                    byteArrayOutputStream.write(1);
                    int n = (Integer)this.pkey;
                    for (int i = 0; i < 4; ++i) {
                        byteArrayOutputStream.write(n >> i * 8);
                    }
                } else if (this.pkey instanceof Long) {
                    byteArrayOutputStream.write(4);
                    long l = (Long)this.pkey;
                    for (int i = 0; i < 8; ++i) {
                        byteArrayOutputStream.write((byte)(l >> i * 8));
                    }
                } else if (this.pkey instanceof String) {
                    byteArrayOutputStream.write(3);
                    byteArrayOutputStream.write(((String)((Object)this.pkey)).getBytes());
                } else {
                    this.writeSerializedPKey(byteArrayOutputStream);
                }
            } else {
                this.writeSerializedPKey(byteArrayOutputStream);
            }
        }
    }

    private final void writeSerializedPKey(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        byteArrayOutputStream.write(0);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(this.pkey);
        objectOutputStream.flush();
    }
}

