/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.CMRHelperImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cpmi.association.CMRHelper;

public class CMRHelperStack {
    private static final TraceComponent tc = Tr.register(CMRHelperStack.class, "EJBContainer", "com.ibm.ejs.container.container");
    private CMRHelper[] ivElements;
    private int ivCapacity;
    private int ivTopOfStack = 0;

    public CMRHelperStack(int n) {
        this.ivElements = new CMRHelper[n];
        this.ivCapacity = n;
        for (int i = 0; i < this.ivCapacity; ++i) {
            this.ivElements[i] = new CMRHelperImpl();
        }
    }

    public CMRHelper get() {
        CMRHelper cMRHelper = this.ivTopOfStack < this.ivCapacity ? this.ivElements[this.ivTopOfStack] : new CMRHelperImpl();
        ++this.ivTopOfStack;
        return cMRHelper;
    }

    public final void done(CMRHelper cMRHelper) {
        if (this.ivTopOfStack > 0) {
            --this.ivTopOfStack;
            if (this.ivTopOfStack < this.ivCapacity && cMRHelper != this.ivElements[this.ivTopOfStack]) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "CMRHelperStack.done: disabled: improper use of get/release");
                    Tr.debug(tc, "                     top    = " + this.ivTopOfStack);
                    Tr.debug(tc, "                     helper = " + cMRHelper);
                    for (int i = 0; i < this.ivCapacity; ++i) {
                        Tr.debug(tc, "                     element[" + i + "] = " + this.ivElements[i]);
                    }
                }
                this.ivCapacity = 0;
                this.ivElements = null;
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "CMRHelperStack.done: call made with top = " + this.ivTopOfStack + ", likely due to problem with java.lang.ThreadLocal");
        }
    }
}

