/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanO;
import com.ibm.ejs.container.ContainerTx;
import com.ibm.ejs.container.EJBMethodInfoImpl;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSDeployedSupport;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cpi.CPIException;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.CSITransactionRolledbackException;
import com.ibm.websphere.csi.EJBKey;
import com.ibm.ws.LocalTransaction.ContainerSynchronization;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.transaction.Synchronization;

public class ContainerAS
implements Synchronization,
ContainerSynchronization {
    private static final TraceComponent tc = Tr.register(ContainerAS.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.ContainerAs";
    private static final int ACTIVE = 0;
    private static final int PREPARING = 1;
    private static final int COMPLETING = 2;
    private static final String[] stateStrs = new String[]{"Active", "Preparing", "Completing"};
    private EJSContainer container;
    private HashMap beanOs;
    private ArrayList beanOList;
    private int state;
    private Object asKey;
    private long ivASCacheHits = 0L;
    private long ivASCacheSearch = 0L;

    private final synchronized void becomePreparing() {
        if (this.state != 0) {
            throw new IllegalStateException(stateStrs[this.state]);
        }
        this.state = 1;
    }

    private final synchronized void becomeCompleting() {
        if (this.state != 1) {
            throw new IllegalStateException(stateStrs[this.state]);
        }
        this.state = 2;
    }

    private final synchronized void ensureActive() {
        switch (this.state) {
            case 0: {
                break;
            }
            default: {
                throw new IllegalStateException(stateStrs[this.state]);
            }
        }
    }

    public ContainerAS(EJSContainer eJSContainer, Object object) {
        this.container = eJSContainer;
        this.asKey = object;
        this.beanOs = new HashMap();
        this.beanOList = new ArrayList();
        this.state = 0;
    }

    public void beforeCompletion() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeCompletion");
        }
        this.becomePreparing();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeCompletion");
        }
    }

    public void afterCompletion(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "afterCompletion", new Object[]{new Integer(n), this});
        }
        try {
            BeanO[] beanOArray = this.getBeanOs();
            EJBKey[] eJBKeyArray = this.getEJBKeys(beanOArray);
            if (beanOArray != null) {
                for (int i = 0; i < beanOArray.length; ++i) {
                    BeanO beanO = beanOArray[i];
                    try {
                        this.container.activator.unitOfWorkEnd(this, beanO);
                        continue;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ejs.container.ContainerAs.afterCompletion", "214", this);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                        Tr.event(tc, "Exception thrown in afterCompletion()", new Object[]{beanO, throwable});
                    }
                }
            }
            this.container.uowCtrl.sessionEnded(eJBKeyArray);
            ContainerTx containerTx = this.container.getCurrentTx(false);
            if (containerTx != null) {
                containerTx.setContainerAS(null);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "removed ContainerAS during afterCompletion");
                }
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ejs.container.ContainerAs.afterCompletion", "219", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Exception during afterCompletion", throwable);
            }
            throw new RuntimeException(throwable.toString());
        }
        finally {
            this.container.containerASCompleted(this.asKey);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "afterCompletion");
        }
    }

    public BeanO find(BeanId beanId) {
        BeanO beanO = (BeanO)this.beanOs.get(beanId);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            ++this.ivASCacheSearch;
            if (beanO != null) {
                ++this.ivASCacheHits;
                Tr.debug(tc, "Bean found in ActivitySession cache (Hit Rate:" + this.ivASCacheHits + "/" + this.ivASCacheSearch + ")");
            } else {
                Tr.debug(tc, "Bean not in ActivitySession cache (Hit Rate:" + this.ivASCacheHits + "/" + this.ivASCacheSearch + ")");
            }
        }
        return beanO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enlist(BeanO beanO) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "enlist", beanO);
        }
        this.ensureActive();
        HashMap hashMap = this.beanOs;
        synchronized (hashMap) {
            BeanO beanO2 = this.beanOs.put(beanO.beanId, beanO);
            if (beanO2 == null) {
                this.beanOList.add(beanO);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "enlist", new Boolean(true));
                }
                return true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "enlist", beanO);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delist(BeanO beanO) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "delist", beanO);
        }
        this.ensureActive();
        HashMap hashMap = this.beanOs;
        synchronized (hashMap) {
            this.beanOs.remove(beanO.beanId);
            this.beanOList.remove(beanO);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "delist", beanO);
        }
    }

    public void registerSynchronization(Synchronization synchronization) throws CPIException {
        try {
            this.container.uowCtrl.enlistWithSession(synchronization);
        }
        catch (CSIException cSIException) {
            throw new CPIException(cSIException.toString());
        }
    }

    private EJBKey[] getEJBKeys(BeanO[] beanOArray) {
        EJBKey[] eJBKeyArray = null;
        if (beanOArray != null) {
            eJBKeyArray = new EJBKey[beanOArray.length];
            for (int i = 0; i < beanOArray.length; ++i) {
                eJBKeyArray[i] = beanOArray[i].getId();
            }
        }
        return eJBKeyArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BeanO[] getBeanOs() {
        BeanO[] beanOArray;
        HashMap hashMap = this.beanOs;
        synchronized (hashMap) {
            beanOArray = new BeanO[this.beanOs.size()];
            Iterator iterator = this.beanOs.values().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                beanOArray[n++] = (BeanO)iterator.next();
            }
        }
        return beanOArray;
    }

    boolean isBmasActive(EJBMethodInfoImpl eJBMethodInfoImpl) {
        return this.container.uowCtrl.isBmasActive(eJBMethodInfoImpl);
    }

    public final void preInvoke(EJSDeployedSupport eJSDeployedSupport) {
        this.ensureActive();
    }

    public final void postInvoke(EJSDeployedSupport eJSDeployedSupport) {
    }

    public static ContainerAS getContainerAS(ContainerTx containerTx) {
        ContainerAS containerAS;
        block3: {
            containerAS = null;
            try {
                if (containerTx != null) {
                    containerAS = containerTx.getContainerAS();
                    return containerAS;
                }
                containerAS = ContainerAS.getCurrentContainerAS();
            }
            catch (CSIException cSIException) {
                FFDCFilter.processException(cSIException, "com.ibm.ejs.container.ContainerAs.getContainerAS", "402");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block3;
                Tr.event(tc, "Exception thrown getting ContainerAS", (Object)cSIException);
            }
        }
        return containerAS;
    }

    public static ContainerAS getCurrentContainerAS() throws CSIException, CSITransactionRolledbackException {
        EJSContainer eJSContainer = EJSContainer.getDefaultContainer();
        ContainerAS containerAS = null;
        containerAS = eJSContainer.getCurrentSessionalUOW(false);
        return containerAS;
    }

    public void setCompleting(boolean bl) {
    }

    public void dump() {
        Tr.dump(tc, "-- ContainerAS Dump --", new Object[]{this, this.beanOs});
    }
}

