/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.EJSDeployedSupport;
import com.ibm.ejs.container.EJSWrapperBase;
import com.ibm.ejs.container.LocalExceptionMappingStrategy;
import com.ibm.ejs.container.RemoteExceptionMappingStrategy;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.MethodInterface;

class EJSDeployedSupportStack {
    private static final TraceComponent tc = Tr.register(EJSDeployedSupportStack.class, "EJBContainer", "com.ibm.ejs.container.container");
    private EJSDeployedSupport[] elements;
    private int topOfStack = 0;
    private boolean orig = false;
    private LocalExceptionMappingStrategy[] localExceptionMappingStrategies;
    private RemoteExceptionMappingStrategy[] remoteExceptionMappingStrategies;

    EJSDeployedSupportStack(int n) {
        this.elements = new EJSDeployedSupport[n];
        this.localExceptionMappingStrategies = new LocalExceptionMappingStrategy[n];
        this.remoteExceptionMappingStrategies = new RemoteExceptionMappingStrategy[n];
        for (int i = 0; i < n; ++i) {
            this.elements[i] = new EJSDeployedSupport();
            this.localExceptionMappingStrategies[i] = new LocalExceptionMappingStrategy(this.elements[i]);
            this.remoteExceptionMappingStrategies[i] = new RemoteExceptionMappingStrategy(this.elements[i]);
        }
    }

    final EJSDeployedSupport get(EJSWrapperBase eJSWrapperBase) {
        EJSDeployedSupport eJSDeployedSupport = null;
        if (this.topOfStack < 0 || this.orig) {
            this.orig = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "EJSDeployedSupportStack::get called withTopOfStack or in orig mode: " + this.topOfStack + " orig:  " + this.orig);
            }
            this.elements = null;
            eJSDeployedSupport = new EJSDeployedSupport(eJSWrapperBase);
        } else if (this.topOfStack < this.elements.length) {
            MethodInterface methodInterface = eJSWrapperBase.methodInfos[0].ivInterface;
            if (methodInterface == MethodInterface.REMOTE || methodInterface == MethodInterface.HOME || methodInterface == MethodInterface.SERVICE_ENDPOINT) {
                RemoteExceptionMappingStrategy remoteExceptionMappingStrategy = this.remoteExceptionMappingStrategies[this.topOfStack];
                remoteExceptionMappingStrategy.ivOrbUtils = methodInterface == MethodInterface.SERVICE_ENDPOINT ? null : eJSWrapperBase.container.orbUtils;
                this.elements[this.topOfStack].exceptionStrategy = remoteExceptionMappingStrategy;
            } else {
                this.elements[this.topOfStack].exceptionStrategy = this.localExceptionMappingStrategies[this.topOfStack];
            }
            eJSDeployedSupport = this.elements[this.topOfStack++];
        } else {
            ++this.topOfStack;
            eJSDeployedSupport = new EJSDeployedSupport(eJSWrapperBase);
        }
        return eJSDeployedSupport;
    }

    final void done(EJSDeployedSupport eJSDeployedSupport) {
        if (this.orig || eJSDeployedSupport == null || this.topOfStack == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "EJSDeployedSupportStack::done called with TopOfStack=" + this.topOfStack + " s: " + eJSDeployedSupport + " orig=" + this.orig);
            }
            this.orig = true;
            this.elements = null;
        } else {
            --this.topOfStack;
            if (this.topOfStack < this.elements.length) {
                if (eJSDeployedSupport != this.elements[this.topOfStack]) {
                    this.orig = true;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "EJSDeployedSupportStack::done called with wrong value for TopOfStack: " + eJSDeployedSupport + "!=" + this.elements[this.topOfStack]);
                    }
                    this.elements = null;
                } else {
                    this.elements[this.topOfStack].initializeInstanceData();
                }
            }
        }
    }
}

