/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.ContainerException;
import com.ibm.ejs.container.ContainerProperties;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSLocalWrapper;
import com.ibm.ejs.container.EJSWrapper;
import com.ibm.ejs.container.WrapperManager;
import com.ibm.ejs.container.drs.SfDRSClient;
import com.ibm.ejs.container.util.EJSPlatformHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.cache.Element;
import com.ibm.ejs.util.cache.WrapperBucket;
import com.ibm.ejs.util.dopriv.SetContextClassLoaderPrivileged;
import com.ibm.websphere.pmi.PmiBean;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.ThreadContextAccessor;
import java.rmi.RemoteException;
import java.security.PrivilegedAction;

public final class EJSWrapperCommon
extends Element {
    private static final TraceComponent tc = Tr.register(EJSWrapperCommon.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.EJSWrapperCommon";
    private static final boolean isZOS = EJSPlatformHelper.isZOS();
    protected EJSWrapper remoteWrapper;
    protected EJSLocalWrapper localWrapper;
    protected EJSLocalWrapper wsEndpointWrapper;
    protected boolean isHome;
    protected boolean isRemoteRegistered;
    public WrapperBucket ivWrapperCacheBucket;
    protected BeanMetaData ivBMD;
    private static final ThreadContextAccessor threadContextAccessor = (ThreadContextAccessor)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

        public Object run() {
            return ThreadContextAccessor.getThreadContextAccessor();
        }
    });

    public EJSWrapperCommon(Class clazz, Class clazz2, Class clazz3, BeanId beanId, BeanMetaData beanMetaData, PmiBean pmiBean, EJSContainer eJSContainer, WrapperManager wrapperManager, boolean bl) throws RemoteException {
        super(beanId.getByteArray());
        String string = null;
        try {
            this.isHome = bl;
            this.ivBMD = beanMetaData;
            if (clazz != null) {
                string = clazz.getName();
                this.remoteWrapper = (EJSWrapper)clazz.newInstance();
                this.remoteWrapper.beanId = beanId;
                this.remoteWrapper.bmd = beanMetaData;
                this.remoteWrapper.methodInfos = bl ? beanMetaData.homeMethodInfos : beanMetaData.methodInfos;
                this.remoteWrapper.isolationAttrs = bl ? beanMetaData.homeIsolationAttrs : beanMetaData.isolationAttrs;
                this.remoteWrapper.methodNames = bl ? beanMetaData.homeMethodNames : beanMetaData.methodNames;
                this.remoteWrapper.container = eJSContainer;
                this.remoteWrapper.wrapperManager = wrapperManager;
                this.remoteWrapper.ivPmiBean = pmiBean;
                this.remoteWrapper.ivCommon = this;
                this.remoteWrapper.isManagedWrapper = true;
                if (bl || !beanMetaData.isStatefulSessionBean()) {
                    this.remoteWrapper.ivCluster = beanMetaData.ivCluster;
                } else {
                    this.remoteWrapper.ivCluster = null;
                    SfDRSClient sfDRSClient = beanMetaData.ivSfDRSClient;
                    if (sfDRSClient != null) {
                        this.remoteWrapper.ivCluster = sfDRSClient.getWLMIdentity(beanId);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "SFSB WLM Cluster Identity from DRS: " + this.remoteWrapper.ivCluster);
                    }
                }
            }
            if (clazz2 != null) {
                string = clazz2.getName();
                this.localWrapper = (EJSLocalWrapper)clazz2.newInstance();
                this.localWrapper.beanId = beanId;
                this.localWrapper.bmd = beanMetaData;
                this.localWrapper.methodInfos = bl ? beanMetaData.localHomeMethodInfos : beanMetaData.localMethodInfos;
                this.localWrapper.methodNames = bl ? beanMetaData.localHomeMethodNames : beanMetaData.localMethodNames;
                this.localWrapper.container = eJSContainer;
                this.localWrapper.wrapperManager = wrapperManager;
                this.localWrapper.ivPmiBean = pmiBean;
                this.localWrapper.ivCommon = this;
                this.localWrapper.isManagedWrapper = false;
            }
            if (clazz3 != null) {
                string = clazz3.getName();
                this.wsEndpointWrapper = (EJSLocalWrapper)clazz3.newInstance();
                this.wsEndpointWrapper.beanId = beanId;
                this.wsEndpointWrapper.bmd = beanMetaData;
                this.wsEndpointWrapper.methodInfos = bl ? beanMetaData.wsEndpointBasicSLSBHomeMethodInfos : beanMetaData.wsEndpointMethodInfos;
                this.wsEndpointWrapper.methodNames = bl ? beanMetaData.wsEndpointBasicSLSBHomeMethodNames : beanMetaData.wsEndpointMethodNames;
                this.wsEndpointWrapper.container = eJSContainer;
                this.wsEndpointWrapper.wrapperManager = wrapperManager;
                this.wsEndpointWrapper.ivPmiBean = pmiBean;
                this.wsEndpointWrapper.ivCommon = this;
                this.wsEndpointWrapper.isManagedWrapper = false;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.container.EJSWrapperCommon.EJSWrapperCommon", "123", this);
            throw new ContainerException(string, (Throwable)exception);
        }
    }

    public EJSWrapper getRemoteWrapper() {
        if (this.remoteWrapper == null) {
            throw new IllegalStateException("Remote interface not defined");
        }
        this.registerServant();
        return this.remoteWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerServant() {
        block15: {
            if (this.remoteWrapper == null) break block15;
            EJSWrapper eJSWrapper = this.remoteWrapper;
            synchronized (eJSWrapper) {
                block14: {
                    if (this.isRemoteRegistered) break block14;
                    try {
                        block13: {
                            if (!isZOS) {
                                ClassLoader classLoader = null;
                                boolean bl = false;
                                SetContextClassLoaderPrivileged setContextClassLoaderPrivileged = null;
                                try {
                                    if (ContainerProperties.PK92914) {
                                        setContextClassLoaderPrivileged = new SetContextClassLoaderPrivileged(threadContextAccessor);
                                        classLoader = setContextClassLoaderPrivileged.execute(this.ivBMD.classLoader);
                                        bl = setContextClassLoaderPrivileged.wasChanged;
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                            if (bl) {
                                                Tr.debug(tc, "registerServant : old ClassLoader = " + classLoader);
                                                Tr.debug(tc, "registerServant : new ClassLoader = " + this.ivBMD.classLoader);
                                            } else {
                                                Tr.debug(tc, "registerServant : current ClassLoader = " + this.ivBMD.classLoader);
                                            }
                                        }
                                    }
                                    this.remoteWrapper.wrapperManager.oa.registerServant(this.remoteWrapper, this.remoteWrapper.beanId.getByteArray(), this.remoteWrapper.ivCluster, this.remoteWrapper.beanId.useLSD());
                                    if (!ContainerProperties.PK92914 || !bl) break block13;
                                    setContextClassLoaderPrivileged.execute(classLoader);
                                }
                                catch (Throwable throwable) {
                                    if (ContainerProperties.PK92914 && bl) {
                                        setContextClassLoaderPrivileged.execute(classLoader);
                                    }
                                    throw throwable;
                                }
                            }
                        }
                        this.isRemoteRegistered = true;
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.container.EJSWrapperCommon.registerServant", "184", this);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block14;
                        Tr.event(tc, "Failed to register wrapper instance", new Object[]{this.remoteWrapper, exception});
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterServant() {
        if (this.remoteWrapper != null) {
            EJSWrapper eJSWrapper = this.remoteWrapper;
            synchronized (eJSWrapper) {
                block8: {
                    if (this.isRemoteRegistered) {
                        try {
                            if (!isZOS || this.remoteWrapper.intie != null) {
                                this.remoteWrapper.wrapperManager.oa.unregisterServant(this.remoteWrapper);
                            }
                            this.isRemoteRegistered = false;
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.container.EJSWrapperCommon.unregisterServant", "207", this);
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block8;
                            Tr.event(tc, "Failed to unregister wrapper instance", new Object[]{this.remoteWrapper, exception});
                        }
                    }
                }
            }
        }
    }

    public EJSLocalWrapper getLocalWrapper() {
        if (this.localWrapper == null) {
            throw new IllegalStateException("Local interface not defined");
        }
        return this.localWrapper;
    }

    public EJSLocalWrapper getWSEndpointWrapper() {
        if (this.wsEndpointWrapper == null) {
            throw new IllegalStateException("WebService Endpoint interface not defined");
        }
        return this.wsEndpointWrapper;
    }

    public BeanId getBeanId() {
        return this.remoteWrapper != null ? this.remoteWrapper.beanId : (this.localWrapper != null ? this.localWrapper.beanId : this.wsEndpointWrapper.beanId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pinOnce() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "pinOnce: " + this.getBeanId());
        }
        boolean bl = false;
        WrapperBucket wrapperBucket = this.ivWrapperCacheBucket;
        synchronized (wrapperBucket) {
            if (this.pinned == 0) {
                ++this.pinned;
                bl = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "pinOnce : " + this.pinned);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpin() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "unpin: " + this.getBeanId());
        }
        WrapperBucket wrapperBucket = this.ivWrapperCacheBucket;
        synchronized (wrapperBucket) {
            if (this.pinned > 0) {
                --this.pinned;
                this.ivWrapperCacheBucket.ivWrapperCache.touch(this);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "unpin: Not pinned : " + this.pinned);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "unpin");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inCache() {
        boolean bl = false;
        WrapperBucket wrapperBucket = this.ivWrapperCacheBucket;
        synchronized (wrapperBucket) {
            if (this.pinned >= 0) {
                this.ivWrapperCacheBucket.ivWrapperCache.touch(this);
                bl = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "touch: inCache = " + bl + ", " + this.getBeanId());
        }
        return bl;
    }

    public String toString() {
        BeanId beanId = null;
        if (this.remoteWrapper != null) {
            beanId = this.remoteWrapper.beanId;
        } else if (this.localWrapper != null) {
            beanId = this.localWrapper.beanId;
        } else if (this.wsEndpointWrapper != null) {
            beanId = this.wsEndpointWrapper.beanId;
        }
        return "EJSWrapperCommon(" + beanId + ", " + (this.remoteWrapper != null ? this.remoteWrapper.getClass().getName() : "NoRemote") + ", " + (this.localWrapper != null ? this.localWrapper.getClass().getName() : "NoLocal") + ", " + (this.wsEndpointWrapper != null ? this.wsEndpointWrapper.getClass().getName() : "NoWSEndpoint") + ", " + "pinned = " + this.pinned + ", accessed = " + this.accessedSweep + ")";
    }
}

