/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanNotReentrantException;
import com.ibm.ejs.container.ContainerProperties;
import com.ibm.ejs.container.CreateFailureException;
import com.ibm.ejs.container.EJSDeployedSupport;
import com.ibm.ejs.container.ExceptionMappingStrategy;
import com.ibm.ejs.container.InvalidTransactionLocalException;
import com.ibm.ejs.container.util.ExceptionUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.CSIAccessException;
import com.ibm.websphere.csi.CSIActivityCompletedException;
import com.ibm.websphere.csi.CSIActivityRequiredException;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.CSIInvalidActivityException;
import com.ibm.websphere.csi.CSIInvalidTransactionException;
import com.ibm.websphere.csi.CSINoSuchObjectException;
import com.ibm.websphere.csi.CSITransactionRequiredException;
import com.ibm.websphere.csi.CSITransactionRolledbackException;
import com.ibm.websphere.csi.ExceptionType;
import com.ibm.websphere.csi.OrbUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.ActivityCompletedException;
import com.ibm.ws.javax.activity.ActivityRequiredException;
import com.ibm.ws.javax.activity.InvalidActivityException;
import com.ibm.ws.javax.ejb.ActivityCompletedLocalException;
import com.ibm.ws.javax.ejb.ActivityRequiredLocalException;
import com.ibm.ws.javax.ejb.InvalidActivityLocalException;
import java.rmi.AccessException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import javax.ejb.AccessLocalException;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.TransactionRequiredLocalException;
import javax.ejb.TransactionRolledbackLocalException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.TransactionRequiredException;
import javax.transaction.TransactionRolledbackException;

public class RemoteExceptionMappingStrategy
extends ExceptionMappingStrategy {
    protected static TraceComponent tc = Tr.register(RemoteExceptionMappingStrategy.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.RemoteExceptionMappingStrategy";
    OrbUtils ivOrbUtils = null;

    public RemoteExceptionMappingStrategy(EJSDeployedSupport eJSDeployedSupport) {
        super(eJSDeployedSupport);
        this.ivOrbUtils = eJSDeployedSupport.container.orbUtils;
    }

    private Throwable mapException(RemoteException remoteException) {
        try {
            if (remoteException instanceof CSIException) {
                CSIException cSIException = (CSIException)((Object)remoteException);
                return this.mapCSIException(cSIException);
            }
            if (remoteException.detail instanceof CSIException) {
                CSIException cSIException = (CSIException)remoteException.detail;
                return this.mapCSIException(cSIException);
            }
            if (remoteException instanceof CreateFailureException) {
                if (this.ivOrbUtils == null) {
                    return remoteException;
                }
                return this.ivOrbUtils.mapException(remoteException);
            }
            if (remoteException.detail instanceof EJBException) {
                EJBException eJBException = (EJBException)remoteException.detail;
                return this.mapEJBException(eJBException);
            }
            if (this.ivOrbUtils == null) {
                return remoteException;
            }
            return this.ivOrbUtils.mapException(remoteException);
        }
        catch (CSIException cSIException) {
            FFDCFilter.processException((Throwable)cSIException, "com.ibm.ejs.container.RemoteExceptionMappingStrategy.mapException", "119", this);
            Tr.warning(tc, "UNABLE_TO_MAP_EXCEPTION_CNTR0013W", new Object[]{remoteException, cSIException});
            return remoteException;
        }
    }

    public final Exception setUncheckedException(Throwable throwable) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setUncheckedException in param:" + throwable);
        }
        if (this.ex == null) {
            if (this.thisStrategiesOwner.preInvokeException && (throwable instanceof NoSuchObjectException || throwable instanceof CSIAccessException || throwable instanceof BeanNotReentrantException)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception should not cause rollback, changing to checked exception");
                }
                if (throwable instanceof BeanNotReentrantException) {
                    this.thisStrategiesOwner.beanO = null;
                }
                this.exType = ExceptionType.CHECKED_EXCEPTION;
            } else {
                this.exType = ExceptionType.UNCHECKED_EXCEPTION;
                ExceptionUtil.logException(throwable, this.thisStrategiesOwner.getEJBMethodInfo(), this.thisStrategiesOwner.getBeanO());
            }
            this.root = this.findRootCause(throwable);
            if (!(throwable instanceof RemoteException)) {
                throwable = new RemoteException("", throwable);
                throwable.setStackTrace(this.root.getStackTrace());
            }
            this.ex = (Exception)this.mapException((RemoteException)throwable);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "setting unchecked exception again", throwable);
            Tr.event(tc, "original exception", this.ex);
        }
        if (this.exType == ExceptionType.UNCHECKED_EXCEPTION) {
            FFDCFilter.processException(throwable, "com.ibm.ejs.container.RemoteExceptionMappingStrategy.setUncheckedException", "200", this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setUncheckedException returning : " + this.ex);
        }
        this.ex.setStackTrace(this.root.getStackTrace());
        return (Exception)this.ex;
    }

    private Exception mapCSIException(CSIException cSIException) throws CSIException {
        Object object;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "mapCSIException: " + (Object)((Object)cSIException));
        }
        Object object2 = null;
        String string = " ";
        if (cSIException instanceof CSITransactionRolledbackException) {
            object = ContainerProperties.IncludeNestedExceptionsExtended && (this.thisStrategiesOwner.began || ContainerProperties.AllowSpecViolationOnRollback) && (cSIException.detail instanceof HeuristicMixedException || cSIException.detail instanceof HeuristicRollbackException) ? new RemoteException("", cSIException.detail) : new TransactionRolledbackException(string);
        } else if (cSIException instanceof CSIAccessException) {
            object = new AccessException(string);
        } else if (cSIException instanceof CSIInvalidTransactionException) {
            object = new InvalidTransactionException(string);
        } else if (cSIException instanceof CSITransactionRequiredException) {
            object = new TransactionRequiredException(string);
        } else if (cSIException instanceof CSIInvalidActivityException) {
            object = new InvalidActivityException(string);
        } else if (cSIException instanceof CSIActivityRequiredException) {
            object = new ActivityRequiredException(string);
        } else if (cSIException instanceof CSIActivityCompletedException) {
            object = new ActivityCompletedException(string);
        } else if (cSIException instanceof CSINoSuchObjectException) {
            object = new NoSuchObjectException(string);
        } else {
            cSIException.detail = null;
            object = new RemoteException(cSIException.getMessage());
        }
        if (ContainerProperties.IncludeNestedExceptions) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Nested exceptions will be included on rollback when possible. " + object + ": " + this.thisStrategiesOwner.began);
            }
            if (object instanceof TransactionRolledbackException && (this.thisStrategiesOwner.began || ContainerProperties.AllowSpecViolationOnRollback)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Transaction was begun in context of this bean method, or the user allows the spec to be violated (ContainerProperties.AllowSpecViolationOnRollback=" + ContainerProperties.AllowSpecViolationOnRollback + ").");
                }
                object = new RemoteException("", (Throwable)object);
            }
        }
        object.detail = this.root;
        object.setStackTrace(this.root.getStackTrace());
        if (this.ivOrbUtils != null) {
            int n;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "mapCSIException calling OrbUtils.mapException: " + object);
            }
            object2 = (n = cSIException.getMinorCode()) == 0 ? this.ivOrbUtils.mapException((RemoteException)object) : this.ivOrbUtils.mapException((RemoteException)object, n);
        } else {
            object2 = object;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "mapCSIException returning: " + object2);
        }
        return object2;
    }

    public Exception mapCSITransactionRolledBackException(CSITransactionRolledbackException cSITransactionRolledbackException) throws CSIException {
        if (this.root == null) {
            this.root = ExceptionUtil.findRootCause(cSITransactionRolledbackException);
        }
        Exception exception = this.mapCSIException((CSIException)((Object)cSITransactionRolledbackException));
        exception.setStackTrace(this.root.getStackTrace());
        return exception;
    }

    private Exception mapEJBException(EJBException eJBException) throws CSIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "mapEJBException: " + (Object)((Object)eJBException));
        }
        Object object = null;
        String string = " ";
        Object object2 = eJBException instanceof TransactionRolledbackLocalException ? new TransactionRolledbackException(string) : (eJBException instanceof AccessLocalException ? new AccessException(string) : (eJBException instanceof InvalidTransactionLocalException ? new InvalidTransactionException(string) : (eJBException instanceof NoSuchObjectLocalException ? new NoSuchObjectException(string) : (eJBException instanceof TransactionRequiredLocalException ? new TransactionRequiredException(string) : (eJBException instanceof InvalidActivityLocalException ? new InvalidActivityException(string) : (eJBException instanceof ActivityRequiredLocalException ? new ActivityRequiredException(string) : (eJBException instanceof ActivityCompletedLocalException ? new ActivityCompletedException(string) : new RemoteException(string))))))));
        object2.detail = this.root;
        object2.setStackTrace(this.root.getStackTrace());
        if (this.ivOrbUtils != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "mapEJBException calling OrbUtils.mapException: " + object2);
            }
            object = this.ivOrbUtils.mapException((RemoteException)object2);
        } else {
            object = object2;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "mapEJBException returning: " + object);
        }
        return object;
    }
}

