/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanOPassivationFailureException;
import com.ibm.ejs.container.ContainerTx;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSDeployedSupport;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.InvalidBeanOStateException;
import com.ibm.ejs.container.SessionBeanO;
import com.ibm.ejs.container.StatefulBeanReaper;
import com.ibm.ejs.container.drs.SfDRSClient;
import com.ibm.ejs.container.passivator.StatefulPassivator;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.traceinfo.ejbcontainer.TEBeanLifeCycleInfo;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.security.Principal;
import javax.ejb.CreateException;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EnterpriseBean;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.TimerService;
import javax.resource.ResourceException;
import javax.transaction.UserTransaction;
import javax.xml.rpc.handler.MessageContext;

public abstract class StatefulBeanO
extends SessionBeanO
implements Serializable {
    private static final TraceComponent tc = Tr.register(StatefulBeanO.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.StatefulBeanO";
    protected boolean removed = false;
    protected boolean discarded = false;
    protected boolean uninstalling = false;
    protected ContainerTx currentTx;
    protected transient StatefulPassivator passivator;
    protected boolean connection_handle_context = false;
    protected transient long lastAccessTime;
    public transient SfDRSClient ivSfDRSClient;
    public static final int CREATING = 1;
    public static final int METHOD_READY = 2;
    public static final int IN_METHOD = 3;
    public static final int TX_METHOD_READY = 4;
    public static final int TX_IN_METHOD = 5;
    public static final int COMMITTING_OUTSIDE_METHOD = 6;
    public static final int COMMITTING_IN_METHOD = 7;
    public static final int PASSIVATING = 8;
    public static final int PASSIVATED = 9;
    public static final int ACTIVATING = 10;
    public static final int PRE_CREATE = 11;
    public static final int REMOVING = 12;
    public static final int AFTER_BEGIN = 13;
    public static final int AFTER_COMPLETION = 14;
    protected static final String[] StateStrs = new String[]{"DESTROYED", "CREATING", "METHOD_READY", "IN_METHOD", "TX_METHOD_READY", "TX_IN_METHOD", "COMMITTING_OUTSIDE_METHOD", "COMMITTING_IN_METHOD", "PASSIVATING", "PASSIVATED", "ACTIVATING", "PRE_CREATE", "REMOVING", "AFTER_BEGIN", "AFTER_COMPLETION"};

    protected StatefulBeanO(EJSContainer eJSContainer, EnterpriseBean enterpriseBean, EJSHome eJSHome) throws RemoteException {
        super(eJSContainer, eJSHome);
        this.passivator = eJSContainer.passivator;
        this.stateStrs = StateStrs;
        this.sessionBean = (SessionBean)enterpriseBean;
        this.state = 11;
        this.ivSfDRSClient = eJSHome.beanMetaData.ivSfDRSClient;
    }

    public void setContextIfRequired(boolean bl) throws RemoteException {
        this.assertState(11);
        if (!bl) {
            this.sessionBean.setSessionContext((SessionContext)this);
            this.setState(1);
        } else {
            this.setState(10);
        }
    }

    public final boolean isRemoved() {
        return this.state == 0;
    }

    public final boolean isDiscarded() {
        return this.discarded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy - bean=" + this.toString());
        }
        if (this.state == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "destroy");
            }
            return;
        }
        if (this.connection_handle_context) {
            this.container.handleCollaborator.popConnectionHandleContext();
            this.connection_handle_context = false;
        }
        if (this.ivSfDRSClient != null) {
            this.ivSfDRSClient.removeEntry(this.beanId);
        }
        this.setState(0);
        if (this.pmiBean != null) {
            this.pmiBean.beanDestroyed();
        }
        if (this.removed) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "destroy");
            }
            return;
        }
        try {
            if (TEBeanLifeCycleInfo.isTraceEnabled()) {
                TEBeanLifeCycleInfo.traceEJBCallEntry("ejbRemove");
            }
            this.sessionBean.ejbRemove();
            if (TEBeanLifeCycleInfo.isTraceEnabled()) {
                TEBeanLifeCycleInfo.traceEJBCallExit("ejbRemove");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.container.StatefulBeanO.destroy", "176", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "ejbRemove() threw an exception:", new Object[]{this, exception});
            }
        }
        finally {
            if (this.pmiBean != null) {
                this.pmiBean.beanRemoved();
            }
            this.connectionHandleList.componentDestroyed();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "destroy");
            }
        }
    }

    public final synchronized void destroyNotRemove() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "destroyNotRemove");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "bean: " + this.toString());
        }
        if (this.state == 0) {
            return;
        }
        this.setState(0);
        if (this.pmiBean != null) {
            this.pmiBean.beanDestroyed();
        }
        this.connectionHandleList.componentDestroyed();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "destroyNotRemove");
        }
    }

    public final synchronized void removeFromStore() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeFromStore");
        }
        if (this.state == 0) {
            return;
        }
        try {
            this.passivator.remove(this.beanId, true);
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, "com.ibm.ejs.container.StatefulBeanO.removeFromStore", "245", this);
            Tr.warning(tc, "REMOVE_FROM_PASSIVATION_STORE_FAILED_CNTR0016W", new Object[]{this.beanId, remoteException});
        }
        this.setState(0);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeFromStore");
        }
    }

    public final synchronized boolean timedOut(StatefulBeanReaper statefulBeanReaper) {
        if (this.state == 2) {
            return statefulBeanReaper.beanDoesNotExistOrHasTimedOut(this.beanId);
        }
        return false;
    }

    public final EnterpriseBean getEnterpriseBean() throws RemoteException {
        this.assertState(1);
        return this.sessionBean;
    }

    public final long getSessionTimeoutInMilliSeconds() {
        return this.home.beanMetaData.sessionTimeout * 1000;
    }

    public void setEnterpriseBean(SessionBean sessionBean) {
        this.sessionBean = sessionBean;
    }

    public void setCurrentTx(ContainerTx containerTx) {
        this.currentTx = containerTx;
    }

    public void setContainerTx(ContainerTx containerTx) {
        this.setCurrentTx(containerTx);
        super.setContainerTx(containerTx);
    }

    public final void postCreate(boolean bl) throws CreateException, RemoteException {
        this.setState(1, 2);
    }

    public final synchronized void activate(BeanId beanId, ContainerTx containerTx) throws RemoteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "activate: " + this);
        }
        boolean bl = false;
        long l = -1L;
        this.assertState(10);
        if (this.pmiBean != null) {
            l = this.pmiBean.activationTime();
        }
        try {
            bl = this.container.handleCollaborator.preInvoke(this);
            this.passivator.activate(this, this.home.beanMetaData.classLoader);
            if (TEBeanLifeCycleInfo.isTraceEnabled()) {
                TEBeanLifeCycleInfo.traceEJBCallEntry("ejbActivate");
            }
            this.sessionBean.ejbActivate();
            if (TEBeanLifeCycleInfo.isTraceEnabled()) {
                TEBeanLifeCycleInfo.traceEJBCallExit("ejbActivate");
            }
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.container.StatefulBeanO.activate", "360", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "activate failed! ", new Object[]{this, resourceException});
            }
            this.destroy();
            throw new RemoteException("", resourceException);
        }
        finally {
            if (this.pmiBean != null) {
                this.pmiBean.activationTime(l);
            }
            if (bl) {
                this.container.handleCollaborator.postInvoke(this);
            }
        }
        this.setState(10, 2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "activate: " + this.stateStrs[this.state]);
        }
    }

    public final synchronized void passivate() throws RemoteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "passivate: " + this);
        }
        boolean bl = false;
        long l = -1L;
        Object object = null;
        ComponentMetaDataAccessorImpl componentMetaDataAccessorImpl = null;
        if (this.state == 5 || this.state == 4) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "State: " + StateStrs[this.state] + " Bean cannot be passivated in a transaction");
            }
            throw new BeanOPassivationFailureException();
        }
        this.setState(2, 8);
        try {
            if (this.pmiBean != null) {
                l = this.pmiBean.passivationTime();
            }
            bl = this.container.handleCollaborator.pushConnectionHandleContext(this);
            componentMetaDataAccessorImpl = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
            object = componentMetaDataAccessorImpl.beginContext(this.home.beanMetaData);
            if (TEBeanLifeCycleInfo.isTraceEnabled()) {
                TEBeanLifeCycleInfo.traceEJBCallEntry("ejbPassivate");
            }
            this.sessionBean.ejbPassivate();
            if (TEBeanLifeCycleInfo.isTraceEnabled()) {
                TEBeanLifeCycleInfo.traceEJBCallExit("ejbPassivate");
            }
            if (!this.uninstalling) {
                this.passivator.passivate(this);
            }
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, "com.ibm.ejs.container.StatefulBeanO.passivate", "425", this);
            l = -1L;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "passivate failed! ", new Object[]{this, remoteException});
            }
            throw remoteException;
        }
        finally {
            if (this.pmiBean != null) {
                this.pmiBean.passivationTime(l);
            }
            if (object != null) {
                componentMetaDataAccessorImpl.endContext();
            }
            if (bl) {
                this.container.handleCollaborator.popConnectionHandleContext();
            }
        }
        this.setState(8, 9);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "passivate: " + this.stateStrs[this.state]);
        }
    }

    public final synchronized EnterpriseBean preInvoke(EJSDeployedSupport eJSDeployedSupport, ContainerTx containerTx) throws RemoteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "preInvoke: " + this);
        }
        try {
            this.connection_handle_context = this.container.handleCollaborator.preInvoke(this);
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.container.StatefulBeanO.preInvoke", "471", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "preInvoke failed - couldn't add connection handle context", (Object)resourceException);
            }
            throw new RemoteException("", resourceException);
        }
        switch (this.state) {
            case 2: {
                this.setState(3);
                break;
            }
            case 4: {
                this.setState(5);
                break;
            }
            default: {
                throw new InvalidBeanOStateException(StateStrs[this.state], "METHOD_READY | TX_METHOD_READY");
            }
        }
        int n = this.currentIsolationLevel;
        this.currentIsolationLevel = eJSDeployedSupport.currentIsolationLevel;
        eJSDeployedSupport.currentIsolationLevel = n;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "preInvoke: " + this.stateStrs[this.state]);
        }
        return this.sessionBean;
    }

    public synchronized void postInvoke(int n, EJSDeployedSupport eJSDeployedSupport) throws RemoteException {
        if (this.connection_handle_context) {
            this.container.handleCollaborator.postInvoke(this);
            this.connection_handle_context = false;
        }
        this.currentIsolationLevel = eJSDeployedSupport.oldIsolationLevel;
        if (this.removed) {
            return;
        }
        switch (this.state) {
            case 3: {
                this.setState(2);
                break;
            }
            case 5: {
                this.setState(4);
                break;
            }
            case 0: {
                return;
            }
            default: {
                throw new InvalidBeanOStateException(StateStrs[this.state], "IN_METHOD | TX_IN_METHOD | DESTROYED");
            }
        }
    }

    public final void store() throws RemoteException {
    }

    public final synchronized void discard() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "discard : " + this);
        }
        if (this.removed || this.discarded) {
            return;
        }
        if (this.connection_handle_context) {
            this.container.handleCollaborator.popConnectionHandleContext();
            this.connection_handle_context = false;
        }
        this.destroyNotRemove();
        if (this.pmiBean != null) {
            this.pmiBean.methodPostInvoke(null, null, 0L);
        }
        this.discarded = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "discard");
        }
    }

    public final synchronized void remove() throws RemoteException, RemoveException {
        block7: {
            this.canBeRemoved();
            this.setState(12);
            try {
                if (TEBeanLifeCycleInfo.isTraceEnabled()) {
                    TEBeanLifeCycleInfo.traceEJBCallEntry("ejbRemove");
                }
                this.sessionBean.ejbRemove();
                if (TEBeanLifeCycleInfo.isTraceEnabled()) {
                    TEBeanLifeCycleInfo.traceEJBCallExit("ejbRemove");
                }
            }
            catch (RemoteException remoteException) {
                FFDCFilter.processException((Throwable)remoteException, "com.ibm.ejs.container.StatefulBeanO.remove", "611", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "ejbRemove() threw an exception", new Object[]{this, remoteException});
                }
                throw new RemoveException(remoteException.getMessage());
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ejs.container.StatefulBeanO.remove", "616", this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block7;
                Tr.event(tc, "ejbRemove() threw an exception", new Object[]{this, throwable});
            }
        }
        if (this.pmiBean != null) {
            this.pmiBean.beanRemoved();
        }
        this.removed = true;
        this.destroy();
    }

    public final synchronized void uninstall() {
        try {
            this.uninstalling = true;
            this.passivate();
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, "com.ibm.ejs.container.StatefulBeanO.uninstall", "654", this);
            Tr.warning(tc, "IGNORING_UNEXPECTED_EXCEPTION_CNTR0033E", remoteException);
        }
        this.destroyNotRemove();
    }

    public void checkTimerServiceAccess() throws IllegalStateException {
        if (this.state == 5 || this.state == 13 || this.state == 6) {
            return;
        }
        IllegalStateException illegalStateException = new IllegalStateException("StatefulBean: Timer Service methods not allowed from state = " + this.stateStrs[this.state]);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "checkTimerServiceAccess: " + illegalStateException);
        }
        throw illegalStateException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRollbackOnly() {
        StatefulBeanO statefulBeanO = this;
        synchronized (statefulBeanO) {
            if (this.state == 11 || this.state == 1 || this.state == 12 || this.state == 10 || this.state == 8 || this.state == 0 || this.state == 14) {
                IllegalStateException illegalStateException = new IllegalStateException("StatefulBean: setRollbackOnly() not allowed from state = " + this.stateStrs[this.state]);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "setRollbackOnly: " + illegalStateException);
                }
                throw illegalStateException;
            }
        }
        super.setRollbackOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getRollbackOnly() {
        StatefulBeanO statefulBeanO = this;
        synchronized (statefulBeanO) {
            if (this.state == 11 || this.state == 1 || this.state == 12 || this.state == 10 || this.state == 8 || this.state == 0 || this.state == 14) {
                IllegalStateException illegalStateException = new IllegalStateException("StatefulBean: getRollbackOnly() not allowed from state = " + this.stateStrs[this.state]);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getRollbackOnly: " + illegalStateException);
                }
                throw illegalStateException;
            }
        }
        return super.getRollbackOnly();
    }

    public synchronized UserTransaction getUserTransaction() {
        if (this.state == 11) {
            throw new IllegalStateException();
        }
        return super.getUserTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Principal getCallerPrincipal() {
        StatefulBeanO statefulBeanO = this;
        synchronized (statefulBeanO) {
            if (this.state == 11) {
                throw new IllegalStateException();
            }
        }
        return super.getCallerPrincipal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCallerInRole(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isCallerInRole, role = " + string + ", state = " + StateStrs[this.state]);
        }
        SessionBean sessionBean = null;
        StatefulBeanO statefulBeanO = this;
        synchronized (statefulBeanO) {
            if (this.state == 11) {
                throw new IllegalStateException();
            }
            if (this.state == 3 || this.state == 5) {
                sessionBean = this.sessionBean;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isCallerInRole");
        }
        return super.isCallerInRole(string, (EnterpriseBean)sessionBean);
    }

    public TimerService getTimerService() throws IllegalStateException {
        IllegalStateException illegalStateException = new IllegalStateException("StatefulBean: getTimerService not allowed from Stateful Session Bean");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getTimerService: " + illegalStateException);
        }
        throw illegalStateException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EJBObject getEJBObject() {
        StatefulBeanO statefulBeanO = this;
        synchronized (statefulBeanO) {
            if (this.state == 11) {
                throw new IllegalStateException(this.stateStrs[this.state]);
            }
        }
        return super.getEJBObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EJBLocalObject getEJBLocalObject() {
        StatefulBeanO statefulBeanO = this;
        synchronized (statefulBeanO) {
            if (this.state == 11) {
                throw new IllegalStateException(this.stateStrs[this.state]);
            }
        }
        return super.getEJBLocalObject();
    }

    public MessageContext getMessageContext() throws IllegalStateException {
        IllegalStateException illegalStateException = new IllegalStateException("StatefulBean: getMessageContext not allowed from Stateful Session Bean");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getMessageContext: " + illegalStateException);
        }
        throw illegalStateException;
    }

    public void flushCache() {
        if (this.state == 11 || this.state == 1 || this.state == 12 || this.state == 10 || this.state == 8 || this.state == 0 || this.state == 14) {
            IllegalStateException illegalStateException = new IllegalStateException("StatefulBean: flushCache not allowed from state = " + this.stateStrs[this.state]);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "flushCache: " + illegalStateException);
            }
            throw illegalStateException;
        }
        super.flushCache();
    }

    public String toString() {
        return this.toString("StatefulBeanO");
    }

    protected final String toString(String string) {
        return string + "(" + this.beanId + ", state = " + StateStrs[this.state] + ")";
    }

    public final long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public final void setLastAccessTime(long l) {
        this.lastAccessTime = l;
    }

    public final boolean sfsbFailoverEnabled() {
        return this.ivSfDRSClient != null;
    }

    public final void createDRSEntry() throws RemoteException {
        this.ivSfDRSClient.createEntry(this.beanId, this.getSessionTimeoutInMilliSeconds());
    }

    public void updateDRSEntry(byte[] byArray, long l) throws RemoteException {
        try {
            this.ivSfDRSClient.passivated(this.beanId, byArray, l);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.container.StatefulBeanO.updateDRSEntry", "1137", this);
            throw new RemoteException("Could not update SFSB Entry in DRS", exception);
        }
    }

    public void updateDRSSetActiveProp() {
        try {
            if (this.ivSfDRSClient != null) {
                this.ivSfDRSClient.activated(this.beanId, this.lastAccessTime);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ejs.container.StatefulBeanO.updateDRSProp", "1158", this);
        }
    }
}

