/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.TimeoutElement;
import com.ibm.ejs.container.activator.Activator;
import com.ibm.ejs.container.drs.SfDRSCache;
import com.ibm.ejs.container.passivator.StatefulPassivator;
import com.ibm.ejs.container.util.EJSPlatformHelper;
import com.ibm.ejs.ras.Dumpable;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.FastHashtable;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.ffdc.FFDCFilter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;

public final class StatefulBeanReaper
extends Thread
implements AlarmListener,
Dumpable {
    private static final TraceComponent tc = Tr.register(StatefulBeanReaper.class, "EJBCache", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.StatefulBeanReaper";
    private long ivSweepInterval;
    private FastHashtable ivStatefulBeanList;
    private static final long DEFAULT_MIN_CLEANUP_INTERVAL = 60000L;
    private static final long DEFAULT_CLEANUP_INTERVAL = 4200000L;
    private static final long DEFAULT_SESSION_TIMEOUT = 300000L;
    private Activator ivActivator;
    private SfDRSCache ivSfDRSCache;
    protected boolean dumped = false;
    protected int numObjects = 0;
    protected int numAdds = 0;
    protected int numRemoves = 0;
    protected int numNullRemoves = 0;
    protected int numDeletes = 0;

    public StatefulBeanReaper(Activator activator, int n, SfDRSCache sfDRSCache) {
        this(activator, n, 60000L, sfDRSCache);
    }

    public StatefulBeanReaper(Activator activator, int n, long l, SfDRSCache sfDRSCache) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.ivSweepInterval = EJSPlatformHelper.isZOS() && l == 0L ? 4200000L : (l < 60000L ? 60000L : l);
        this.setDaemon(true);
        this.setName("StatefulBeanReaper");
        this.ivStatefulBeanList = new FastHashtable(n);
        this.ivActivator = activator;
        this.ivSfDRSCache = sfDRSCache;
        Tr.registerDumpable(tc, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init> : sweep = " + this.ivSweepInterval + " ms");
        }
    }

    public void run() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "run");
        }
        if (this.ivSweepInterval >= 60000L) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "StatefulBeanReaper using Alarms");
            }
            AlarmManager.create(this.ivSweepInterval, this, null);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "run");
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "StatefulBeanReaper running as background thread");
        }
        while (true) {
            try {
                while (true) {
                    StatefulBeanReaper.sleep(this.ivSweepInterval);
                    this.sweep();
                }
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ejs.container.StatefulBeanReaper.run", "185", this);
                Tr.warning(tc, "STATEFUL_BEAN_REAPER_THREAD_INTERRUPTED_CNTR0014W", new Object[]{interruptedException});
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.container.StatefulBeanReaper.run", "192", this);
                Tr.warning(tc, "UNEXPECTED_EXCEPTION_DURING_STATEFUL_BEAN_CLEANUP_CNTR0015W", new Object[]{this, exception});
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object object) {
        try {
            this.sweep();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.container.StatefulBeanReaper.alarm", "226", this);
            Tr.warning(tc, "UNEXPECTED_EXCEPTION_DURING_STATEFUL_BEAN_CLEANUP_CNTR0015W", new Object[]{this, exception});
        }
        finally {
            AlarmManager.create(this.ivSweepInterval, this, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sweep() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "Sweep : Stateful Beans = " + this.ivStatefulBeanList.size());
        }
        Enumeration enumeration = this.ivStatefulBeanList.elements();
        while (enumeration.hasMoreElements()) {
            TimeoutElement timeoutElement;
            boolean bl = false;
            TimeoutElement timeoutElement2 = timeoutElement = (TimeoutElement)enumeration.nextElement();
            synchronized (timeoutElement2) {
                if (this.beanTimedOut(timeoutElement)) {
                    bl = true;
                }
            }
            if (!bl) continue;
            this.deleteBean(timeoutElement.beanId);
        }
        if (this.ivSfDRSCache != null) {
            this.ivSfDRSCache.sweep();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "Sweep : Stateful Beans = " + this.ivStatefulBeanList.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalSweep(StatefulPassivator statefulPassivator) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "finalSweep : Stateful Beans = " + this.ivStatefulBeanList.size());
        }
        Enumeration enumeration = this.ivStatefulBeanList.elements();
        while (enumeration.hasMoreElements()) {
            TimeoutElement timeoutElement;
            TimeoutElement timeoutElement2 = timeoutElement = (TimeoutElement)enumeration.nextElement();
            synchronized (timeoutElement2) {
                if (timeoutElement.passivated) {
                    try {
                        if (this.remove(timeoutElement.beanId)) {
                            statefulPassivator.remove(timeoutElement.beanId, false);
                        }
                    }
                    catch (RemoteException remoteException) {
                        FFDCFilter.processException((Throwable)remoteException, "com.ibm.ejs.container.StatefulBeanReaper.finalSweep", "298", this);
                        Tr.warning(tc, "REMOVE_FROM_PASSIVATION_STORE_FAILED_CNTR0016W", new Object[]{timeoutElement.beanId, remoteException});
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "finalSweep : Stateful Beans = " + this.ivStatefulBeanList.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beanExistsAndTimedOut(BeanId beanId) {
        TimeoutElement timeoutElement = (TimeoutElement)this.ivStatefulBeanList.get(beanId);
        if (timeoutElement == null) {
            if (this.ivSfDRSCache != null) {
                return this.ivSfDRSCache.beanExistsAndTimedOut(beanId);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Session bean not in Reaper: Timeout = false");
            }
            return false;
        }
        TimeoutElement timeoutElement2 = timeoutElement;
        synchronized (timeoutElement2) {
            return this.beanTimedOut(timeoutElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beanDoesNotExistOrHasTimedOut(BeanId beanId) {
        TimeoutElement timeoutElement = (TimeoutElement)this.ivStatefulBeanList.get(beanId);
        if (timeoutElement == null) {
            if (this.ivSfDRSCache != null) {
                return this.ivSfDRSCache.beanDoesNotExistOrHasTimedOut(beanId);
            }
            return true;
        }
        TimeoutElement timeoutElement2 = timeoutElement;
        synchronized (timeoutElement2) {
            return this.beanTimedOut(timeoutElement);
        }
    }

    private boolean beanTimedOut(TimeoutElement timeoutElement) {
        if (timeoutElement.timeout > 0L && System.currentTimeMillis() - timeoutElement.lastAccessTime >= timeoutElement.timeout) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Date date = new Date(System.currentTimeMillis());
                Date date2 = new Date(timeoutElement.lastAccessTime);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Session bean timed out", "Current Time: " + date.toString() + " Last Access Time: " + date2.toString() + " Timeout: " + timeoutElement.timeout + " ms");
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteBean(BeanId beanId) {
        block7: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "deleteBean " + beanId);
            }
            StatefulBeanReaper statefulBeanReaper = this;
            synchronized (statefulBeanReaper) {
                ++this.numDeletes;
            }
            try {
                this.ivActivator.timeoutBean(beanId);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.container.StatefulBeanReaper.deleteBean", "367", this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Unable to timeout session bean");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteBean");
        }
    }

    public void add(BeanId beanId) {
        this.add(beanId, 300000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(BeanId beanId, long l) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "add " + beanId + ", " + l);
        }
        TimeoutElement timeoutElement = new TimeoutElement(beanId, l);
        Object object = this.ivStatefulBeanList.put(beanId, timeoutElement);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, object != null ? "Stateful bean information replaced" : "Stateful bean information added");
        }
        this.setLastAccessTime(beanId);
        StatefulBeanReaper statefulBeanReaper = this;
        synchronized (statefulBeanReaper) {
            ++this.numObjects;
            ++this.numAdds;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "add");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(BeanId beanId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "remove (" + beanId + ")");
        }
        TimeoutElement timeoutElement = null;
        timeoutElement = (TimeoutElement)this.ivStatefulBeanList.remove(beanId);
        StatefulBeanReaper statefulBeanReaper = this;
        synchronized (statefulBeanReaper) {
            if (timeoutElement != null) {
                --this.numObjects;
                ++this.numRemoves;
            } else {
                ++this.numNullRemoves;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "remove (" + (timeoutElement != null) + ")");
        }
        return timeoutElement != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastAccessTime(BeanId beanId) {
        TimeoutElement timeoutElement;
        TimeoutElement timeoutElement2 = timeoutElement = (TimeoutElement)this.ivStatefulBeanList.get(beanId);
        synchronized (timeoutElement2) {
            timeoutElement.lastAccessTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastAccessTime(BeanId beanId, long l) {
        TimeoutElement timeoutElement;
        TimeoutElement timeoutElement2 = timeoutElement = (TimeoutElement)this.ivStatefulBeanList.get(beanId);
        synchronized (timeoutElement2) {
            timeoutElement.lastAccessTime = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPassivated(BeanId beanId) {
        TimeoutElement timeoutElement;
        TimeoutElement timeoutElement2 = timeoutElement = (TimeoutElement)this.ivStatefulBeanList.get(beanId);
        synchronized (timeoutElement2) {
            timeoutElement.passivated = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(BeanId beanId) {
        TimeoutElement timeoutElement;
        TimeoutElement timeoutElement2 = timeoutElement = (TimeoutElement)this.ivStatefulBeanList.get(beanId);
        synchronized (timeoutElement2) {
            timeoutElement.passivated = false;
        }
    }

    public synchronized Iterator getStatefulBeanIds(J2EEName j2EEName) {
        ArrayList<BeanId> arrayList = new ArrayList<BeanId>();
        Enumeration enumeration = this.ivStatefulBeanList.elements();
        while (enumeration.hasMoreElements()) {
            TimeoutElement timeoutElement = (TimeoutElement)enumeration.nextElement();
            if (!j2EEName.equals(timeoutElement.beanId.getJ2EEName()) || timeoutElement.passivated) continue;
            arrayList.add(timeoutElement.beanId);
        }
        return arrayList.iterator();
    }

    public synchronized Iterator getStatefulBeanIds() {
        ArrayList<BeanId> arrayList = new ArrayList<BeanId>();
        Enumeration enumeration = this.ivStatefulBeanList.elements();
        while (enumeration.hasMoreElements()) {
            TimeoutElement timeoutElement = (TimeoutElement)enumeration.nextElement();
            if (timeoutElement.passivated) continue;
            arrayList.add(timeoutElement.beanId);
        }
        return arrayList.iterator();
    }

    public synchronized Iterator getPassivatedStatefulBeanIds(J2EEName j2EEName) {
        ArrayList<BeanId> arrayList = new ArrayList<BeanId>();
        Enumeration enumeration = this.ivStatefulBeanList.elements();
        while (enumeration.hasMoreElements()) {
            TimeoutElement timeoutElement = (TimeoutElement)enumeration.nextElement();
            if (!j2EEName.equals(timeoutElement.beanId.getJ2EEName()) || !timeoutElement.passivated) continue;
            arrayList.add(timeoutElement.beanId);
        }
        return arrayList.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastAccessTime(BeanId beanId) {
        TimeoutElement timeoutElement = (TimeoutElement)this.ivStatefulBeanList.get(beanId);
        long l = 0L;
        TimeoutElement timeoutElement2 = timeoutElement;
        synchronized (timeoutElement2) {
            l = timeoutElement.lastAccessTime;
        }
        return l;
    }

    public boolean beanExists(BeanId beanId) {
        TimeoutElement timeoutElement = (TimeoutElement)this.ivStatefulBeanList.get(beanId);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, timeoutElement != null ? "Session bean is in Reaper" : "Session bean is not in Reaper");
        }
        return timeoutElement != null;
    }

    public long getBeanTimeoutTime(BeanId beanId) {
        TimeoutElement timeoutElement = (TimeoutElement)this.ivStatefulBeanList.get(beanId);
        long l = 0L;
        if (timeoutElement != null && timeoutElement.timeout != 0L) {
            l = timeoutElement.lastAccessTime + timeoutElement.timeout;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump() {
        if (this.dumped) {
            return;
        }
        try {
            Tr.dump(tc, "-- StatefulBeanReaper Dump -- ", this);
            StatefulBeanReaper statefulBeanReaper = this;
            synchronized (statefulBeanReaper) {
                Tr.dump(tc, "Number of objects:      " + this.numObjects);
                Tr.dump(tc, "Number of adds:         " + this.numAdds);
                Tr.dump(tc, "Number of removes:      " + this.numRemoves);
                Tr.dump(tc, "Number of null removes: " + this.numNullRemoves);
                Tr.dump(tc, "Number of deletes:      " + this.numDeletes);
            }
        }
        finally {
            this.dumped = true;
        }
    }

    public void resetDump() {
        this.dumped = false;
    }
}

