/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.TimerImpl;
import com.ibm.ejs.container.TimerServiceException;
import com.ibm.ejs.container.TimerTaskInfoImpl;
import com.ibm.ejs.container.util.ByteArray;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.scheduler.Scheduler;
import com.ibm.websphere.scheduler.TaskInvalid;
import com.ibm.websphere.scheduler.TaskStatus;
import com.ibm.ws.ejb.portable.Constants;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;

public final class TimerHandleImpl
implements TimerHandle,
Serializable {
    private static final TraceComponent tc = Tr.register(TimerHandleImpl.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.TimerHandleImpl";
    private static final long serialVersionUID = -7720620493313660153L;
    private static final byte[] EYECATCHER = Constants.TIMER_HANDLE_EYE_CATCHER;
    private static final short PLATFORM = 1;
    private static final short VERSION_ID = 1;
    private transient String ivTaskId;
    private transient BeanId ivBeanId;
    private transient int ivHashCode;
    private transient boolean isTimer;

    TimerHandleImpl(BeanId beanId, String string, int n, boolean bl) {
        this.ivBeanId = beanId;
        this.ivTaskId = string;
        this.ivHashCode = n;
        this.isTimer = bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, this.toString());
        }
    }

    public Timer getTimer() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        TimerImpl timerImpl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getTimer: " + this);
        }
        try {
            EJSHome eJSHome = (EJSHome)this.ivBeanId.home;
            Scheduler scheduler = eJSHome.container.ivScheduler;
            if (eJSHome.beanMetaData.allowCachedTimerDataForMethods == 0) {
                TaskStatus taskStatus = scheduler.getStatus(this.ivTaskId);
                timerImpl = new TimerImpl(this.ivBeanId, this.ivTaskId, this.ivHashCode);
                timerImpl.ivStatus = taskStatus;
            } else {
                TimerTaskInfoImpl timerTaskInfoImpl = (TimerTaskInfoImpl)scheduler.getTask(this.ivTaskId);
                timerImpl = new TimerImpl(this.ivBeanId, this.ivTaskId, this.ivHashCode);
                timerImpl.ivHandler = timerTaskInfoImpl.getHandler();
                timerImpl.ivStatus = timerTaskInfoImpl;
            }
        }
        catch (TaskInvalid taskInvalid) {
            NoSuchObjectLocalException noSuchObjectLocalException = new NoSuchObjectLocalException(this.toString(), (Exception)taskInvalid);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getTimer: " + noSuchObjectLocalException);
            }
            throw noSuchObjectLocalException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ejs.container.TimerHandleImpl.getTimer", "109", this);
            TimerServiceException timerServiceException = new TimerServiceException(this.toString(), throwable);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getTimer: " + timerServiceException);
            }
            throw timerServiceException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getTimer: " + timerImpl);
        }
        timerImpl.checkTimerAccess();
        return timerImpl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "writeObject: " + this);
        }
        objectOutputStream.defaultWriteObject();
        objectOutputStream.write(EYECATCHER);
        objectOutputStream.writeShort(1);
        objectOutputStream.writeShort(1);
        objectOutputStream.writeBoolean(this.isTimer);
        objectOutputStream.writeUTF(this.ivTaskId);
        objectOutputStream.writeInt(this.ivHashCode);
        objectOutputStream.writeObject(this.ivBeanId.getByteArrayBytes());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "writeObject");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "readObject");
        }
        objectInputStream.defaultReadObject();
        byte[] byArray = new byte[EYECATCHER.length];
        int n2 = 0;
        for (n = 0; n < EYECATCHER.length; n += n2) {
            n2 = objectInputStream.read(byArray, n, EYECATCHER.length - n);
            if (n2 != -1) continue;
            throw new IOException("end of input stream while reading eye catcher");
        }
        for (n = 0; n < EYECATCHER.length; ++n) {
            if (EYECATCHER[n] == byArray[n]) continue;
            String string = new String(byArray);
            throw new IOException("Invalid eye catcher '" + string + "' in TimerHandle input stream");
        }
        n = objectInputStream.readShort();
        short s = objectInputStream.readShort();
        if (s != 1) {
            throw new InvalidObjectException("EJB TimerHandle data stream is not of the correct version, this client should be updated.");
        }
        this.isTimer = objectInputStream.readBoolean();
        this.ivTaskId = objectInputStream.readUTF();
        this.ivHashCode = objectInputStream.readInt();
        byte[] byArray2 = (byte[])objectInputStream.readObject();
        ByteArray byteArray = new ByteArray(byArray2);
        EJSContainer eJSContainer = EJSContainer.getDefaultContainer();
        this.ivBeanId = BeanId.getBeanId(byteArray, eJSContainer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "readObject: " + this);
        }
    }

    public Object getSerializedObject() {
        if (this.isTimer) {
            TimerImpl timerImpl = new TimerImpl(this.ivBeanId, this.ivTaskId, this.ivHashCode);
            return timerImpl;
        }
        return this;
    }

    public boolean equals(Object object) {
        if (object instanceof TimerHandleImpl) {
            TimerHandleImpl timerHandleImpl = (TimerHandleImpl)object;
            if (this.ivHashCode == timerHandleImpl.ivHashCode && this.ivTaskId.equals(timerHandleImpl.ivTaskId)) {
                return true;
            }
        }
        return false;
    }

    public boolean equals(TimerHandleImpl timerHandleImpl) {
        return timerHandleImpl != null && this.ivHashCode == timerHandleImpl.ivHashCode && this.ivTaskId.equals(timerHandleImpl.ivTaskId);
    }

    public int hashCode() {
        return this.ivHashCode;
    }

    public String toString() {
        return "TimerHandleImpl(" + this.ivTaskId + ", " + this.ivBeanId + ")";
    }
}

