/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanO;
import com.ibm.ejs.container.ContainerTx;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.TimerHandleImpl;
import com.ibm.ejs.container.TimerServiceException;
import com.ibm.ejs.container.TimerTaskHandler;
import com.ibm.ejs.container.TimerTaskInfoImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.TransactionAttribute;
import com.ibm.websphere.scheduler.Scheduler;
import com.ibm.websphere.scheduler.TaskInvalid;
import com.ibm.websphere.scheduler.TaskStatus;
import com.ibm.ws.csi.TimerTaskInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;

public final class TimerImpl
implements Timer {
    private static final TraceComponent tc = Tr.register(TimerImpl.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.TimerImpl";
    private String ivTaskId;
    private BeanId ivBeanId;
    private EJSHome ivHome;
    private Scheduler ivScheduler;
    private int ivHashCode;
    private boolean allowCachedTimerDateForMethod_getHandle = false;
    private boolean allowCachedTimerDateForMethod_getInfo = false;
    private boolean allowCachedTimerDateForMethod_getNextTimeout = false;
    private boolean allowCachedTimerDateForMethod_getTimeRemaining = false;
    protected boolean isExecutingEJBTimeout = false;
    protected TaskStatus ivStatus;
    protected TimerTaskHandler ivHandler;

    TimerImpl(BeanId beanId, Date date, long l, Serializable serializable) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            String string = serializable == null ? null : serializable.getClass().getName();
            Tr.entry(tc, "TimerImpl: " + beanId + ", " + date + ", " + l + ", " + string);
        }
        try {
            this.ivBeanId = beanId;
            this.ivHome = (EJSHome)beanId.home;
            this.setCachingOptions(this.ivHome.beanMetaData.allowCachedTimerDataForMethods);
            this.ivScheduler = this.ivHome.container.ivScheduler;
            boolean bl = false;
            if (this.ivHome.beanMetaData.timedMethodInfos[0].getTransactionAttribute() == TransactionAttribute.TX_REQUIRED) {
                bl = true;
            }
            TimerTaskInfoImpl timerTaskInfoImpl = new TimerTaskInfoImpl(beanId, date, l, serializable, TimerImpl.getTaskName(beanId), bl);
            this.ivHandler = timerTaskInfoImpl.getHandler();
            this.ivStatus = this.ivScheduler.create(timerTaskInfoImpl);
            this.ivTaskId = this.ivStatus.getTaskId();
            this.ivHashCode = this.ivStatus.hashCode();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ejs.container.TimerImpl.<init>", "128", this);
            TimerServiceException timerServiceException = new TimerServiceException(this.toString(), throwable);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "TimerImpl: " + timerServiceException);
            }
            throw timerServiceException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, this.toString());
        }
    }

    TimerImpl(BeanId beanId, String string, int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "TimerImpl : " + beanId + ", " + string);
        }
        this.ivTaskId = string;
        this.ivBeanId = beanId;
        this.ivHome = (EJSHome)this.ivBeanId.home;
        this.setCachingOptions(this.ivHome.beanMetaData.allowCachedTimerDataForMethods);
        this.ivScheduler = this.ivHome.container.ivScheduler;
        this.ivHashCode = n;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, this.toString());
        }
    }

    private void setCachingOptions(int n) {
        this.allowCachedTimerDateForMethod_getHandle = (n & 1) > 0;
        this.allowCachedTimerDateForMethod_getInfo = (n & 2) > 0;
        this.allowCachedTimerDateForMethod_getNextTimeout = (n & 4) > 0;
        this.allowCachedTimerDateForMethod_getTimeRemaining = (n & 8) > 0;
    }

    public void cancel() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "cancel: " + this);
        }
        this.checkTimerAccess();
        try {
            this.ivScheduler.cancel(this.ivTaskId, true);
        }
        catch (TaskInvalid taskInvalid) {
            FFDCFilter.processException((Throwable)taskInvalid, "com.ibm.ejs.container.TimerImpl.cancel", "203", this);
            NoSuchObjectLocalException noSuchObjectLocalException = new NoSuchObjectLocalException(this.toString(), (Exception)taskInvalid);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "cancel: " + noSuchObjectLocalException);
            }
            throw noSuchObjectLocalException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ejs.container.TimerImpl.cancel", "215", this);
            TimerServiceException timerServiceException = new TimerServiceException(this.toString(), throwable);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "cancel: " + timerServiceException);
            }
            throw timerServiceException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "cancel: successful");
        }
    }

    public long getTimeRemaining() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        Date date = this.getNextTimeout(this.allowCachedTimerDateForMethod_getTimeRemaining);
        long l = System.currentTimeMillis();
        long l2 = date.getTime() - l;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getTimeRemaining: " + l2);
        }
        return l2;
    }

    public Date getNextTimeout() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getNextTimeout: " + this);
        }
        Date date = this.getNextTimeout(this.allowCachedTimerDateForMethod_getNextTimeout);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getNextTimeout: " + date);
        }
        return date;
    }

    private Date getNextTimeout(boolean bl) throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getNextTimeout: " + bl);
        }
        this.checkTimerAccess();
        Date date = null;
        TaskStatus taskStatus = null;
        try {
            if (this.ivStatus != null && (bl || this.isExecutingEJBTimeout)) {
                taskStatus = this.ivStatus;
            } else {
                this.ivStatus = taskStatus = this.ivScheduler.getStatus(this.ivTaskId);
            }
            date = taskStatus.getNextFireTime();
        }
        catch (TaskInvalid taskInvalid) {
            FFDCFilter.processException((Throwable)taskInvalid, "com.ibm.ejs.container.TimerImpl.getNextTimeout", "288", this);
            NoSuchObjectLocalException noSuchObjectLocalException = new NoSuchObjectLocalException(this.toString(), (Exception)taskInvalid);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getNextTimeout: " + noSuchObjectLocalException);
            }
            throw noSuchObjectLocalException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ejs.container.TimerImpl.getNextTimeout", "300", this);
            TimerServiceException timerServiceException = new TimerServiceException(this.toString(), throwable);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getNextTimeout: " + timerServiceException);
            }
            throw timerServiceException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getNextTimeout: " + date);
        }
        return date;
    }

    public Serializable getInfo() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getInfo: " + this);
        }
        this.checkTimerAccess();
        Serializable serializable = null;
        TimerTaskInfoImpl timerTaskInfoImpl = null;
        if (this.ivHandler != null && this.allowCachedTimerDateForMethod_getInfo) {
            serializable = (Serializable)EJSHome.copyObject(this.ivHandler.getInfo());
        } else {
            try {
                timerTaskInfoImpl = (TimerTaskInfoImpl)this.ivScheduler.getTask(this.ivTaskId);
                serializable = timerTaskInfoImpl.getInfo();
                this.ivHandler = timerTaskInfoImpl.getHandler();
                if (this.ivStatus == null) {
                    this.ivStatus = timerTaskInfoImpl;
                }
            }
            catch (TaskInvalid taskInvalid) {
                FFDCFilter.processException((Throwable)taskInvalid, "com.ibm.ejs.container.TimerImpl.getInfo", "351", this);
                NoSuchObjectLocalException noSuchObjectLocalException = new NoSuchObjectLocalException(this.toString(), (Exception)taskInvalid);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getInfo: " + noSuchObjectLocalException);
                }
                throw noSuchObjectLocalException;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ejs.container.TimerImpl.getInfo", "363", this);
                TimerServiceException timerServiceException = new TimerServiceException(this.toString(), throwable);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getInfo: " + timerServiceException);
                }
                throw timerServiceException;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getInfo: " + serializable);
        }
        return serializable;
    }

    public TimerHandle getHandle() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getHandle: " + this);
        }
        this.checkTimerAccess();
        TimerHandleImpl timerHandleImpl = null;
        try {
            if (this.ivStatus == null || !this.allowCachedTimerDateForMethod_getHandle && !this.isExecutingEJBTimeout) {
                this.ivStatus = this.ivScheduler.getStatus(this.ivTaskId);
            }
            timerHandleImpl = new TimerHandleImpl(this.ivBeanId, this.ivTaskId, this.ivHashCode, false);
        }
        catch (TaskInvalid taskInvalid) {
            FFDCFilter.processException((Throwable)taskInvalid, "com.ibm.ejs.container.TimerImpl.getHandle", "415", this);
            NoSuchObjectLocalException noSuchObjectLocalException = new NoSuchObjectLocalException(this.toString(), (Exception)taskInvalid);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getHandle: " + noSuchObjectLocalException);
            }
            throw noSuchObjectLocalException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ejs.container.TimerImpl.getHandle", "427", this);
            TimerServiceException timerServiceException = new TimerServiceException(this.toString(), throwable);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getHandle: " + timerServiceException);
            }
            throw timerServiceException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getHandle: " + timerHandleImpl);
        }
        return timerHandleImpl;
    }

    static Collection findTimersByBeanId(BeanId beanId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "findTimersByBeanId: " + beanId);
        }
        ArrayList<TimerImpl> arrayList = new ArrayList<TimerImpl>();
        String string = TimerImpl.getTaskName(beanId);
        EJSHome eJSHome = (EJSHome)beanId.home;
        Scheduler scheduler = eJSHome.container.ivScheduler;
        long l = 0L;
        Iterator iterator = null;
        try {
            iterator = scheduler.findTasksByName(string);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ejs.container.TimerImpl.findTimersByBeanId", "487");
            TimerServiceException timerServiceException = new TimerServiceException(beanId.toString(), throwable);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "findTimersByBeanId: " + timerServiceException);
            }
            throw timerServiceException;
        }
        while (iterator.hasNext()) {
            TimerTaskInfoImpl timerTaskInfoImpl = (TimerTaskInfoImpl)iterator.next();
            BeanId beanId2 = (BeanId)timerTaskInfoImpl.getTimedObjectId();
            if (beanId.equals(beanId2)) {
                TimerImpl timerImpl = new TimerImpl(beanId2, timerTaskInfoImpl.getTaskId(), timerTaskInfoImpl.hashCode());
                timerImpl.ivStatus = timerTaskInfoImpl;
                timerImpl.ivHandler = timerTaskInfoImpl.getHandler();
                arrayList.add(timerImpl);
            }
            ++l;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "findTimersByBeanId: " + arrayList.size() + "(of " + l + " found)");
        }
        return arrayList;
    }

    static void removeTimersByBeanId(BeanId beanId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeTimersByBeanId: " + beanId);
        }
        String string = TimerImpl.getTaskName(beanId);
        EJSHome eJSHome = (EJSHome)beanId.home;
        Scheduler scheduler = eJSHome.container.ivScheduler;
        long l = 0L;
        long l2 = 0L;
        Iterator iterator = null;
        try {
            iterator = scheduler.findTasksByName(string);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ejs.container.TimerImpl.removeTimersByBeanId", "559");
            TimerServiceException timerServiceException = new TimerServiceException(beanId.toString(), throwable);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "removeTimersByBeanId: " + timerServiceException);
            }
            throw timerServiceException;
        }
        while (iterator.hasNext()) {
            TimerTaskInfo timerTaskInfo = (TimerTaskInfo)iterator.next();
            BeanId beanId2 = (BeanId)timerTaskInfo.getTimedObjectId();
            if (beanId.equals(beanId2)) {
                try {
                    scheduler.cancel(timerTaskInfo.getTaskId(), true);
                    ++l2;
                }
                catch (TaskInvalid taskInvalid) {
                    FFDCFilter.processException(taskInvalid, "com.ibm.ejs.container.TimerImpl.removeTimersByBeanId", "591");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "TaskInvalid ignored : " + timerTaskInfo.getTaskId());
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ejs.container.TimerImpl.removeTimersByBeanId", "601");
                    TimerServiceException timerServiceException = new TimerServiceException(timerTaskInfo.toString(), throwable);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "removeTimersByBeanId: " + timerServiceException);
                    }
                    throw timerServiceException;
                }
            }
            ++l;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeTimersByBeanId: " + l2 + "(of " + l + " found)");
        }
    }

    private static String getTaskName(BeanId beanId) {
        J2EEName j2EEName = beanId.getJ2EEName();
        StringBuffer stringBuffer = new StringBuffer(j2EEName.getComponent());
        if (stringBuffer.length() > 240) {
            stringBuffer.setLength(240);
        }
        stringBuffer.append("_").append(beanId.hashCode());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "taskName = " + stringBuffer);
        }
        return stringBuffer.toString();
    }

    protected void checkTimerAccess() throws IllegalStateException {
        IllegalStateException illegalStateException;
        BeanO beanO;
        block6: {
            beanO = null;
            ContainerTx containerTx = null;
            Object var3_3 = null;
            illegalStateException = null;
            try {
                containerTx = this.ivHome.container.getCurrentTx(false);
                if (containerTx != null) {
                    beanO = containerTx.ivCallbackBeanO;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "checkTimerAccess: checking callback  beanO from current tx: " + beanO);
                    }
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ejs.container.TimerImpl.checkTimerAccess", "703", this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Exception ignored : " + throwable);
            }
        }
        if (beanO == null) {
            illegalStateException = new IllegalStateException("Timer: Timer methods not allowed - no active EJB");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "checkTimerAccess: " + illegalStateException);
            }
            throw illegalStateException;
        }
        beanO.checkTimerServiceAccess();
    }

    public TimerHandleImpl getSerializableObject() {
        TimerHandleImpl timerHandleImpl = new TimerHandleImpl(this.ivBeanId, this.ivTaskId, this.ivHashCode, true);
        return timerHandleImpl;
    }

    public boolean equals(Object object) {
        if (object instanceof TimerImpl) {
            TimerImpl timerImpl = (TimerImpl)object;
            if (this.ivHashCode == timerImpl.ivHashCode && this.ivTaskId.equals(timerImpl.ivTaskId)) {
                return true;
            }
        }
        return false;
    }

    public boolean equals(TimerImpl timerImpl) {
        return timerImpl != null && this.ivHashCode == timerImpl.ivHashCode && this.ivTaskId.equals(timerImpl.ivTaskId);
    }

    public int hashCode() {
        return this.ivHashCode;
    }

    public String toString() {
        return "TimerImpl(" + this.ivTaskId + ", " + this.ivBeanId + ")";
    }
}

