/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.EJBNotFoundException;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.TimedObjectWrapper;
import com.ibm.ejs.container.TimerHandleImpl;
import com.ibm.ejs.container.TimerImpl;
import com.ibm.ejs.container.TimerServiceException;
import com.ibm.ejs.container.util.ByteArray;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.dopriv.DeserializeObjectPrivileged;
import com.ibm.ejs.util.dopriv.SerializeObjectPrivileged;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.scheduler.TaskStatus;
import com.ibm.ws.ejb.portable.Constants;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.scheduler.Runnable;
import com.ibm.ws.security.util.AccessController;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

final class TimerTaskHandler
extends Runnable {
    private static final TraceComponent tc = Tr.register(TimerTaskHandler.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.TimerTaskHandler";
    private static final long serialVersionUID = -8200752857441853748L;
    private static final byte[] EYECATCHER = Constants.TIMER_TASK_EYE_CATCHER;
    private static final short PLATFORM = 1;
    private static final short VERSION_ID = 1;
    private transient BeanId ivBeanId;
    private transient byte[] ivBeanIdBytes;
    private transient Serializable ivInfo;
    private transient byte[] ivInfoBytes;
    private transient TimerServiceException ivBeanIdException;
    private transient TimerServiceException ivInfoException;

    TimerTaskHandler(BeanId beanId, Serializable serializable) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            String string = serializable == null ? null : serializable.getClass().getName();
            Tr.entry(tc, "<init>: " + beanId + ", " + string);
        }
        this.ivBeanId = beanId;
        this.ivBeanIdBytes = beanId.getByteArrayBytes();
        this.ivBeanIdException = null;
        this.ivInfo = serializable;
        this.ivInfoBytes = TimerTaskHandler.serializeObject(serializable);
        this.ivInfoException = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>: " + this.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork() throws Throwable {
        Object object;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "doWork: " + this.ivBeanId);
        }
        if (this.ivBeanIdException != null || this.ivInfoException != null) {
            TimerServiceException timerServiceException = this.ivBeanIdException != null ? this.ivBeanIdException : this.ivInfoException;
            timerServiceException.fillInStackTrace();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "doWork: " + timerServiceException);
            }
            throw timerServiceException;
        }
        EJSHome eJSHome = (EJSHome)this.ivBeanId.home;
        if (!eJSHome.enabled) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "doWork: home disabled - rebuilding beanId");
            }
            object = EJSContainer.getDefaultContainer();
            this.ivBeanId = BeanId.getBeanId(this.ivBeanId.getByteArray(), (EJSContainer)object);
            eJSHome = (EJSHome)this.ivBeanId.home;
            if (!eJSHome.beanMetaData.isTimedObject) {
                Tr.warning(tc, "HOME_NOT_FOUND_CNTR0092W", this.ivBeanId.getJ2EEName());
                throw new EJBNotFoundException("Incompatible Application Change: " + this.ivBeanId.getJ2EEName() + " no longer implements TimedObject.");
            }
        }
        object = this.getTaskStatus();
        String string = object.getTaskId();
        int n = object.hashCode();
        TimerImpl timerImpl = new TimerImpl(this.ivBeanId, string, n);
        TimedObjectWrapper timedObjectWrapper = eJSHome.getTimedObjectWrapper(this.ivBeanId);
        try {
            timerImpl.isExecutingEJBTimeout = true;
            timerImpl.ivStatus = object;
            timerImpl.ivHandler = this;
            timedObjectWrapper.ejbTimeout(timerImpl);
        }
        finally {
            timerImpl.isExecutingEJBTimeout = false;
            eJSHome.putTimedObjectWrapper(timedObjectWrapper);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "doWork: " + this.ivBeanId);
            }
        }
    }

    public BeanId getTimedObjectId() throws TimerServiceException {
        if (this.ivBeanIdException != null) {
            this.ivBeanIdException.fillInStackTrace();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getTimedObjectId: " + this.ivBeanIdException);
            }
            throw this.ivBeanIdException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getTimedObjectId: " + this.ivBeanId);
        }
        return this.ivBeanId;
    }

    public Serializable getInfo() throws TimerServiceException {
        if (this.ivInfoException != null) {
            this.ivInfoException.fillInStackTrace();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getInfo: " + this.ivInfoException);
            }
            throw this.ivInfoException;
        }
        return this.ivInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public J2EEName getJ2EEName() throws TimerServiceException, IllegalStateException {
        J2EEName j2EEName = null;
        if (this.ivBeanId != null) {
            j2EEName = this.ivBeanId.getJ2EEName();
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) return j2EEName;
            Tr.debug(tc, "getJ2EEName: BeanId: " + j2EEName);
            return j2EEName;
        } else if (this.ivBeanIdBytes != null) {
            try {
                byte[] byArray = BeanId.getJ2EENameBytes(this.ivBeanIdBytes);
                j2EEName = EJSContainer.getJ2EENameFactory().create(byArray);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) return j2EEName;
                Tr.debug(tc, "getJ2EEName: BeanIdBytes: " + j2EEName);
                return j2EEName;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ejs.container.TimerTaskHandler.getJ2EEName", "361", this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) throw new TimerServiceException("Failure deserializing TimedObject identity", throwable);
                Tr.debug(tc, "getJ2EEName: BeanIdBytes: " + throwable);
                throw new TimerServiceException("Failure deserializing TimedObject identity", throwable);
            }
        } else {
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) throw new IllegalStateException("TimedObject Identity not set.");
            Tr.debug(tc, "getJ2EEName: BeanId not set: IllegalStateException");
            throw new IllegalStateException("TimedObject Identity not set.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Serializable getPrimaryKey() throws TimerServiceException, IllegalStateException {
        Serializable serializable = null;
        if (this.ivBeanId != null) {
            serializable = this.ivBeanId.getPrimaryKey();
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) return serializable;
            Tr.debug(tc, "getPrimaryKey: BeanId: " + serializable.toString());
            return serializable;
        } else if (this.ivBeanIdBytes != null) {
            try {
                serializable = BeanId.getPrimaryKey(this.ivBeanIdBytes);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) return serializable;
                Tr.debug(tc, "getPrimaryKey: BeanIdBytes: " + serializable.toString());
                return serializable;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ejs.container.TimerTaskHandler.getPrimaryKey", "437", this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) throw new TimerServiceException("Failure deserializing TimedObject identity", throwable);
                Tr.debug(tc, "getPrimaryKey: BeanIdBytes: " + throwable);
                throw new TimerServiceException("Failure deserializing TimedObject identity", throwable);
            }
        } else {
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) throw new IllegalStateException("TimedObject Identity not set.");
            Tr.debug(tc, "getPrimaryKey: BeanId not set: IllegalStateException");
            throw new IllegalStateException("TimedObject Identity not set.");
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "writeObject: " + this);
        }
        objectOutputStream.defaultWriteObject();
        objectOutputStream.write(EYECATCHER);
        objectOutputStream.writeShort(1);
        objectOutputStream.writeShort(1);
        objectOutputStream.writeObject(this.ivBeanIdBytes);
        objectOutputStream.writeObject(this.ivInfoBytes);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "writeObject");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        block10: {
            block9: {
                int n;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.entry(tc, "readObject");
                }
                objectInputStream.defaultReadObject();
                byte[] byArray = new byte[EYECATCHER.length];
                int n2 = 0;
                for (n = 0; n < EYECATCHER.length; n += n2) {
                    n2 = objectInputStream.read(byArray, n, EYECATCHER.length - n);
                    if (n2 != -1) continue;
                    throw new IOException("end of input stream while reading eye catcher");
                }
                for (n = 0; n < EYECATCHER.length; ++n) {
                    if (EYECATCHER[n] == byArray[n]) continue;
                    String string = new String(byArray);
                    throw new IOException("Invalid eye catcher '" + string + "' in TimerHandle input stream");
                }
                n = objectInputStream.readShort();
                short s = objectInputStream.readShort();
                if (s != 1) {
                    throw new InvalidObjectException("EJB TimerTaskHandler data stream is not of the correct version, this client should be updated.");
                }
                this.ivBeanIdBytes = (byte[])objectInputStream.readObject();
                this.ivInfoBytes = (byte[])objectInputStream.readObject();
                try {
                    ByteArray byteArray = new ByteArray(this.ivBeanIdBytes);
                    EJSContainer eJSContainer = EJSContainer.getDefaultContainer();
                    this.ivBeanId = BeanId.getBeanId(byteArray, eJSContainer);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ejs.container.TimerTaskHandler.readObject", "567", this);
                    this.ivBeanIdException = new TimerServiceException("Failure deserializing TimedObject identity", throwable);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block9;
                    Tr.debug(tc, "readObject: " + this.ivBeanIdException);
                }
            }
            try {
                this.ivInfo = (Serializable)TimerTaskHandler.deserializeObject(this.ivInfoBytes);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ejs.container.TimerTaskHandler.readObject", "585", this);
                this.ivInfoException = new TimerServiceException("Failure deserializing TimedObject identity", throwable);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block10;
                Tr.debug(tc, "readObject: " + this.ivInfoException);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "readObject: " + this);
        }
    }

    private static byte[] serializeObject(Object object) throws IOException {
        if (object == null) {
            return null;
        }
        SerializeObjectPrivileged serializeObjectPrivileged = SerializeObjectPrivileged.getSerializeObjectPrivileged();
        serializeObjectPrivileged.ivObjToSerialize = object;
        try {
            AccessController.doPrivileged((PrivilegedExceptionAction)serializeObjectPrivileged);
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException(privilegedActionException, "com.ibm.ejs.container.TimerTaskHandler.serializeObject", "642");
            IOException iOException = (IOException)privilegedActionException.getException();
            throw iOException;
        }
        byte[] byArray = serializeObjectPrivileged.ivSerializedObj;
        SerializeObjectPrivileged.releaseSerializeObjectPrivileged(serializeObjectPrivileged);
        return byArray;
    }

    private static Object deserializeObject(byte[] byArray) throws IOException, ClassNotFoundException {
        if (byArray == null) {
            return null;
        }
        Object object = null;
        DeserializeObjectPrivileged deserializeObjectPrivileged = DeserializeObjectPrivileged.getDeserializeObjectPrivileged();
        deserializeObjectPrivileged.ivBytesToDeserialize = byArray;
        try {
            object = AccessController.doPrivileged((PrivilegedExceptionAction)deserializeObjectPrivileged);
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException(privilegedActionException, "com.ibm.ejs.container.TimerTaskHandler.deserializeObject", "698");
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw (ClassNotFoundException)exception;
        }
        DeserializeObjectPrivileged.releaseDeserializeObjectPrivileged(deserializeObjectPrivileged);
        return object;
    }

    public boolean equals(Object object) {
        if (this.ivBeanIdException != null || this.ivInfoException != null) {
            TimerServiceException timerServiceException = this.ivBeanIdException != null ? this.ivBeanIdException : this.ivInfoException;
            timerServiceException.fillInStackTrace();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "equals: " + timerServiceException);
            }
            throw timerServiceException;
        }
        if (object instanceof TimerHandleImpl && super.equals(object)) {
            TimerTaskHandler timerTaskHandler = (TimerTaskHandler)object;
            if (this.ivBeanId.equals(timerTaskHandler.ivBeanId) && this.ivInfo.equals(timerTaskHandler.ivInfo)) {
                return true;
            }
        }
        return false;
    }

    public boolean equals(TimerTaskHandler timerTaskHandler) {
        if (this.ivBeanIdException != null || this.ivInfoException != null) {
            TimerServiceException timerServiceException = this.ivBeanIdException != null ? this.ivBeanIdException : this.ivInfoException;
            timerServiceException.fillInStackTrace();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "equals: " + timerServiceException);
            }
            throw timerServiceException;
        }
        return super.equals(timerTaskHandler) && this.ivBeanId.equals(timerTaskHandler.ivBeanId) && this.ivInfo.equals(timerTaskHandler.ivInfo);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        String string = null;
        TaskStatus taskStatus = this.getTaskStatus();
        if (taskStatus != null) {
            string = taskStatus.getTaskId();
        }
        return "TimerTaskHandler(" + string + ", " + this.ivBeanId + ")";
    }
}

