/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanIdCache;
import com.ibm.ejs.container.EJBNotFoundException;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.EJSWrapper;
import com.ibm.ejs.container.EJSWrapperBase;
import com.ibm.ejs.container.EJSWrapperCommon;
import com.ibm.ejs.container.InvalidBeanIdException;
import com.ibm.ejs.container.util.ByteArray;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.CacheElement;
import com.ibm.websphere.csi.DiscardException;
import com.ibm.websphere.csi.DiscardStrategy;
import com.ibm.websphere.csi.EJBCache;
import com.ibm.websphere.csi.EJBServantManager;
import com.ibm.websphere.csi.FaultException;
import com.ibm.websphere.csi.FaultStrategy;
import com.ibm.websphere.csi.IllegalOperationException;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.ObjectAdapter;
import com.ibm.ws.ffdc.FFDCFilter;
import java.rmi.RemoteException;
import java.util.Enumeration;

public final class WrapperManager
implements DiscardStrategy,
FaultStrategy,
EJBServantManager {
    private static final TraceComponent tc = Tr.register(WrapperManager.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.WrapperManager";
    protected EJBCache wrapperCache;
    private EJSContainer container;
    protected ObjectAdapter oa;
    protected BeanIdCache beanIdCache;

    public WrapperManager(EJSContainer eJSContainer) throws CSIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "WrapperManager");
        }
        this.wrapperCache = eJSContainer.wrapperCache;
        this.wrapperCache.setDiscardStrategy(this);
        this.wrapperCache.setFaultStrategy(this);
        this.container = eJSContainer;
        this.oa = eJSContainer.objectAdapter;
        this.oa.registerServantManager(this);
        int n = this.wrapperCache.getConfigSize();
        n = n < 0x3FFFFFFF ? (n *= 2) : Integer.MAX_VALUE;
        this.beanIdCache = new BeanIdCache(n);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "WrapperManager");
        }
    }

    public void destroy() {
    }

    public boolean preInvoke(EJSWrapperBase eJSWrapperBase) throws CSIException, RemoteException {
        if (eJSWrapperBase.ivCommon.pinned > 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "preInvoke : pinned = false (already pinned)", eJSWrapperBase);
            }
            return false;
        }
        boolean bl = eJSWrapperBase.ivCommon.pinOnce();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "preInvoke : pinned = " + bl, eJSWrapperBase);
        }
        return bl;
    }

    public void postInvoke(EJSWrapperBase eJSWrapperBase) throws CSIException, RemoteException {
        eJSWrapperBase.ivCommon.unpin();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "postInvoke : unpinned", eJSWrapperBase);
        }
    }

    public EJSWrapperCommon getWrapper(BeanId beanId) throws CSIException, RemoteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getWrapper");
        }
        EJSWrapperCommon eJSWrapperCommon = null;
        if (beanId.byteArray == null && !beanId._isHome && beanId.pkey != null) {
            beanId = this.beanIdCache.find(beanId);
        }
        ByteArray byteArray = beanId.getByteArray();
        byteArray.setBeanId(beanId);
        try {
            eJSWrapperCommon = (EJSWrapperCommon)this.wrapperCache.findAndFault(byteArray);
        }
        catch (FaultException faultException) {
            FFDCFilter.processException((Throwable)faultException, "com.ibm.ejs.container.WrapperManager.getWrapper", "259", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Unable to fault in wrapper", (Object)faultException);
            }
            throw new CSIException(faultException.toString());
        }
        if (!beanId._isHome && beanId.pkey != null) {
            this.beanIdCache.add(eJSWrapperCommon.getBeanId());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getWrapper");
        }
        return eJSWrapperCommon;
    }

    public void registerInternal(EJSWrapperCommon eJSWrapperCommon) throws CSIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "registerInternal : " + eJSWrapperCommon);
        }
        BeanId beanId = eJSWrapperCommon.getBeanId();
        ByteArray byteArray = beanId.getByteArray();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "registerInternal : " + byteArray);
        }
    }

    public boolean unregister(BeanId beanId, boolean bl) throws CSIException {
        boolean bl2;
        block7: {
            bl2 = false;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "unregister", new Object[]{beanId, new Boolean(bl)});
            }
            ByteArray byteArray = beanId.getByteArray();
            try {
                EJSWrapperCommon eJSWrapperCommon = (EJSWrapperCommon)this.wrapperCache.removeAndDiscard(byteArray, bl);
                if (eJSWrapperCommon != null) {
                    bl2 = true;
                }
            }
            catch (IllegalOperationException illegalOperationException) {
                FFDCFilter.processException((Throwable)illegalOperationException, "com.ibm.ejs.container.WrapperManager.unregister", "351", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "unregister ignoring IllegalOperationException for object " + beanId);
                    Tr.event(tc, "Exception: " + (Object)((Object)illegalOperationException));
                }
            }
            catch (DiscardException discardException) {
                FFDCFilter.processException((Throwable)discardException, "com.ibm.ejs.container.WrapperManager.unregister", "358", this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block7;
                Tr.event(tc, "Unable to discard element");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "unregister");
        }
        return bl2;
    }

    public void unregisterHome(J2EEName j2EEName, EJSHome eJSHome) throws CSIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "unregisterHome");
        }
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = this.wrapperCache.enumerateElements();
        while (enumeration.hasMoreElements()) {
            EJSWrapperCommon eJSWrapperCommon = (EJSWrapperCommon)((CacheElement)enumeration.nextElement()).getObject();
            BeanId beanId = eJSWrapperCommon.getBeanId();
            J2EEName j2EEName2 = beanId.getJ2EEName();
            ++n;
            if (!j2EEName2.equals(j2EEName) && !beanId.equals(eJSHome.getId())) continue;
            this.unregister(beanId, true);
            ++n2;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Unregistered " + n2 + " wrappers (total = " + n + ")");
        }
        this.beanIdCache.removeAll(eJSHome);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "unregisterHome");
        }
    }

    public void discardObject(EJBCache eJBCache, Object object, Object object2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "discardObject", new Object[]{object, object2});
        }
        EJSWrapperCommon eJSWrapperCommon = (EJSWrapperCommon)object2;
        eJSWrapperCommon.unregisterServant();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "discardObject");
        }
    }

    public Object keyToObject(byte[] byArray) throws RemoteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "keyToObject");
        }
        EJSWrapperCommon eJSWrapperCommon = null;
        EJSWrapper eJSWrapper = null;
        ByteArray byteArray = new ByteArray(byArray);
        try {
            eJSWrapperCommon = (EJSWrapperCommon)this.wrapperCache.findAndFault(byteArray);
            if (eJSWrapperCommon != null) {
                eJSWrapper = eJSWrapperCommon.getRemoteWrapper();
            }
        }
        catch (FaultException faultException) {
            FFDCFilter.processException((Throwable)faultException, "com.ibm.ejs.container.WrapperManager.keyToObject", "501", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Unable to fault in wrapper", (Object)faultException);
            }
            throw new RemoteException(faultException.getMessage(), faultException);
        }
        BeanId beanId = eJSWrapper.beanId;
        if (!beanId._isHome && beanId.pkey != null) {
            this.beanIdCache.add(beanId);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "keyToObject", eJSWrapper);
        }
        return eJSWrapper;
    }

    public Object faultOnKey(EJBCache eJBCache, Object object) throws FaultException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "faultOnKey", object);
        }
        ByteArray byteArray = (ByteArray)object;
        EJSWrapperCommon eJSWrapperCommon = null;
        BeanId beanId = byteArray.getBeanId();
        try {
            if (beanId == null) {
                beanId = BeanId.getBeanId(byteArray, this.container);
            }
            eJSWrapperCommon = this.container.createWrapper(beanId);
            this.registerInternal(eJSWrapperCommon);
        }
        catch (InvalidBeanIdException invalidBeanIdException) {
            FFDCFilter.processException((Throwable)invalidBeanIdException, "com.ibm.ejs.container.WrapperManager.faultOnKey", "533", this);
            Throwable throwable = invalidBeanIdException.getCause();
            if (throwable instanceof EJBNotFoundException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Application Not Started", (Object)invalidBeanIdException);
                }
                throw new FaultException((Exception)((EJBNotFoundException)throwable), (Object)"Application not started or not installed");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Malformed object key", (Object)invalidBeanIdException);
            }
            throw new FaultException((Exception)((Object)invalidBeanIdException), (Object)"Malformed object key");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.container.WrapperManager.faultOnKey", "548", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Malformed object key", exception);
            }
            throw new FaultException(exception, (Object)"Malformed object key");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "faultOnKey");
        }
        return eJSWrapperCommon;
    }

    public byte[] getJ2EENameBytes(byte[] byArray) throws CSIException {
        return BeanId.getJ2EENameBytes(byArray);
    }

    public void dump() {
    }
}

