/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.activator;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanO;
import com.ibm.ejs.container.ContainerAS;
import com.ibm.ejs.container.ContainerTx;
import com.ibm.ejs.container.SessionBeanTimeoutException;
import com.ibm.ejs.container.StatefulBeanO;
import com.ibm.ejs.container.activator.Activator;
import com.ibm.ejs.container.activator.ActivatorCacheFullException;
import com.ibm.ejs.container.activator.MasterKey;
import com.ibm.ejs.container.activator.StatefulActivateTranActivationStrategy;
import com.ibm.ejs.container.drs.SfDRSCache;
import com.ibm.ejs.container.util.EJSPlatformHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.IllegalOperationException;
import com.ibm.websphere.csi.InsufficientCacheSpaceException;
import com.ibm.websphere.csi.PassivationPolicy;
import com.ibm.ws.ffdc.FFDCFilter;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.Date;
import javax.transaction.InvalidTransactionException;
import javax.transaction.TransactionRolledbackException;

public class StatefulASActivationStrategy
extends StatefulActivateTranActivationStrategy {
    private TraceComponent tc = Tr.register(StatefulASActivationStrategy.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.activator.StatefulASActivationStrategy";

    public StatefulASActivationStrategy(Activator activator, PassivationPolicy passivationPolicy, SfDRSCache sfDRSCache) {
        super(activator, passivationPolicy, sfDRSCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BeanO atCreate(ContainerTx containerTx, BeanO beanO) throws RemoteException {
        if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "atCreate", new Object[]{containerTx, beanO});
        }
        ContainerAS containerAS = containerTx.getContainerAS();
        if (containerAS == null) {
            beanO = super.atCreate(containerTx, beanO);
            if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
                Tr.exit(this.tc, "atCreate", beanO);
            }
            return beanO;
        }
        BeanId beanId = beanO.getId();
        MasterKey masterKey = new MasterKey(beanId);
        boolean bl = false;
        boolean bl2 = false;
        BeanO beanO2 = null;
        try {
            Object object = this.locks.getLock(masterKey);
            synchronized (object) {
                block33: {
                    beanO2 = (BeanO)this.cache.find(masterKey);
                    if (beanO2 == null) break block33;
                    this.cache.unpin(masterKey);
                    ContainerTx containerTx2 = beanO2.getContainerTx();
                    if (containerTx2 != containerTx) {
                        if (containerTx2 != null && containerTx2.isTransactionGlobal() && containerTx.isTransactionGlobal()) {
                            Tr.error(this.tc, "SESSIONAL_CONCURRENT_TRANSACTION_ERROR_CNTR0064E", ((Object)beanId.getJ2EEName()).toString());
                            throw new InvalidTransactionException("EJB attempted to become involved with concurrent global transactions within an activity session");
                        }
                        beanO.setContainerTx(containerTx);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
                        Tr.exit(this.tc, "atCreate: found bean in cache", beanO2);
                    }
                    BeanO beanO3 = beanO2;
                    return beanO3;
                }
                this.cache.insert(masterKey, beanO);
                beanO.ivCacheKey = masterKey;
                bl = true;
            }
            if (!beanO.enlist(containerTx)) {
                this.cache.unpin(masterKey);
            }
            beanO.setContainerTx(containerTx);
            containerAS.enlist(beanO);
            if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                Tr.debug(this.tc, "Adding beanO to reaper list");
            }
            object = (StatefulBeanO)beanO;
            this.reaper.add(beanId, ((StatefulBeanO)object).getSessionTimeoutInMilliSeconds());
            if (beanO2 == null && ((StatefulBeanO)object).sfsbFailoverEnabled()) {
                ((StatefulBeanO)object).createDRSEntry();
            }
        }
        catch (InsufficientCacheSpaceException insufficientCacheSpaceException) {
            FFDCFilter.processException((Throwable)insufficientCacheSpaceException, "com.ibm.ejs.container.activator.StatefulASActivationStrategy.atCreate", "129", this);
            bl2 = true;
            throw new ActivatorCacheFullException();
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, "com.ibm.ejs.container.activator.StatefulASActivationStrategy.atCreate", "135", this);
            bl2 = true;
            Tr.event(this.tc, "Exception raised", remoteException);
            throw remoteException;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, "com.ibm.ejs.container.activator.StatefulASActivationStrategy.atCreate", "142", this);
            bl2 = true;
            Tr.event(this.tc, "atCreate", runtimeException);
            throw runtimeException;
        }
        finally {
            if (bl2) {
                beanO.destroy();
                if (bl) {
                    Object object = this.locks.getLock(masterKey);
                    synchronized (object) {
                        this.cache.remove(masterKey, true);
                        beanO.ivCacheKey = null;
                    }
                    containerAS.delist(beanO);
                    this.reaper.remove(beanId);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "atCreate", null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    BeanO atActivate(ContainerTx containerTx, BeanId beanId) throws RemoteException {
        BeanO beanO;
        block37: {
            if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
                Tr.entry(this.tc, "atActivate (" + beanId + ")", containerTx);
            }
            beanO = null;
            ContainerAS containerAS = containerTx.getContainerAS();
            if (containerAS == null) {
                beanO = super.atActivate(containerTx, beanId);
                if (!TraceComponent.isAnyTracingEnabled()) return beanO;
                if (!this.tc.isEntryEnabled()) return beanO;
                Tr.exit(this.tc, "atActivate", beanO);
                return beanO;
            }
            Throwable throwable = null;
            MasterKey masterKey = new MasterKey(beanId);
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            StatefulBeanO statefulBeanO = null;
            Object object = this.locks.getLock(masterKey);
            synchronized (object) {
                try {
                    block36: {
                        try {
                            beanO = (BeanO)this.cache.find(masterKey);
                            if (beanO == null) {
                                boolean bl4;
                                if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                                    Tr.debug(this.tc, "Bean not in cache");
                                }
                                if (bl4 = EJSPlatformHelper.isZOS() ? this.reaper.beanExistsAndTimedOut(beanId) : this.reaper.beanDoesNotExistOrHasTimedOut(beanId)) {
                                    if (this.reaper.beanExistsAndTimedOut(beanId)) {
                                        if (!TraceComponent.isAnyTracingEnabled()) throw new SessionBeanTimeoutException("Stateful bean " + beanId + " timed out.");
                                        if (!this.tc.isDebugEnabled()) throw new SessionBeanTimeoutException("Stateful bean " + beanId + " timed out.");
                                        Tr.debug(this.tc, "Bean " + beanId + " in passivated filesystem or SfDRSCache, " + " but timed out.");
                                        throw new SessionBeanTimeoutException("Stateful bean " + beanId + " timed out.");
                                    }
                                    if (!TraceComponent.isAnyTracingEnabled()) throw new NoSuchObjectException("Stateful bean " + beanId + " was removed or timed out.");
                                    if (!this.tc.isDebugEnabled()) throw new NoSuchObjectException("Stateful bean " + beanId + " was removed or timed out.");
                                    Tr.debug(this.tc, "Bean " + beanId + " not in the passivated filesystem either.");
                                    throw new NoSuchObjectException("Stateful bean " + beanId + " was removed or timed out.");
                                }
                                beanO = beanId.getHome().createBeanO(beanId, containerTx);
                                this.cache.insert(masterKey, beanO);
                                beanO.ivCacheKey = masterKey;
                                bl = true;
                                bl2 = true;
                                statefulBeanO = (StatefulBeanO)beanO;
                            } else {
                                if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                                    Tr.debug(this.tc, "Found bean in cache");
                                }
                                bl3 = true;
                                statefulBeanO = (StatefulBeanO)beanO;
                                this.cache.unpin(masterKey);
                                ContainerTx containerTx2 = beanO.getContainerTx();
                                if (containerTx2 == null) {
                                    bl2 = true;
                                } else if (containerTx2 != containerTx) {
                                    Tr.error(this.tc, "SESSIONAL_CONCURRENT_TRANSACTION_ERROR_CNTR0064E", ((Object)beanId.getJ2EEName()).toString());
                                    throw new InvalidTransactionException("EJB attempted to become involved with concurrent transactions within an activity session");
                                }
                                if (containerTx != null) {
                                    containerTx.ivCallbackBeanO = beanO;
                                    if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                                        Tr.debug(this.tc, "CallbackBeanO = " + beanO);
                                    }
                                }
                            }
                            if (bl) {
                                beanO.activate(beanId, containerTx);
                                if (!this.reaper.beanExists(beanId) || this.passivationPolicy.equals(PassivationPolicy.ON_DEMAND)) {
                                    this.reaper.add(beanId, statefulBeanO.getSessionTimeoutInMilliSeconds());
                                    long l = statefulBeanO.getLastAccessTime();
                                    this.reaper.setLastAccessTime(beanId, l);
                                    if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                                        Tr.debug(this.tc, "Bean last access: " + new Date(l).toString());
                                    }
                                } else {
                                    this.reaper.setActive(beanId);
                                }
                                if (statefulBeanO.sfsbFailoverEnabled()) {
                                    statefulBeanO.updateDRSSetActiveProp();
                                }
                                containerAS.enlist(beanO);
                            }
                            if (statefulBeanO.timedOut(this.reaper)) {
                                throw new SessionBeanTimeoutException("Stateful bean " + beanO + " timed out");
                            }
                            if (!bl2) break block36;
                            if (beanO.enlist(containerTx)) {
                                this.cache.pin(masterKey);
                            }
                            beanO.setContainerTx(containerTx);
                        }
                        catch (InsufficientCacheSpaceException insufficientCacheSpaceException) {
                            FFDCFilter.processException((Throwable)insufficientCacheSpaceException, "com.ibm.ejs.container.activator.StatefulASActivationStrategy.atActivate", "258", this);
                            throwable = insufficientCacheSpaceException;
                            throw new ActivatorCacheFullException();
                        }
                        catch (RemoteException remoteException) {
                            FFDCFilter.processException((Throwable)remoteException, "com.ibm.ejs.container.activator.StatefulASActivationStrategy.atActivate", "264", this);
                            throwable = remoteException;
                            throw remoteException;
                        }
                        catch (RuntimeException runtimeException) {
                            FFDCFilter.processException((Throwable)runtimeException, "com.ibm.ejs.container.activator.StatefulASActivationStrategy.atActivate", "270", this);
                            throwable = runtimeException;
                            throw runtimeException;
                        }
                    }
                    Object var15_18 = null;
                    if (throwable != null) {
                        Tr.event(this.tc, "atActivation: exception raised", throwable);
                    }
                    if (throwable == null || beanO == null) break block37;
                    if (bl || bl3) {
                        try {
                            this.cache.remove(masterKey, true);
                            beanO.ivCacheKey = null;
                            this.reaper.remove(beanId);
                            containerAS.delist(beanO);
                            beanO.destroy();
                        }
                        catch (IllegalOperationException illegalOperationException) {
                            FFDCFilter.processException((Throwable)illegalOperationException, "com.ibm.ejs.container.activator.StatefulASActivationStrategy.atActivate", "201", this);
                            this.cache.unpin(masterKey);
                        }
                    } else {
                        beanO.destroy();
                    }
                }
                catch (Throwable throwable2) {
                    Object var15_19 = null;
                    if (throwable != null) {
                        Tr.event(this.tc, "atActivation: exception raised", throwable);
                    }
                    if (throwable == null) throw throwable2;
                    if (beanO == null) throw throwable2;
                    if (!bl && !bl3) {
                        beanO.destroy();
                        throw throwable2;
                    }
                    try {}
                    catch (IllegalOperationException illegalOperationException) {
                        FFDCFilter.processException((Throwable)illegalOperationException, "com.ibm.ejs.container.activator.StatefulASActivationStrategy.atActivate", "201", this);
                        this.cache.unpin(masterKey);
                        throw throwable2;
                    }
                    this.cache.remove(masterKey, true);
                    beanO.ivCacheKey = null;
                    this.reaper.remove(beanId);
                    containerAS.delist(beanO);
                    beanO.destroy();
                    throw throwable2;
                }
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return beanO;
        if (!this.tc.isEntryEnabled()) return beanO;
        Tr.exit(this.tc, "atActivate", beanO);
        return beanO;
    }

    void atCommit(ContainerTx containerTx, BeanO beanO) {
        ContainerAS containerAS;
        if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "atCommit", new Object[]{containerTx, beanO});
        }
        if ((containerAS = ContainerAS.getContainerAS(containerTx)) == null) {
            super.atCommit(containerTx, beanO);
            if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
                Tr.exit(this.tc, "atCommit");
            }
            return;
        }
        this.resetBeanOContainerTx(beanO);
        if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "atCommit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetBeanOContainerTx(BeanO beanO) {
        Object object = beanO.ivCacheKey;
        Object object2 = this.locks.getLock(object);
        synchronized (object2) {
            BeanO beanO2 = (BeanO)this.cache.find(object);
            if (beanO2 != null) {
                this.cache.unpin(object);
                this.cache.unpin(object);
                beanO2.setContainerTx(null);
            }
        }
    }

    void atRollback(ContainerTx containerTx, BeanO beanO) {
        ContainerAS containerAS;
        if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "atRollback", new Object[]{containerTx, beanO});
        }
        if ((containerAS = ContainerAS.getContainerAS(containerTx)) == null) {
            super.atRollback(containerTx, beanO);
            if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
                Tr.exit(this.tc, "atRollback");
            }
            return;
        }
        this.resetBeanOContainerTx(beanO);
        if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "atRollback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void atPostInvoke(ContainerTx containerTx, BeanO beanO) {
        ContainerAS containerAS;
        if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "atPostInvoke", new Object[]{containerTx, beanO});
        }
        if ((containerAS = ContainerAS.getContainerAS(containerTx)) == null) {
            super.atPostInvoke(containerTx, beanO);
            if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
                Tr.exit(this.tc, "atPostInvoke");
            }
            return;
        }
        BeanId beanId = beanO.getId();
        Object object = beanO.ivCacheKey;
        this.reaper.setLastAccessTime(beanId);
        Object object2 = this.locks.getLock(object);
        synchronized (object2) {
            beanO = (BeanO)this.cache.find(object);
            if (beanO != null) {
                this.cache.unpin(object);
                if (beanO.isRemoved() || beanO.isDiscarded()) {
                    this.cache.unpin(object);
                    if (containerTx != null) {
                        try {
                            containerTx.delist(beanO);
                        }
                        catch (TransactionRolledbackException transactionRolledbackException) {
                            FFDCFilter.processException((Throwable)transactionRolledbackException, "com.ibm.ejs.container.activator.StatefulASActivationStrategy.atPostInvoke", "258", this);
                            Tr.debug(this.tc, "atPostInvoke : transaction has rolledback");
                        }
                    }
                    beanO.setContainerTx(null);
                    containerAS.delist(beanO);
                    ((BeanO)this.cache.remove(object, true)).destroy();
                    beanO.ivCacheKey = null;
                    this.reaper.remove(beanId);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "atPostInvoke");
        }
    }

    void atDiscard(BeanO beanO) throws RemoteException {
        ContainerAS containerAS;
        if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "atDiscard", beanO);
        }
        if ((containerAS = ContainerAS.getCurrentContainerAS()) == null) {
            super.atDiscard(beanO);
            if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
                Tr.exit(this.tc, "atDiscard");
            }
            return;
        }
        try {
            BeanId beanId = ((StatefulBeanO)beanO).getId();
            StatefulBeanO statefulBeanO = (StatefulBeanO)beanO;
            if (!this.reaper.beanDoesNotExistOrHasTimedOut(beanId)) {
                containerAS.delist(beanO);
                beanO.setContainerTx(null);
                beanO.ivCacheKey = null;
                long l = this.reaper.getLastAccessTime(beanId);
                statefulBeanO.setLastAccessTime(l);
                if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                    Tr.debug(this.tc, "StatefulBeanO last access time set to: " + l);
                }
                beanO.passivate();
                this.reaper.setPassivated(beanId);
                statefulBeanO.destroyNotRemove();
            } else {
                Tr.event(this.tc, "Discarding session bean", beanO);
                this.reaper.remove(beanId);
                statefulBeanO.destroy();
                beanO.ivCacheKey = null;
            }
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, "com.ibm.ejs.container.activator.StatefulASActivationStrategy.atDiscard", "484", this);
            Tr.warning(this.tc, "UNABLE_TO_PASSIVATE_EJB_CNTR0005W", new Object[]{beanO, this, remoteException});
            throw remoteException;
        }
        if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "atDiscard");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void atUnitOfWorkEnd(ContainerAS containerAS, BeanO beanO) {
        if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "atUnitOfWorkEnd", new Object[]{containerAS, beanO});
        }
        if (containerAS == null) {
            super.atUnitOfWorkEnd(containerAS, beanO);
            if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
                Tr.exit(this.tc, "atUnitOfWorkEnd");
            }
            return;
        }
        BeanId beanId = beanO.getId();
        Object object = beanO.ivCacheKey;
        Object object2 = this.locks.getLock(object);
        synchronized (object2) {
            beanO = (BeanO)this.cache.find(object);
            if (beanO != null) {
                this.cache.unpin(object);
                try {
                    if (!beanO.isRemoved()) {
                        this.cache.remove(object, true);
                        beanO.ivCacheKey = null;
                        beanO.setContainerTx(null);
                        StatefulBeanO statefulBeanO = (StatefulBeanO)beanO;
                        long l = this.reaper.getLastAccessTime(beanId);
                        statefulBeanO.setLastAccessTime(l);
                        if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                            Tr.debug(this.tc, "StatefulBeanO last access time set to: " + l);
                        }
                        beanO.passivate();
                        this.reaper.setPassivated(beanId);
                        statefulBeanO.destroyNotRemove();
                    }
                }
                catch (RemoteException remoteException) {
                    FFDCFilter.processException((Throwable)remoteException, "com.ibm.ejs.container.activator.StatefulASActivationStrategy.atUnitOfWorkEnd", "64", this);
                    Tr.warning(this.tc, "UNABLE_TO_PASSIVATE_EJB_CNTR0005W", new Object[]{beanO, this, remoteException});
                }
            } else if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                Tr.debug(this.tc, "Bean not found in cache");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "atUnitOfWorkEnd");
        }
    }
}

