/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.activator;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.BeanO;
import com.ibm.ejs.container.ContainerTx;
import com.ibm.ejs.container.SessionBeanTimeoutException;
import com.ibm.ejs.container.StatefulBeanO;
import com.ibm.ejs.container.StatefulBeanReaper;
import com.ibm.ejs.container.activator.Activator;
import com.ibm.ejs.container.activator.ActivatorCacheFullException;
import com.ibm.ejs.container.activator.MasterKey;
import com.ibm.ejs.container.activator.SingletonActivationStrategy;
import com.ibm.ejs.container.drs.SfDRSCache;
import com.ibm.ejs.container.drs.SfDRSClient;
import com.ibm.ejs.container.passivator.StatefulPassivator;
import com.ibm.ejs.container.util.EJSPlatformHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.IllegalOperationException;
import com.ibm.websphere.csi.InsufficientCacheSpaceException;
import com.ibm.websphere.csi.PassivationPolicy;
import com.ibm.ws.ffdc.FFDCFilter;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.Date;
import javax.transaction.TransactionRolledbackException;

public abstract class StatefulSessionActivationStrategy
extends SingletonActivationStrategy {
    protected PassivationPolicy passivationPolicy;
    protected StatefulBeanReaper reaper;
    public StatefulPassivator ivPassivator;
    public SfDRSCache ivSfDRSCache;
    private static final TraceComponent tc = Tr.register(StatefulSessionActivationStrategy.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.activator.StatefulSessionActivationStrategy";

    StatefulSessionActivationStrategy(Activator activator, PassivationPolicy passivationPolicy) {
        this(activator, passivationPolicy, null);
    }

    StatefulSessionActivationStrategy(Activator activator, PassivationPolicy passivationPolicy, SfDRSCache sfDRSCache) {
        super(activator);
        this.passivationPolicy = passivationPolicy;
        this.reaper = activator.statefulBeanReaper;
        this.ivPassivator = activator.passivator;
        this.ivSfDRSCache = sfDRSCache;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", passivationPolicy);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Reaper", this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    BeanO atCreate(ContainerTx containerTx, BeanO beanO) throws RemoteException {
        BeanO beanO2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "atCreate");
        }
        if ((beanO2 = super.atCreate(containerTx, beanO)) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding beanO to reaper list");
            }
            StatefulBeanO statefulBeanO = (StatefulBeanO)beanO;
            this.reaper.add(statefulBeanO.getId(), statefulBeanO.getSessionTimeoutInMilliSeconds());
            if (statefulBeanO.sfsbFailoverEnabled()) {
                statefulBeanO.createDRSEntry();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "atCreate");
        }
        return beanO2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    BeanO atActivate(ContainerTx containerTx, BeanId beanId) throws RemoteException {
        BeanO beanO;
        block34: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "atActivate (" + beanId + ")", containerTx);
            }
            beanO = null;
            Throwable throwable = null;
            MasterKey masterKey = new MasterKey(beanId);
            boolean bl = false;
            boolean bl2 = false;
            StatefulBeanO statefulBeanO = null;
            Object object = this.locks.getLock(masterKey);
            synchronized (object) {
                try {
                    block33: {
                        try {
                            beanO = (BeanO)this.cache.find(masterKey);
                            if (beanO == null) {
                                boolean bl3;
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Bean not in cache");
                                }
                                if (EJSPlatformHelper.isZOS()) {
                                    bl3 = this.reaper.beanExistsAndTimedOut(beanId) || this.passivationPolicy.equals(PassivationPolicy.ON_DEMAND);
                                } else {
                                    boolean bl4 = bl3 = this.reaper.beanDoesNotExistOrHasTimedOut(beanId) || this.passivationPolicy.equals(PassivationPolicy.ON_DEMAND);
                                }
                                if (bl3) {
                                    if (this.reaper.beanExistsAndTimedOut(beanId)) {
                                        if (!TraceComponent.isAnyTracingEnabled()) throw new SessionBeanTimeoutException("Stateful bean " + beanId + " timed out.");
                                        if (!tc.isDebugEnabled()) throw new SessionBeanTimeoutException("Stateful bean " + beanId + " timed out.");
                                        Tr.debug(tc, "Bean " + beanId + " in passivated filesystem or SfDRSCache, " + " but timed out.");
                                        throw new SessionBeanTimeoutException("Stateful bean " + beanId + " timed out.");
                                    }
                                    if (!TraceComponent.isAnyTracingEnabled()) throw new NoSuchObjectException("Stateful bean " + beanId + " was removed or timed out.");
                                    if (!tc.isDebugEnabled()) throw new NoSuchObjectException("Stateful bean " + beanId + " was removed or timed out.");
                                    Tr.debug(tc, "Bean " + beanId + " not in the passivated filesystem either.");
                                    throw new NoSuchObjectException("Stateful bean " + beanId + " was removed or timed out.");
                                }
                                beanO = beanId.getHome().createBeanO(beanId, containerTx);
                                this.cache.insert(masterKey, beanO);
                                beanO.ivCacheKey = masterKey;
                                bl = true;
                                statefulBeanO = (StatefulBeanO)beanO;
                            } else {
                                bl2 = true;
                                statefulBeanO = (StatefulBeanO)beanO;
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Found bean in cache");
                                }
                                if (containerTx != null) {
                                    containerTx.ivCallbackBeanO = beanO;
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "CallbackBeanO = " + beanO);
                                    }
                                }
                            }
                            if (bl) {
                                beanO.activate(beanId, containerTx);
                                if (!this.reaper.beanExists(beanId) || this.passivationPolicy.equals(PassivationPolicy.ON_DEMAND)) {
                                    this.reaper.add(beanId, statefulBeanO.getSessionTimeoutInMilliSeconds());
                                    long l = statefulBeanO.getLastAccessTime();
                                    this.reaper.setLastAccessTime(beanId, l);
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Bean last access: " + new Date(l).toString());
                                    }
                                } else {
                                    this.reaper.setActive(beanId);
                                }
                                if (statefulBeanO.sfsbFailoverEnabled()) {
                                    statefulBeanO.updateDRSSetActiveProp();
                                }
                            }
                            if (statefulBeanO.timedOut(this.reaper)) {
                                throw new SessionBeanTimeoutException("Stateful bean " + beanO + " timed out");
                            }
                            if (!beanO.enlist(containerTx)) break block33;
                            this.cache.pin(masterKey);
                        }
                        catch (InsufficientCacheSpaceException insufficientCacheSpaceException) {
                            FFDCFilter.processException((Throwable)insufficientCacheSpaceException, "com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atActivate", "163", this);
                            throwable = insufficientCacheSpaceException;
                            throw new ActivatorCacheFullException();
                        }
                        catch (RemoteException remoteException) {
                            FFDCFilter.processException((Throwable)remoteException, "com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atActivate", "169", this);
                            throwable = remoteException;
                            throw remoteException;
                        }
                        catch (RuntimeException runtimeException) {
                            FFDCFilter.processException((Throwable)runtimeException, "com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atActivate", "175", this);
                            throwable = runtimeException;
                            throw runtimeException;
                        }
                    }
                    Object var13_15 = null;
                    if (throwable != null && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "atActivation: exception raised", throwable);
                    }
                    if (throwable == null || beanO == null) break block34;
                    if (bl || bl2) {
                        try {
                            this.cache.remove(masterKey, true);
                            beanO.ivCacheKey = null;
                            this.reaper.remove(beanId);
                            beanO.destroy();
                        }
                        catch (IllegalOperationException illegalOperationException) {
                            this.cache.unpin(masterKey);
                        }
                    } else {
                        beanO.destroy();
                    }
                }
                catch (Throwable throwable2) {
                    Object var13_16 = null;
                    if (throwable != null && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "atActivation: exception raised", throwable);
                    }
                    if (throwable == null) throw throwable2;
                    if (beanO == null) throw throwable2;
                    if (!bl && !bl2) {
                        beanO.destroy();
                        throw throwable2;
                    }
                    try {}
                    catch (IllegalOperationException illegalOperationException) {
                        this.cache.unpin(masterKey);
                        throw throwable2;
                    }
                    this.cache.remove(masterKey, true);
                    beanO.ivCacheKey = null;
                    this.reaper.remove(beanId);
                    beanO.destroy();
                    throw throwable2;
                }
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return beanO;
        if (!tc.isEntryEnabled()) return beanO;
        Tr.exit(tc, "atActivate", beanO);
        return beanO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void atPostInvoke(ContainerTx containerTx, BeanO beanO) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "atPostInvoke", new Object[]{containerTx, beanO});
        }
        BeanId beanId = beanO.getId();
        Object object = beanO.ivCacheKey;
        this.reaper.setLastAccessTime(beanId);
        Object object2 = this.locks.getLock(object);
        synchronized (object2) {
            beanO = (BeanO)this.cache.findDontPinNAdjustPinCount(object, -1);
            if (beanO != null && (beanO.isRemoved() || beanO.isDiscarded())) {
                block9: {
                    if (containerTx != null) {
                        try {
                            containerTx.delist(beanO);
                        }
                        catch (TransactionRolledbackException transactionRolledbackException) {
                            FFDCFilter.processException((Throwable)transactionRolledbackException, "com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atPostInvoke", "261", this);
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block9;
                            Tr.debug(tc, "atPostInvoke : transaction has rolledback");
                        }
                    }
                }
                ((BeanO)this.cache.remove(object, true)).destroy();
                beanO.ivCacheKey = null;
                this.reaper.remove(beanId);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "atPostInvoke");
        }
    }

    void atDiscard(BeanO beanO) throws RemoteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "atDiscard", beanO);
        }
        try {
            BeanId beanId = ((StatefulBeanO)beanO).getId();
            StatefulBeanO statefulBeanO = (StatefulBeanO)beanO;
            if (!this.reaper.beanDoesNotExistOrHasTimedOut(beanId)) {
                if (EJSPlatformHelper.isZOS()) {
                    ((StatefulBeanO)beanO).setLastAccessTime(this.reaper.getLastAccessTime(beanId));
                }
                beanO.ivCacheKey = null;
                long l = this.reaper.getLastAccessTime(beanId);
                statefulBeanO.setLastAccessTime(l);
                beanO.passivate();
                this.reaper.setPassivated(beanId);
                statefulBeanO.destroyNotRemove();
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Discarding session bean", beanO);
                }
                this.reaper.remove(beanId);
                statefulBeanO.destroy();
                beanO.ivCacheKey = null;
            }
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, "com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atDiscard", "368", this);
            Tr.warning(tc, "UNABLE_TO_PASSIVATE_EJB_CNTR0005W", new Object[]{beanO, this, remoteException});
            throw remoteException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "atDiscard");
        }
    }

    void atRemove(ContainerTx containerTx, BeanO beanO) {
        super.atRemove(containerTx, beanO);
        this.reaper.remove(beanO.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void atTimeout(BeanId beanId) throws RemoteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "atTimeout " + beanId);
        }
        BeanO beanO = null;
        Exception exception = null;
        MasterKey masterKey = new MasterKey(beanId);
        try {
            Object object = this.locks.getLock(masterKey);
            synchronized (object) {
                beanO = (BeanO)this.cache.find(masterKey);
                if (beanO == null) {
                    if (this.reaper.beanExistsAndTimedOut(beanId)) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Bean not in cache: removing file");
                        }
                        this.ivPassivator.remove(beanId, true);
                        this.reaper.remove(beanId);
                        BeanMetaData beanMetaData = beanId.getBeanMetaData();
                        SfDRSClient sfDRSClient = beanMetaData.getSfDRSClient();
                        if (sfDRSClient != null) {
                            sfDRSClient.removeEntry(beanId);
                        }
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Bean not in cache: already removed");
                    }
                } else if (this.reaper.beanDoesNotExistOrHasTimedOut(beanId)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found bean in cache: passivating / removing");
                    }
                    try {
                        beanO = (BeanO)this.cache.remove(masterKey, true);
                        beanO.ivCacheKey = null;
                        this.reaper.remove(beanId);
                        ((StatefulBeanO)beanO).uninstall();
                    }
                    catch (IllegalOperationException illegalOperationException) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found bean in cache: active");
                        }
                        this.cache.unpin(masterKey);
                    }
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found bean in cache: no longer timed out");
                    }
                    this.cache.unpin(masterKey);
                }
            }
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, "com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atTimeout", "474", this);
            exception = remoteException;
            throw remoteException;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, "com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atTimeout", "480", this);
            exception = runtimeException;
            throw runtimeException;
        }
        finally {
            if (exception != null && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "atTimeout: exception raised", exception);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "atTimeout");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void atPassivate(BeanId beanId) throws RemoteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "atPassivate " + beanId);
        }
        BeanO beanO = null;
        MasterKey masterKey = new MasterKey(beanId);
        try {
            Object object = this.locks.getLock(masterKey);
            synchronized (object) {
                beanO = (BeanO)this.cache.find(masterKey);
                if (beanO != null) {
                    StatefulBeanO statefulBeanO = (StatefulBeanO)beanO;
                    long l = this.reaper.getLastAccessTime(beanId);
                    statefulBeanO.setLastAccessTime(l);
                    beanO.passivate();
                    this.cache.remove(masterKey, true);
                    beanO.ivCacheKey = null;
                    this.reaper.setPassivated(beanId);
                    if (EJSPlatformHelper.isZOS() || this.passivationPolicy.equals(PassivationPolicy.ON_DEMAND)) {
                        this.reaper.remove(beanId);
                    }
                    statefulBeanO.destroyNotRemove();
                }
            }
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, "com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atPassivate", "525", this);
            Tr.warning(tc, "UNABLE_TO_PASSIVATE_EJB_CNTR0005W", new Object[]{beanO, this, remoteException});
            throw remoteException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "atPassivate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void atUninstall(BeanId beanId, BeanO beanO) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "atUninstall (" + beanId + ")");
        }
        MasterKey masterKey = new MasterKey(beanId);
        Object object = this.locks.getLock(masterKey);
        synchronized (object) {
            beanO = (BeanO)this.cache.find(masterKey);
            if (beanO != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Found bean in cache: uninstalling");
                }
                try {
                    this.cache.remove(masterKey, true);
                    beanO.ivCacheKey = null;
                    this.reaper.remove(beanId);
                    ((StatefulBeanO)beanO).uninstall();
                }
                catch (IllegalOperationException illegalOperationException) {
                    FFDCFilter.processException((Throwable)illegalOperationException, "com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atUninstall", "590", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found bean in cache: active!");
                    }
                    this.cache.unpin(masterKey);
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Bean not in cache: removing file");
                }
                try {
                    if (this.reaper.remove(beanId)) {
                        this.ivPassivator.remove(beanId, false);
                    }
                }
                catch (RemoteException remoteException) {
                    FFDCFilter.processException((Throwable)remoteException, "com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atUninstall", "598", this);
                    Tr.warning(tc, "REMOVE_FROM_PASSIVATION_STORE_FAILED_CNTR0016W", new Object[]{beanId, remoteException});
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "atUninstall");
        }
    }

    public StatefulBeanReaper getReaper() {
        return this.reaper;
    }
}

