/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.drs;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.activator.Activator;
import com.ibm.ejs.container.drs.SfDRSCacheEntry;
import com.ibm.ejs.container.drs.SfDRSCacheMsgListener;
import com.ibm.ejs.container.drs.SfDRSClient;
import com.ibm.ejs.container.drs.SfDRSKey;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.FastHashtable;
import com.ibm.websphere.models.config.applicationserver.webcontainer.DRSSettings;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.MultibrokerDomain;
import com.ibm.wsspi.drs.DRSDataXfer;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;

public class SfDRSCache {
    private static final TraceComponent tc = Tr.register(SfDRSCache.class, "EJBDRSCache", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.drs.SfDRSCache";
    private final FastHashtable ivCache;
    private final FastHashtable ivSfDRSClientCache;
    private Activator ivActivator;
    private final MultibrokerDomain ivMultibrokerDomain;
    private String ivContainerId;
    private SfDRSClient ivContainerSfDRSClient;
    private EJSContainer ivContainer;

    public SfDRSCache(MultibrokerDomain multibrokerDomain) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "SfDRSCache CTOR");
        }
        this.ivCache = new FastHashtable(97);
        this.ivSfDRSClientCache = new FastHashtable(17);
        this.ivMultibrokerDomain = multibrokerDomain;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "SfDRSCache created");
        }
    }

    public final SfDRSClient getContainerSfDRSClient() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getContainerSfDRSClient", this.ivContainerSfDRSClient);
        }
        return this.ivContainerSfDRSClient;
    }

    public SfDRSClient getSfDRSClient(String string, DRSSettings dRSSettings) {
        SfDRSClient sfDRSClient;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSfDRSClient for DRS instance ID = " + string);
        }
        if ((sfDRSClient = (SfDRSClient)this.ivSfDRSClientCache.get(string)) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "creating DRS instance for ID = " + string);
            }
            try {
                SfDRSCacheMsgListener sfDRSCacheMsgListener = new SfDRSCacheMsgListener(this);
                String string2 = dRSSettings.getMessageBrokerDomainName();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "DRS replication domain: " + string2);
                }
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("Configure DRS Controller Instance", "EJB Container DRS Controller Instance");
                hashMap.put("MISC_PARM_JOIN_CLUSTER", Boolean.TRUE);
                DRSDataXfer dRSDataXfer = this.ivMultibrokerDomain.createInstance(string, sfDRSCacheMsgListener, null, dRSSettings, null, hashMap);
                sfDRSClient = new SfDRSClient(dRSDataXfer, string);
                sfDRSCacheMsgListener.setSfDRSClient(sfDRSClient);
                this.ivSfDRSClientCache.put(string, sfDRSClient);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ejs.container.drs.SfDRSCache.getSfDRSClient", "216", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "creating DRS instance failed: " + throwable);
                }
                sfDRSClient = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSfDRSClient returning " + sfDRSClient);
        }
        return sfDRSClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beanDoesNotExistOrHasTimedOut(BeanId beanId) {
        SfDRSKey sfDRSKey;
        CacheEntry cacheEntry;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "beanDoesNotExistOrHasTimedOut for BeanId = " + beanId);
        }
        if ((cacheEntry = (CacheEntry)this.ivCache.get(sfDRSKey = new SfDRSKey(beanId))) == null) {
            cacheEntry = this.faultDataIntoCache(beanId);
        }
        boolean bl = true;
        if (cacheEntry != null) {
            CacheEntry cacheEntry2 = cacheEntry;
            synchronized (cacheEntry2) {
                bl = this.beanTimedOut(cacheEntry);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "beanDoesNotExistOrHasTimedOut returning " + bl + " for BeanId = " + beanId);
        }
        return bl;
    }

    public void addCacheEntry(SfDRSKey sfDRSKey, SfDRSCacheEntry sfDRSCacheEntry) {
        CacheEntry cacheEntry;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addCacheEntry for key = " + sfDRSKey);
        }
        if ((cacheEntry = (CacheEntry)this.ivCache.get(sfDRSKey)) != null) {
            this.updateCacheEntry(sfDRSKey, sfDRSCacheEntry);
        } else {
            cacheEntry = new CacheEntry();
            cacheEntry.ivData = sfDRSCacheEntry.ivData;
            cacheEntry.ivSequenceNumber = sfDRSCacheEntry.ivSequenceNumber;
            cacheEntry.ivPassivated = sfDRSCacheEntry.ivPassivated;
            cacheEntry.ivStickyUOW = sfDRSCacheEntry.ivStickyUOW;
            cacheEntry.ivTimeoutValue = sfDRSCacheEntry.ivTimeoutValue;
            cacheEntry.ivLastAccessTime = sfDRSCacheEntry.ivLastAccessTime;
            cacheEntry.ivKey = sfDRSKey;
            this.ivCache.put(sfDRSKey, cacheEntry);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "added: " + cacheEntry);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addCacheEntry");
        }
    }

    public final boolean beanExists(BeanId beanId) {
        SfDRSKey sfDRSKey = new SfDRSKey(beanId);
        return this.beanExists(sfDRSKey);
    }

    final boolean beanExists(SfDRSKey sfDRSKey) {
        CacheEntry cacheEntry = (CacheEntry)this.ivCache.get(sfDRSKey);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, cacheEntry != null ? "Session bean is in DRS cache" : "Session bean is not DRS cache");
        }
        return cacheEntry != null;
    }

    private boolean beanTimedOut(CacheEntry cacheEntry) {
        long l;
        long l2;
        if (cacheEntry.ivTimeoutValue > 0L && (l2 = (l = System.currentTimeMillis()) - cacheEntry.ivLastAccessTime) >= cacheEntry.ivTimeoutValue) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Date date = new Date(l);
                Date date2 = new Date(cacheEntry.ivLastAccessTime);
                Tr.event(tc, "SFSB DRS cache entry timed out ", "DRS Key: " + cacheEntry.ivKey + ", Current Time: " + date.toString() + ", Last Access Time: " + date2.toString() + " Timeout: " + cacheEntry.ivTimeoutValue + " ms");
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beanExistsAndTimedOut(BeanId beanId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "beanExistsAndTimedOut for BeanId = " + beanId);
        }
        boolean bl = false;
        SfDRSKey sfDRSKey = new SfDRSKey(beanId);
        CacheEntry cacheEntry = (CacheEntry)this.ivCache.get(sfDRSKey);
        if (cacheEntry != null) {
            CacheEntry cacheEntry2 = cacheEntry;
            synchronized (cacheEntry2) {
                bl = this.beanTimedOut(cacheEntry);
            }
        }
        cacheEntry = this.faultDataIntoCache(beanId);
        if (cacheEntry != null) {
            CacheEntry cacheEntry3 = cacheEntry;
            synchronized (cacheEntry3) {
                bl = this.beanTimedOut(cacheEntry);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "beanExistsAndTimedOut returning " + bl + " for BeanId = " + beanId);
        }
        return bl;
    }

    private CacheEntry faultDataIntoCache(BeanId beanId) {
        SfDRSCacheEntry sfDRSCacheEntry;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "faultDataIntoCache for BeanId: " + beanId);
        }
        CacheEntry cacheEntry = null;
        SfDRSClient sfDRSClient = beanId.getBeanMetaData().getSfDRSClient();
        if (sfDRSClient != null && (sfDRSCacheEntry = sfDRSClient.getEntry(beanId)) != null) {
            SfDRSKey sfDRSKey = new SfDRSKey(beanId);
            this.addCacheEntry(sfDRSKey, sfDRSCacheEntry);
            cacheEntry = (CacheEntry)this.ivCache.get(sfDRSKey);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "faultDataIntoCache returning: " + cacheEntry + "for BeanId = " + beanId);
        }
        return cacheEntry;
    }

    public byte[] getAndRemoveData(BeanId beanId, SfDRSClient sfDRSClient) {
        SfDRSKey sfDRSKey = new SfDRSKey(beanId);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAndRemoveData, key = " + sfDRSKey);
        }
        byte[] byArray = null;
        CacheEntry cacheEntry = (CacheEntry)this.ivCache.remove(sfDRSKey);
        if (cacheEntry != null) {
            byArray = cacheEntry.ivData;
            SfDRSCacheEntry sfDRSCacheEntry = new SfDRSCacheEntry(cacheEntry.ivKey, cacheEntry.ivTimeoutValue);
            sfDRSCacheEntry.ivData = byArray;
            sfDRSCacheEntry.ivLastAccessTime = cacheEntry.ivLastAccessTime;
            sfDRSCacheEntry.ivPassivated = cacheEntry.ivPassivated;
            sfDRSCacheEntry.ivSequenceNumber = cacheEntry.ivSequenceNumber;
            sfDRSCacheEntry.ivStickyUOW = cacheEntry.ivStickyUOW;
            sfDRSClient.createEntry(beanId, sfDRSCacheEntry);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            int n = byArray != null ? byArray.length : 0;
            Tr.exit(tc, "getAndRemoveData returning data of length: " + n);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SfDRSCacheEntry getCacheEntry(SfDRSKey sfDRSKey) {
        SfDRSCacheEntry sfDRSCacheEntry = null;
        CacheEntry cacheEntry = (CacheEntry)this.ivCache.get(sfDRSKey);
        if (cacheEntry != null) {
            sfDRSCacheEntry = new SfDRSCacheEntry(sfDRSKey, cacheEntry.ivTimeoutValue);
            CacheEntry cacheEntry2 = cacheEntry;
            synchronized (cacheEntry2) {
                sfDRSCacheEntry.ivSequenceNumber = cacheEntry.ivSequenceNumber;
                sfDRSCacheEntry.ivData = cacheEntry.ivData;
                sfDRSCacheEntry.ivPassivated = cacheEntry.ivPassivated;
                sfDRSCacheEntry.ivStickyUOW = cacheEntry.ivStickyUOW;
                sfDRSCacheEntry.ivLastAccessTime = cacheEntry.ivLastAccessTime;
            }
        }
        return sfDRSCacheEntry;
    }

    public void initialize(EJSContainer eJSContainer, DRSSettings dRSSettings) {
        String string;
        String string2 = string = dRSSettings != null ? dRSSettings.getMessageBrokerDomainName() : "*unknown";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize for MultiBrokerDomain: " + string);
        }
        this.ivContainer = eJSContainer;
        this.ivContainerId = eJSContainer.getHomeOfHomes().getJ2EEName().getApplication();
        if (dRSSettings != null) {
            this.ivContainerSfDRSClient = this.getSfDRSClient(this.ivContainerId, dRSSettings);
        }
        this.ivActivator = eJSContainer.getActivator();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize completed for MultiBrokerDomain: " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inStickyUOW(BeanId beanId) {
        boolean bl = false;
        SfDRSKey sfDRSKey = new SfDRSKey(beanId);
        CacheEntry cacheEntry = (CacheEntry)this.ivCache.get(sfDRSKey);
        if (cacheEntry != null) {
            CacheEntry cacheEntry2 = cacheEntry;
            synchronized (cacheEntry2) {
                bl = cacheEntry.ivStickyUOW;
            }
        }
        return bl;
    }

    public final void removeCacheEntry(SfDRSKey sfDRSKey) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeCacheEntry, key = " + sfDRSKey);
        }
        CacheEntry cacheEntry = (CacheEntry)this.ivCache.remove(sfDRSKey);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (cacheEntry != null) {
                Tr.debug(tc, "removed cache entry: " + cacheEntry);
            } else {
                Tr.debug(tc, "cache entry not removed since it was not found");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeCacheEntry");
        }
    }

    public final void removeCacheEntry(BeanId beanId) {
        SfDRSKey sfDRSKey = new SfDRSKey(beanId);
        this.removeCacheEntry(sfDRSKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sweep() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "sweep : DRS Cache size = " + this.ivCache.size());
        }
        Enumeration enumeration = this.ivCache.elements();
        while (enumeration.hasMoreElements()) {
            CacheEntry cacheEntry;
            boolean bl = false;
            CacheEntry cacheEntry2 = cacheEntry = (CacheEntry)enumeration.nextElement();
            synchronized (cacheEntry2) {
                if (this.beanTimedOut(cacheEntry)) {
                    bl = true;
                }
            }
            if (!bl) continue;
            this.ivCache.remove(cacheEntry.ivKey);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "sweep : DRS Cache size = " + this.ivCache.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCacheEntry(SfDRSKey sfDRSKey, SfDRSCacheEntry sfDRSCacheEntry) {
        CacheEntry cacheEntry;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "updateCacheEntry for key = " + sfDRSKey);
        }
        if ((cacheEntry = (CacheEntry)this.ivCache.get(sfDRSKey)) == null) {
            this.addCacheEntry(sfDRSKey, sfDRSCacheEntry);
        } else if (sfDRSCacheEntry.ivSequenceNumber > cacheEntry.ivSequenceNumber) {
            long l = System.currentTimeMillis();
            CacheEntry cacheEntry2 = cacheEntry;
            synchronized (cacheEntry2) {
                cacheEntry.ivSequenceNumber = sfDRSCacheEntry.ivSequenceNumber;
                cacheEntry.ivStickyUOW = sfDRSCacheEntry.ivStickyUOW;
                cacheEntry.ivPassivated = sfDRSCacheEntry.ivPassivated;
                cacheEntry.ivLastAccessTime = sfDRSCacheEntry.ivLastAccessTime;
                if (sfDRSCacheEntry.ivData != null) {
                    cacheEntry.ivData = sfDRSCacheEntry.ivData;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "cached updated: " + cacheEntry);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "stale data cache entry: " + sfDRSCacheEntry);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "updateCacheEntry");
        }
    }

    private class CacheEntry {
        SfDRSKey ivKey;
        byte[] ivData;
        long ivSequenceNumber;
        long ivTimeoutValue;
        long ivLastAccessTime;
        boolean ivPassivated;
        boolean ivStickyUOW;

        private CacheEntry() {
        }

        public String toString() {
            return "key = " + this.ivKey + ", sequence = " + this.ivSequenceNumber + ", passivated = " + this.ivPassivated + ", sticky UOW = " + this.ivStickyUOW;
        }
    }
}

