/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.drs;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.drs.SfDRSKey;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.drs.DRSDataXfer;
import com.ibm.wsspi.drs.exception.DRSCongestedException;
import com.ibm.wsspi.drs.exception.DRSNotReadyException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

class SfDRSCacheEntry
implements Serializable {
    private static final long serialVersionUID = 4929853033094911926L;
    private static final TraceComponent tc = Tr.register(SfDRSCacheEntry.class, "EJBDRSCache", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.drs.SfDRSCacheEntry";
    private static final long LATENCY_TIME = 120000L;
    static final int NUMBER_OF_BUCKETS = 97;
    short ivVersionId = 1;
    long ivSequenceNumber;
    final long ivTimeoutValue;
    boolean ivPassivated;
    boolean ivStickyUOW;
    long ivLastAccessTime;
    transient byte[] ivData;
    transient boolean ivCreateEntry = true;
    transient long ivDRSState = 0L;
    static final byte STATE_DRS_READY = 0;
    static final byte STATE_DRS_CONGESTED = 1;
    static final byte STATE_DRS_NOT_READY = 2;
    final transient SfDRSKey ivKey;

    public SfDRSCacheEntry(BeanId beanId, long l) {
        this.ivKey = new SfDRSKey(beanId);
        this.ivTimeoutValue = l + 120000L;
        this.ivLastAccessTime = System.currentTimeMillis();
    }

    public SfDRSCacheEntry(SfDRSKey sfDRSKey, long l) {
        this.ivKey = sfDRSKey;
        this.ivTimeoutValue = l;
    }

    boolean replicate(DRSDataXfer dRSDataXfer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "replicate " + this);
        }
        boolean bl = false;
        try {
            if (this.ivCreateEntry) {
                dRSDataXfer.createEntry(this.ivKey, this);
                this.ivCreateEntry = false;
            } else {
                dRSDataXfer.updateEntry(this.ivKey, this);
            }
            this.ivDRSState = 0L;
            bl = true;
        }
        catch (DRSNotReadyException dRSNotReadyException) {
            this.ivDRSState = 2L;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "replicate caught DRS is NOT ready");
            }
        }
        catch (DRSCongestedException dRSCongestedException) {
            this.ivDRSState = 1L;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "replicate caught DRS is congested");
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ejs.container.drs.SfDRSCacheEntry.replicate", "258", this);
            Tr.warning(tc, "IGNORING_UNEXPECTED_EXCEPTION_CNTR0033E", throwable);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "replicate returning: " + bl);
        }
        return bl;
    }

    public String toString() {
        if (this.ivKey != null) {
            return "key = " + this.ivKey.toString() + ", sequence = " + this.ivSequenceNumber + ", passivated = " + this.ivPassivated + ", sticky UOW = " + this.ivStickyUOW;
        }
        return "sequence = " + this.ivSequenceNumber + ", passivated = " + this.ivPassivated + ", sticky UOW = " + this.ivStickyUOW;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        if (n == 0) {
            this.ivData = null;
        } else {
            this.ivData = new byte[n];
            int n2 = 0;
            for (int i = 0; i < n; i += n2) {
                n2 = objectInputStream.read(this.ivData, i, n - i);
                if (n2 != -1) continue;
                throw new IOException("end of input stream while reading SFSB data");
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.ivData == null) {
            objectOutputStream.writeInt(0);
        } else {
            objectOutputStream.writeInt(this.ivData.length);
            objectOutputStream.write(this.ivData);
        }
    }
}

