/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.drs;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.drs.SfDRSCacheEntry;
import com.ibm.ejs.container.drs.SfDRSKey;
import com.ibm.ejs.container.util.ByteArray;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.FastHashtable;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.drs.DRSDataXfer;
import com.ibm.wsspi.drs.DRSEventObject;
import java.util.Enumeration;

public final class SfDRSClient {
    private static final TraceComponent tc = Tr.register(SfDRSClient.class, "EJBDRSCache", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.drs.SfDRSClient";
    private DRSDataXfer ivBaseDataXfer = null;
    private String ivInstanceId;
    private FastHashtable ivCache = new FastHashtable(97);

    public SfDRSClient(DRSDataXfer dRSDataXfer, String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "SfDRSClient CTOR for ID = " + string);
        }
        this.ivInstanceId = string;
        this.ivBaseDataXfer = dRSDataXfer;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "SfDRSClient CTOR for ID = " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activated(BeanId beanId, long l) {
        SfDRSCacheEntry sfDRSCacheEntry;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "activated, beanId is: " + beanId);
        }
        if ((sfDRSCacheEntry = (SfDRSCacheEntry)this.ivCache.get(beanId)) != null) {
            ByteArray byteArray = beanId.getByteArray();
            SfDRSCacheEntry sfDRSCacheEntry2 = sfDRSCacheEntry;
            synchronized (sfDRSCacheEntry2) {
                ++sfDRSCacheEntry.ivSequenceNumber;
                sfDRSCacheEntry.ivPassivated = false;
                sfDRSCacheEntry.ivLastAccessTime = l;
                sfDRSCacheEntry.replicate(this.ivBaseDataXfer);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "activated, beanId is: " + beanId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passivated(BeanId beanId, byte[] byArray, long l) {
        SfDRSCacheEntry sfDRSCacheEntry;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "passivated, beanId is: " + beanId);
        }
        if ((sfDRSCacheEntry = (SfDRSCacheEntry)this.ivCache.get(beanId)) != null) {
            ByteArray byteArray = beanId.getByteArray();
            SfDRSCacheEntry sfDRSCacheEntry2 = sfDRSCacheEntry;
            synchronized (sfDRSCacheEntry2) {
                ++sfDRSCacheEntry.ivSequenceNumber;
                sfDRSCacheEntry.ivPassivated = true;
                sfDRSCacheEntry.ivLastAccessTime = l;
                sfDRSCacheEntry.ivData = byArray;
                sfDRSCacheEntry.replicate(this.ivBaseDataXfer);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "passivated, beanId is: " + beanId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createEntry(BeanId beanId, long l) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createEntry beanId is: " + beanId);
        }
        SfDRSCacheEntry sfDRSCacheEntry = new SfDRSCacheEntry(beanId, l);
        Object object = this.ivCache;
        synchronized (object) {
            this.ivCache.put(beanId, sfDRSCacheEntry);
        }
        object = sfDRSCacheEntry;
        synchronized (object) {
            ++sfDRSCacheEntry.ivSequenceNumber;
            sfDRSCacheEntry.replicate(this.ivBaseDataXfer);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createEntry ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createEntry(BeanId beanId, SfDRSCacheEntry sfDRSCacheEntry) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createEntry bean ID is: " + beanId);
        }
        Object object = this.ivCache;
        synchronized (object) {
            this.ivCache.put(beanId, sfDRSCacheEntry);
        }
        object = sfDRSCacheEntry;
        synchronized (object) {
            sfDRSCacheEntry.replicate(this.ivBaseDataXfer);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createEntry ");
        }
    }

    public void event(DRSEventObject dRSEventObject) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "eventObject = " + dRSEventObject);
        }
        int n = dRSEventObject.getEvent();
        switch (n) {
            case 1: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "received event REPLICATION_UP.");
                }
                this.retryReplication();
                break;
            }
            case 2: {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                Tr.debug(tc, "received event REPLICATION_DOWN.");
                break;
            }
            case 3: {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                Tr.debug(tc, "received event IS_CONGESTED.");
                break;
            }
            case 4: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "received event NOT_CONGESTED.");
                }
                this.retryReplication();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "eventObject = " + dRSEventObject);
        }
    }

    public SfDRSCacheEntry getEntry(BeanId beanId) {
        SfDRSCacheEntry sfDRSCacheEntry;
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "getEntry beanId is: " + beanId);
            }
            sfDRSCacheEntry = null;
            try {
                SfDRSKey sfDRSKey = new SfDRSKey(beanId);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getEntry key: " + sfDRSKey);
                }
                sfDRSCacheEntry = (SfDRSCacheEntry)this.ivBaseDataXfer.getEntry(sfDRSKey);
            }
            catch (Throwable throwable) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "getEntry failed for entryKey = " + beanId);
                Tr.debug(tc, "caught Throwable: ", throwable);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getEntry ");
        }
        return sfDRSCacheEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(BeanId beanId) {
        block9: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "removeEntry beanId is: " + beanId);
            }
            SfDRSCacheEntry sfDRSCacheEntry = null;
            FastHashtable fastHashtable = this.ivCache;
            synchronized (fastHashtable) {
                sfDRSCacheEntry = (SfDRSCacheEntry)this.ivCache.remove(beanId);
            }
            try {
                if (sfDRSCacheEntry != null && !sfDRSCacheEntry.ivCreateEntry) {
                    ++sfDRSCacheEntry.ivSequenceNumber;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "removing DRS entry, " + sfDRSCacheEntry);
                    }
                    this.ivBaseDataXfer.removeEntry(sfDRSCacheEntry.ivKey);
                }
            }
            catch (Throwable throwable) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "remoteEntry failed for entryKey = " + beanId);
                Tr.debug(tc, "caught Throwable: ", throwable);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeEntry ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retryReplication() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "retryReplication", this);
        }
        FastHashtable fastHashtable = this.ivCache;
        synchronized (fastHashtable) {
            Enumeration enumeration = this.ivCache.elements();
            while (enumeration.hasMoreElements()) {
                SfDRSCacheEntry sfDRSCacheEntry = (SfDRSCacheEntry)enumeration.nextElement();
                if (sfDRSCacheEntry == null) continue;
                SfDRSCacheEntry sfDRSCacheEntry2 = sfDRSCacheEntry;
                synchronized (sfDRSCacheEntry2) {
                    if (sfDRSCacheEntry.ivDRSState != 0L) {
                        sfDRSCacheEntry.replicate(this.ivBaseDataXfer);
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "retryReplication");
        }
    }

    public boolean entryIDExists(BeanId beanId) {
        boolean bl;
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "entryIDExists beanId is: " + beanId);
            }
            bl = false;
            try {
                SfDRSKey sfDRSKey = new SfDRSKey(beanId);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "entryIDExists key: " + sfDRSKey);
                }
                bl = this.ivBaseDataXfer.entryIDExists(sfDRSKey);
            }
            catch (Throwable throwable) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "entryIDExists failed for entryKey = " + beanId);
                Tr.debug(tc, "caught Throwable: ", throwable);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "entryIDExists returning " + bl);
        }
        return bl;
    }

    public Identity getWLMIdentity(BeanId beanId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getWLMIdentity, beanId is: " + beanId);
        }
        SfDRSKey sfDRSKey = new SfDRSKey(beanId);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getWLMIdentity key: " + sfDRSKey);
        }
        Identity identity = this.ivBaseDataXfer.getWLMIdentity(sfDRSKey, true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getWLMIdentity returning WLM Identity: " + identity);
        }
        return identity;
    }

    public String toString() {
        return "SfDRSClient for ID: " + this.ivInstanceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stickyUOW(BeanId beanId, boolean bl) {
        SfDRSCacheEntry sfDRSCacheEntry;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "stickyUOW, state is " + bl);
        }
        if ((sfDRSCacheEntry = (SfDRSCacheEntry)this.ivCache.get(beanId)) != null) {
            ByteArray byteArray = beanId.getByteArray();
            SfDRSCacheEntry sfDRSCacheEntry2 = sfDRSCacheEntry;
            synchronized (sfDRSCacheEntry2) {
                ++sfDRSCacheEntry.ivSequenceNumber;
                sfDRSCacheEntry.ivStickyUOW = bl;
                sfDRSCacheEntry.replicate(this.ivBaseDataXfer);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "stickyUOW");
        }
    }
}

