/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.drs.ws390;

import com.ibm.ejs.container.drs.ws390.SfDRSControllerBootstrapImpl;
import com.ibm.ejs.container.drs.ws390.SfDRSControllerCacheMsgListenerImpl;
import com.ibm.ejs.container.drs.ws390.SfDRSControllerDataXferImpl;
import com.ibm.ejs.container.drs.ws390.SfDRSControllerInstanceImpl;
import com.ibm.ejs.container.drs.ws390.SfPlatformHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.models.config.applicationserver.webcontainer.DRSSettings;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.MultibrokerDomain;
import com.ibm.wsspi.drs.DRSBootstrap;
import com.ibm.wsspi.drs.DRSCacheMsgListener;
import com.ibm.wsspi.drs.DRSControllerInstance;
import com.ibm.wsspi.drs.DRSControllerInstanceFactory;
import com.ibm.wsspi.drs.DRSControllerInstanceFactoryConfig;
import com.ibm.wsspi.drs.DRSDataXfer;
import com.ibm.wsspi.drs.DRSServantProxyFactory;
import java.util.Map;

public class SfControllerServiceImpl
extends ComponentImpl
implements DRSControllerInstanceFactory {
    private static TraceComponent tc = Tr.register(SfControllerServiceImpl.class, "EJBDRSCache", "com.ibm.ejs.container.container");
    private static boolean _loggedVersion = false;
    private static DRSServantProxyFactory proxyFactory = null;
    private static DRSControllerInstanceFactory sfControllerService = null;

    public SfControllerServiceImpl() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "SfControllerServiceImpl.constructor: Entry");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && !_loggedVersion) {
            Tr.debug(tc, "SfControllerServiceImpl.constructor: Version 1.8 1/11/06 13:15:29");
            _loggedVersion = true;
        }
        if (sfControllerService != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "SfControllerServiceImpl.constructor:  SfControllerServiceImpl already exists");
            }
            throw new IllegalStateException(" SfControllerServiceImpl already exists");
        }
        sfControllerService = this;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "SfControllerServiceImpl.constructor: Exit");
        }
    }

    private boolean shouldRunInThisJVM() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "SfControllerServiceImpl.shouldRunInThisJVM: Entry.");
        }
        boolean bl = false;
        bl = SfPlatformHelper.isZOS();
        if (bl) {
            bl = SfPlatformHelper.isZOS_Controller();
        }
        if (bl) {
            String string = AdminServiceFactory.getAdminService().getProcessType();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "SfControllerServiceImpl.shouldRunInThisJVM:  Process Type = " + string);
            }
            if (string.equals("NodeAgent") || string.equals("DeploymentManager")) {
                bl = false;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "SfControllerServiceImpl.shouldRunInThisJVM: Exit rc = " + bl);
        }
        return bl;
    }

    public void initialize(Object object) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "SfControllerServiceImpl.initialize() WCCM config=" + object);
        }
        if (this.shouldRunInThisJVM()) {
            DRSControllerInstanceFactoryConfig.setControllerInstanceFactory("EJB Container DRS Controller Instance", this);
            Tr.info(tc, "SFB_CONTROLLER_INIT_CNTR0099I", "SfControllerServiceImpl");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "SfControllerServiceImpl.initialize()");
        }
    }

    public void start() throws RuntimeWarning, RuntimeError {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "SfControllerServiceImpl.start()");
        }
        if (this.shouldRunInThisJVM()) {
            try {
                this.getDRSServantProxyFactory();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ejs.container.drs.ws390.SfControllerServiceImpl.start", "256", this);
                Tr.error(tc, "SFB_CONTROLLER_EXCEPTION_CNTR0100E", new Object[]{"SfControllerServiceImpl.start()", throwable});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "SfControllerServiceImpl.start()");
        }
    }

    public void stop() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "SfControllerServiceImpl.stop()");
        }
        if (this.shouldRunInThisJVM()) {
            // empty if block
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "SfControllerServiceImpl.stop()");
        }
    }

    public DRSControllerInstance createDRSControllerInstance(String string, DRSSettings dRSSettings, Map map, boolean bl, long l) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "SfControllerServiceImpl.createDRSControllerInstance()");
        }
        SfDRSControllerInstanceImpl sfDRSControllerInstanceImpl = null;
        try {
            SfDRSControllerBootstrapImpl sfDRSControllerBootstrapImpl;
            SfDRSControllerCacheMsgListenerImpl sfDRSControllerCacheMsgListenerImpl;
            sfDRSControllerInstanceImpl = new SfDRSControllerInstanceImpl(string, dRSSettings, map, bl, l);
            sfDRSControllerInstanceImpl.dcml = sfDRSControllerCacheMsgListenerImpl = new SfDRSControllerCacheMsgListenerImpl(sfDRSControllerInstanceImpl);
            sfDRSControllerInstanceImpl.db = sfDRSControllerBootstrapImpl = new SfDRSControllerBootstrapImpl(sfDRSControllerInstanceImpl);
            sfDRSControllerInstanceImpl.drsServantProxyFactory = proxyFactory;
            SfDRSControllerDataXferImpl sfDRSControllerDataXferImpl = new SfDRSControllerDataXferImpl(sfDRSControllerInstanceImpl, bl);
            if (bl) {
                DRSDataXfer dRSDataXfer = this.getDRSDataXfer(dRSSettings.getMessageBrokerDomainName(), string, sfDRSControllerCacheMsgListenerImpl, sfDRSControllerBootstrapImpl, dRSSettings, map);
                sfDRSControllerDataXferImpl.setBaseDDX(dRSDataXfer);
                sfDRSControllerInstanceImpl.baseDDX = dRSDataXfer;
            }
            sfDRSControllerInstanceImpl.ddx = sfDRSControllerDataXferImpl;
            sfDRSControllerInstanceImpl.init();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ejs.container.drs.ws390.SfControllerServiceImpl.createDRSControllerInstance", "381", this);
            Tr.error(tc, "SFB_CONTROLLER_EXCEPTION_CNTR0100E", new Object[]{"SfControllerServiceImpl.createDRSControllerInstance()", throwable});
            sfDRSControllerInstanceImpl = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "SfControllerServiceImpl.createDRSControllerInstance()" + (sfDRSControllerInstanceImpl == null ? "failure" : "success"));
        }
        return sfDRSControllerInstanceImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DRSDataXfer getDRSDataXfer(String string, String string2, DRSCacheMsgListener dRSCacheMsgListener, DRSBootstrap dRSBootstrap, DRSSettings dRSSettings, Map map) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "SfControllerServiceImpl.getDRSDataXfer() instanceID = " + string2);
        }
        DRSDataXfer dRSDataXfer = null;
        MultibrokerDomain multibrokerDomain = null;
        try {
            multibrokerDomain = (MultibrokerDomain)super.getService(MultibrokerDomain.class);
            dRSDataXfer = multibrokerDomain.getInstance(string, string2);
            if (dRSDataXfer == null) {
                dRSDataXfer = multibrokerDomain.createInstance(string2, dRSCacheMsgListener, dRSBootstrap, dRSSettings, null, map);
            }
            super.releaseService(multibrokerDomain);
        }
        catch (Throwable throwable) {
            try {
                FFDCFilter.processException(throwable, "com.ibm.ejs.container.drs.ws390.SfControllerServiceImpl.getDRSDataXfer", "430", this);
                Tr.error(tc, "SFB_CONTROLLER_EXCEPTION_CNTR0100E", new Object[]{"SfControllerServiceImpl.getDRSDataXfer()", throwable});
                super.releaseService(multibrokerDomain);
            }
            catch (Throwable throwable2) {
                super.releaseService(multibrokerDomain);
                throw throwable2;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "SfControllerServiceImpl.getDRSDataXfer() instanceID = " + string2);
        }
        return dRSDataXfer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDRSServantProxyFactory() {
        block8: {
            block9: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.entry(tc, "SfControllerServiceImpl.getDRSServantProxyFactory()");
                }
                if (proxyFactory != null) break block9;
                MultibrokerDomain multibrokerDomain = null;
                try {
                    multibrokerDomain = (MultibrokerDomain)this.getService(MultibrokerDomain.class);
                    proxyFactory = multibrokerDomain.getDRSServantProxyFactoryInstance();
                }
                catch (Throwable throwable) {
                    try {
                        FFDCFilter.processException(throwable, "com.ibm.ejs.container.drs.ws390.SfControllerServiceImpl.getDRSServantProxyFactory", "461", this);
                        Tr.error(tc, "SFB_CONTROLLER_EXCEPTION_CNTR0100E", new Object[]{"SfControllerServiceImpl.getDRSServantProxyFactory()", throwable});
                    }
                    catch (Throwable throwable2) {
                        this.releaseService(multibrokerDomain);
                        throw throwable2;
                    }
                    this.releaseService(multibrokerDomain);
                    break block8;
                }
                this.releaseService(multibrokerDomain);
                break block8;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "SfControllerServiceImpl.getDRSServantProxyFactory - proxy factory already acquired");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "SfControllerServiceImpl.getDRSServantProxyFactory - exit : " + (proxyFactory == null ? "failure" : "success"));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "SfControllerServiceImpl.getDRSServantProxyFactory()");
        }
    }
}

