/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.drs.ws390;

import com.ibm.ejs.container.drs.ws390.SfDRSControllerBootstrapImpl;
import com.ibm.ejs.container.drs.ws390.SfDRSControllerCacheMsgListenerImpl;
import com.ibm.ejs.container.drs.ws390.SfDRSControllerDataXferImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.applicationserver.webcontainer.DRSSettings;
import com.ibm.wsspi.drs.DRSControllerDataXfer;
import com.ibm.wsspi.drs.DRSControllerInstance;
import com.ibm.wsspi.drs.DRSControllerInstanceFactoryConfig;
import com.ibm.wsspi.drs.DRSDataXfer;
import com.ibm.wsspi.drs.DRSEventObject;
import com.ibm.wsspi.drs.DRSInstanceToken;
import com.ibm.wsspi.drs.DRSInstanceTokenTable;
import com.ibm.wsspi.drs.DRSServantProxyFactory;
import java.util.Map;

public class SfDRSControllerInstanceImpl
implements DRSControllerInstance {
    DRSInstanceTokenTable registerendServants;
    DRSInstanceTokenTable unRegisterendServants;
    DRSServantProxyFactory drsServantProxyFactory;
    SfDRSControllerDataXferImpl ddx;
    DRSDataXfer baseDDX;
    DRSSettings drss;
    String ddxKey;
    Map miscParms;
    SfDRSControllerCacheMsgListenerImpl dcml;
    SfDRSControllerBootstrapImpl db;
    boolean usingHAManager;
    long uniqueInstanceId;
    long instanceId;
    String instanceName;
    String instanceUniqueName;
    private DRSEventObject isUpEvent;
    private DRSEventObject isNotCongestedEvent;
    boolean eventStateReplicationUp;
    boolean eventStateIsCongested;
    private Integer drsStateLock;
    private int unAvailableCount;
    private static final int MAX_UNAVAILABLE_ATTEMPTS = 500;
    private static TraceComponent tc = Tr.register(SfDRSControllerInstanceImpl.class, "EJBDRSCache", "com.ibm.ejs.container.container");
    private static boolean _loggedVersion = false;

    public SfDRSControllerInstanceImpl(String string, DRSSettings dRSSettings, Map map, boolean bl, long l) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "SfDRSControllerInstanceImpl.constructor:  Entry - ddxKey = " + string);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && !_loggedVersion) {
            Tr.debug(tc, "SfDRSControllerInstanceImpl.constructor: Version 1.6 1/11/06 13:15:40");
            _loggedVersion = true;
        }
        this.ddxKey = string;
        this.drss = dRSSettings;
        this.miscParms = map;
        this.usingHAManager = bl;
        this.uniqueInstanceId = l;
        this.instanceUniqueName = this.ddxKey + ":" + this.uniqueInstanceId;
        this.drsStateLock = new Integer(9472);
        this.unAvailableCount = 0;
        this.isUpEvent = new DRSEventObject(1, this);
        this.isNotCongestedEvent = new DRSEventObject(4, this);
        this.eventStateReplicationUp = true;
        this.eventStateIsCongested = false;
        this.ddx = null;
        this.baseDDX = null;
        this.dcml = null;
        this.drsServantProxyFactory = null;
        this.instanceId = 0L;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "SfDRSControllerInstanceImpl.constructor:  ddxKey = " + this.ddxKey);
            Tr.debug(tc, "SfDRSControllerInstanceImpl.constructor:  DRS Settings = " + this.drss);
            Tr.debug(tc, "SfDRSControllerInstanceImpl.constructor:  Misc Parms = " + this.miscParms);
            Tr.debug(tc, "SfDRSControllerInstanceImpl.constructor:  Using HAManager = " + this.usingHAManager);
            Tr.debug(tc, "SfDRSControllerInstanceImpl.constructor:  Unique Instance Id = " + this.uniqueInstanceId);
        }
        this.registerendServants = DRSControllerInstanceFactoryConfig.createDRSInstanceTokenTable("SfDRSControllerInstance" + this.instanceUniqueName, "registerendServants");
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "SfDRSControllerInstanceImpl.constructor:  ddxKey = " + this.ddxKey);
        }
    }

    public void init() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "SfDRSControllerInstanceImpl.init:  Entry - ddxKey = " + this.ddxKey);
        }
        if (this.usingHAManager) {
            this.instanceId = this.ddx.getInstanceId();
            this.instanceName = this.ddx.getInstanceName();
        } else {
            this.instanceId = this.uniqueInstanceId;
            this.instanceName = this.ddxKey;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "SfDRSControllerInstanceImpl.init:  instanceId = " + this.instanceId);
            Tr.debug(tc, "SfDRSControllerInstanceImpl.init:  instanceName = " + this.instanceName);
            Tr.debug(tc, "SfDRSControllerInstanceImpl.init:  instanceUniqueName = " + this.instanceUniqueName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "SfDRSControllerInstanceImpl.init:  Exit - ddxKey = " + this.ddxKey + " instanceUniqueName = " + this.instanceUniqueName);
        }
    }

    public DRSControllerDataXfer getDRSControllerDataXfer() {
        String string = "SfDRSControllerInstanceImpl.getDRSControllerDataXfer/" + this.instanceUniqueName + "/";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, string + " Entry");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, string + " Exit");
        }
        return this.ddx;
    }

    public DRSInstanceTokenTable getDRSInstanceTokenTable() {
        String string = "SfDRSControllerInstanceImpl.getDRSInstanceTokenTable/" + this.instanceUniqueName + "/";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, string + " Entry");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, string + " Exit");
        }
        return this.registerendServants;
    }

    public void addServant(DRSInstanceToken dRSInstanceToken, DRSEventObject dRSEventObject) {
        String string = "SfDRSControllerInstanceImpl.addServant/" + this.instanceUniqueName + "/";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, string + " token = " + dRSInstanceToken + " event = " + dRSEventObject);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, string + " token = " + dRSInstanceToken + " event = " + dRSEventObject);
        }
        this.dcml.sendEvent(dRSInstanceToken, this.isUpEvent);
        this.dcml.sendEvent(dRSInstanceToken, this.isNotCongestedEvent);
        this.registerendServants.addServant(dRSInstanceToken);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, string + " Exit");
        }
    }

    public void deleteServant(DRSInstanceToken dRSInstanceToken) {
        String string = "SfDRSControllerInstanceImpl.deleteServant/" + this.instanceUniqueName + "/";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, string + " Token = " + dRSInstanceToken);
        }
        this.registerendServants.deleteServant(dRSInstanceToken);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, string + " Exit");
        }
    }

    public void deleteServant(String string) {
        String string2 = "SfDRSControllerInstanceImpl.deleteServant/" + this.instanceUniqueName + "/";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, string2 + " Stoken = " + string);
        }
        this.registerendServants.deleteServant(string);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, string2 + " Exit");
        }
    }

    public long getInstanceId() {
        String string = "SfDRSControllerInstanceImpl.getInstanceId/" + this.instanceUniqueName + "/";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry");
        }
        long l = this.instanceId;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, string + " Exit - instanceId = " + l);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDRSReplicationUp() {
        boolean bl;
        String string = "SfDRSControllerInstanceImpl.setDRSReplicationUp/" + this.instanceUniqueName + "/ ";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry  - eventStateReplicationUp = " + this.eventStateReplicationUp);
        }
        Integer n = this.drsStateLock;
        synchronized (n) {
            bl = this.eventStateReplicationUp;
            this.eventStateReplicationUp = true;
            this.eventStateIsCongested = false;
        }
        if (!bl) {
            Tr.info(tc, "SFB_CONTROLLER_DRSEVENT_REPLICATION_UP_CNTR0113I", this.instanceUniqueName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit - eventStateReplicationUp = " + this.eventStateReplicationUp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDRSReplicationDown() {
        boolean bl;
        String string = "SfDRSControllerInstanceImpl.setDRSReplicationDown/" + this.instanceUniqueName + "/ ";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry  - eventStateReplicationUp = " + this.eventStateReplicationUp);
        }
        Integer n = this.drsStateLock;
        synchronized (n) {
            bl = this.eventStateReplicationUp;
            this.eventStateReplicationUp = false;
            this.eventStateIsCongested = false;
        }
        if (bl) {
            Tr.info(tc, "SFB_CONTROLLER_DRSEVENT_REPLICATION_DOWN_CNTR0114I", this.instanceUniqueName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit - eventStateReplicationUp = " + this.eventStateReplicationUp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDRSCongested() {
        boolean bl;
        String string = "SfDRSControllerInstanceImpl.setDRSCongested/" + this.instanceUniqueName + "/ ";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry  - eventStateIsCongested = " + this.eventStateIsCongested);
        }
        Integer n = this.drsStateLock;
        synchronized (n) {
            bl = this.eventStateIsCongested;
            this.eventStateIsCongested = true;
        }
        if (!bl) {
            Tr.info(tc, "SFB_CONTROLLER_DRSEVENT_IS_CONGESTED_CNTR0115I", this.instanceUniqueName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit - eventStateIsCongested = " + this.eventStateIsCongested);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDRSNotCongested() {
        boolean bl;
        String string = "SfDRSControllerInstanceImpl.setDRSNotCongested/" + this.instanceUniqueName + "/ ";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry  - eventStateIsCongested = " + this.eventStateIsCongested);
        }
        Integer n = this.drsStateLock;
        synchronized (n) {
            bl = this.eventStateIsCongested;
            this.eventStateIsCongested = false;
        }
        if (bl) {
            Tr.info(tc, "SFB_CONTROLLER_DRSEVENT_NOT_CONGESTED_CNTR0116I", this.instanceUniqueName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit - eventStateIsCongested = " + this.eventStateIsCongested);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDRSAvailable() {
        String string = "SfDRSControllerInstanceImpl.isDRSAvailable/" + this.instanceUniqueName + "/ ";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry.");
        }
        boolean bl = false;
        Integer n = this.drsStateLock;
        synchronized (n) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, string + "DRS state - eventStateReplicationUp = " + this.eventStateReplicationUp + " - eventStateIsCongested = " + this.eventStateIsCongested);
            }
            boolean bl2 = bl = this.eventStateReplicationUp && !this.eventStateIsCongested;
            if (!bl && this.usingHAManager) {
                try {
                    ++this.unAvailableCount;
                    if (this.unAvailableCount > 500) {
                        boolean bl3;
                        this.unAvailableCount = 0;
                        if (!this.eventStateReplicationUp) {
                            bl3 = this.baseDDX.isReplicationUp();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, string + "replicationUp = " + bl3);
                            }
                            if (bl3) {
                                this.setDRSReplicationUp();
                            }
                        }
                        if (this.eventStateReplicationUp && this.eventStateIsCongested) {
                            bl3 = this.baseDDX.isCongested();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, string + "isCongested = " + bl3);
                            }
                            if (!bl3) {
                                this.setDRSNotCongested();
                            }
                        }
                        bl = this.eventStateReplicationUp && !this.eventStateIsCongested;
                    }
                }
                catch (Throwable throwable) {
                    Tr.error(tc, "ControllerSession.CaughtException", new Object[]{string, throwable});
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit - isDRSAvailable = " + bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDRSUp() {
        String string = "SfDRSControllerInstanceImpl.isDRSUp/" + this.instanceUniqueName + "/ ";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry.");
        }
        boolean bl = false;
        Integer n = this.drsStateLock;
        synchronized (n) {
            bl = this.eventStateReplicationUp;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit - isDRSUp = " + bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDRSCongested() {
        String string = "SfDRSControllerInstanceImpl.isDRSCongested/" + this.instanceUniqueName + "/ ";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry.");
        }
        boolean bl = false;
        Integer n = this.drsStateLock;
        synchronized (n) {
            bl = this.eventStateIsCongested;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit - isDRSUp = " + bl);
        }
        return bl;
    }
}

