/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.lock;

import com.ibm.ejs.container.lock.Lock;
import com.ibm.ejs.container.lock.LockException;
import com.ibm.ejs.container.lock.LockProxy;
import com.ibm.ejs.container.lock.Locker;
import com.ibm.ejs.container.lock.Waiter;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.util.Enumeration;
import java.util.Hashtable;

public class LockManager {
    private static final TraceComponent tc = Tr.register(LockManager.class, "EJBContainer", "com.ibm.ejs.container.container");
    public static final int SHARED = 0;
    public static final int EXCLUSIVE = 1;
    public static final String[] modeStrs = new String[]{"SHARED", "EXCLUSIVE"};
    private Hashtable lockTable;
    private Hashtable waitTable;

    public LockManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.lockTable = new Hashtable();
        this.waitTable = new Hashtable();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lock(Object object, Locker locker, int n) throws InterruptedException, LockException {
        Lock lock = null;
        Hashtable hashtable = this.lockTable;
        synchronized (hashtable) {
            LockProxy lockProxy;
            Locker locker2 = this.lockTable.put(object, locker);
            if (locker2 == null || locker2 == locker) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "lock acquired", new Object[]{object, locker, modeStrs[n]});
                }
                return locker2 == null;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Conflict : Lock upgrading from proxy", new Object[]{object, locker, modeStrs[n]});
            }
            if ((lockProxy = (LockProxy)locker2).isLock()) {
                lock = (Lock)lockProxy;
                if (lock.isHolder(locker)) {
                    this.lockTable.put(object, lock);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "lock acquired (already held)", new Object[]{object, locker, modeStrs[n]});
                    }
                    return false;
                }
            } else {
                lock = new Lock(object, locker2, this);
            }
            this.lockTable.put(object, lock);
            lock.acquire(locker, n, false);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Conflict : Lock upgraded from proxy", new Object[]{object, locker, modeStrs[n]});
            }
        }
        lock.acquire(locker, n, true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "lock acquired", new Object[]{object, locker, modeStrs[n]});
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Object object, Locker locker) {
        Hashtable hashtable = this.lockTable;
        synchronized (hashtable) {
            Lock lock;
            Object v = this.lockTable.remove(object);
            if (v != null && v != locker && (lock = (Lock)v).release(locker) != 0) {
                this.lockTable.put(object, lock);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "lock released", new Object[]{object, locker});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Locker locker) {
        Hashtable hashtable = this.lockTable;
        synchronized (hashtable) {
            if (this.lockTable.size() == 0) {
                return;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "unlock", locker);
            }
            Enumeration enumeration = this.lockTable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Object v = this.lockTable.get(k);
                if (v == locker) {
                    this.unlock(k, locker);
                    continue;
                }
                if (!((LockProxy)v).isLock() || !((Lock)v).isHolder(locker)) continue;
                this.unlock(k, locker);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "unlock");
            }
        }
    }

    void waitEvent(Waiter waiter) {
        this.waitTable.put(waiter.locker, waiter.theLock);
    }

    void unwaitEvent(Waiter waiter) {
        this.waitTable.remove(waiter.locker);
    }

    boolean detectDeadlock(Locker locker, Lock lock, int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "detectDeadlock", new Object[]{locker, lock, modeStrs[n]});
        }
        boolean bl = false;
        Enumeration enumeration = lock.getHolders();
        while (enumeration.hasMoreElements()) {
            if (!this.lockerWaitingOn((Locker)enumeration.nextElement(), locker)) continue;
            bl = true;
            break;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "detectDeadlock:" + bl);
        }
        return bl;
    }

    public boolean lockerWaitingOn(Locker locker, Locker locker2) {
        Lock lock = (Lock)this.waitTable.get(locker);
        if (lock == null) {
            return false;
        }
        Enumeration enumeration = lock.getHolders();
        while (enumeration.hasMoreElements()) {
            Locker locker3 = (Locker)enumeration.nextElement();
            if (locker3 == locker2) {
                return true;
            }
            if (!this.lockerWaitingOn(locker3, locker2)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.lockTable.size();
    }

    public void dump() {
        if (!tc.isDumpEnabled()) {
            return;
        }
        Enumeration enumeration = this.lockTable.keys();
        Tr.dump(tc, "-- Lock Manager Dump --");
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Tr.dump(tc, "lock table entry", new Object[]{k, this.lockTable.get(k)});
        }
    }
}

