/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.passivator;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanO;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSLocalWrapper;
import com.ibm.ejs.container.TimerHandleImpl;
import com.ibm.ejs.container.util.ByteArray;
import com.ibm.ejs.container.util.SerializableByteArray;
import com.ibm.ejs.container.util.StatefulBeanOReplacement;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.CSIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.rmi.CORBA.Stub;

class NewInputStream
extends ObjectInputStream {
    BeanO activatedBeanO;
    private ClassLoader classLoader;
    private EJSContainer container;
    private static final TraceComponent tc = Tr.register(NewInputStream.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.passivator.NewInputStream";

    NewInputStream(InputStream inputStream, BeanO beanO, ClassLoader classLoader, EJSContainer eJSContainer) throws StreamCorruptedException, IOException {
        super(inputStream);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "NewInputStream: Input stream:" + inputStream + ", activatedBeanO: " + beanO);
        }
        this.activatedBeanO = beanO;
        this.classLoader = classLoader;
        this.container = eJSContainer;
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                NewInputStream.this.enableResolveObject(true);
                return null;
            }
        });
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "NewInputStream");
        }
    }

    protected Object resolveObject(Object object) {
        Object object2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            object2 = object == null ? null : object.getClass().getName();
            Tr.entry(tc, "resolveObject: " + (String)object2);
        }
        if (object instanceof StatefulBeanOReplacement) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "replacing StatefulBeanOReplacement");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "resolveObject: " + this.activatedBeanO);
            }
            return this.activatedBeanO;
        }
        if (object instanceof Stub) {
            try {
                this.container.getOrbUtils().connectToOrb(object);
            }
            catch (CSIException cSIException) {
                FFDCFilter.processException((Throwable)cSIException, "com.ibm.ejs.container.passivator.NewInputStream.resolveObject", "172", this);
                Tr.warning(tc, "FAILED_TO_CONNECT_TO_ORB_CNTR0006W", (Object)cSIException);
                return null;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "resolveObject: original remote object");
            }
            return object;
        }
        if (object instanceof SerializableByteArray) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "replacing SerializableByteArray with EJSLocalWrapper");
            }
            try {
                object2 = ((SerializableByteArray)object).getByteArray();
                BeanId beanId = BeanId.getBeanId(new ByteArray((byte[])object2), this.container);
                EJSLocalWrapper eJSLocalWrapper = this.container.getWrapperManager().getWrapper(beanId).getLocalWrapper();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "resolveObject: " + eJSLocalWrapper.getClass().getName());
                }
                return eJSLocalWrapper;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.container.passivator.NewInputStream.resolveObject", "191", this);
                Tr.warning(tc, "UNABLE_TO_PASSIVATE_EJB_CNTR0005W", new Object[]{object, this, exception});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "resolveObject: null : ERROR");
                }
                return null;
            }
        }
        if (object instanceof TimerHandleImpl) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "replacing TimerHandle with Timer or TimerHandle");
            }
            object2 = ((TimerHandleImpl)object).getSerializedObject();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "resolveObject: " + object2);
            }
            return object2;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveObject: original object");
        }
        return object;
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        final String string = objectStreamClass.getName();
        if (this.classLoader != null) {
            Class clazz;
            final ClassLoader classLoader = this.classLoader;
            try {
                clazz = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException {
                        return classLoader.loadClass(string);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                ClassNotFoundException classNotFoundException = (ClassNotFoundException)privilegedActionException.getException();
                FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ejs.container.passivator.NewInputStream.resolveClass", "185", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to find class for passivated bean");
                }
                throw classNotFoundException;
            }
            return clazz;
        }
        throw new ClassNotFoundException();
    }
}

