/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.passivator;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.StatefulBeanO;
import com.ibm.ejs.container.drs.SfDRSCache;
import com.ibm.ejs.container.passivator.NewInputStream;
import com.ibm.ejs.container.passivator.NewOutputStream;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.RemoveCollaborator;
import com.ibm.websphere.csi.SessionBeanStore;
import com.ibm.websphere.csi.StreamUnavailableException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.j2c.WSLoginLocalOSExtensionFactory;
import com.ibm.ws.security.util.ServerIdentityHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.ejb.SessionBean;

public class StatefulPassivator {
    private static final TraceComponent tc = Tr.register(StatefulPassivator.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.passivator.StatefulPassivator";
    private static final boolean isZOS = PlatformHelperFactory.getPlatformHelper().isZOS();
    private SessionBeanStore beanStore;
    private RemoveCollaborator[] removeCollaborators;
    private EJSContainer container;
    private boolean ivTerminating = false;
    private Object ivActivateLock;
    private Object ivPassivateLock;
    private Object ivRemoveLock;
    private SfDRSCache ivStatefulDRSCache;

    public StatefulPassivator(SessionBeanStore sessionBeanStore, RemoveCollaborator[] removeCollaboratorArray, EJSContainer eJSContainer, SfDRSCache sfDRSCache) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "StatefulPassivator");
        }
        this.beanStore = sessionBeanStore;
        this.removeCollaborators = removeCollaboratorArray;
        this.container = eJSContainer;
        this.ivStatefulDRSCache = sfDRSCache;
        this.ivActivateLock = new Object();
        this.ivPassivateLock = new Object();
        this.ivRemoveLock = new Object();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "StatefulPassivator");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passivate(Object object) throws RemoteException {
        block35: {
            Object object2;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "passivate", object);
            }
            boolean bl = false;
            StatefulBeanO statefulBeanO = (StatefulBeanO)object;
            if (statefulBeanO.isRemoved() || this.isTerminating()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Bean removed!");
                }
                return;
            }
            BeanId beanId = statefulBeanO.getId();
            SessionBean sessionBean = statefulBeanO.sessionBean;
            boolean bl2 = false;
            ObjectOutputStream objectOutputStream = null;
            if (isZOS) {
                object2 = WSLoginLocalOSExtensionFactory.getInstance();
                bl = object2.isApplicationSyncToOSThreadEnabled();
            }
            if (this.removeCollaborators != null) {
                for (int i = 0; i < this.removeCollaborators.length; ++i) {
                    this.removeCollaborators[i].passivate(beanId);
                }
            }
            object2 = null;
            if (isZOS && bl) {
                object2 = ServerIdentityHelper.getServerIdentityHelper().push();
            }
            try {
                if (statefulBeanO.sfsbFailoverEnabled()) {
                    long l = statefulBeanO.getLastAccessTime();
                    byte[] byArray = this.getCompressedBytes(sessionBean, l);
                    Object object3 = this.ivPassivateLock;
                    synchronized (object3) {
                        OutputStream outputStream = this.beanStore.getOutputStream(beanId);
                        objectOutputStream = new NewOutputStream(outputStream, this.container);
                        objectOutputStream.writeInt(byArray.length);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "length of compressed bytes is: " + byArray.length);
                        }
                        objectOutputStream.write(byArray);
                        objectOutputStream.close();
                    }
                    statefulBeanO.updateDRSEntry(byArray, l);
                    break block35;
                }
                Object object4 = this.ivPassivateLock;
                synchronized (object4) {
                    GZIPOutputStream gZIPOutputStream = this.beanStore.getGZIPOutputStream(beanId);
                    objectOutputStream = new NewOutputStream(gZIPOutputStream, this.container);
                    long l = statefulBeanO.getLastAccessTime();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "writing passivation file with last access time set to: " + l);
                    }
                    objectOutputStream.writeLong(l);
                    objectOutputStream.writeObject(sessionBean);
                    objectOutputStream.close();
                }
            }
            catch (CSIException cSIException) {
                bl2 = true;
                FFDCFilter.processException((Throwable)cSIException, "com.ibm.ejs.container.passivator.StatefulPassivator.passivate", "113", this);
                throw new RemoteException("passivation failed", cSIException);
            }
            catch (Exception exception) {
                bl2 = true;
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.container.passivator.StatefulPassivator.passivate", "107", this);
                Tr.warning(tc, "CANNOT_PASSIVATE_STATEFUL_BEAN_CNTR0001W", new Object[]{object.toString(), this, exception});
                throw new RemoteException("passivation failed", exception);
            }
            finally {
                block36: {
                    if (isZOS && bl) {
                        ServerIdentityHelper.getServerIdentityHelper().pop(object2);
                    }
                    if (bl2) {
                        try {
                            if (objectOutputStream == null) break block36;
                            objectOutputStream.close();
                            Object object5 = this.ivRemoveLock;
                            synchronized (object5) {
                                this.beanStore.remove(beanId);
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "passivate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(Object object, ClassLoader classLoader) throws RemoteException {
        Object object2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "activate", object);
        }
        boolean bl = false;
        SessionBean sessionBean = null;
        StatefulBeanO statefulBeanO = (StatefulBeanO)object;
        BeanId beanId = statefulBeanO.getId();
        Object object3 = null;
        if (isZOS && (bl = (object2 = WSLoginLocalOSExtensionFactory.getInstance()).isApplicationSyncToOSThreadEnabled())) {
            object3 = ServerIdentityHelper.getServerIdentityHelper().push();
        }
        try {
            if (!statefulBeanO.sfsbFailoverEnabled()) {
                object2 = this.ivActivateLock;
                synchronized (object2) {
                    GZIPInputStream gZIPInputStream = this.beanStore.getGZIPInputStream(beanId);
                    NewInputStream newInputStream = new NewInputStream(gZIPInputStream, statefulBeanO, classLoader, this.container);
                    long l = newInputStream.readLong();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "read from passivation file last access time: " + l);
                    }
                    statefulBeanO.setLastAccessTime(l);
                    sessionBean = (SessionBean)newInputStream.readObject();
                    gZIPInputStream.close();
                }
                statefulBeanO.setEnterpriseBean(sessionBean);
            } else {
                NewInputStream newInputStream;
                InputStream inputStream;
                object2 = null;
                if (this.ivStatefulDRSCache.beanExists(beanId)) {
                    boolean bl2 = this.ivStatefulDRSCache.inStickyUOW(beanId);
                    object2 = this.ivStatefulDRSCache.getAndRemoveData(beanId, statefulBeanO.ivSfDRSClient);
                    if (bl2) {
                        throw new NoSuchObjectException("Bean Managed Transaction is active, SFSB failover not supported");
                    }
                    if (object2 == null) {
                        throw new NoSuchObjectException("SFSB replication failed.");
                    }
                } else {
                    Object object4 = this.ivActivateLock;
                    synchronized (object4) {
                        inputStream = this.beanStore.getInputStream(beanId);
                        newInputStream = new NewInputStream(inputStream, statefulBeanO, classLoader, this.container);
                        int n = newInputStream.readInt();
                        object2 = new byte[n];
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "length of compressed bytes is: " + n);
                        }
                        int n2 = 0;
                        for (int i = 0; i < n; i += n2) {
                            n2 = newInputStream.read((byte[])object2, i, n - i);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "bytes read from input stream is: " + n2);
                            }
                            if (n2 != -1) continue;
                            throw new IOException("end of input stream while reading compressed bytes");
                        }
                        newInputStream.close();
                    }
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object2);
                inputStream = new GZIPInputStream(byteArrayInputStream);
                newInputStream = new NewInputStream(inputStream, statefulBeanO, classLoader, this.container);
                long l = newInputStream.readLong();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "read from DRS data last access time: " + l);
                }
                statefulBeanO.setLastAccessTime(l);
                sessionBean = (SessionBean)newInputStream.readObject();
                ((GZIPInputStream)inputStream).close();
                statefulBeanO.setEnterpriseBean(sessionBean);
            }
            object2 = this.ivRemoveLock;
            synchronized (object2) {
                this.beanStore.remove(beanId);
            }
        }
        catch (StreamUnavailableException streamUnavailableException) {
            FFDCFilter.processException((Throwable)streamUnavailableException, "com.ibm.ejs.container.passivator.StatefulPassivator.activate", "146", this);
            throw new NoSuchObjectException("");
        }
        catch (CSIException cSIException) {
            FFDCFilter.processException((Throwable)cSIException, "com.ibm.ejs.container.passivator.StatefulPassivator.activate", "149", this);
            throw new RemoteException("passivation failed", cSIException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ejs.container.passivator.StatefulPassivator.activate", "152", this);
            Tr.warning(tc, "CANNOT_ACTIVATE_STATEFUL_BEAN_CNTR0003W", new Object[]{object.toString(), this, classNotFoundException});
            throw new RemoteException("", classNotFoundException);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ejs.container.passivator.StatefulPassivator.activate", "157", this);
            Tr.warning(tc, "CANNOT_ACTIVATE_STATEFUL_BEAN_CNTR0003W", new Object[]{object.toString(), this, iOException});
            throw new RemoteException("", iOException);
        }
        finally {
            if (isZOS && bl) {
                ServerIdentityHelper.getServerIdentityHelper().pop(object3);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "activate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(BeanId beanId, boolean bl) throws RemoteException {
        if (this.ivStatefulDRSCache == null || !this.ivStatefulDRSCache.beanExists(beanId)) {
            Object object = this.ivRemoveLock;
            synchronized (object) {
                this.beanStore.remove(beanId);
            }
        } else if (bl) {
            this.ivStatefulDRSCache.removeCacheEntry(beanId);
        }
    }

    public synchronized void terminate() {
        this.ivTerminating = true;
    }

    private synchronized boolean isTerminating() {
        return this.ivTerminating;
    }

    private byte[] getCompressedBytes(SessionBean sessionBean, long l) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getCompressedBytes", sessionBean);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        NewOutputStream newOutputStream = new NewOutputStream(gZIPOutputStream, this.container);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "writing DRS data with last access time set to: " + l);
        }
        newOutputStream.writeLong(l);
        newOutputStream.writeObject(sessionBean);
        gZIPOutputStream.finish();
        gZIPOutputStream.close();
        newOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getCompressedBytes");
        }
        return byArray;
    }
}

