/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.util;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanO;
import com.ibm.ejs.container.ContainerException;
import com.ibm.ejs.container.UncheckedException;
import com.ibm.ejs.persistence.EJSPersistenceException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cpi.CPIException;
import com.ibm.websphere.cpmi.CPMIException;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.ws.exception.WsEJBException;
import com.ibm.ws.exception.WsNestedException;
import com.ibm.ws.javax.ejb.ActivityCompletedLocalException;
import com.ibm.ws.javax.ejb.ActivityRequiredLocalException;
import com.ibm.ws.javax.ejb.InvalidActivityLocalException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import javax.ejb.AccessLocalException;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.TransactionRequiredLocalException;
import javax.ejb.TransactionRolledbackLocalException;
import javax.naming.NamingException;
import org.omg.CORBA.portable.UnknownException;

public class ExceptionUtil {
    private static TraceComponent tc = Tr.register(ExceptionUtil.class, "EJBContainer", "com.ibm.ejs.container.container");

    public static final String throwableToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        ExceptionUtil.printStackTrace(throwable, printWriter);
        return stringWriter.toString();
    }

    public static final void logException(Throwable throwable, EJBMethodInfo eJBMethodInfo, BeanO beanO) {
        BeanId beanId = null;
        if (beanO != null) {
            beanId = beanO.getId();
        }
        if (eJBMethodInfo == null) {
            if (beanId == null) {
                Tr.error(tc, "NON_APPLICATION_EXCEPTION_CNTR0018E", throwable);
            } else {
                Tr.error(tc, "NON_APPLICATION_EXCEPTION_ON_BEAN_CNTR0021E", new Object[]{throwable, beanId});
            }
        } else {
            String string = eJBMethodInfo.getMethodName();
            if (beanId == null) {
                Tr.error(tc, "NON_APPLICATION_EXCEPTION_METHOD_CNTR0019E", new Object[]{throwable, string});
            } else {
                Tr.error(tc, "NON_APPLICATION_EXCEPTION_METHOD_ON_BEAN_CNTR0020E", new Object[]{throwable, string, beanId});
            }
        }
    }

    public static void logException(Throwable throwable) {
        ExceptionUtil.logException(throwable, null, null);
    }

    private static final void printStackTrace(Throwable throwable, PrintWriter printWriter) {
        throwable.printStackTrace(printWriter);
    }

    public static Throwable findRootCause(Throwable throwable) {
        Throwable throwable2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "findRootCause: " + throwable);
        }
        Throwable throwable3 = throwable2 = throwable;
        while (throwable3 != null) {
            throwable2 = throwable3;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "finding cause of: " + throwable2.getClass().getName());
            }
            if (throwable2 instanceof RemoteException) {
                throwable3 = ((RemoteException)throwable2).detail;
                continue;
            }
            if (throwable2 instanceof WsNestedException) {
                throwable3 = ((WsNestedException)((Object)throwable2)).getCause();
                continue;
            }
            if (throwable2 instanceof TransactionRolledbackLocalException) {
                throwable3 = ((TransactionRolledbackLocalException)throwable2).getCause();
                continue;
            }
            if (throwable2 instanceof AccessLocalException) {
                throwable3 = ((AccessLocalException)throwable2).getCause();
                continue;
            }
            if (throwable2 instanceof NoSuchObjectLocalException) {
                throwable3 = ((NoSuchObjectLocalException)throwable2).getCause();
                continue;
            }
            if (throwable2 instanceof TransactionRequiredLocalException) {
                throwable3 = ((TransactionRequiredLocalException)throwable2).getCause();
                continue;
            }
            if (throwable2 instanceof InvalidActivityLocalException) {
                throwable2 = ((InvalidActivityLocalException)((Object)throwable2)).getCause();
                continue;
            }
            if (throwable2 instanceof ActivityRequiredLocalException) {
                throwable2 = ((ActivityRequiredLocalException)((Object)throwable2)).getCause();
                continue;
            }
            if (throwable2 instanceof ActivityCompletedLocalException) {
                throwable3 = ((ActivityCompletedLocalException)((Object)throwable2)).getCause();
                continue;
            }
            if (throwable2 instanceof NamingException) {
                throwable3 = ((NamingException)throwable2).getRootCause();
                continue;
            }
            if (throwable2 instanceof InvocationTargetException) {
                throwable3 = ((InvocationTargetException)throwable2).getTargetException();
                continue;
            }
            if (throwable2 instanceof UnknownException) {
                throwable3 = ((UnknownException)throwable2).originalEx;
                continue;
            }
            throwable3 = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "findRootCause returning: " + throwable2);
        }
        return throwable2;
    }

    public static EJBException EJBException(Throwable throwable) {
        return ExceptionUtil.EJBException("See nested exception", throwable);
    }

    public static EJBException EJBException(String string, Throwable throwable) {
        Throwable throwable2;
        EJBException eJBException = null;
        if (throwable == null) {
            eJBException = new EJBException(string);
        }
        while (throwable != null && (throwable instanceof ContainerException || throwable instanceof UncheckedException || throwable instanceof EJSPersistenceException || throwable instanceof CPIException || throwable instanceof CPMIException || throwable instanceof CSIException || throwable instanceof WsEJBException)) {
            throwable2 = throwable.getCause();
            if (throwable2 == null) {
                eJBException = new EJBException(throwable.getMessage());
                eJBException.setStackTrace(throwable.getStackTrace());
            }
            throwable = throwable2;
        }
        if (eJBException == null) {
            if (throwable instanceof EJBException) {
                eJBException = (EJBException)throwable;
                if ((throwable = eJBException.getCausedByException()) != null && eJBException.getCause() == null) {
                    eJBException.initCause(throwable);
                }
            } else {
                if (throwable instanceof Exception) {
                    eJBException = new EJBException(string, (Exception)throwable);
                } else {
                    throwable2 = new Exception(throwable);
                    throwable2.setStackTrace(new StackTraceElement[0]);
                    eJBException = new EJBException(string, (Exception)throwable2);
                }
                eJBException.initCause(throwable);
                eJBException.setStackTrace(new StackTraceElement[0]);
            }
        }
        return eJBException;
    }

    public static RemoteException RemoteException(Throwable throwable) {
        return ExceptionUtil.RemoteException("See nested exception", throwable);
    }

    public static RemoteException RemoteException(String string, Throwable throwable) {
        RemoteException remoteException = null;
        if (throwable == null) {
            remoteException = new RemoteException(string);
        }
        while (throwable != null && (throwable instanceof ContainerException || throwable instanceof UncheckedException || throwable instanceof EJSPersistenceException || throwable instanceof CPIException || throwable instanceof CPMIException || throwable instanceof CSIException || throwable instanceof WsEJBException)) {
            Throwable throwable2 = throwable.getCause();
            if (throwable2 == null) {
                remoteException = new RemoteException(throwable.getMessage());
                remoteException.setStackTrace(throwable.getStackTrace());
            }
            throwable = throwable2;
        }
        if (remoteException == null) {
            if (throwable instanceof RemoteException) {
                remoteException = (RemoteException)throwable;
            } else {
                remoteException = new RemoteException(string, throwable);
                remoteException.setStackTrace(new StackTraceElement[0]);
            }
        }
        return remoteException;
    }

    private static String getBaseMessage(Throwable throwable) {
        String string = null;
        if (throwable != null && (string = throwable.getMessage()) != null) {
            if (string.startsWith("nested exception is:")) {
                string = null;
            } else {
                int n = string.indexOf("; nested exception is:");
                if (n > -1) {
                    string = string.substring(0, n);
                }
            }
        }
        return string;
    }
}

