/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.util;

import com.ibm.ejs.csi.ActivitySessionMethod;
import com.ibm.ejs.models.base.extensions.ejbext.AccessIntent;
import com.ibm.ejs.models.base.extensions.ejbext.IsolationLevelAttributes;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.ActivitySessionAttribute;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.TransactionAttribute;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.ejb.MessageDriven;
import org.eclipse.jst.j2ee.ejb.MethodElement;
import org.eclipse.jst.j2ee.ejb.MethodTransaction;
import org.eclipse.jst.j2ee.ejb.Session;

public class MethodAttribUtils {
    private static final TraceComponent tc = Tr.register(MethodAttribUtils.class, "", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.util.MethodAttribUtils";
    public static final String METHOD_ARGLIST_SEP = ":";
    public static final String[] TX_ATTR_STR;
    private static int[] isoLevelMOFMap;
    private static String[] ISOLATION_STR;
    private static TransactionAttribute[] txMOFMap;
    private static final TransactionAttribute[] txAttrMap;

    public static final void getTransactions(TransactionAttribute[] transactionAttributeArray, int n, String[] stringArray, String[] stringArray2, List list, EnterpriseBean enterpriseBean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getTransactions", transactionAttributeArray);
        }
        if (enterpriseBean instanceof Entity || enterpriseBean instanceof Session && ((Session)enterpriseBean).getTransactionType().getValue() == 1 || enterpriseBean instanceof MessageDriven && ((MessageDriven)enterpriseBean).getTransactionType().getValue() == 1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Bean is CMT");
            }
            if (list != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "tranAttrList non-null");
                }
                int[] nArray = new int[stringArray.length];
                for (int i = 0; i < list.size(); ++i) {
                    MethodTransaction methodTransaction = (MethodTransaction)list.get(i);
                    int n2 = methodTransaction.getTransactionAttribute().getValue();
                    EList eList = methodTransaction.getMethodElements();
                    for (int j = 0; j < eList.size(); ++j) {
                        int n3;
                        MethodElement methodElement = (MethodElement)eList.get(j);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "MethodElement EnterpriseBean name:", methodElement.getEnterpriseBean());
                            Tr.debug(tc, "MethodElement method name:", methodElement.getName());
                            Tr.debug(tc, "MethodElement method parms:", methodElement.getParms());
                            if (methodElement.isUnspecified()) {
                                Tr.debug(tc, "Interface type unspecified");
                            } else {
                                Tr.debug(tc, "Interface type specified");
                                Tr.debug(tc, "Interface type:", new Integer(methodElement.getType().getValue()));
                            }
                        }
                        if (methodElement.getEnterpriseBean() != enterpriseBean) continue;
                        String string = methodElement.getName().trim();
                        if (string.equals("*")) {
                            if (methodElement.isUnspecified()) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Style type 1 - all bean methods:", txMOFMap[n2]);
                                }
                                for (n3 = 0; n3 < stringArray.length; ++n3) {
                                    if (nArray[n3] > 1) continue;
                                    transactionAttributeArray[n3] = txMOFMap[n2];
                                    nArray[n3] = 1;
                                }
                                continue;
                            }
                            if (methodElement.getType().getValue() != n) continue;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Style type 2 - home/remote methods only:", txMOFMap[n2]);
                            }
                            for (n3 = 0; n3 < stringArray.length; ++n3) {
                                if (nArray[n3] > 2) continue;
                                transactionAttributeArray[n3] = txMOFMap[n2];
                                nArray[n3] = 2;
                            }
                            continue;
                        }
                        if (!methodElement.isUnspecified() && methodElement.getType().getValue() != n) continue;
                        for (n3 = 0; n3 < stringArray.length; ++n3) {
                            if (!string.equals(stringArray[n3])) continue;
                            String string2 = methodElement.getParms();
                            if (string2 == null) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Style type 3 - method name only:", txMOFMap[n2]);
                                }
                                if (nArray[n3] > 3) continue;
                                transactionAttributeArray[n3] = txMOFMap[n2];
                                nArray[n3] = 3;
                                continue;
                            }
                            if (!(string2 = MethodAttribUtils.normalizeSignature(string2.trim())).equals(stringArray2[n3])) continue;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Style type 4 - method name and signature:", txMOFMap[n2]);
                            }
                            transactionAttributeArray[n3] = txMOFMap[n2];
                            nArray[n3] = 4;
                        }
                    }
                }
            }
        } else if (enterpriseBean instanceof Session && ((Session)enterpriseBean).getTransactionType().getValue() == 0 || enterpriseBean instanceof MessageDriven && ((MessageDriven)enterpriseBean).getTransactionType().getValue() == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Bean is BMT -- all methods will be set to BEAN_MANAGED");
            }
            for (int i = 0; i < transactionAttributeArray.length; ++i) {
                transactionAttributeArray[i] = TransactionAttribute.TX_BEAN_MANAGED;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getTransactions");
        }
    }

    public static final void getActivitySessions(ActivitySessionAttribute[] activitySessionAttributeArray, int n, String[] stringArray, String[] stringArray2, List list, EnterpriseBean enterpriseBean, boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getActivitySessions", activitySessionAttributeArray);
        }
        if (enterpriseBean instanceof Entity || !bl) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Bean is CMT");
            }
            if (list != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "asAttrList non-null");
                }
                int[] nArray = new int[stringArray.length];
                for (int i = 0; i < list.size(); ++i) {
                    ActivitySessionMethod activitySessionMethod = (ActivitySessionMethod)list.get(i);
                    ActivitySessionAttribute activitySessionAttribute = activitySessionMethod.getActivitySessionAttribute();
                    List list2 = activitySessionMethod.getMethodElements();
                    for (int j = 0; j < list2.size(); ++j) {
                        int n2;
                        MethodElement methodElement = (MethodElement)list2.get(j);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "MethodElement EnterpriseBean name:", methodElement.getEnterpriseBean());
                            Tr.debug(tc, "MethodElement method name:", methodElement.getName());
                            Tr.debug(tc, "MethodElement method parms:", methodElement.getParms());
                            if (methodElement.isUnspecified()) {
                                Tr.debug(tc, "Interface type unspecified");
                            } else {
                                Tr.debug(tc, "Interface type specified");
                                Tr.debug(tc, "Interface type:", new Integer(methodElement.getType().getValue()));
                            }
                        }
                        if (methodElement.getEnterpriseBean() != enterpriseBean) continue;
                        String string = methodElement.getName().trim();
                        if (string.equals("*")) {
                            if (methodElement.isUnspecified()) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Style type 1 - all bean methods:", activitySessionAttribute);
                                }
                                for (n2 = 0; n2 < stringArray.length; ++n2) {
                                    if (nArray[n2] > 1) continue;
                                    activitySessionAttributeArray[n2] = activitySessionAttribute;
                                    nArray[n2] = 1;
                                }
                                continue;
                            }
                            if (methodElement.getType().getValue() != n) continue;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Style type 2 - home/remote methods only:", activitySessionAttribute);
                            }
                            for (n2 = 0; n2 < stringArray.length; ++n2) {
                                if (nArray[n2] > 2) continue;
                                activitySessionAttributeArray[n2] = activitySessionAttribute;
                                nArray[n2] = 2;
                            }
                            continue;
                        }
                        if (!methodElement.isUnspecified() && methodElement.getType().getValue() != n) continue;
                        for (n2 = 0; n2 < stringArray.length; ++n2) {
                            if (!string.equals(stringArray[n2])) continue;
                            String string2 = methodElement.getParms();
                            if (string2 == null) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Style type 3 - method name only:", activitySessionAttribute);
                                }
                                if (nArray[n2] > 3) continue;
                                activitySessionAttributeArray[n2] = activitySessionAttribute;
                                nArray[n2] = 3;
                                continue;
                            }
                            if (!(string2 = MethodAttribUtils.normalizeSignature(string2.trim())).equals(stringArray2[n2])) continue;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Style type 4 - method name and signature:", activitySessionAttribute);
                            }
                            activitySessionAttributeArray[n2] = activitySessionAttribute;
                            nArray[n2] = 4;
                        }
                    }
                }
            }
        } else if (bl) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Bean is BM Activity Session -- all methods will be set to AS_BEAN_MANAGED");
            }
            for (int i = 0; i < activitySessionAttributeArray.length; ++i) {
                activitySessionAttributeArray[i] = ActivitySessionAttribute.AS_BEAN_MANAGED;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getActivitySessions");
        }
    }

    public static final void getIsolationLevels(int[] nArray, int n, String[] stringArray, String[] stringArray2, List list, EnterpriseBean enterpriseBean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getIsolationLevels");
        }
        if (list != null) {
            int[] nArray2 = new int[stringArray.length];
            for (int i = 0; i < list.size(); ++i) {
                IsolationLevelAttributes isolationLevelAttributes = (IsolationLevelAttributes)list.get(i);
                int n2 = isolationLevelAttributes.getIsolationLevel().getValue();
                EList eList = isolationLevelAttributes.getMethodElements();
                for (int j = 0; j < eList.size(); ++j) {
                    int n3;
                    MethodElement methodElement = (MethodElement)eList.get(j);
                    if (methodElement.getEnterpriseBean() != enterpriseBean) continue;
                    String string = methodElement.getName().trim();
                    if (string.equals("*")) {
                        if (methodElement.isUnspecified()) {
                            for (n3 = 0; n3 < stringArray.length; ++n3) {
                                if (nArray2[n3] > 1) continue;
                                nArray[n3] = isoLevelMOFMap[n2];
                                nArray2[n3] = 1;
                            }
                            continue;
                        }
                        if (methodElement.getType().getValue() != n) continue;
                        for (n3 = 0; n3 < stringArray.length; ++n3) {
                            if (nArray2[n3] > 2) continue;
                            nArray[n3] = isoLevelMOFMap[n2];
                            nArray2[n3] = 2;
                        }
                        continue;
                    }
                    if (!methodElement.isUnspecified() && methodElement.getType().getValue() != n) continue;
                    for (n3 = 0; n3 < stringArray.length; ++n3) {
                        if (!string.equals(stringArray[n3])) continue;
                        String string2 = methodElement.getParms();
                        if (string2 == null) {
                            if (nArray2[n3] > 3) continue;
                            nArray[n3] = isoLevelMOFMap[n2];
                            nArray2[n3] = 3;
                            continue;
                        }
                        if (!(string2 = MethodAttribUtils.normalizeSignature(string2.trim())).equals(stringArray2[n3])) continue;
                        nArray[n3] = isoLevelMOFMap[n2];
                        nArray2[n3] = 4;
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getIsolationLevels");
        }
    }

    public static final void getReadOnlyAttributes(boolean[] blArray, int n, String[] stringArray, String[] stringArray2, List list, EnterpriseBean enterpriseBean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getReadOnlyAttributes");
        }
        if (list != null) {
            int[] nArray = new int[stringArray.length];
            for (int i = 0; i < list.size(); ++i) {
                AccessIntent accessIntent = (AccessIntent)list.get(i);
                boolean bl = accessIntent.getIntentType().getValue() == 0;
                EList eList = accessIntent.getMethodElements();
                for (int j = 0; j < eList.size(); ++j) {
                    int n2;
                    MethodElement methodElement = (MethodElement)eList.get(j);
                    if (methodElement.getEnterpriseBean() != enterpriseBean) continue;
                    String string = methodElement.getName().trim();
                    if (string.equals("*")) {
                        if (methodElement.isUnspecified()) {
                            for (n2 = 0; n2 < stringArray.length; ++n2) {
                                if (nArray[n2] > 1) continue;
                                blArray[n2] = bl;
                                nArray[n2] = 1;
                            }
                            continue;
                        }
                        if (methodElement.getType().getValue() != n) continue;
                        for (n2 = 0; n2 < stringArray.length; ++n2) {
                            if (nArray[n2] > 2) continue;
                            blArray[n2] = bl;
                            nArray[n2] = 2;
                        }
                        continue;
                    }
                    if (!methodElement.isUnspecified() && methodElement.getType().getValue() != n) continue;
                    for (n2 = 0; n2 < stringArray.length; ++n2) {
                        if (!string.equals(stringArray[n2])) continue;
                        String string2 = methodElement.getParms();
                        if (string2 == null) {
                            if (nArray[n2] > 3) continue;
                            blArray[n2] = bl;
                            nArray[n2] = 3;
                            continue;
                        }
                        if (!(string2 = MethodAttribUtils.normalizeSignature(string2.trim())).equals(stringArray2[n2])) continue;
                        blArray[n2] = bl;
                        nArray[n2] = 4;
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getReadOnlyAttributes");
        }
    }

    public static final void checkTxAttrs(TransactionAttribute[] transactionAttributeArray, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, TransactionAttribute transactionAttribute) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "checkTxAttrs");
        }
        block0: for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray3.length; ++j) {
                if (!((stringArray[i].equals(stringArray3[j]) && stringArray2[i].equals(stringArray4[j])) | stringArray3[j].equals("*"))) continue;
                transactionAttributeArray[i] = transactionAttribute;
                continue block0;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "checkTxAttrs");
        }
    }

    public static final void chkBMT(List list, EnterpriseBean enterpriseBean, J2EEName j2EEName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "chkBMT");
        }
        if (list != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "tranAttrList non-null");
            }
            for (int i = 0; i < list.size(); ++i) {
                MethodTransaction methodTransaction = (MethodTransaction)list.get(i);
                int n = methodTransaction.getTransactionAttribute().getValue();
                EList eList = methodTransaction.getMethodElements();
                for (int j = 0; j < eList.size(); ++j) {
                    MethodElement methodElement = (MethodElement)eList.get(j);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "MethodElement EnterpriseBean name:", methodElement.getEnterpriseBean());
                        Tr.debug(tc, "MethodElement method name:", methodElement.getName());
                        Tr.debug(tc, "MethodElement method parms:", methodElement.getParms());
                        if (methodElement.isUnspecified()) {
                            Tr.debug(tc, "Interface type unspecified");
                        } else {
                            Tr.debug(tc, "Interface type specified");
                            Tr.debug(tc, "Interface type:", new Integer(methodElement.getType().getValue()));
                        }
                    }
                    if (methodElement.getEnterpriseBean() != enterpriseBean) continue;
                    Tr.warning(tc, "BMT_DEFINES_CMT_ATTRIBUTES_CNTR0067W", new Object[]{j2EEName});
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "chkBMT");
        }
    }

    public static final void chkBMAS(List list, EnterpriseBean enterpriseBean, J2EEName j2EEName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "chkBMAS");
        }
        if (list != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "asAttrList non-null");
            }
            for (int i = 0; i < list.size(); ++i) {
                ActivitySessionMethod activitySessionMethod = (ActivitySessionMethod)list.get(i);
                ActivitySessionAttribute activitySessionAttribute = activitySessionMethod.getActivitySessionAttribute();
                List list2 = activitySessionMethod.getMethodElements();
                for (int j = 0; j < list2.size(); ++j) {
                    MethodElement methodElement = (MethodElement)list2.get(j);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "MethodElement EnterpriseBean name:", methodElement.getEnterpriseBean());
                        Tr.debug(tc, "MethodElement method name:", methodElement.getName());
                        Tr.debug(tc, "MethodElement method parms:", methodElement.getParms());
                        if (methodElement.isUnspecified()) {
                            Tr.debug(tc, "Interface type unspecified");
                        } else {
                            Tr.debug(tc, "Interface type specified");
                            Tr.debug(tc, "Interface type:", new Integer(methodElement.getType().getValue()));
                        }
                    }
                    if (methodElement.getEnterpriseBean() != enterpriseBean) continue;
                    Tr.warning(tc, "BMAS_DEFINES_CMAS_ATTRIBUTES_CNTR0068W", new Object[]{j2EEName});
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "chkBMAS");
        }
    }

    public static final String normalizeSignature(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            if (stringBuffer.charAt(n) == ' ') {
                char c = stringBuffer.charAt(n + 1);
                if (c == ' ' | c == '[' | c == ']') {
                    stringBuffer.deleteCharAt(n);
                    continue;
                }
                ++n;
                continue;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static final String methodSignature(MethodElement methodElement) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "methodSignature", methodElement.getName());
        }
        String string = methodElement.getName() + METHOD_ARGLIST_SEP + methodElement.getParms();
        string = string.trim();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "methodSignature", string);
        }
        return string;
    }

    public static final String methodSignature(Method method2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "methodSignature", method2.getName());
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(method2.getName());
        stringBuffer.append(METHOD_ARGLIST_SEP);
        Class<?>[] classArray = method2.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(",");
            }
            if (classArray[i].isArray()) {
                stringBuffer.append(MethodAttribUtils.convertArraySignature(classArray[i].getName()));
                continue;
            }
            stringBuffer.append(classArray[i].getName());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "methodSignature", stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public static final String convertArraySignature(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (string.charAt(n) == '[') {
            ++n;
        }
        switch (string.charAt(n)) {
            case 'B': {
                stringBuffer.append("byte[]");
                break;
            }
            case 'C': {
                stringBuffer.append("char[]");
                break;
            }
            case 'D': {
                stringBuffer.append("double[]");
                break;
            }
            case 'F': {
                stringBuffer.append("float[]");
                break;
            }
            case 'I': {
                stringBuffer.append("int[]");
                break;
            }
            case 'J': {
                stringBuffer.append("long[]");
                break;
            }
            case 'L': {
                stringBuffer.append(string.substring(n + 1, string.length() - 1));
                stringBuffer.append("[]");
                break;
            }
            case 'S': {
                stringBuffer.append("short[]");
                break;
            }
            case 'Z': {
                stringBuffer.append("boolean[]");
            }
        }
        while (--n > 0) {
            stringBuffer.append("[]");
        }
        return stringBuffer.toString();
    }

    public static final String methodSignatureOnly(Method method2) {
        StringBuffer stringBuffer = new StringBuffer();
        Class<?>[] classArray = method2.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(" ");
            }
            if (classArray[i].isArray()) {
                stringBuffer.append(MethodAttribUtils.convertArraySignature(classArray[i].getName()));
                continue;
            }
            stringBuffer.append(classArray[i].getName());
        }
        return stringBuffer.toString();
    }

    public static final String mapTypeToJDIEncoding(Class clazz) {
        String string = clazz.getName();
        String string2 = clazz.isArray() ? string.replace('.', '/') : (string.indexOf(46) > 0 ? "L" + string.replace('.', '/') + ";" : (string.equals("void") ? "V" : (string.equals("boolean") ? "Z" : (string.equals("int") ? "I" : (string.equals("long") ? "J" : (string.equals("double") ? "D" : (string.equals("float") ? "F" : (string.equals("char") ? "C" : (string.equals("byte") ? "B" : (string.equals("short") ? "S" : "L" + string + ";"))))))))));
        return string2;
    }

    public static final String jdiMethodSignature(Method method2) {
        StringBuffer stringBuffer = new StringBuffer();
        Class<?>[] classArray = method2.getParameterTypes();
        stringBuffer.append("(");
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(MethodAttribUtils.mapTypeToJDIEncoding(classArray[i]));
        }
        stringBuffer.append(")");
        stringBuffer.append(MethodAttribUtils.mapTypeToJDIEncoding(method2.getReturnType()));
        return stringBuffer.toString();
    }

    public static final boolean methodsEqual(Method method2, Method method3) {
        Class<?>[] classArray;
        if (method2 == null || method3 == null) {
            return false;
        }
        if (!method2.getName().equals(method3.getName())) {
            return false;
        }
        Class<?>[] classArray2 = method2.getParameterTypes();
        if (classArray2.length != (classArray = method3.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < classArray2.length; ++i) {
            if (classArray2[i].equals(classArray[i])) continue;
            return false;
        }
        return true;
    }

    public static final boolean homeMethodEquals(Method method2, Properties properties) {
        String[] stringArray;
        String string;
        if (method2 == null || properties == null) {
            return false;
        }
        String string2 = method2.getName();
        if (!string2.equals(string = (String)properties.get("Name"))) {
            return false;
        }
        Class<?>[] classArray = method2.getParameterTypes();
        if (classArray.length != (stringArray = (String[])properties.get("ArgumentTypes")).length) {
            return false;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i].getName().equals(stringArray[i])) continue;
            return false;
        }
        return true;
    }

    public static final String getIsolationLevelString(int n) {
        if (n >= 0 && n < ISOLATION_STR.length) {
            return ISOLATION_STR[n];
        }
        return "-- ILLEGAL ISOLATION LEVEL --";
    }

    private static final void populateIsoStringMap() {
        ISOLATION_STR = new String[9];
        for (int i = 0; i < ISOLATION_STR.length; ++i) {
            MethodAttribUtils.ISOLATION_STR[i] = "-- ILLEGAL ISOLATION LEVEL --";
        }
        MethodAttribUtils.ISOLATION_STR[1] = "TRANSACTION_READ_UNCOMMITTED";
        MethodAttribUtils.ISOLATION_STR[2] = "TRANSACTION_READ_COMMITTED";
        MethodAttribUtils.ISOLATION_STR[4] = "TRANSACTION_REPEATABLE_READ";
        MethodAttribUtils.ISOLATION_STR[8] = "TRANSACTION_SERIALIZABLE";
        MethodAttribUtils.ISOLATION_STR[0] = "TRANSACTION_NONE";
    }

    private static final void populateTxMofMap() {
        txMOFMap = new TransactionAttribute[7];
        MethodAttribUtils.txMOFMap[0] = TransactionAttribute.TX_NOT_SUPPORTED;
        MethodAttribUtils.txMOFMap[1] = TransactionAttribute.TX_SUPPORTS;
        MethodAttribUtils.txMOFMap[2] = TransactionAttribute.TX_REQUIRED;
        MethodAttribUtils.txMOFMap[3] = TransactionAttribute.TX_REQUIRES_NEW;
        MethodAttribUtils.txMOFMap[4] = TransactionAttribute.TX_MANDATORY;
        MethodAttribUtils.txMOFMap[5] = TransactionAttribute.TX_NEVER;
    }

    private static final void populateIsoLevelMOFMap() {
        isoLevelMOFMap = new int[5];
        MethodAttribUtils.isoLevelMOFMap[2] = 1;
        MethodAttribUtils.isoLevelMOFMap[1] = 2;
        MethodAttribUtils.isoLevelMOFMap[0] = 4;
        MethodAttribUtils.isoLevelMOFMap[3] = 8;
    }

    static {
        MethodAttribUtils.populateTxMofMap();
        MethodAttribUtils.populateIsoLevelMOFMap();
        MethodAttribUtils.populateIsoStringMap();
        TX_ATTR_STR = new String[]{"TX_NOT_SUPPORTED", "TX_BEAN_MANAGED", "TX_REQUIRED", "TX_SUPPORTS", "TX_REQUIRES_NEW", "TX_MANDATORY", "TX_NEVER"};
        txAttrMap = new TransactionAttribute[]{TransactionAttribute.TX_NOT_SUPPORTED, TransactionAttribute.TX_BEAN_MANAGED, TransactionAttribute.TX_REQUIRED, TransactionAttribute.TX_SUPPORTS, TransactionAttribute.TX_REQUIRES_NEW, TransactionAttribute.TX_MANDATORY, TransactionAttribute.TX_NEVER};
    }
}

