/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.csi;

import com.ibm.ejs.container.ContainerProperties;
import com.ibm.ejs.csi.EJBModuleMetaDataImpl;
import com.ibm.ejs.csi.TransactionControlImpl;
import com.ibm.ejs.csi.TxCookieImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.CSITransactionRequiredException;
import com.ibm.websphere.csi.CSITransactionRolledbackException;
import com.ibm.websphere.csi.EJBComponentMetaData;
import com.ibm.websphere.csi.EJBKey;
import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.websphere.csi.ExceptionType;
import com.ibm.websphere.csi.LocalTranConfigData;
import com.ibm.websphere.csi.MethodInterface;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.LocalTransaction.LocalTransactionCurrent;
import com.ibm.ws.LocalTransaction.RolledbackException;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.WebSphereTransactionManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.traceinfo.ejbcontainer.TETxLifeCycleInfo;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

abstract class TranStrategy {
    protected static TraceComponent tc = Tr.register(TranStrategy.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.csi.TranStrategy";
    protected TransactionControlImpl txCtrl;
    protected LocalTransactionCurrent ltcCurrent;
    private WebSphereTransactionManager txManager = TransactionManagerFactory.getTransactionManager();

    protected TranStrategy(TransactionControlImpl transactionControlImpl) {
        this.txCtrl = transactionControlImpl;
        this.ltcCurrent = TransactionManagerFactory.getLocalTransactionCurrent();
    }

    abstract TxCookieImpl preInvoke(EJBKey var1, EJBMethodInfo var2) throws CSIException;

    void postInvoke(EJBKey eJBKey, TxCookieImpl txCookieImpl, EJBMethodInfo eJBMethodInfo) throws CSIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "postInvoke");
        }
        if (txCookieImpl.beginner) {
            if (this.txCtrl.getRollbackOnly()) {
                this.rollback(true, eJBKey, eJBMethodInfo);
                MethodInterface methodInterface = eJBMethodInfo.getInterfaceType();
                EJBModuleMetaDataImpl eJBModuleMetaDataImpl = (EJBModuleMetaDataImpl)eJBMethodInfo.getEJBComponentMetaData().getModuleMetaData();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "EJBModuleMetaDataImpl.ivUseExtendedSetRollbackOnlyBehavior = " + eJBModuleMetaDataImpl.ivUseExtendedSetRollbackOnlyBehavior);
                }
                if (!eJBModuleMetaDataImpl.ivUseExtendedSetRollbackOnlyBehavior || methodInterface == MethodInterface.MESSAGE_LISTENER || methodInterface == MethodInterface.TIMED_OBJECT) {
                    throw new CSITransactionRolledbackException("Transaction marked rollbackonly");
                }
            } else {
                this.commit(eJBKey, eJBMethodInfo);
            }
        } else {
            this.txCtrl.completeTxTimeout();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "postInvoke");
        }
    }

    void handleException(EJBKey eJBKey, TxCookieImpl txCookieImpl, ExceptionType exceptionType, EJBMethodInfo eJBMethodInfo) throws CSIException {
        if (exceptionType == ExceptionType.CHECKED_EXCEPTION) {
            this.postInvoke(eJBKey, txCookieImpl, eJBMethodInfo);
            return;
        }
        if (txCookieImpl.beginner) {
            this.rollback(true, eJBKey, eJBMethodInfo);
            return;
        }
        if (this.globalTxExists(false)) {
            this.txCtrl.completeTxTimeout();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "handleException: marking client transaction rollbackOnly");
            }
            this.rollback(false, eJBKey, eJBMethodInfo);
            throw new CSITransactionRolledbackException();
        }
    }

    final void beginLocalTx(EJBKey eJBKey, EJBMethodInfo eJBMethodInfo) throws CSIException {
        LocalTransactionCoordinator localTransactionCoordinator;
        int n = ((EJBComponentMetaData)eJBMethodInfo.getComponentMetaData()).getEJBComponentType();
        LocalTranConfigData localTranConfigData = ((EJBComponentMetaData)eJBMethodInfo.getComponentMetaData()).getLocalTranConfigData();
        boolean bl = localTranConfigData.getValueBoundary() == 1;
        boolean bl2 = false;
        if (bl && (n == 3 || n == 4 || n == 5) && (localTransactionCoordinator = (LocalTransactionCoordinator)this.txCtrl.stickyLocalTxTable.remove(eJBKey)) != null) {
            bl2 = true;
            try {
                this.resumeLocalTx(localTransactionCoordinator);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ejs.csi.TranStrategy.beginLocalTx", "200", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Local tx resume failed", throwable);
                }
                throw new CSIException("Resume local tx failed", throwable);
            }
        }
        if (!bl2) {
            try {
                boolean bl3 = localTranConfigData.getValueUnresolvedAction() == 1;
                boolean bl4 = localTranConfigData.getValueResolver() == 1;
                this.ltcCurrent.begin(bl, bl3, bl4);
                LocalTransactionCoordinator localTransactionCoordinator2 = null;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled() || TETxLifeCycleInfo.isTraceEnabled()) {
                    localTransactionCoordinator2 = this.txCtrl.getLocalCoord();
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    if (localTransactionCoordinator2 != null) {
                        Tr.event(tc, "Began LTC cntxt: tid=" + Integer.toHexString(localTransactionCoordinator2.hashCode()) + "(LTC)");
                    } else {
                        Tr.event(tc, "Began LTC cntxt: null Coordinator!");
                    }
                }
                if (localTransactionCoordinator2 != null && TETxLifeCycleInfo.isTraceEnabled()) {
                    TETxLifeCycleInfo.traceLocalTxBegin("" + System.identityHashCode(localTransactionCoordinator2), "Begin Local Tx");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.csi.TranStrategy.beginLocalTx", "217", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Begin local tx failed", exception);
                }
                throw new CSIException("Begin local tx failed", (Throwable)exception);
            }
        }
    }

    final void suspendLocalTx(LocalTransactionCoordinator localTransactionCoordinator) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            if (localTransactionCoordinator != null) {
                Tr.event(tc, "Suspending LTC cntxt: tid=" + Integer.toHexString(localTransactionCoordinator.hashCode()) + "(LTC)");
            } else {
                Tr.event(tc, "Suspending LTC cntxt: null Coordinator!");
            }
        }
        this.ltcCurrent.suspend();
        if (localTransactionCoordinator != null && TETxLifeCycleInfo.isTraceEnabled()) {
            TETxLifeCycleInfo.traceLocalTxSuspend("" + System.identityHashCode(localTransactionCoordinator), "Suspend Local Tx");
        }
    }

    final void resumeLocalTx(LocalTransactionCoordinator localTransactionCoordinator) throws IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            if (localTransactionCoordinator != null) {
                Tr.event(tc, "Resuming LTC cntxt: tid=" + Integer.toHexString(localTransactionCoordinator.hashCode()) + "(LTC)");
            } else {
                Tr.event(tc, "Resuming LTC cntxt: null Coordinator!");
            }
        }
        this.ltcCurrent.resume(localTransactionCoordinator);
        if (localTransactionCoordinator != null && TETxLifeCycleInfo.isTraceEnabled()) {
            TETxLifeCycleInfo.traceLocalTxResume("" + System.identityHashCode(localTransactionCoordinator), "Resume Local Tx");
        }
    }

    final boolean globalTxExists(boolean bl) throws CSIException {
        Transaction transaction;
        block4: {
            transaction = null;
            try {
                transaction = this.txManager.getTransaction();
            }
            catch (SystemException systemException) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                Tr.event(tc, "Could not determine if there is a global tx active");
            }
        }
        if (bl && transaction != null && ((UOWCoordinator)transaction).getTxType() == 2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Cannot proceed under a non-interoperable transaction context");
            }
            throw new CSITransactionRequiredException("Interoperable global transaction required");
        }
        return transaction != null;
    }

    final void beginGlobalTx(EJBKey eJBKey, EJBMethodInfo eJBMethodInfo) throws CSIException {
        try {
            this.txCtrl.txService.begin();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Began TX cntxt: " + this.txCtrl.txService.getTransaction());
            }
            if (TETxLifeCycleInfo.isTraceEnabled()) {
                int n;
                String string = this.txCtrl.txService.getTransaction().toString();
                string = string != null ? ((n = string.indexOf("(")) != -1 ? string.substring(n + 1, string.indexOf(")")) : ((n = string.indexOf("tid=")) != -1 ? string.substring(n + 4) : string)) : "NoTx";
                TETxLifeCycleInfo.traceGlobalTxBegin(string, "Begin Global Tx");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.csi.TranStrategy.beginGlobalTx", "243", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Begin global tx failed", exception);
            }
            throw new CSIException("Begin global tx failed", (Throwable)exception);
        }
    }

    final Transaction suspendGlobalTx(int n) throws CSIException {
        Transaction transaction = this.txCtrl.suspendGlobalTx(n);
        if (TETxLifeCycleInfo.isTraceEnabled()) {
            TETxLifeCycleInfo.traceGlobalTxSuspend("NoTx", "Suspend Global Tx");
        }
        return transaction;
    }

    final void resumeGlobalTx(Transaction transaction, int n) throws CSIException {
        try {
            this.txCtrl.resumeGlobalTx(transaction, n);
            if (TETxLifeCycleInfo.isTraceEnabled()) {
                int n2;
                String string = this.txCtrl.txService.getTransaction().toString();
                string = string != null ? ((n2 = string.indexOf("(")) != -1 ? string.substring(n2 + 1, string.indexOf(")")) : ((n2 = string.indexOf("tid=")) != -1 ? string.substring(n2 + 4) : string)) : "NoTx";
                TETxLifeCycleInfo.traceGlobalTxResume(string, "Resume Global Tx");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.csi.TranStrategy.resumeGlobalTx", "335", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Global tx resume failed", exception);
            }
            throw new CSIException("", (Throwable)exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void commit(EJBKey eJBKey, EJBMethodInfo eJBMethodInfo) throws CSITransactionRolledbackException {
        LocalTransactionCoordinator localTransactionCoordinator = this.ltcCurrent.getLocalTranCoord();
        if (localTransactionCoordinator != null) {
            int n = ((EJBComponentMetaData)eJBMethodInfo.getComponentMetaData()).getEJBComponentType();
            if (localTransactionCoordinator.isASScoped()) {
                if (eJBMethodInfo.isHome() || n == 6) return;
                this.suspendLocalTx(localTransactionCoordinator);
                if (n == 2 || eJBMethodInfo.getMethodName().equalsIgnoreCase("remove")) return;
                this.txCtrl.stickyLocalTxTable.put(eJBKey, localTransactionCoordinator);
                return;
            } else {
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Completing LTC cntxt: tid=" + Integer.toHexString(localTransactionCoordinator.hashCode()) + "(LTC)");
                    }
                    localTransactionCoordinator.end(0);
                    if (localTransactionCoordinator == null || !TETxLifeCycleInfo.isTraceEnabled()) return;
                    TETxLifeCycleInfo.traceLocalTxCommit("" + System.identityHashCode(localTransactionCoordinator), "Commit Local Tx - end");
                    return;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.csi.TranStrategy.commit", "277", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Local tx completion failed", exception);
                    }
                    if (!ContainerProperties.IncludeNestedExceptionsExtended) throw new CSITransactionRolledbackException("");
                    throw new CSITransactionRolledbackException("", (Throwable)exception);
                }
            }
        }
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Committing TX cntxt: " + this.txCtrl.txService.getTransaction());
            }
            this.txCtrl.txService.commit();
            if (!TETxLifeCycleInfo.isTraceEnabled()) return;
            TETxLifeCycleInfo.traceGlobalTxCommit("NoTx", "Commit Global Tx");
            return;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.csi.TranStrategy.commit", "294", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Global tx commit failed", exception);
            }
            if (!ContainerProperties.IncludeNestedExceptionsExtended) throw new CSITransactionRolledbackException("");
            throw new CSITransactionRolledbackException("", (Throwable)exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void rollback(boolean bl, EJBKey eJBKey, EJBMethodInfo eJBMethodInfo) throws CSIException {
        LocalTransactionCoordinator localTransactionCoordinator = this.ltcCurrent.getLocalTranCoord();
        if (localTransactionCoordinator != null) {
            int n = ((EJBComponentMetaData)eJBMethodInfo.getComponentMetaData()).getEJBComponentType();
            if (localTransactionCoordinator.isASScoped()) {
                if (eJBMethodInfo.isHome() || n == 6) return;
                localTransactionCoordinator.setRollbackOnly();
                this.suspendLocalTx(localTransactionCoordinator);
                if (n == 2 || eJBMethodInfo.getMethodName().equalsIgnoreCase("remove")) return;
                this.txCtrl.stickyLocalTxTable.put(eJBKey, localTransactionCoordinator);
                return;
            } else {
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Completing LTC cntxt with rollback due to bean exception: tid=" + Integer.toHexString(localTransactionCoordinator.hashCode()) + "(LTC)");
                    }
                    localTransactionCoordinator.setRollbackOnly();
                    localTransactionCoordinator.end(1);
                    if (localTransactionCoordinator == null || !TETxLifeCycleInfo.isTraceEnabled()) return;
                    TETxLifeCycleInfo.traceLocalTxRollback("" + System.identityHashCode(localTransactionCoordinator), "Rollback Local Tx - end");
                    return;
                }
                catch (RolledbackException rolledbackException) {
                    FFDCFilter.processException((Throwable)rolledbackException, "com.ibm.ejs.csi.TranStrategy.rollback", "375", this);
                    return;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.csi.TranStrategy.rollback", "378", this);
                    String string = "Could not complete local tx";
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) throw new CSIException(string, (Throwable)exception);
                    Tr.event(tc, string, exception);
                    throw new CSIException(string, (Throwable)exception);
                }
            }
        }
        try {
            if (bl) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Rolling back TX cntxt due to bean exception: " + this.txCtrl.txService.getTransaction());
                }
                this.txCtrl.txService.rollback();
                if (!TETxLifeCycleInfo.isTraceEnabled()) return;
                TETxLifeCycleInfo.traceGlobalTxRollback("NoTx", "Rollback Global Tx");
                return;
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Marking TX cntxt for rollback due to bean exception: " + this.txCtrl.txService.getTransaction());
                }
                this.txCtrl.txService.setRollbackOnly();
            }
            return;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.csi.TranStrategy.rollback", "405", this);
            String string = "Could not roll back global tx";
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) throw new CSIException(string, (Throwable)exception);
            Tr.event(tc, string, exception);
            throw new CSIException(string, (Throwable)exception);
        }
    }

    boolean isBmtActive() {
        return false;
    }
}

