/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.csi;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.ContainerProperties;
import com.ibm.ejs.csi.BeanManaged;
import com.ibm.ejs.csi.Mandatory;
import com.ibm.ejs.csi.Never;
import com.ibm.ejs.csi.NotSupported;
import com.ibm.ejs.csi.Required;
import com.ibm.ejs.csi.RequiresNew;
import com.ibm.ejs.csi.Supports;
import com.ibm.ejs.csi.TranStrategy;
import com.ibm.ejs.csi.TxCookieImpl;
import com.ibm.ejs.csi.UOWHandleImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.FastHashtable;
import com.ibm.ejs.util.tran.SyncDriver;
import com.ibm.ejs.util.tran.SyncDriverCreationFailure;
import com.ibm.ejs.util.tran.SyncDriverFactory;
import com.ibm.websphere.csi.CSIActivitySessionResetException;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.CSITransactionRolledbackException;
import com.ibm.websphere.csi.EJBComponentMetaData;
import com.ibm.websphere.csi.EJBKey;
import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.websphere.csi.ExceptionType;
import com.ibm.websphere.csi.TransactionAttribute;
import com.ibm.websphere.csi.TxContextChange;
import com.ibm.websphere.csi.UOWControl;
import com.ibm.websphere.csi.UOWCookie;
import com.ibm.websphere.csi.UOWHandle;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.LocalTransaction.LocalTransactionCurrent;
import com.ibm.ws.LocalTransaction.RolledbackException;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.Transaction.UtxFactory;
import com.ibm.ws.Transaction.WebSphereTransactionManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.traceinfo.ejbcontainer.TETxLifeCycleInfo;
import javax.transaction.InvalidTransactionException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionRolledbackException;
import javax.transaction.UserTransaction;

public class TransactionControlImpl
implements UOWControl {
    private static final TraceComponent tc = Tr.register(TransactionControlImpl.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.csi.TransactionControlImpl";
    public static final int DEFAULT_TRAN_TIMEOUT = 120;
    public static final int DEFAULT_INACTIVITY_TIMEOUT = 60000;
    protected WebSphereTransactionManager txService;
    protected UOWCurrent uowCurrent;
    protected LocalTransactionCurrent ltcCurrent;
    private int inactivityTimeout;
    protected int txLifetime;
    private TranStrategy[] txStrategies;
    private UserTransaction userTransactionImpl;
    protected SyncDriverFactory sdFactory;
    FastHashtable stickyLocalTxTable = new FastHashtable(251);
    static final int TIMEOUT_CLOCK_START = 0;
    static final int TIMEOUT_CLOCK_STOP = 2;

    public TransactionControlImpl(WebSphereTransactionManager webSphereTransactionManager, SyncDriverFactory syncDriverFactory, int n, int n2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{webSphereTransactionManager, "txLifeTime = " + n, "inactivityTimeout = " + n2});
        }
        this.txService = webSphereTransactionManager;
        this.sdFactory = syncDriverFactory;
        this.txLifetime = n;
        this.inactivityTimeout = n2;
        this.ltcCurrent = TransactionManagerFactory.getLocalTransactionCurrent();
        this.uowCurrent = TransactionManagerFactory.getUOWCurrent();
        this.userTransactionImpl = UtxFactory.createUserTransaction();
        this.txStrategies = new TranStrategy[TransactionAttribute.getNumAttrs()];
        this.txStrategies[TransactionAttribute.TX_NOT_SUPPORTED.getValue()] = new NotSupported(this);
        this.txStrategies[TransactionAttribute.TX_BEAN_MANAGED.getValue()] = new BeanManaged(this);
        this.txStrategies[TransactionAttribute.TX_REQUIRED.getValue()] = new Required(this);
        this.txStrategies[TransactionAttribute.TX_SUPPORTS.getValue()] = new Supports(this);
        this.txStrategies[TransactionAttribute.TX_REQUIRES_NEW.getValue()] = new RequiresNew(this);
        this.txStrategies[TransactionAttribute.TX_MANDATORY.getValue()] = new Mandatory(this);
        this.txStrategies[TransactionAttribute.TX_NEVER.getValue()] = new Never(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public UOWCookie preInvoke(EJBKey eJBKey, EJBMethodInfo eJBMethodInfo) throws CSIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "preInvoke");
        }
        this.completeTxTimeout();
        TranStrategy tranStrategy = this.txStrategies[eJBMethodInfo.getTransactionAttribute().getValue()];
        LocalTransactionCoordinator localTransactionCoordinator = this.suspendLocalTx();
        TxCookieImpl txCookieImpl = null;
        try {
            txCookieImpl = tranStrategy.preInvoke(eJBKey, eJBMethodInfo);
        }
        catch (Throwable throwable) {
            block23: {
                FFDCFilter.processException(throwable, "com.ibm.ejs.csi.TransactionControlImpl.preInvoke", "266", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Tran Strategy preInvoke failed", throwable);
                }
                if (localTransactionCoordinator != null) {
                    try {
                        this.resumeLocalTx(localTransactionCoordinator);
                    }
                    catch (Throwable throwable2) {
                        FFDCFilter.processException(throwable2, "com.ibm.ejs.csi.TransactionControlImpl.preInvoke", "280", this);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block23;
                        Tr.event(tc, "Local tx resume failed", throwable2);
                    }
                }
            }
            if (throwable instanceof CSIException) {
                throw (CSIException)throwable;
            }
            throw new CSIException("Tran Strategy preInvoke failed", throwable);
        }
        if (localTransactionCoordinator != null) {
            txCookieImpl.suspendedLocalTx = localTransactionCoordinator;
        }
        txCookieImpl.methodInfo = eJBMethodInfo;
        try {
            txCookieImpl.ivCoordinator = this.getCurrentTransactionalUOW(false);
        }
        catch (Throwable throwable) {
            block24: {
                FFDCFilter.processException(throwable, "com.ibm.ejs.csi.TransactionControlImpl.preInvoke", "266", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "getCurrentTransactionalUOW failed", throwable);
                }
                boolean bl = false;
                if (throwable instanceof CSITransactionRolledbackException && eJBMethodInfo.getTransactionAttribute() == TransactionAttribute.TX_BEAN_MANAGED) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "BMT - allowing method to proceed");
                    }
                    try {
                        txCookieImpl.ivCoordinator = this.getCurrentTransactionalUOW(false);
                    }
                    catch (Throwable throwable3) {
                        FFDCFilter.processException(throwable, "com.ibm.ejs.csi.TransactionControlImpl.preInvoke", "386", this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event(tc, "BMT - failed trying to get Tran BMT bean in invalid state");
                        }
                        bl = true;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "preInvoke (RolledBack) using old stuff : " + txCookieImpl);
                    }
                    if (!bl) {
                        return txCookieImpl;
                    }
                }
                try {
                    this.postInvoke(eJBKey, txCookieImpl, ExceptionType.UNCHECKED_EXCEPTION, eJBMethodInfo);
                }
                catch (Throwable throwable4) {
                    FFDCFilter.processException(throwable4, "com.ibm.ejs.csi.TransactionControlImpl.preInvoke", "266", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block24;
                    Tr.event(tc, "postInvoke failed : original exception re-thrown", throwable4);
                }
            }
            if (throwable instanceof CSIException) {
                throw (CSIException)throwable;
            }
            throw new CSIException("getCurrentTransactionalUOW failed", throwable);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "preInvoke : " + txCookieImpl);
        }
        return txCookieImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postInvoke(EJBKey eJBKey, UOWCookie uOWCookie, ExceptionType exceptionType, EJBMethodInfo eJBMethodInfo) throws CSIException {
        TxCookieImpl txCookieImpl;
        block31: {
            LocalTransactionCoordinator localTransactionCoordinator;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "postInvoke");
            }
            if ((txCookieImpl = (TxCookieImpl)uOWCookie) == null) {
                block30: {
                    LocalTransactionCoordinator localTransactionCoordinator2 = this.getLocalCoord();
                    if (localTransactionCoordinator2 != null) {
                        block29: {
                            try {
                                int n = ((EJBComponentMetaData)eJBMethodInfo.getComponentMetaData()).getLocalTranConfigData().getValueResolver();
                                if (n == 1) {
                                    localTransactionCoordinator2.complete(1);
                                } else {
                                    localTransactionCoordinator2.setRollbackOnly();
                                    localTransactionCoordinator2.cleanup();
                                }
                            }
                            catch (RolledbackException rolledbackException) {
                                FFDCFilter.processException((Throwable)rolledbackException, "com.ibm.ejs.csi.TransactionControlImpl.postInvoke", "325", this);
                            }
                            catch (Throwable throwable) {
                                FFDCFilter.processException(throwable, "com.ibm.ejs.csi.TransactionControlImpl.postInvoke", "330", this);
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block29;
                                Tr.event(tc, "Failed to complete local transaction", throwable);
                            }
                        }
                        throw new CSIException("Aborted improperly started local transaction");
                    }
                    try {
                        this.setRollbackOnly();
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ejs.csi.TransactionControlImpl.postInvoke", "345", this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event(tc, "Failed to mark global transaction for rollback", throwable);
                        }
                        if (!ContainerProperties.IncludeNestedExceptionsExtended) break block30;
                        throw new CSITransactionRolledbackException("Rolled back improperly started global transaction", throwable);
                    }
                }
                throw new CSITransactionRolledbackException("Rolled back improperly started global transaction");
            }
            TranStrategy tranStrategy = txCookieImpl.txStrategy;
            try {
                if (exceptionType == ExceptionType.NO_EXCEPTION) {
                    tranStrategy.postInvoke(eJBKey, txCookieImpl, eJBMethodInfo);
                } else {
                    tranStrategy.handleException(eJBKey, txCookieImpl, exceptionType, eJBMethodInfo);
                }
                Object var9_12 = null;
                localTransactionCoordinator = txCookieImpl.suspendedLocalTx;
                if (localTransactionCoordinator == null) break block31;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                LocalTransactionCoordinator localTransactionCoordinator3 = txCookieImpl.suspendedLocalTx;
                if (localTransactionCoordinator3 != null) {
                    try {
                        this.resumeLocalTx(localTransactionCoordinator3);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.csi.TransactionControlImpl.postInvoke", "394", this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event(tc, "Local tx resume failed", exception);
                        }
                        throw new CSIException("Local tx resume failed", (Throwable)exception);
                    }
                }
                Transaction transaction = txCookieImpl.suspendedTx;
                if (transaction != null) {
                    try {
                        this.resumeGlobalTx(transaction, 0);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.csi.TransactionControlImpl.postInvoke", "414", this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event(tc, "Global tx resume failed", exception);
                        }
                        throw new CSIException("Global tx resume failed", (Throwable)exception);
                    }
                }
                throw throwable;
            }
            try {
                this.resumeLocalTx(localTransactionCoordinator);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.csi.TransactionControlImpl.postInvoke", "394", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Local tx resume failed", exception);
                }
                throw new CSIException("Local tx resume failed", (Throwable)exception);
            }
        }
        Transaction transaction = txCookieImpl.suspendedTx;
        if (transaction != null) {
            try {
                this.resumeGlobalTx(transaction, 0);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.csi.TransactionControlImpl.postInvoke", "414", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Global tx resume failed", exception);
                }
                throw new CSIException("Global tx resume failed", (Throwable)exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "postInvoke");
        }
    }

    public Object getCurrentTransactionalUOW(boolean bl) throws CSITransactionRolledbackException {
        UOWCoordinator uOWCoordinator = this.uowCurrent.getUOWCoord();
        if (uOWCoordinator != null && bl && uOWCoordinator.getRollbackOnly()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Attempting to do work on a tx that has been marked rollback.");
            }
            throw new CSITransactionRolledbackException("Transaction rolled back");
        }
        return uOWCoordinator;
    }

    public Object getCurrentSessionalUOW(boolean bl) throws CSIActivitySessionResetException {
        return null;
    }

    public UserTransaction getUserTransaction() {
        return this.userTransactionImpl;
    }

    public void setRollbackOnly() {
        LocalTransactionCoordinator localTransactionCoordinator;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setRollbackOnly", this);
        }
        if ((localTransactionCoordinator = this.getLocalCoord()) != null) {
            localTransactionCoordinator.setRollbackOnly();
        } else {
            try {
                this.txService.setRollbackOnly();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.csi.TransactionControlImpl.setRollbackOnly", "556", this);
                throw new IllegalStateException("No active transaction");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setRollbackOnly");
        }
    }

    public boolean getRollbackOnly() {
        LocalTransactionCoordinator localTransactionCoordinator = this.getLocalCoord();
        if (localTransactionCoordinator != null) {
            return localTransactionCoordinator.getRollbackOnly();
        }
        int n = 6;
        try {
            n = this.txService.getStatus();
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ejs.csi.TransactionControlImpl.getRollbackOnly", "667", this);
        }
        return n == 1 || n == 4 || n == 9;
    }

    public void enlistWithTransaction(Synchronization synchronization) throws CSIException {
        SyncDriver syncDriver = null;
        LocalTransactionCoordinator localTransactionCoordinator = this.getLocalCoord();
        if (localTransactionCoordinator != null) {
            try {
                syncDriver = this.sdFactory.create(localTransactionCoordinator);
            }
            catch (SyncDriverCreationFailure syncDriverCreationFailure) {
                FFDCFilter.processException((Throwable)syncDriverCreationFailure, "com.ibm.ejs.csi.TransactionControlImpl.enlist", "603", this);
                throw new CSIException("enlistment with local tx failed", (Throwable)syncDriverCreationFailure);
            }
        } else {
            Transaction transaction = this.getGlobalCoord();
            if (transaction != null) {
                try {
                    syncDriver = this.sdFactory.create(transaction);
                }
                catch (SyncDriverCreationFailure syncDriverCreationFailure) {
                    FFDCFilter.processException((Throwable)syncDriverCreationFailure, "com.ibm.ejs.csi.TransactionControlImpl.enlist", "616", this);
                    throw new CSIException("enlistment with global tx failed", (Throwable)syncDriverCreationFailure);
                }
            } else {
                throw new IllegalStateException("No active transaction");
            }
        }
        syncDriver.addParticipant(synchronization);
    }

    public void enlistWithTransaction(Object object, Synchronization synchronization) throws CSIException {
        SyncDriver syncDriver = null;
        if (object != null) {
            try {
                syncDriver = this.sdFactory.create((UOWCoordinator)object);
            }
            catch (SyncDriverCreationFailure syncDriverCreationFailure) {
                FFDCFilter.processException((Throwable)syncDriverCreationFailure, "com.ibm.ejs.csi.TransactionControlImpl.enlist", "745", this);
                throw new CSIException("enlistment with UOWCoord failed", (Throwable)syncDriverCreationFailure);
            }
        } else {
            throw new IllegalStateException("No active transaction");
        }
        syncDriver.addParticipant(synchronization);
    }

    public void enlistWithSession(Synchronization synchronization) throws CSIException {
        throw new CSIException("ActivitySession should not exist");
    }

    public void sessionEnded(EJBKey[] eJBKeyArray) throws CSIException {
        throw new CSIException("ActivitySession should not exist");
    }

    public TxContextChange setupLocalTxContext(EJBKey eJBKey) throws CSIException {
        LocalTransactionCoordinator localTransactionCoordinator = null;
        Transaction transaction = null;
        LocalTransactionCoordinator localTransactionCoordinator2 = null;
        BeanMetaData beanMetaData = ((BeanId)eJBKey).getHome().getBeanMetaData(eJBKey);
        int n = beanMetaData.getLocalTranConfigData().getValueBoundary();
        Transaction transaction2 = this.getGlobalCoord();
        if (transaction2 != null) {
            LocalTransactionCoordinator localTransactionCoordinator3;
            if (n == 1 && (localTransactionCoordinator3 = (LocalTransactionCoordinator)this.stickyLocalTxTable.remove(eJBKey)) != null) {
                try {
                    transaction = this.suspendGlobalTx(2);
                }
                catch (CSIException cSIException) {
                    FFDCFilter.processException((Throwable)cSIException, "com.ibm.ejs.csi.TransactionControlImpl.setupLocalTxContext", "937", this);
                    this.stickyLocalTxTable.put(eJBKey, localTransactionCoordinator3);
                    throw cSIException;
                }
                this.resumeLocalTx(localTransactionCoordinator3);
                localTransactionCoordinator2 = localTransactionCoordinator3;
            }
        } else {
            LocalTransactionCoordinator localTransactionCoordinator4 = this.getLocalCoord();
            LocalTransactionCoordinator localTransactionCoordinator5 = null;
            if (n == 1) {
                localTransactionCoordinator5 = (LocalTransactionCoordinator)this.stickyLocalTxTable.remove(eJBKey);
            }
            if (localTransactionCoordinator4 != null && localTransactionCoordinator5 != null) {
                this.suspendLocalTx();
                localTransactionCoordinator = localTransactionCoordinator4;
                this.resumeLocalTx(localTransactionCoordinator5);
                localTransactionCoordinator2 = localTransactionCoordinator5;
            } else if (localTransactionCoordinator4 == null && localTransactionCoordinator5 != null) {
                this.resumeLocalTx(localTransactionCoordinator5);
                localTransactionCoordinator2 = localTransactionCoordinator5;
            }
        }
        return new TxContextChange(localTransactionCoordinator, transaction, localTransactionCoordinator2, eJBKey);
    }

    public void teardownLocalTxContext(TxContextChange txContextChange) {
        block5: {
            LocalTransactionCoordinator localTransactionCoordinator = txContextChange.getActivatedLocalTx();
            if (localTransactionCoordinator != null) {
                Transaction transaction;
                this.suspendLocalTx();
                this.stickyLocalTxTable.put(txContextChange.getKey(), localTransactionCoordinator);
                LocalTransactionCoordinator localTransactionCoordinator2 = txContextChange.getSuspendedLocalTx();
                if (localTransactionCoordinator2 != null) {
                    this.resumeLocalTx(localTransactionCoordinator2);
                }
                if ((transaction = txContextChange.getSuspendedGlobalTx()) != null) {
                    try {
                        this.resumeGlobalTx(transaction, 0);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.csi.TransactionControlImpl.teardownLocalTxContext", "650", this);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block5;
                        Tr.event(tc, "Global tx resume failed", exception);
                    }
                }
            }
        }
    }

    public void setClientInactivityTimeout(int n) {
        this.inactivityTimeout = n * 1000;
    }

    public void setTotalTranLifetimeTimeout(int n) {
        this.txLifetime = n;
    }

    final LocalTransactionCoordinator beginLocalTx() {
        LocalTransactionCoordinator localTransactionCoordinator;
        block6: {
            localTransactionCoordinator = null;
            try {
                LocalTransactionCurrent localTransactionCurrent = TransactionManagerFactory.getLocalTransactionCurrent();
                localTransactionCurrent.begin();
                localTransactionCoordinator = this.getLocalCoord();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    if (localTransactionCoordinator != null) {
                        Tr.event(tc, "Began LTC cntxt: tid=" + Integer.toHexString(localTransactionCoordinator.hashCode()) + "(LTC)");
                    } else {
                        Tr.event(tc, "Began LTC cntxt: null Coordinator!");
                    }
                }
                if (localTransactionCoordinator != null && TETxLifeCycleInfo.isTraceEnabled()) {
                    TETxLifeCycleInfo.traceLocalTxBegin("" + System.identityHashCode(localTransactionCoordinator), "Begin Local Tx");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.csi.TransactionControlImpl.beginLocalTx", "737", this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block6;
                Tr.event(tc, "Begin local tx failed", exception);
            }
        }
        return localTransactionCoordinator;
    }

    final LocalTransactionCoordinator suspendLocalTx() {
        LocalTransactionCoordinator localTransactionCoordinator = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled() || TETxLifeCycleInfo.isTraceEnabled()) {
            localTransactionCoordinator = this.getLocalCoord();
        }
        if (localTransactionCoordinator != null && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Suspending LTC cntxt: tid=" + Integer.toHexString(localTransactionCoordinator.hashCode()) + "(LTC)");
        }
        LocalTransactionCoordinator localTransactionCoordinator2 = this.ltcCurrent.suspend();
        if (localTransactionCoordinator != null && TETxLifeCycleInfo.isTraceEnabled()) {
            TETxLifeCycleInfo.traceLocalTxSuspend("" + System.identityHashCode(localTransactionCoordinator), "Suspend Local Tx");
        }
        return localTransactionCoordinator2;
    }

    final Transaction suspendGlobalTx(int n) throws CSIException {
        int n2;
        Transaction transaction = null;
        try {
            transaction = this.txService.suspend();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Suspending TX cntxt: " + transaction);
            }
            if (TETxLifeCycleInfo.isTraceEnabled()) {
                int n3;
                String string = null;
                if (transaction != null) {
                    string = transaction.toString();
                }
                string = string != null ? ((n3 = string.indexOf("(")) != -1 ? string.substring(n3 + 1, string.indexOf(")")) : ((n3 = string.indexOf("tid=")) != -1 ? string.substring(n3 + 4) : string)) : "NoTx";
                TETxLifeCycleInfo.traceGlobalTxSuspend(string, "Suspend Global Tx");
            }
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ejs.csi.TransactionControlImpl.setRollbackOnly", "770", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Error suspending global tx", (Object)systemException);
            }
            throw new CSIException("suspend global tx failed", (Throwable)systemException);
        }
        if (transaction != null && (n2 = ((UOWCoordinator)transaction).getTxType()) == 2) {
            return transaction;
        }
        return transaction;
    }

    final void resumeLocalTx(LocalTransactionCoordinator localTransactionCoordinator) throws IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            if (localTransactionCoordinator != null) {
                Tr.event(tc, "Resuming LTC cntxt: tid=" + Integer.toHexString(localTransactionCoordinator.hashCode()) + "(LTC)");
            } else {
                Tr.event(tc, "Resuming LTC cntxt: null Coordinator!");
            }
        }
        this.ltcCurrent.resume(localTransactionCoordinator);
        if (localTransactionCoordinator != null && TETxLifeCycleInfo.isTraceEnabled()) {
            TETxLifeCycleInfo.traceLocalTxResume("" + System.identityHashCode(localTransactionCoordinator), "Resume Local Tx");
        }
    }

    final void resumeGlobalTx(Transaction transaction, int n) throws SystemException, InvalidTransactionException {
        try {
            this.txService.resume(transaction);
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ejs.csi.TransactionControlImpl.resumeGlobalTx", "814", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Error resuming global tx", (Object)systemException);
            }
            throw systemException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Resumed TX cntxt: " + this.txService.getTransaction());
        }
        if (TETxLifeCycleInfo.isTraceEnabled()) {
            int n2;
            String string = null;
            if (transaction != null) {
                string = transaction.toString();
            }
            string = string != null ? ((n2 = string.indexOf("(")) != -1 ? string.substring(n2 + 1, string.indexOf(")")) : ((n2 = string.indexOf("tid=")) != -1 ? string.substring(n2 + 4) : string)) : "NoTx";
            TETxLifeCycleInfo.traceGlobalTxResume(string, "Resume Global Tx");
        }
        if (((UOWCoordinator)transaction).getTxType() == 2) {
            return;
        }
    }

    final LocalTransactionCoordinator getLocalCoord() {
        return this.ltcCurrent.getLocalTranCoord();
    }

    final Transaction getGlobalCoord() {
        try {
            Transaction transaction = this.txService.getTransaction();
            return transaction;
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ejs.csi.TransactionControlImpl.getGlobalCoord", "856", this);
            Tr.warning(tc, "TRANSACTION_COORDINATOR_NOT_AVAILABLE_CNTR0022E", new Object[]{systemException});
            return null;
        }
    }

    public final void completeTxTimeout() throws CSITransactionRolledbackException {
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "completeTxTimeout");
            }
            this.txService.completeTxTimeout();
        }
        catch (TransactionRolledbackException transactionRolledbackException) {
            FFDCFilter.processException((Throwable)transactionRolledbackException, "com.ibm.ejs.csi.TransactionControlImpl.completeTxTimeout", "1390", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "completeTxTimeout throwing CSITransactionRolledBackException");
            }
            throw new CSITransactionRolledbackException("Transaction rolled back", (Throwable)transactionRolledbackException);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTxTimeout exit");
        }
    }

    public boolean isBmtActive(EJBMethodInfo eJBMethodInfo) {
        TranStrategy tranStrategy = this.txStrategies[eJBMethodInfo.getTransactionAttribute().getValue()];
        return tranStrategy.isBmtActive();
    }

    public boolean isBmasActive(EJBMethodInfo eJBMethodInfo) {
        return false;
    }

    public UOWHandle suspend() throws CSIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "suspend");
        }
        UOWHandleImpl uOWHandleImpl = null;
        if (this.getGlobalCoord() != null) {
            Transaction transaction = this.suspendGlobalTx(2);
            uOWHandleImpl = new UOWHandleImpl(transaction);
        } else if (this.getLocalCoord() != null) {
            LocalTransactionCoordinator localTransactionCoordinator = this.suspendLocalTx();
            uOWHandleImpl = new UOWHandleImpl(localTransactionCoordinator);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "suspend : " + uOWHandleImpl);
        }
        return uOWHandleImpl;
    }

    public void resume(UOWHandle uOWHandle) throws CSIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "resume : " + uOWHandle);
        }
        if (uOWHandle != null) {
            UOWHandleImpl uOWHandleImpl = (UOWHandleImpl)uOWHandle;
            try {
                if (uOWHandleImpl.suspendedLocalTx != null) {
                    this.resumeLocalTx(uOWHandleImpl.suspendedLocalTx);
                } else {
                    this.resumeGlobalTx(uOWHandleImpl.suspendedGlobalTx, 0);
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ejs.csi.TransactionControlImpl.resume", "1491", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "resume", "Error resuming tx in TransactionControlImpl: " + throwable);
                }
                throw new CSIException("Error resuming tx in TransactionControlImpl.", throwable);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "resume");
        }
    }
}

