/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.j2c.ConnectionHandleManager;
import com.ibm.ejs.j2c.ConnectionManager;
import com.ibm.ejs.j2c.HandleList;
import com.ibm.ejs.j2c.J2CUtilityClass;
import com.ibm.ejs.j2c.MCWrapper;
import com.ibm.ejs.j2c.PoolManager;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.j2c.InteractionMetrics;
import com.ibm.websphere.pmi.reqmetrics.PmiReqMetrics;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.j2c.TranWrapper;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ManagedConnection;

public final class ConnectionEventListener
implements com.ibm.websphere.j2c.ConnectionEventListener,
InteractionMetrics {
    private MCWrapper mcWrapper = null;
    private static final TraceComponent tc = Tr.register(ConnectionEventListener.class, "WAS.j2c", "com.ibm.ws.j2c.resources.J2CAMessages");
    private static TraceComponent tc3 = Tr.register("ConnCloseLogic", null, null);

    ConnectionEventListener() {
    }

    protected ConnectionEventListener(MCWrapper mCWrapper) {
        this.mcWrapper = mCWrapper;
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        Object object;
        Object object2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "connectionClosed");
        }
        if (tc3.isDebugEnabled()) {
            try {
                object2 = RasHelper.getThreadId();
                if (!this.mcWrapper.getThreadID().equals(object2)) {
                    Tr.debug(tc3, " WARNING !!! Multi threaded access to connection handle object detected !!!");
                    Tr.debug(tc3, "Handle Name: " + connectionEvent.getConnectionHandle() + "  Details: : " + this.mcWrapper + "  Connection Pool Name: " + this.mcWrapper.getPoolManager().getGConfigProps().pmiName);
                    Tr.debug(tc3, " Thread for allocation connection: " + this.mcWrapper.getThreadID());
                    Tr.debug(tc3, "Allocate connection Request Stack: ", this.mcWrapper.getInitialRequestStackTrace());
                    Tr.debug(tc3, " Thread for close connection: " + (String)object2);
                    object = new Throwable();
                    Tr.debug(tc3, "Connection Close Request Stack: ", object);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (connectionEvent.getId() == 1) {
            if (!this.mcWrapper.isParkedWrapper()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    object2 = null;
                    try {
                        object2 = (ManagedConnection)connectionEvent.getSource();
                    }
                    catch (ClassCastException classCastException) {
                        Tr.error(tc, "GET_SOURCE_CLASS_CAST_EXCP_J2CA0098", classCastException);
                        throw new IllegalStateException("ClassCastException occurred attempting to cast event.getSource to ManagedConnection");
                    }
                    Tr.debug(tc, "***Connection Close Request*** Handle Name: " + connectionEvent.getConnectionHandle() + "  Connection Pool: " + this.mcWrapper.getPoolManager().getGConfigProps().pmiName + "  Details: : " + this.mcWrapper);
                }
                object2 = this.mcWrapper.getConnectionManager();
                if (this.mcWrapper.gConfigProps.xComponentConnectionUseDetectionEnabled) {
                    this.checkForHandleUseViolation(connectionEvent.getConnectionHandle());
                }
                if (this.mcWrapper.gConfigProps.multiThreadedUseDetectionEnabled && ((ConnectionManager)object2).handleToThreadMap != null) {
                    object = connectionEvent.getConnectionHandle();
                    ((ConnectionManager)object2).handleToThreadMap.remove(object);
                }
                if (this.mcWrapper.gConfigProps.manageCachedHandles || !this.mcWrapper.gConfigProps.isSmartHandleSupport() || !((ConnectionManager)object2).shareable()) {
                    if (null == connectionEvent.getConnectionHandle()) {
                        Tr.warning(tc, "CONNECTION_CLOSED_NULL_HANDLE_J2CA0148", connectionEvent);
                    }
                    object = connectionEvent.getConnectionHandle();
                    HandleList handleList = this.mcWrapper.getHandleList(object);
                    ConnectionHandleManager.getConnectionHandleManager().removeHandle(connectionEvent, handleList);
                    this.mcWrapper.removeFromHandleList(object);
                }
                this.mcWrapper.decrementHandleCount();
                if (this.mcWrapper.getHandleCount() == 0) {
                    if (this.mcWrapper.getTranWrapperId() == 3) {
                        this.mcWrapper.transactionComplete();
                    }
                    if (!this.mcWrapper.involvedInTransaction()) {
                        try {
                            this.mcWrapper.releaseToPoolManager();
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.j2c.ConnectionEventListener.connectionClosed", "197", this);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "connectionClosed: Closing connection in pool " + this.mcWrapper.gConfigProps.pmiName + " caught exception, but will continue processing: ", exception);
                            }
                        }
                    } else if (this.mcWrapper.getPoolManager().efficiencyGroupEnabled && !this.mcWrapper.gConfigProps.isInteractionMetricsEnabled()) {
                        this.mcWrapper.useTimeStop();
                    }
                }
            }
        } else {
            this.processBadEvent("connectionClosed", 1, connectionEvent);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "connectionClosed");
        }
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        Object object;
        CharSequence charSequence;
        Throwable throwable;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "connectionErrorOccurred");
        }
        if (tc3.isDebugEnabled()) {
            throwable = new Throwable();
            Tr.debug(tc3, "Connection Error Request Stack: ", throwable);
        }
        this.checkForHandleUseViolation(connectionEvent.getConnectionHandle());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            throwable = null;
            try {
                throwable = (ManagedConnection)connectionEvent.getSource();
            }
            catch (ClassCastException classCastException) {
                Tr.error(tc, "GET_SOURCE_CLASS_CAST_EXCP_J2CA0098", classCastException);
                throw new IllegalStateException("ClassCastException occurred attempting to cast event.getSource to ManagedConnection");
            }
            charSequence = new StringBuffer("");
            object = connectionEvent.getConnectionHandle();
            ((StringBuffer)charSequence).append("***Connection Error*** Handle Name: " + (object == null ? "null" : object.toString()));
            if (this.mcWrapper != null) {
                PoolManager poolManager = this.mcWrapper.getPoolManager();
                ((StringBuffer)charSequence).append(", Connection Pool: " + (poolManager == null ? "null" : ((Object)poolManager).toString()) + ", Details: " + this.mcWrapper.toString());
            } else {
                ((StringBuffer)charSequence).append(", Details: null");
            }
            Tr.debug(tc, ((StringBuffer)charSequence).toString());
        }
        if (connectionEvent.getId() == 5) {
            throwable = connectionEvent.getException();
            charSequence = "";
            if (throwable != null) {
                charSequence = J2CUtilityClass.generateExceptionString(throwable);
                Tr.audit(tc, "RA_CONNECTION_ERROR_J2CA0056", new Object[]{charSequence, this.mcWrapper.gConfigProps.pmiName});
            } else {
                charSequence = "(none)";
                Tr.audit(tc, "RA_CONNECTION_ERROR_J2CA0056", new Object[]{charSequence, this.mcWrapper.gConfigProps.pmiName});
                object = "No exception was received from the Resource Adapter.  Information may be available in previous messages or exceptions.";
                Tr.audit(tc, "ENGLISH_ONLY_MESSAGE_J2CA0090", object);
            }
            this.mcWrapper.getPoolManager().processConnErrorEvent();
            this.mcWrapper.connectionErrorOccurred(connectionEvent);
        } else if (connectionEvent.getId() == 51) {
            throwable = connectionEvent.getException();
            charSequence = "";
            if (throwable != null) {
                charSequence = J2CUtilityClass.generateExceptionString(throwable);
                Tr.audit(tc, "RA_CONNECTION_ERROR_J2CA0056", new Object[]{charSequence, this.mcWrapper.gConfigProps.pmiName});
            } else {
                Tr.audit(tc, "NO_RA_EXCEPTION_J2CA0216", new Object[]{this.mcWrapper.gConfigProps.pmiName});
            }
            this.mcWrapper.getPoolManager().processConnErrorEvent();
            this.mcWrapper.connectionErrorOccurred(connectionEvent);
        } else {
            this.processBadEvent("connectionErrorOccurred", 5, connectionEvent);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "connectionErrorOccurred");
        }
    }

    public void localTransactionCommitted(ConnectionEvent connectionEvent) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "localTransactionCommitted");
        }
        this.checkForHandleUseViolation(connectionEvent.getConnectionHandle());
        if (connectionEvent.getId() == 3) {
            if (this.mcWrapper.involvedInTransaction()) {
                TranWrapper tranWrapper = null;
                try {
                    tranWrapper = this.mcWrapper.getCurrentTranWrapper();
                    tranWrapper.delist();
                }
                catch (ResourceException resourceException) {
                    FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.j2c.ConnectionEventListener.localTransactionCommitted", "316", "this");
                    Tr.error(tc, "DELIST_FAILED_J2CA0073", new Object[]{"localTransactionCommitted", resourceException, this.mcWrapper.gConfigProps.pmiName});
                    ManagedConnection managedConnection = null;
                    try {
                        managedConnection = (ManagedConnection)connectionEvent.getSource();
                    }
                    catch (ClassCastException classCastException) {
                        Tr.error(tc, "GET_SOURCE_CLASS_CAST_EXCP_J2CA0098", classCastException);
                        throw new IllegalStateException("ClassCastException occurred attempting to cast event.getSource to ManagedConnection");
                    }
                    ConnectionEvent connectionEvent2 = new ConnectionEvent(managedConnection, 5);
                    this.connectionErrorOccurred(connectionEvent2);
                    IllegalStateException illegalStateException = new IllegalStateException(resourceException.getMessage());
                    throw illegalStateException;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "localTransactionCommitted:  no transaction context, return without delisting.");
            }
            return;
        }
        this.processBadEvent("localTransactionCommitted", 3, connectionEvent);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "localTransactionCommitted");
        }
    }

    public void localTransactionRolledback(ConnectionEvent connectionEvent) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "localTransactionRolledback");
        }
        this.checkForHandleUseViolation(connectionEvent.getConnectionHandle());
        if (connectionEvent.getId() == 4) {
            if (this.mcWrapper.involvedInTransaction()) {
                try {
                    this.mcWrapper.getCurrentTranWrapper().delist();
                }
                catch (ResourceException resourceException) {
                    FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.j2c.ConnectionEventListener.localTransactionRolledback", "393", this);
                    Tr.error(tc, "DELIST_FAILED_J2CA0073", new Object[]{"localTransactionRolledback", resourceException, this.mcWrapper.gConfigProps.pmiName});
                    ManagedConnection managedConnection = null;
                    try {
                        managedConnection = (ManagedConnection)connectionEvent.getSource();
                    }
                    catch (ClassCastException classCastException) {
                        Tr.error(tc, "GET_SOURCE_CLASS_CAST_EXCP_J2CA0098", classCastException);
                        throw new IllegalStateException("ClassCastException occurred attempting to cast event.getSource to ManagedConnection");
                    }
                    ConnectionEvent connectionEvent2 = new ConnectionEvent(managedConnection, 5);
                    this.connectionErrorOccurred(connectionEvent2);
                    IllegalStateException illegalStateException = new IllegalStateException(resourceException.getMessage());
                    throw illegalStateException;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "localTransactionRolledback:  no transaction context, return without delisting.");
            }
            return;
        }
        this.processBadEvent("localTransactionRolledback", 4, connectionEvent);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "localTransactionRolledback");
        }
    }

    public void localTransactionStarted(ConnectionEvent connectionEvent) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "localTransactionStarted");
        }
        this.checkForHandleUseViolation(connectionEvent.getConnectionHandle());
        if (connectionEvent.getId() == 2) {
            UOWCoordinator uOWCoordinator = this.mcWrapper.getUOWCoordinator();
            if (uOWCoordinator == null) {
                uOWCoordinator = this.mcWrapper.updateUOWCoordinator();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "uowCoord was null, updating it to current coordinator");
                }
            }
            if (uOWCoordinator == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "localTransactionStarted:  no transaction context, return without enlisting.");
                }
                return;
            }
            if (tc.isDebugEnabled() && uOWCoordinator.isGlobal()) {
                IllegalStateException illegalStateException = new IllegalStateException("Illegal attempt to start a local transaction within a global (user) transaction");
                Tr.error(tc, "ILLEGAL_USE_OF_LOCAL_TRANSACTION_J2CA0295", illegalStateException);
                FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ejs.j2c.ConnectionEventListener.localTransactionStarted", "600", this);
            }
            try {
                this.mcWrapper.getCurrentTranWrapper().enlist();
            }
            catch (ResourceException resourceException) {
                FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.j2c.ConnectionEventListener.localTransactionStarted", "481", this);
                Tr.error(tc, "ENLIST_FAILED_J2CA0074", new Object[]{"localTransactionStarted", resourceException, this.mcWrapper.gConfigProps.pmiName});
                ManagedConnection managedConnection = null;
                try {
                    managedConnection = (ManagedConnection)connectionEvent.getSource();
                }
                catch (ClassCastException classCastException) {
                    Tr.error(tc, "GET_SOURCE_CLASS_CAST_EXCP_J2CA0098", classCastException);
                    throw new IllegalStateException("ClassCastException occurred attempting to cast event.getSource to ManagedConnection");
                }
                ConnectionEvent connectionEvent2 = new ConnectionEvent(managedConnection, 5);
                this.connectionErrorOccurred(connectionEvent2);
                IllegalStateException illegalStateException = new IllegalStateException(resourceException.getMessage());
                throw illegalStateException;
            }
        }
        this.processBadEvent("localTransactionStarted", 2, connectionEvent);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "localTransactionStarted");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void interactionPending(ConnectionEvent connectionEvent) throws ResourceException {
        block20: {
            block18: {
                block19: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.entry(tc, "interactionPending");
                    }
                    this.checkForHandleUseViolation(connectionEvent.getConnectionHandle());
                    if (!this.mcWrapper.gConfigProps.isDynamicEnlistmentSupported()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "interactionPending - DynamicEnlistment Not Supported.  Nothing to do. Returning.");
                        }
                        return;
                    }
                    if (connectionEvent != null && connectionEvent.getId() != 900) break block18;
                    UOWCoordinator uOWCoordinator = this.mcWrapper.getUOWCoordinator();
                    boolean bl = false;
                    if (uOWCoordinator == null) {
                        bl = true;
                        uOWCoordinator = this.mcWrapper.updateUOWCoordinator();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "uowCoord was null, updating it to current coordinator");
                        }
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Coordinator in effect: " + uOWCoordinator);
                    }
                    if (uOWCoordinator == null) break block19;
                    if (uOWCoordinator.isGlobal()) {
                        TranWrapper tranWrapper = null;
                        try {
                            tranWrapper = this.mcWrapper.getCurrentTranWrapper();
                            if (tranWrapper == null) {
                                Tr.error(tc, "NULL_TRAN_WRAPPER_J2CA0057");
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                    Tr.exit(tc, "interactionPending: No TranWrapper found.");
                                }
                                IllegalStateException illegalStateException = new IllegalStateException("interactionPending: No TranWrapper found.");
                                throw illegalStateException;
                            }
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.j2c.ConnectionEventListener.interactionPending", "622", this);
                            Tr.error(tc, "ENLIST_FAILED_J2CA0074", new Object[]{"interactionPending", exception, this.mcWrapper.gConfigProps.pmiName});
                            try {
                                this.mcWrapper.markStale();
                                this.mcWrapper.releaseToPoolManager();
                            }
                            catch (Exception exception2) {
                                FFDCFilter.processException((Throwable)exception2, "com.ibm.ejs.j2c.ConnectionEventListener.interactionPending", "631", this);
                            }
                            ResourceException resourceException = new ResourceException(exception.getMessage());
                            resourceException.initCause((Throwable)exception);
                            throw resourceException;
                        }
                        tranWrapper.enlist();
                        break block20;
                    } else if (bl) {
                        this.mcWrapper.resetCoordinator();
                    }
                    break block20;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Transaction context does NOT exist");
                }
                Tr.error(tc, "TRANSACTION_REQUIRED_J2CA0076", "interactionPending");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "interactionPending: missing transaction context");
                }
                ResourceException resourceException = new ResourceException("interactionPending: missing transaction context");
                throw resourceException;
            }
            this.processBadEvent("interactionPending", 900, connectionEvent);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "interactionPending");
        }
    }

    private void processBadEvent(String string, int n, ConnectionEvent connectionEvent) {
        String string2 = Integer.toString(connectionEvent.getId());
        String string3 = this.mcWrapper.gConfigProps.pmiName;
        Object[] objectArray = new Object[]{Integer.toString(n), string2, string3};
        Tr.error(tc, "UNEXPECTED_CONNECTION_EVENT_J2CA0034", objectArray);
        ManagedConnection managedConnection = null;
        try {
            managedConnection = (ManagedConnection)connectionEvent.getSource();
        }
        catch (ClassCastException classCastException) {
            Tr.error(tc, "GET_SOURCE_CLASS_CAST_EXCP_J2CA0098", classCastException);
            IllegalStateException illegalStateException = new IllegalStateException("processBadEvent: ClassCastException occurred attempting to cast event.getSource to ManagedConnection");
            FFDCFilter.processException((Throwable)classCastException, "com.ibm.ejs.j2c.ConnectionEventListener.processBadEvent", "809", this);
            throw illegalStateException;
        }
        ConnectionEvent connectionEvent2 = new ConnectionEvent(managedConnection, 5);
        this.connectionErrorOccurred(connectionEvent2);
        IllegalStateException illegalStateException = new IllegalStateException("Method " + string + " detected an unexpected ConnectionEvent of " + string2 + " for DataSource/ConnectionFactory " + string3);
        FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ejs.j2c.ConnectionEventListener.processBadEvent", "709", this);
        throw illegalStateException;
    }

    public MCWrapper getMcWrapper() {
        return this.mcWrapper;
    }

    private void checkForHandleUseViolation(Object object) throws IllegalStateException {
        Object object2;
        Object object3;
        if (this.mcWrapper.gConfigProps.xComponentConnectionUseDetectionEnabled && object != null) {
            boolean bl;
            object3 = ConnectionManager.getComponentMetaData();
            object2 = ConnectionHandleManager.getConnectionHandleManager().getHandleList((ComponentMetaData)object3);
            if (object2 != null && !(bl = ((HandleList)object2).findHandle(object))) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "No handleList entry found for handle: " + object.toString());
                }
                IllegalStateException illegalStateException = new IllegalStateException("Illegal sharing of connection handle between components.");
                Tr.error(tc, "CROSS_COMPONENT_HANDLE_USE_J2CA0166", new Object[]{object, illegalStateException});
                throw illegalStateException;
            }
        }
        if (this.mcWrapper.gConfigProps.multiThreadedUseDetectionEnabled) {
            Thread thread;
            String string;
            object3 = this.mcWrapper.getConnectionManager();
            if (((ConnectionManager)object3).handleToThreadMap != null && (object2 = (String)((ConnectionManager)object3).handleToThreadMap.get(object)) != null && !((String)object2).equals(string = Integer.toHexString((thread = Thread.currentThread()).hashCode())) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Concurrent use violation for handle: " + object + " for managed connection wrapper " + this.mcWrapper);
            }
        }
    }

    public byte[] getCorrelator() {
        return PmiReqMetrics.getArmCorrelator();
    }

    public int getTranDetailLevel() {
        if (PmiReqMetrics.isComponentEnabled(this.mcWrapper.gConfigProps.reqMetricID)) {
            return PmiReqMetrics.getTranDetailLevel(this.mcWrapper.gConfigProps.reqMetricID);
        }
        if (this.mcWrapper.pm.efficiencyGroupEnabled) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object preInteraction(String[] stringArray) {
        Object object;
        if (!this.isInteractionMetricsEnabled()) {
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "preInteraction");
        }
        if (!this.mcWrapper.gConfigProps.isInteractionMetricsEnabled()) {
            object = this;
            synchronized (object) {
                if (!this.mcWrapper.gConfigProps.isInteractionMetricsEnabled()) {
                    this.mcWrapper.gConfigProps.setInteractionMetricsEnabled(true);
                    this.mcWrapper.totalUseTime = 0L;
                    this.mcWrapper.currentUseStartTime = 0L;
                }
            }
        }
        object = null;
        if (PmiReqMetrics.isComponentEnabled(this.mcWrapper.gConfigProps.reqMetricID)) {
            object = PmiReqMetrics.reqStart(this.mcWrapper.gConfigProps.reqMetricID, 2, stringArray);
        }
        if (this.mcWrapper.pm.efficiencyGroupEnabled) {
            this.mcWrapper.useTimeStart();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "preInteraction");
        }
        return object;
    }

    public void postInteraction(Object object, int n) {
        if (!this.isInteractionMetricsEnabled()) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "postInteraction");
        }
        if (PmiReqMetrics.isComponentEnabled(this.mcWrapper.gConfigProps.reqMetricID)) {
            PmiReqMetrics.reqStop(object, this.mcWrapper.gConfigProps.reqMetricID, 2, n);
        }
        if (this.mcWrapper.pm.efficiencyGroupEnabled) {
            this.mcWrapper.useTimeStop();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "postInteraction");
        }
    }

    public void postInteraction(Object object, int n, Properties properties) {
        if (!this.isInteractionMetricsEnabled()) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "postInteraction");
        }
        if (PmiReqMetrics.isComponentEnabled(this.mcWrapper.gConfigProps.reqMetricID)) {
            PmiReqMetrics.reqStop(object, this.mcWrapper.gConfigProps.reqMetricID, 2, n, properties);
        }
        if (this.mcWrapper.pm.efficiencyGroupEnabled) {
            this.mcWrapper.useTimeStop();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "postInteraction");
        }
    }

    public boolean isInteractionMetricsEnabled() {
        return PmiReqMetrics.isComponentEnabled(this.mcWrapper.gConfigProps.reqMetricID) || this.mcWrapper.pm.efficiencyGroupEnabled;
    }
}

