/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.j2c.CMConfigData;
import com.ibm.ejs.j2c.ConnectionManager;
import com.ibm.ejs.j2c.ConnectorRuntime;
import com.ibm.ejs.j2c.J2CGlobalConfigProperties;
import com.ibm.ejs.j2c.MCFEntry;
import com.ibm.ejs.j2c.PoolManager;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.rasdiag.DiagnosticProviderHelper;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnectionFactory;

public final class ConnectionFactoryDetailsImpl {
    private static final TraceComponent tc = Tr.register(ConnectionFactoryDetailsImpl.class, "WAS.j2c", "com.ibm.ws.j2c.resources.J2CAMessages");
    private ManagedConnectionFactory mcf = null;
    private ConnectionManager cm = null;
    private PoolManager pm = null;
    private ClassLoader cl = null;
    private J2CGlobalConfigProperties gConfigProps = null;
    private static final HashMap factoryDetails = new HashMap();
    public static final Object LOCKOBJECT = new Object();
    public static final HashMap cfKeyToMcf = new HashMap();
    public static final HashMap cfKeyToPm = new HashMap();

    private ConnectionFactoryDetailsImpl() {
    }

    ConnectionFactoryDetailsImpl(ManagedConnectionFactory managedConnectionFactory, ConnectionManager connectionManager, PoolManager poolManager, J2CGlobalConfigProperties j2CGlobalConfigProperties) {
        this.cm = connectionManager;
        this.mcf = managedConnectionFactory;
        this.pm = poolManager;
        this.gConfigProps = j2CGlobalConfigProperties;
    }

    static HashMap getFactoryDetailsTable() {
        return factoryDetails;
    }

    ManagedConnectionFactory getManagedConnectionFactory() {
        return this.mcf;
    }

    ConnectionManager getConnectionManager() {
        return this.cm;
    }

    PoolManager getPoolManager() {
        return this.pm;
    }

    ClassLoader getClassloader() {
        return this.cl;
    }

    void setClassloader(ClassLoader classLoader) {
        this.cl = classLoader;
    }

    boolean isStarted() {
        if (this.gConfigProps == null) {
            this.gConfigProps = new J2CGlobalConfigProperties();
        }
        return this.gConfigProps.isStarted();
    }

    boolean isRaEmbedded() {
        if (this.gConfigProps == null) {
            this.gConfigProps = new J2CGlobalConfigProperties();
        }
        return this.gConfigProps.isEmbeddedRa();
    }

    void setEmbeddedRa(boolean bl) {
        if (this.gConfigProps == null) {
            this.gConfigProps = new J2CGlobalConfigProperties();
        }
        this.gConfigProps.setEmbeddedRa(bl);
    }

    void setStarted(boolean bl) {
        if (this.gConfigProps == null) {
            this.gConfigProps = new J2CGlobalConfigProperties();
        }
        this.gConfigProps.setStarted(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pause(String string) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pause for " + string);
        }
        Object object2 = factoryDetails;
        synchronized (object2) {
            object = factoryDetails.keySet().iterator();
            while (object.hasNext()) {
                ConnectionFactoryDetailsImpl connectionFactoryDetailsImpl;
                String string2 = (String)object.next();
                if (!string2.startsWith(string) || (connectionFactoryDetailsImpl = (ConnectionFactoryDetailsImpl)factoryDetails.get(string2)) == null) continue;
                connectionFactoryDetailsImpl.setStarted(false);
            }
        }
        object2 = null;
        object = LOCKOBJECT;
        synchronized (object) {
            object2 = (PoolManager)cfKeyToPm.get(string);
        }
        if (object2 != null) {
            ((PoolManager)object2).pause();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pause");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resume(String string) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resume for " + string);
        }
        Object object2 = factoryDetails;
        synchronized (object2) {
            object = factoryDetails.keySet().iterator();
            while (object.hasNext()) {
                ConnectionFactoryDetailsImpl connectionFactoryDetailsImpl;
                String string2 = (String)object.next();
                if (!string2.startsWith(string) || (connectionFactoryDetailsImpl = (ConnectionFactoryDetailsImpl)factoryDetails.get(string2)) == null) continue;
                connectionFactoryDetailsImpl.setStarted(true);
            }
        }
        object2 = null;
        object = LOCKOBJECT;
        synchronized (object) {
            object2 = (PoolManager)cfKeyToPm.get(string);
        }
        if (object2 != null) {
            ((PoolManager)object2).resume();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resume");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(String string, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start for " + string);
        }
        HashMap hashMap = factoryDetails;
        synchronized (hashMap) {
            Object object;
            boolean bl2 = false;
            Iterator iterator = factoryDetails.keySet().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                if (!((String)object).startsWith(string)) continue;
                ConnectionFactoryDetailsImpl connectionFactoryDetailsImpl = (ConnectionFactoryDetailsImpl)factoryDetails.get(object);
                if (connectionFactoryDetailsImpl == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Unexpected condition:  null entry for key " + (String)object);
                    continue;
                }
                bl2 = true;
                connectionFactoryDetailsImpl.setStarted(true);
                connectionFactoryDetailsImpl.setEmbeddedRa(bl);
                try {
                    ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() throws ClassNotFoundException {
                            return Thread.currentThread().getContextClassLoader();
                        }
                    });
                    connectionFactoryDetailsImpl.setClassloader(classLoader);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Tr.error(tc, "Error getting classloader: " + privilegedActionException);
                }
            }
            if (!bl2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating Shell CFD for short key ", string);
                }
                object = new ConnectionFactoryDetailsImpl();
                Tr.debug(tc, "  Shell is: ", object);
                ((ConnectionFactoryDetailsImpl)object).setStarted(true);
                ((ConnectionFactoryDetailsImpl)object).setEmbeddedRa(bl);
                ((ConnectionFactoryDetailsImpl)object).setClassloader(Thread.currentThread().getContextClassLoader());
                factoryDetails.put(string, object);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start for " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop(String string) {
        Object object;
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "stop for " + string);
            }
            PoolManager poolManager = null;
            object = LOCKOBJECT;
            synchronized (object) {
                cfKeyToMcf.remove(string);
                poolManager = (PoolManager)cfKeyToPm.remove(string);
            }
            if (poolManager != null) {
                try {
                    poolManager.quiesceIfPossible();
                }
                catch (ResourceException resourceException) {
                    if (!tc.isDebugEnabled()) break block16;
                    Tr.debug(tc, "stop caught ResourceException calling pm.quiesce() for " + string);
                    resourceException.printStackTrace();
                }
            }
        }
        object = factoryDetails;
        synchronized (object) {
            String string2;
            ArrayList<String> arrayList = null;
            Iterator<Object> iterator = factoryDetails.keySet().iterator();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                if (!string2.startsWith(string)) continue;
                ConnectionFactoryDetailsImpl connectionFactoryDetailsImpl = (ConnectionFactoryDetailsImpl)factoryDetails.get(string2);
                if (connectionFactoryDetailsImpl.cm != null) {
                    connectionFactoryDetailsImpl.cm.nullPMref();
                    connectionFactoryDetailsImpl.cm = null;
                    connectionFactoryDetailsImpl.setStarted(false);
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                arrayList.add(string2);
            }
            if (arrayList != null) {
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    string2 = (String)iterator.next();
                    factoryDetails.remove(string2);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop for " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dump() {
        StringBuffer stringBuffer = new StringBuffer(256);
        String string = ConnectorRuntime.nl;
        HashMap hashMap = null;
        Map.Entry entry = factoryDetails;
        synchronized (entry) {
            hashMap = new HashMap(factoryDetails);
        }
        Iterator iterator = hashMap.entrySet().iterator();
        stringBuffer.append("[ConnectionFactoryDetailsImpl]");
        stringBuffer.append(string);
        while (iterator.hasNext()) {
            entry = iterator.next();
            stringBuffer.append("\tConnector Name: ");
            stringBuffer.append(entry.getKey());
            stringBuffer.append("\tDetails: ");
            stringBuffer.append(entry.getValue());
            stringBuffer.append(string);
        }
        entry = LOCKOBJECT;
        synchronized (entry) {
            Map.Entry entry2;
            iterator = cfKeyToMcf.entrySet().iterator();
            stringBuffer.append("[cfKeyToMcf]");
            stringBuffer.append(string);
            while (iterator.hasNext()) {
                entry2 = iterator.next();
                MCFEntry mCFEntry = (MCFEntry)entry2.getValue();
                stringBuffer.append("\tConnection Factory Name: ");
                stringBuffer.append(entry2.getKey());
                stringBuffer.append("\tManagedConnectionFactory: ");
                stringBuffer.append(mCFEntry.getManagedConnectionFactory());
                stringBuffer.append("\tMCFExtendedProperties: ");
                stringBuffer.append(mCFEntry.getMCFExtendedProperties());
                stringBuffer.append(string);
            }
            iterator = cfKeyToPm.entrySet().iterator();
            stringBuffer.append("[cfKeyToPm]");
            stringBuffer.append(string);
            while (iterator.hasNext()) {
                entry2 = iterator.next();
                stringBuffer.append("\tConnection Factory Name: ");
                stringBuffer.append(entry2.getKey());
                stringBuffer.append("\tPoolManager: ");
                stringBuffer.append(entry2.getValue());
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getStatus(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "status for " + string);
        }
        int n = 0;
        try {
            boolean bl = false;
            HashMap hashMap = factoryDetails;
            synchronized (hashMap) {
                Iterator iterator = factoryDetails.keySet().iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    if (!string2.startsWith(string)) continue;
                    ConnectionFactoryDetailsImpl connectionFactoryDetailsImpl = (ConnectionFactoryDetailsImpl)factoryDetails.get(string2);
                    if (connectionFactoryDetailsImpl == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Unexpected condition:  null entry for key " + string2);
                        continue;
                    }
                    PoolManager poolManager = connectionFactoryDetailsImpl.getPoolManager();
                    if (poolManager == null) continue;
                    bl = true;
                    n = poolManager.getStatus();
                    break;
                }
                if (!bl) {
                    n = 99;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "status for " + string + " " + n);
        }
        return n;
    }

    protected J2CGlobalConfigProperties getGConfigProps() {
        return this.gConfigProps;
    }

    protected final void setGConfigProps(J2CGlobalConfigProperties j2CGlobalConfigProperties) {
        this.gConfigProps = j2CGlobalConfigProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedHashMap getConfigDump(String string, String string2, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigDump " + string);
        }
        LinkedHashMap linkedHashMap = null;
        LinkedHashMap linkedHashMap2 = null;
        LinkedHashMap<String, LinkedHashMap> linkedHashMap3 = new LinkedHashMap<String, LinkedHashMap>();
        boolean bl2 = false;
        HashMap hashMap = factoryDetails;
        synchronized (hashMap) {
            Iterator iterator = factoryDetails.keySet().iterator();
            while (iterator.hasNext()) {
                CMConfigData cMConfigData;
                String string3;
                if (linkedHashMap == null) {
                    linkedHashMap = new LinkedHashMap();
                }
                if (!(string3 = (String)iterator.next()).startsWith(string)) continue;
                ConnectionFactoryDetailsImpl connectionFactoryDetailsImpl = (ConnectionFactoryDetailsImpl)factoryDetails.get(string3);
                J2CGlobalConfigProperties j2CGlobalConfigProperties = null;
                if (connectionFactoryDetailsImpl == null) continue;
                if (!bl2) {
                    j2CGlobalConfigProperties = connectionFactoryDetailsImpl.getGConfigProps();
                    linkedHashMap = j2CGlobalConfigProperties.getConfigDump(linkedHashMap, string2, bl);
                    bl2 = true;
                }
                if ((linkedHashMap2 = (cMConfigData = connectionFactoryDetailsImpl.getConnectionManager().getCMConfigData()).getConfigDump(string2, bl)).isEmpty()) continue;
                linkedHashMap3.put(cMConfigData.getConfigDumpId(), linkedHashMap2);
            }
            if (!linkedHashMap3.isEmpty()) {
                linkedHashMap.put("current-CMInstance", linkedHashMap3);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigDump");
        }
        return linkedHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedHashMap getStateDump(String string, String string2, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStateDump " + string);
        }
        LinkedHashMap linkedHashMap = null;
        HashMap hashMap = factoryDetails;
        synchronized (hashMap) {
            Iterator iterator = factoryDetails.keySet().iterator();
            while (iterator.hasNext()) {
                ConnectionFactoryDetailsImpl connectionFactoryDetailsImpl;
                String string3;
                if (linkedHashMap == null) {
                    linkedHashMap = new LinkedHashMap();
                }
                if (!(string3 = (String)iterator.next()).startsWith(string) || (connectionFactoryDetailsImpl = (ConnectionFactoryDetailsImpl)factoryDetails.get(string3)) == null) continue;
                PoolManager poolManager = connectionFactoryDetailsImpl.getPoolManager();
                if (poolManager != null) {
                    linkedHashMap = poolManager.getStateDump(linkedHashMap, string2, bl);
                    break;
                }
                Tr.info(tc, "CONNECTION_POOL_NOT_AVAILABLE_J2CA0165");
                return null;
            }
            DiagnosticProviderHelper.filterEventPayload(string2, linkedHashMap);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStateDump");
        }
        return linkedHashMap;
    }
}

