/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.j2c.DiagnosticModuleForJ2C;
import com.ibm.ejs.j2c.MBeanProps;
import com.ibm.ejs.j2c.NamesQueryer;
import com.ibm.ejs.j2c.UOW;
import com.ibm.ejs.j2c.XMLReader;
import com.ibm.ejs.j2c.ffdcHelper;
import com.ibm.ejs.models.base.resources.ConnectionFactory;
import com.ibm.ejs.models.base.resources.J2EEResourceFactory;
import com.ibm.ejs.models.base.resources.J2EEResourceProvider;
import com.ibm.ejs.models.base.resources.jdbc.CMPConnectorFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.pmi.J2CPerf;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.Transaction.WebSphereTransactionManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.pmi.server.PmiFactory;
import com.ibm.ws.pmi.server.PmiRegistry;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.HashMap;
import javax.management.ObjectName;
import javax.resource.ResourceException;
import javax.transaction.SystemException;
import org.eclipse.emf.common.util.EList;

public final class ConnectorRuntime {
    private static final TraceComponent tc = Tr.register(ConnectorRuntime.class, "WAS.j2c", "com.ibm.ws.j2c.resources.J2CAMessages");
    public static final String nl = System.getProperty("line.separator");
    private static DiagnosticModuleForJ2C dm = ffdcHelper.registerFFDC();
    private static HashMap pmiMap = new HashMap();

    private ConnectorRuntime() {
    }

    protected static synchronized J2CPerf createPmiData(MBeanProps mBeanProps, String string) {
        J2CPerf j2CPerf = null;
        ObjectName objectName = null;
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createPmiData");
        }
        if (!PmiRegistry.isDisabled()) {
            j2CPerf = ConnectorRuntime.getPmiData(string);
            if (j2CPerf == null) {
                if (mBeanProps != null) {
                    NamesQueryer namesQueryer = new NamesQueryer();
                    mBeanProps.providerName = namesQueryer.queryNames(mBeanProps.providerId);
                    mBeanProps.factoryName = namesQueryer.queryNames(mBeanProps.factoryId);
                    objectName = namesQueryer.queryNames(mBeanProps.factoryId + "_mcf");
                    if (namesQueryer.mbeanErrorOccurred) {
                        Tr.warning(tc, "NULL_OBJECTNAMES_J2CA0112", new Object[]{string, mBeanProps.factoryName, mBeanProps.providerName});
                        bl = true;
                    }
                }
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Creating pmiData for pmiName, " + string);
                    }
                    j2CPerf = bl || mBeanProps == null ? PmiFactory.createJ2CPerf(string, null, null, objectName) : PmiFactory.createJ2CPerf(string, mBeanProps.providerName, mBeanProps.factoryName, objectName);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ejs.j2c.ConnectorRuntime.createPmiData", "388");
                    Tr.warning(tc, "ERROR_CREATE_PMIDATA_J2CA0279");
                }
                if (j2CPerf != null) {
                    pmiMap.put(string, j2CPerf);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found pmiData for pmiName, " + string + ", in pmiMap");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "pmi is disabled, returning null");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "PmiData is " + (j2CPerf == null ? "null" : "not null"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createPmiData");
        }
        return j2CPerf;
    }

    protected static J2CPerf getPmiData(String string) {
        J2CPerf j2CPerf = null;
        if (pmiMap.containsKey(string)) {
            try {
                j2CPerf = (J2CPerf)pmiMap.get(string);
            }
            catch (ClassCastException classCastException) {
                FFDCFilter.processException(classCastException, "com.ibm.ejs.j2c.ConnectorRuntime.getPmiData", "1915");
                Tr.warning(tc, "ERROR_FINDING_CACHED_PMIDATA_J2CA0111");
            }
        }
        return j2CPerf;
    }

    public static UOW getCurrentUOW() throws ResourceException {
        UOW uOW = new UOW();
        ConnectorRuntime.getCurrentUOW(uOW);
        return uOW;
    }

    public static void getCurrentUOW(UOW uOW) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCurrentUOW");
        }
        try {
            UOWCurrent uOWCurrent = TransactionManagerFactory.getUOWCurrent();
            UOWCoordinator uOWCoordinator = uOWCurrent.getUOWCoord();
            if (uOWCoordinator != null) {
                if (uOWCoordinator.isGlobal()) {
                    uOW.setScope(0);
                } else {
                    uOW.setScope(1);
                }
                uOW.setCoordinator(uOWCoordinator);
            } else {
                String string = "";
                if (tc.isDebugEnabled()) {
                    WebSphereTransactionManager webSphereTransactionManager = TransactionManagerFactory.getTransactionManager();
                    int n = webSphereTransactionManager.getStatus();
                    switch (n) {
                        case 0: {
                            string = "STATUS_ACTIVE";
                            break;
                        }
                        case 3: {
                            string = "STATUS_COMMITTED";
                            break;
                        }
                        case 8: {
                            string = "STATUS_COMMITTING";
                            break;
                        }
                        case 1: {
                            string = "STATUS_MARKED_ROLLBACK";
                            break;
                        }
                        case 6: {
                            string = "STATUS_NO_TRANSACTION";
                            break;
                        }
                        case 2: {
                            string = "STATUS_PREPARED";
                            break;
                        }
                        case 7: {
                            string = "STATUS_PREPARING";
                            break;
                        }
                        case 4: {
                            string = "STATUS_ROLLEDBACK";
                            break;
                        }
                        case 9: {
                            string = "STATUS_ROLLING_BACK";
                            break;
                        }
                        case 5: {
                            string = "STATUS_UNKNOWN";
                            break;
                        }
                        default: {
                            string = "transaction status unknown (default case)";
                        }
                    }
                    Tr.debug(tc, "getcurrentUOW(): not detecting active transaction. No local context. Global status is: " + string);
                }
                uOW.setScope(2);
                uOW.setCoordinator(UOW.NULL_COORDINATOR);
            }
        }
        catch (SystemException systemException) {
            FFDCFilter.processException(systemException, "com.ibm.ejs.j2c.ConnectorRuntime.getCurrentUOW", "333");
            Tr.error(tc, "FAILED_TO_GET_TRANSACTION_STATUS_J2CA0064", (Object)systemException);
            throw new ResourceException("getCurrentUOW: Failed to get transaction status" + (Object)((Object)systemException));
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCurrentUOW");
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(nl + "[[ConnectorRuntime]]" + nl + nl);
        return stringBuffer.toString();
    }

    public static HashMap getPmiMap() {
        return pmiMap;
    }

    public static String exceptionList(Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<=================================>");
        stringBuffer.append("Exception Message -> ");
        stringBuffer.append(throwable.getMessage());
        stringBuffer.append(nl);
        if (throwable instanceof ResourceException) {
            stringBuffer.append("  ResourceException Error Code -> ");
            stringBuffer.append(((ResourceException)throwable).getErrorCode());
            stringBuffer.append(nl);
        }
        if (throwable instanceof SQLException) {
            stringBuffer.append("  SQLException  Error Code -> ");
            stringBuffer.append(((SQLException)throwable).getErrorCode());
            stringBuffer.append(nl);
            stringBuffer.append("  SQLException  SQLState -> ");
            stringBuffer.append(((SQLException)throwable).getSQLState());
            stringBuffer.append(nl);
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        stringBuffer.append(stringWriter.getBuffer());
        stringBuffer.append("<=================================>");
        Throwable throwable2 = null;
        throwable2 = throwable.getCause();
        if (throwable2 != null) {
            stringBuffer.append("Next Linked Exception:" + nl);
            stringBuffer.append(ConnectorRuntime.exceptionList(throwable2));
        }
        return stringBuffer.toString();
    }

    public static XMLReader getJ2C_Properties() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJ2C_Properties");
        }
        XMLReader xMLReader = null;
        try {
            xMLReader = new XMLReader("j2c.properties", "j2c-customizations");
        }
        catch (XMLReader.XMLReaderException xMLReaderException) {
            xMLReader = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJ2C_Properties");
        }
        return xMLReader;
    }

    public static void setupPMIData(J2EEResourceProvider j2EEResourceProvider) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setupPMIData");
        }
        EList eList = j2EEResourceProvider.getFactories();
        String string = null;
        try {
            string = AdminServiceFactory.getMBeanFactory().getConfigId(j2EEResourceProvider);
        }
        catch (AdminException adminException) {
            FFDCFilter.processException(adminException, "com.ibm.ejs.j2c.ConnectorRuntime.setupPMIData", "581");
            Tr.debug(tc, "An AdminException occurred getting the providerId for " + j2EEResourceProvider.getName() + " : cause=" + adminException.getCause());
        }
        int n = eList.size();
        String string2 = null;
        int n2 = n;
        for (int i = 0; i < n2; ++i) {
            J2EEResourceFactory j2EEResourceFactory = (J2EEResourceFactory)eList.get(i);
            String string3 = j2EEResourceFactory.getJndiName();
            if (!(j2EEResourceFactory instanceof ConnectionFactory) || j2EEResourceFactory instanceof CMPConnectorFactory) continue;
            MBeanProps mBeanProps = new MBeanProps();
            mBeanProps.setProviderId(string);
            try {
                string2 = AdminServiceFactory.getMBeanFactory().getConfigId(j2EEResourceFactory);
                mBeanProps.setFactoryId(string2);
            }
            catch (AdminException adminException) {
                FFDCFilter.processException(adminException, "com.ibm.ejs.j2c.ConnectorRuntime.setupPMIData", "598");
                Tr.debug(tc, "An AdminException occurred getting the factoryId for " + j2EEResourceFactory.getName() + " : cause=" + adminException.getCause());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "providerId=" + string);
                Tr.debug(tc, "factoryId=" + string2);
            }
            ConnectorRuntime.createPmiData(mBeanProps, string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupPMIData");
        }
    }
}

