/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.j2c.PoolManager;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.rasdiag.AlertController;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.ListIterator;

public class DBRequestMonitorPool {
    private int bitSetSize;
    private int stuckTime;
    private int timerTime;
    private int stuckThreshold;
    private LinkedList bsList;
    private BitSet currentBS;
    private int numBack;
    private BitSet connExists;
    private BitSet trueBS;
    private Object connExistsLockObject = new Object();
    private boolean lastStuckValue = false;
    private String dataSourceName;
    private PoolManager pm = null;
    private static final TraceComponent tc = Tr.register(DBRequestMonitorPool.class, "WAS.j2c", "com.ibm.ws.j2c.resources.J2CAMessages");

    public DBRequestMonitorPool(int n, int n2, int n3, int n4, String string, PoolManager poolManager) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.bitSetSize = n;
        this.stuckTime = n2;
        this.timerTime = n3;
        this.stuckThreshold = n4;
        this.dataSourceName = string;
        this.pm = poolManager;
        this.numBack = this.stuckTime / this.timerTime;
        if (this.stuckTime % this.timerTime != 0) {
            ++this.numBack;
        }
        this.bsList = new LinkedList();
        this.connExists = new BitSet(this.bitSetSize);
        this.trueBS = new BitSet(this.bitSetSize);
        for (int i = 0; i < this.bitSetSize; ++i) {
            this.trueBS.set(i);
        }
        this.currentBS = new BitSet(this.bitSetSize);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", new Object[]{"bitSetSize=" + this.bitSetSize, " stuckTime=" + this.stuckTime, " timerTime=" + this.timerTime, " stuckThreshold=" + this.stuckThreshold, " numBack=" + this.numBack});
        }
    }

    public BitSet set(int n) {
        BitSet bitSet;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "set(int)");
            }
            bitSet = this.currentBS;
            try {
                bitSet.set(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "caught exception doing set", indexOutOfBoundsException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "set(int)", bitSet);
        }
        return bitSet;
    }

    public void clear(int n, BitSet bitSet) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "clear(int, BitSet)", new Object[]{new Integer(n), bitSet});
            }
            try {
                bitSet.clear(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "caught exception doing clear", indexOutOfBoundsException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clear(int, BitSet)");
        }
    }

    public boolean processAlarm() {
        BitSet bitSet;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processAlarm()");
        }
        boolean bl = false;
        this.currentBS = bitSet = new BitSet(this.bitSetSize);
        this.bsList.addFirst(this.currentBS);
        int n = 0;
        if (this.bsList.size() > this.numBack) {
            ListIterator listIterator = this.bsList.listIterator(this.numBack + 1);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There might be stuck connections.");
            }
            int n2 = 0;
            while (listIterator.hasNext()) {
                BitSet bitSet2 = (BitSet)listIterator.next();
                n2 = bitSet2.length();
                for (int i = 0; i < n2; ++i) {
                    if (!bitSet2.get(i)) continue;
                    ++n;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "numStuck is " + n);
            }
            if (n >= this.stuckThreshold) {
                bl = true;
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The list of BitSets is too small to have stuck connections.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "bsList.size() before removing empties is " + this.bsList.size());
        }
        for (int i = this.bsList.size(); i > 1 && ((BitSet)this.bsList.getLast()).length() == 0; --i) {
            this.bsList.removeLast();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "bsList.size() after removing empties is " + this.bsList.size());
        }
        if (!this.lastStuckValue && bl) {
            Tr.audit(tc, "MSG_CONM_2001I", new Object[]{new Integer(n), this.dataSourceName, new Integer(this.stuckTime)});
            this.pm.alertIsforEnteringStuck = true;
            AlertController.checkPoint(PoolManager.alertLogger, this.pm, this.pm.gConfigProps.hungConnModeAlertConfig);
        } else if (this.lastStuckValue && !bl) {
            Tr.audit(tc, "MSG_CONM_2002I", new Object[]{this.dataSourceName, new Integer(n), new Integer(this.stuckThreshold)});
            this.pm.alertIsforEnteringStuck = false;
            AlertController.checkPoint(PoolManager.alertLogger, this.pm, this.pm.gConfigProps.hungConnModeAlertConfig);
        }
        this.lastStuckValue = bl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processAlarm()" + Boolean.valueOf(bl));
        }
        return bl;
    }

    public int currentNumberStuck() {
        BitSet bitSet;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "currentNumberStuck()");
        }
        boolean bl = false;
        this.currentBS = bitSet = new BitSet(this.bitSetSize);
        this.bsList.addFirst(this.currentBS);
        int n = 0;
        if (this.bsList.size() > this.numBack) {
            ListIterator listIterator = this.bsList.listIterator(this.numBack + 1);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There might be stuck connections.");
            }
            int n2 = 0;
            while (listIterator.hasNext()) {
                BitSet bitSet2 = (BitSet)listIterator.next();
                n2 = bitSet2.length();
                for (int i = 0; i < n2; ++i) {
                    if (!bitSet2.get(i)) continue;
                    ++n;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "numStuck is " + n);
            }
            if (n >= this.stuckThreshold) {
                bl = true;
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The list of BitSets is too small to have stuck connections.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "currentNumberStuck()" + n);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setCreated() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCreated()");
        }
        Object object = this.connExistsLockObject;
        synchronized (object) {
            BitSet bitSet = (BitSet)this.connExists.clone();
            bitSet.xor(this.trueBS);
            int n = bitSet.length();
            if (n != 0) {
                this.connExists.set(--n);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The BitSet is full during setCreated()");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setCreated()", new Integer(n));
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDestroyed(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDestroyed(int)", new Integer(n));
        }
        Object object = this.connExistsLockObject;
        synchronized (object) {
            this.connExists.clear(n);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDestroyed(int)");
        }
    }

    public int getStuckThreshold() {
        return this.stuckThreshold;
    }

    public int getStuckTime() {
        return this.stuckTime;
    }

    public int getTimerTime() {
        return this.timerTime;
    }

    public void setStuckThreshold(int n) {
        this.stuckThreshold = n;
    }

    public void setStuckTime(int n) {
        this.stuckTime = n;
        if (this.timerTime > 0) {
            this.numBack = this.stuckTime / this.timerTime;
            if (this.stuckTime % this.timerTime != 0) {
                ++this.numBack;
            }
        }
    }

    public void setTimerTime(int n) {
        this.timerTime = n;
        if (this.timerTime > 0) {
            this.numBack = this.stuckTime / this.timerTime;
            if (this.stuckTime % this.timerTime != 0) {
                ++this.numBack;
            }
        }
    }
}

