/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.j2c.ConnectionEventListener;
import com.ibm.ejs.j2c.ConnectionManager;
import com.ibm.ejs.j2c.LocalTransactionWrapper;
import com.ibm.ejs.j2c.MCWrapper;
import com.ibm.ejs.j2c.PoolManager;
import com.ibm.ejs.j2c.SharedPool;
import com.ibm.ejs.j2c.XATransactionWrapper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.ffdc.DiagnosticModule;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.IncidentStream;
import com.ibm.ws.rsadapter.spi.WSConnectionRequestInfoImpl;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import java.util.Vector;
import javax.resource.spi.ConnectionRequestInfo;
import javax.security.auth.Subject;

public class DiagnosticModuleForJ2C
extends DiagnosticModule {
    TraceComponent tc = Tr.register("ConnLeakLogic", "WAS.j2c", "com.ibm.ws.j2c.resources.J2CAMessages");
    public static final String DMSID_MAX_CONNECTIONS_REACHED = "Max connections reached";

    public void ffdcDumpDefaultJ2C(Throwable throwable, IncidentStream incidentStream, Object object, Object[] objectArray, String string) {
        if (string.equals(DMSID_MAX_CONNECTIONS_REACHED)) {
            this.ffdcDumpMaxConnectionsReached(throwable, incidentStream, object, objectArray, string);
        } else if (string.equals("com.ibm.ejs.j2c.LocalTransactionWrapper.enlist") && object instanceof LocalTransactionWrapper && objectArray != null && objectArray.length >= 1) {
            this.ffdcDumpIllegal1PCResourceMessage(throwable, incidentStream, object, objectArray, string);
        } else {
            incidentStream.writeLine("sourceId ", string);
            incidentStream.introspectAndWriteLine("This", object);
            try {
                Object object2;
                if (object instanceof MCWrapper) {
                    object2 = (MCWrapper)object;
                    incidentStream.writeLine("Pool Information:", ((MCWrapper)object2).getPoolManager().toString());
                }
                if (object instanceof ConnectionManager) {
                    object2 = (ConnectionManager)object;
                    incidentStream.writeLine("Pool Information:", ((ConnectionManager)object2).getPoolManager().toString());
                }
                if (object instanceof XATransactionWrapper) {
                    object2 = (XATransactionWrapper)object;
                    incidentStream.writeLine("Pool Information:", ((XATransactionWrapper)object2).getMcWrapper().getPoolManager().toString());
                }
                if (object instanceof LocalTransactionWrapper) {
                    object2 = (LocalTransactionWrapper)object;
                    incidentStream.writeLine("Pool Information:", ((LocalTransactionWrapper)object2).getMcWrapper().getPoolManager().toString());
                }
                if (object instanceof ConnectionEventListener) {
                    object2 = (ConnectionEventListener)object;
                    incidentStream.writeLine("Pool Information:", ((ConnectionEventListener)object2).getMcWrapper().getPoolManager().toString());
                }
            }
            catch (NullPointerException nullPointerException) {
                incidentStream.writeLine("Pool Information:", "No Pool information available");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ffdcDumpMaxConnectionsReached(Throwable throwable, IncidentStream incidentStream, Object object, Object[] objectArray, String string) {
        incidentStream.write("Maximum number of connections has been reached, and the connection request has been waiting longer than", "");
        incidentStream.write("ConnectionWaitTime.  Two possible solutions  : increase the max number of connections, or increase the", "");
        incidentStream.writeLine("ConnectionWaitTime.", "");
        try {
            PoolManager poolManager = (PoolManager)object;
            if (this.tc.isDebugEnabled()) {
                int n;
                long l = System.currentTimeMillis();
                SharedPool[] sharedPoolArray = poolManager.getSharedPool();
                Tr.debug(this.tc, "Dumping initial request stack traces");
                com.ibm.ws.j2c.MCWrapper[] mCWrapperArray = null;
                for (n = 0; n < sharedPoolArray.length; ++n) {
                    if (sharedPoolArray[n] == null) continue;
                    mCWrapperArray = sharedPoolArray[n].getMCWrapperList();
                    for (int i = 0; i < mCWrapperArray.length; ++i) {
                        Throwable throwable2;
                        if (mCWrapperArray[i] == null || (throwable2 = ((MCWrapper)mCWrapperArray[i]).getInitialRequestStackTrace()) == null) continue;
                        long l2 = ((MCWrapper)mCWrapperArray[i]).getCreatedTimeStamp();
                        Tr.debug(this.tc, mCWrapperArray[i].toString() + " in-use for " + (l - l2) + "ms", throwable2);
                    }
                }
                mCWrapperArray = poolManager.getUnSharedPoolConnections();
                for (n = 0; n < mCWrapperArray.length; ++n) {
                    Throwable throwable3;
                    if (mCWrapperArray[n] == null || (throwable3 = ((MCWrapper)mCWrapperArray[n]).getInitialRequestStackTrace()) == null) continue;
                    long l3 = ((MCWrapper)mCWrapperArray[n]).getCreatedTimeStamp();
                    Tr.debug(this.tc, mCWrapperArray[n].toString() + " in-use for " + (l - l3) + "ms", throwable3);
                }
            }
            incidentStream.writeLine("   Maximum Connections           = ", poolManager.maxConnections);
            incidentStream.writeLine("   Current number of connections = ", poolManager.getConnectionCount());
            incidentStream.writeLine("   Connection Wait Timout        = ", poolManager.connectionTimeout);
            incidentStream.write("If the current number of connections is not greater than or equal to max connections, ", "");
            incidentStream.writeLine("there has been a WebSphere internal error.", "");
        }
        catch (ClassCastException classCastException) {
            incidentStream.writeLine("Internal J2C FFDC Diagnostic Module error", "");
            incidentStream.writeLine("ClassCastException in ffdcDumpMaxConnectionsReached", "");
            incidentStream.writeLine("Object this was not of type ConnectionManager when ffdcDumpMaxConnectionsReached was called - introspecting the object: ", "");
        }
        catch (Exception exception) {
            incidentStream.writeLine("Internal J2C FFDC Diagnostic Module error", "");
            incidentStream.writeLine("Exception ", exception);
        }
        finally {
            incidentStream.introspectAndWriteLine("This = ", object);
        }
    }

    public void ffdcDumpIllegal1PCResourceMessage(Throwable throwable, IncidentStream incidentStream, Object object, Object[] objectArray, String string) {
        MCWrapper mCWrapper;
        MCWrapper mCWrapper2 = mCWrapper = (MCWrapper)objectArray[0];
        UOWCoordinator uOWCoordinator = mCWrapper.getUOWCoordinator();
        PoolManager poolManager = mCWrapper.getPoolManager();
        Vector vector = poolManager.getMCWrappersByTran(uOWCoordinator);
        if (vector != null && vector.size() > 0) {
            incidentStream.writeLine("DSRA9002E J2CA0030E WTRN0062E ", "Possible misuse of connection manager may have caused 2PC transaction when 1PC tran was desired.");
            Subject subject = mCWrapper.getSubject();
            ConnectionRequestInfo connectionRequestInfo = mCWrapper.getCRI();
            String string2 = connectionRequestInfo instanceof WSConnectionRequestInfoImpl ? ((WSConnectionRequestInfoImpl)connectionRequestInfo).getPassword() : "";
            this.printMCWrapperDetails(mCWrapper, incidentStream, string2, subject);
            for (int i = 0; i < vector.size(); ++i) {
                mCWrapper = (MCWrapper)vector.elementAt(i);
                if (mCWrapper == mCWrapper2) continue;
                this.printMCWrapperDetails(mCWrapper, incidentStream, string2, subject);
            }
        }
    }

    private void printMCWrapperDetails(MCWrapper mCWrapper, IncidentStream incidentStream, String string, Subject subject) {
        Subject subject2 = mCWrapper.getSubject();
        ConnectionRequestInfo connectionRequestInfo = mCWrapper.getCRI();
        incidentStream.writeLine("MCWrapper", mCWrapper.toString());
        incidentStream.writeLine("PoolName", mCWrapper.gConfigProps.pmiName);
        incidentStream.writeLine(connectionRequestInfo.toString(), "");
        if (!this.subjectsMatch(subject2, subject)) {
            incidentStream.writeLine("Subject does NOT match!", "");
        }
        if (subject2 == null) {
            incidentStream.writeLine("Subject", "null");
        }
        incidentStream.writeLine("Container Managed Auth", mCWrapper.getConnectionManager().getContainerManagedAuth() ? "Yes" : "No");
        if (connectionRequestInfo instanceof WSConnectionRequestInfoImpl) {
            String string2 = ((WSConnectionRequestInfoImpl)connectionRequestInfo).getPassword();
            if (string != null && !string.equals(string2)) {
                incidentStream.writeLine("Password does NOT match!", "");
            }
        }
    }

    private boolean subjectsMatch(Subject subject, Subject subject2) {
        Boolean bl;
        block5: {
            if (subject == subject2) {
                return true;
            }
            if (subject == null && subject2 != null || subject != null && subject2 == null) {
                return false;
            }
            final Set<Object> set = subject.getPublicCredentials();
            final Set<Object> set2 = subject2.getPublicCredentials();
            final Set<Object> set3 = subject.getPrivateCredentials();
            final Set<Object> set4 = subject2.getPrivateCredentials();
            bl = null;
            try {
                bl = (Boolean)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException {
                        if (set == null && set2 != null || set != null && set2 == null) {
                            return new Boolean(false);
                        }
                        boolean bl = false;
                        if (set != null && ((Object)set).equals(set2)) {
                            bl = set3 != null && ((Object)set3).equals(set4);
                        }
                        return new Boolean(bl);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ejs.j2c.DiagnosticModuleForJ2C.subjectsMatch", "688", this);
                if (!this.tc.isDebugEnabled()) break block5;
                Tr.debug(this.tc, "Caught PrivilegedActionException " + privilegedActionException.getException());
            }
        }
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        System.out.println("Start of the test for the component DM");
        DiagnosticModuleForJ2C diagnosticModuleForJ2C = new DiagnosticModuleForJ2C();
        diagnosticModuleForJ2C.validate();
    }
}

