/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.csi.EJBJ2CHandleLink;
import com.ibm.ejs.j2c.ConnectorRuntime;
import com.ibm.ejs.j2c.J2CGlobalConfigProperties;
import com.ibm.ejs.j2c.MCWrapper;
import com.ibm.ejs.j2c.MCWrapperList;
import com.ibm.ejs.j2c.MCWrapperPool;
import com.ibm.ejs.j2c.PoolManager;
import com.ibm.ejs.j2c.ThreadSupportedCleanupAndDestroy;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.ce.j2c.ConnectionWaitTimeoutException;
import com.ibm.websphere.pmi.J2CPerf;
import com.ibm.websphere.pmi.reqmetrics.PmiReqMetrics;
import com.ibm.ws.Transaction.SynchronizationProvider;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rasdiag.AlertController;
import com.ibm.ws.rsadapter.exceptions.RRAInternalResourceException;
import com.ibm.ws.rsadapter.spi.WSManagedConnection;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import com.ibm.ws.security.util.AccessController;
import java.io.PrintWriter;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.DissociatableManagedConnection;
import javax.resource.spi.LazyEnlistableManagedConnection;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAllocationException;
import javax.security.auth.Subject;

public final class FreePool {
    private static final TraceComponent tc = Tr.register(FreePool.class, "WAS.j2c", "com.ibm.ws.j2c.resources.J2CAMessages");
    protected final MCWrapperList mcWrapperList;
    private MCWrapperPool _mcWrapperPool = null;
    private final String nl = ConnectorRuntime.nl;
    private J2CPerf pmiData = null;
    private ManagedConnectionFactory _managedFactory = null;
    protected Object freeConnectionLockObject = new Object();
    private PoolManager pm = null;
    protected int numberOfConnectionsInFreePool = 0;
    protected int numberOfConnectionsAssignedToThisFreePool = 0;
    private int fatalErrorNotificationTime = 0;
    private static final boolean _mcWrapperDoesNotExistInFreePool = false;
    private static final boolean _synchronizeInMethod = true;
    private static final boolean _notifyWaiter = false;
    private static final boolean _decrementTotalCounter = true;
    protected int fop_gets = 0;
    protected int fnop_gets = 0;
    protected int freePoolQueuedRequests = 0;
    protected int freePoolCreateManagedConnection = 0;
    protected int numberOfClaimedVictims = 0;
    protected int numberOfClaimedVictims_CRI_Only_Mismatch = 0;
    protected int numberOfClaimedVictims_Subject_Only_Mismatch = 0;
    protected int numberOfClaimedVictims_CRI_Subject_Mismatch = 0;
    protected int numberOfClaimedVictims_MM_Only_Mismatch = 0;
    protected int fop_get_notfound = 0;
    protected int fnop_get_notfound = 0;
    boolean check_WSRdbManagedConnectionImpl = true;
    private J2CGlobalConfigProperties gConfigProps = null;

    public FreePool(int n, MCWrapperPool mCWrapperPool, J2CPerf j2CPerf, ManagedConnectionFactory managedConnectionFactory, PoolManager poolManager, J2CGlobalConfigProperties j2CGlobalConfigProperties) {
        if (n < 1) {
            n = 100;
        }
        this.mcWrapperList = new MCWrapperList(n);
        this._mcWrapperPool = mCWrapperPool;
        this.pmiData = j2CPerf;
        this._managedFactory = managedConnectionFactory;
        this.pm = poolManager;
        this.gConfigProps = j2CGlobalConfigProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueRequest(long l) throws ResourceAllocationException, ConnectionWaitTimeoutException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "queueRequest");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "waitTimeout is " + l);
        }
        if (l < 0L) {
            Tr.error(tc, "POOL_MANAGER_EXCP_CCF2_0001_J2CA0045", new Object[]{"queueRequest", this.gConfigProps.pmiName});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "Abnormal exit of queueRequest");
            }
            ConnectionWaitTimeoutException connectionWaitTimeoutException = new ConnectionWaitTimeoutException("Connection not available, Timed out waiting. -1 used for wait timeout");
            FFDCFilter.processException((Throwable)((Object)connectionWaitTimeoutException), "Max connections reached", "192", this.pm);
            Object object = this.pm.updateToPoolInProgressLockObject;
            synchronized (object) {
                --this.pm.activeRequest;
            }
            this.pm.processConnWaitTOEvent();
            throw connectionWaitTimeoutException;
        }
        if (tc.isDebugEnabled() || this.pm.requestGroupEnabled) {
            ++this.freePoolQueuedRequests;
            this.pm.processPoolRequestStats(9);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                String string = this.pm.gatherPoolStatisticalData();
                Tr.debug(tc, "Queueing Waiter for pool <" + this.gConfigProps.pmiName + ">. Current Pool Stats are:");
                Tr.debug(tc, string);
            }
        }
        try {
            if (this.pm.displayInfiniteWaitMessage) {
                Tr.info(tc, "INFINITE_CONNECTION_WAIT_TIMEOUT_J2CA0127", this.gConfigProps.pmiName);
                this.pm.displayInfiniteWaitMessage = false;
            }
            this.pm.waiterFreePoolLock.wait(l);
        }
        catch (InterruptedException interruptedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " PK65633 Got Interupted waiting for a connection");
            }
            Object object = this.pm.waiterFreePoolLock;
            synchronized (object) {
                --this.pm.waiterCount;
            }
            if (tc.isDebugEnabled() && this.pm.waiterCount == 0) {
                this.pm.waitersEndedTime = System.currentTimeMillis();
                Tr.debug(tc, "Waiters: requests for connections are no longer being queued. End Time:" + this.pm.waitersEndedTime);
                Tr.debug(tc, "Waiters: total time waiter were in queue: " + (this.pm.waitersEndedTime - this.pm.waitersStartedTime));
            }
            if (this.pm.loadGroupEnabled) {
                this.pm.processAvePoolLoad();
            }
            object = new ConnectionWaitTimeoutException("Connection not available got  InterruptedException while waiting");
            Object object2 = this.pm.updateToPoolInProgressLockObject;
            synchronized (object2) {
                --this.pm.activeRequest;
            }
            throw object;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "queueRequest");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void returnToFreePool(com.ibm.ws.j2c.MCWrapper mCWrapper) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "returnToFreePool, datasource: " + this.gConfigProps.pmiName);
        }
        if (mCWrapper.shouldBeDestroyed() || mCWrapper.hasFatalErrorNotificationOccurred(this.fatalErrorNotificationTime) || this.pm.agedTimeout != 0 && mCWrapper.hasAgedTimedOut(this.pm.agedTimeoutMillis)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                if (mCWrapper.shouldBeDestroyed()) {
                    Tr.debug(tc, "Connection destroy flag is set, removing connection " + mCWrapper);
                }
                if (mCWrapper.hasFatalErrorNotificationOccurred(this.fatalErrorNotificationTime)) {
                    Tr.debug(tc, "Fatal error occurred, removing connection " + mCWrapper);
                }
                if (this.pm.agedTimeout != 0 && mCWrapper.hasAgedTimedOut(this.pm.agedTimeoutMillis)) {
                    Tr.debug(tc, "Aged timeout exceeded, removing connection " + mCWrapper);
                }
                if (mCWrapper.isDestroyState()) {
                    Tr.debug(tc, "Mbean method purgePoolContents with option immediate was used.  Connection cleanup and destroy is being processed.");
                }
            }
            if (mCWrapper.isDestroyState()) {
                final FreePool freePool = this;
                final com.ibm.ws.j2c.MCWrapper mCWrapper2 = mCWrapper;
                this.pm.tscdList.add(AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                    public Object run() {
                        ThreadSupportedCleanupAndDestroy threadSupportedCleanupAndDestroy = new ThreadSupportedCleanupAndDestroy(((FreePool)FreePool.this).pm.tscdList, freePool, mCWrapper2);
                        return threadSupportedCleanupAndDestroy;
                    }
                }));
            } else {
                this.cleanupAndDestroyMCWrapper(mCWrapper);
                this.removeMCWrapperFromList(mCWrapper, false, true, false, true);
                this._mcWrapperPool.releaseInstance(mCWrapper);
            }
        } else {
            try {
                mCWrapper.cleanup();
            }
            catch (Exception exception) {
                Object object;
                String string = exception.getLocalizedMessage();
                if (string != null && string.equals("Skip logging for this failing connection")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Connection failed, resource adapter requested skipping failure logging");
                    }
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "MCWrapper cleanup failed, datasource: " + this.gConfigProps.pmiName);
                    }
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.j2c.poolmanager.FreePool.returnToFreePool", "190", this);
                }
                try {
                    try {
                        this.pm.removeMcToMCWMap(mCWrapper.getManagedConnectionWithoutStateCheck());
                        mCWrapper.destroy();
                    }
                    catch (Exception exception2) {
                        FFDCFilter.processException((Throwable)exception2, "com.ibm.ejs.j2c.poolmanager.FreePool.returnToFreePool", "210", this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "datasource " + this.gConfigProps.pmiName + ": ResourceException", exception2);
                        }
                        Object var6_9 = null;
                        Object object5 = this.pm.waiterFreePoolLock;
                        synchronized (object5) {
                            Object object6 = this.pm.poolManagerTotalCountLock;
                            synchronized (object6) {
                                --this.pm.totalConnectionCount;
                                if (this.pm.surgeCounter > 0) {
                                    --this.pm.surgeCounter;
                                    if (this.pm.surgeModeAlertEnabled && this.pm.surgeCounter == 0) {
                                        AlertController.checkPoint(PoolManager.alertLogger, this.pm, this.gConfigProps.surgeModeAlertConfig);
                                    }
                                }
                                if (this.pm.loadGroupEnabled) {
                                    this.pm.processAvePoolLoad();
                                }
                            }
                            if (this.pm.waiterCount <= 0) return;
                            this.pm.waiterFreePoolLock.notify();
                            return;
                        }
                    }
                    Object var6_8 = null;
                    object = this.pm.waiterFreePoolLock;
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    Object object2 = this.pm.waiterFreePoolLock;
                    synchronized (object2) {
                        Object object3 = this.pm.poolManagerTotalCountLock;
                        synchronized (object3) {
                            --this.pm.totalConnectionCount;
                            if (this.pm.surgeCounter > 0) {
                                --this.pm.surgeCounter;
                                if (this.pm.surgeModeAlertEnabled && this.pm.surgeCounter == 0) {
                                    AlertController.checkPoint(PoolManager.alertLogger, this.pm, this.gConfigProps.surgeModeAlertConfig);
                                }
                            }
                            if (this.pm.loadGroupEnabled) {
                                this.pm.processAvePoolLoad();
                            }
                        }
                        if (this.pm.waiterCount <= 0) throw throwable;
                        this.pm.waiterFreePoolLock.notify();
                        throw throwable;
                    }
                }
                synchronized (object) {
                    Object object4 = this.pm.poolManagerTotalCountLock;
                    synchronized (object4) {
                        --this.pm.totalConnectionCount;
                        if (this.pm.surgeCounter > 0) {
                            --this.pm.surgeCounter;
                            if (this.pm.surgeModeAlertEnabled && this.pm.surgeCounter == 0) {
                                AlertController.checkPoint(PoolManager.alertLogger, this.pm, this.gConfigProps.surgeModeAlertConfig);
                            }
                        }
                        if (this.pm.loadGroupEnabled) {
                            this.pm.processAvePoolLoad();
                        }
                    }
                    if (this.pm.waiterCount <= 0) return;
                    this.pm.waiterFreePoolLock.notify();
                    return;
                }
            }
            if (this.pmiData != null && !mCWrapper.isParkedWrapper()) {
                this.pmiData.managedConnectionFreed();
            }
            Object object = this.pm.waiterFreePoolLock;
            synchronized (object) {
                if (this.pm.waiterCount > 0 && this.pm.waiterCount > this.pm.mcWrapperWaiterList.size()) {
                    this.pm.mcWrapperWaiterList.add(mCWrapper);
                    mCWrapper.setPoolState(4);
                    this.pm.waiterFreePoolLock.notify();
                } else {
                    Object object7 = this.freeConnectionLockObject;
                    synchronized (object7) {
                        this.mcWrapperList.add(mCWrapper);
                        mCWrapper.setPoolState(1);
                        if (this.pm.loadGroupEnabled) {
                            this.pm.processAvePoolLoad();
                        }
                    }
                }
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return;
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "returnToFreePool");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMCWrapperFromList(com.ibm.ws.j2c.MCWrapper mCWrapper, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeMCWrapperFromList");
        }
        if (bl2) {
            Object object = this.pm.waiterFreePoolLock;
            synchronized (object) {
                Object object2 = this.freeConnectionLockObject;
                synchronized (object2) {
                    if (bl) {
                        this.mcWrapperList.remove(mCWrapper);
                        mCWrapper.setPoolState(0);
                    }
                    --this.numberOfConnectionsAssignedToThisFreePool;
                    if (bl4) {
                        Object object3 = this.pm.poolManagerTotalCountLock;
                        synchronized (object3) {
                            --this.pm.totalConnectionCount;
                            if (this.pm.surgeCounter > 0) {
                                --this.pm.surgeCounter;
                                if (this.pm.surgeModeAlertEnabled && this.pm.surgeCounter == 0) {
                                    AlertController.checkPoint(PoolManager.alertLogger, this.pm, this.gConfigProps.surgeModeAlertConfig);
                                }
                            }
                        }
                    }
                    if (!bl3) {
                        this.pm.waiterFreePoolLock.notify();
                    }
                }
            }
        }
        if (bl) {
            this.mcWrapperList.remove(mCWrapper);
            mCWrapper.setPoolState(0);
            --this.numberOfConnectionsAssignedToThisFreePool;
        }
        if (bl4) {
            Object object = this.pm.poolManagerTotalCountLock;
            synchronized (object) {
                --this.pm.totalConnectionCount;
            }
        }
        if (this.pm.loadGroupEnabled) {
            this.pm.processAvePoolLoad();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeMCWrapperFromList");
        }
    }

    protected boolean cleanupAndDestroyMCWrapper(com.ibm.ws.j2c.MCWrapper mCWrapper) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanupAndDestroyMCWrapper");
        }
        boolean bl = false;
        this.pm.removeMcToMCWMap(mCWrapper.getManagedConnectionWithoutStateCheck());
        try {
            mCWrapper.cleanup();
        }
        catch (Exception exception) {
            bl = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "MCWrapper cleanup failed, datasource: " + this.gConfigProps.pmiName);
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.j2c.poolmanager.FreePool.cleanupAndDestroyMCWrapper", "1140", this);
        }
        try {
            mCWrapper.destroy();
        }
        catch (Exception exception) {
            bl = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "MCWrapper destroy failed, datasource: " + this.gConfigProps.pmiName);
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.j2c.poolmanager.FreePool.cleanupAndDestroyMCWrapper", "300", this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanupAndDestroyMCWrapper");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeParkedConnection() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeParkedConnection");
        }
        boolean bl = false;
        if (this.pm.parkedMCWrapper != null) {
            Object object = this.pm.parkedConnectionLockObject;
            synchronized (object) {
                if (this.pm.parkedMCWrapper != null) {
                    bl = this.cleanupAndDestroyMCWrapper(this.pm.parkedMCWrapper);
                    if (!bl) {
                        this._mcWrapperPool.releaseInstance(this.pm.parkedMCWrapper);
                    }
                    this.pm.parkedMCWrapper = null;
                    this.pm.createParkedConnection = true;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Reset the createParkedConnection flag to recreate a new parked connection");
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeParkedConnection");
        }
    }

    protected int getTotalConnectionCount() {
        return this.pm.totalConnectionCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected com.ibm.ws.j2c.MCWrapper getFreeConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo, int n) throws ResourceAllocationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getFreeConnection");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "datasource: " + this.gConfigProps.pmiName);
            }
        }
        com.ibm.ws.j2c.MCWrapper mCWrapper = null;
        com.ibm.ws.j2c.MCWrapper mCWrapper2 = null;
        com.ibm.ws.j2c.MCWrapper mCWrapper3 = null;
        int n2 = 0;
        int n3 = 0;
        Object object = this.freeConnectionLockObject;
        synchronized (object) {
            n2 = this.mcWrapperList.size();
            if (n2 > 0) {
                n3 = n2 - 1;
                mCWrapper2 = (com.ibm.ws.j2c.MCWrapper)this.mcWrapperList.remove(n3);
                mCWrapper2.setPoolState(0);
            }
        }
        if (mCWrapper2 != null) {
            Object object2;
            if (n == mCWrapper2.getSubjectCRIHashCode()) {
                mCWrapper = this.getMCWrapperFromMatch(subject, connectionRequestInfo, this._managedFactory, mCWrapper2);
                if (((MCWrapper)mCWrapper2).do_not_reuse_mcw) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Connection error occurred for this mcw " + mCWrapper2 + ", mcw will not be reuse");
                    }
                    object = this.pm.waiterFreePoolLock;
                    synchronized (object) {
                        this.cleanupAndDestroyMCWrapper(mCWrapper2);
                        object2 = this.freeConnectionLockObject;
                        synchronized (object2) {
                            --this.numberOfConnectionsAssignedToThisFreePool;
                        }
                        object2 = this.pm.poolManagerTotalCountLock;
                        synchronized (object2) {
                            --this.pm.totalConnectionCount;
                        }
                        if (this.pm.waiterCount > 0 && this.pm.waiterCount > this.pm.mcWrapperWaiterList.size()) {
                            this.pm.waiterFreePoolLock.notify();
                        }
                    }
                }
            }
            if (mCWrapper == null) {
                object = this.pm.waiterFreePoolLock;
                synchronized (object) {
                    object2 = this.freeConnectionLockObject;
                    synchronized (object2) {
                        n2 = this.mcWrapperList.size();
                        if (n2 > 0) {
                            for (int i = n3 = n2 - 1; i >= 0; --i) {
                                mCWrapper3 = (com.ibm.ws.j2c.MCWrapper)this.mcWrapperList.get(i);
                                if (n == mCWrapper3.getSubjectCRIHashCode()) {
                                    mCWrapper = this.getMCWrapperFromMatch(subject, connectionRequestInfo, this._managedFactory, mCWrapper3);
                                    if (((MCWrapper)mCWrapper3).do_not_reuse_mcw) {
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Connection error occurred for this mcw " + mCWrapper3 + ", mcw will not be reuse");
                                        }
                                        this.mcWrapperList.remove(i);
                                        this.cleanupAndDestroyMCWrapper(mCWrapper3);
                                        Object object3 = this.freeConnectionLockObject;
                                        synchronized (object3) {
                                            --this.numberOfConnectionsAssignedToThisFreePool;
                                        }
                                        object3 = this.pm.poolManagerTotalCountLock;
                                        synchronized (object3) {
                                            --this.pm.totalConnectionCount;
                                        }
                                        if (this.pm.waiterCount > 0 && this.pm.waiterCount > this.pm.mcWrapperWaiterList.size()) {
                                            this.pm.waiterFreePoolLock.notify();
                                        }
                                    }
                                }
                                if (mCWrapper == null) continue;
                                this.mcWrapperList.remove(i);
                                mCWrapper.setPoolState(0);
                                break;
                            }
                        }
                    }
                    if (!((MCWrapper)mCWrapper2).do_not_reuse_mcw) {
                        if (this.pm.waiterCount > 0 && this.pm.waiterCount > this.pm.mcWrapperWaiterList.size()) {
                            this.pm.mcWrapperWaiterList.add(mCWrapper2);
                            this.pm.waiterFreePoolLock.notify();
                        } else {
                            object2 = this.freeConnectionLockObject;
                            synchronized (object2) {
                                this.mcWrapperList.add(mCWrapper2);
                                mCWrapper2.setPoolState(1);
                            }
                        }
                    }
                    if ((tc.isDebugEnabled() || this.pm.requestGroupEnabled) && mCWrapper != null) {
                        ++this.fnop_gets;
                        this.pm.processPoolRequestStats(6);
                    }
                }
            }
            if (tc.isDebugEnabled() || this.pm.requestGroupEnabled) {
                ++this.fop_gets;
                this.pm.processPoolRequestStats(5);
            }
        }
        if ((tc.isDebugEnabled() || this.pm.requestGroupEnabled) && mCWrapper == null) {
            ++this.fnop_get_notfound;
            this.pm.processPoolRequestStats(8);
        }
        if (this.pm.loadGroupEnabled) {
            this.pm.processAvePoolLoad();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                if (mCWrapper != null) {
                    Tr.debug(tc, "Returning mcWrapper " + mCWrapper);
                } else {
                    Tr.debug(tc, "MCWrapper was not found in Free Pool");
                }
            }
            Tr.exit(tc, "getFreeConnection");
        }
        return mCWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected com.ibm.ws.j2c.MCWrapper createOrWaitForConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo, int n, int n2, int n3, int n4, boolean bl, boolean bl2, int n5) throws ResourceAllocationException, ConnectionWaitTimeoutException {
        long l;
        boolean bl3;
        Object object;
        block106: {
            block105: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.entry(tc, "createOrWaitForConnection");
                }
                object = null;
                bl3 = false;
                if (bl) break block105;
                if (this.pm.maxConnections == 0 || this.pm.totalConnectionCount < this.pm.maxConnections) {
                    Object object2 = this.pm.poolManagerTotalCountLock;
                    // MONITORENTER : object2
                    if (this.pm.totalConnectionCount + this.pm.surgeCounter < this.pm.maxConnections || this.pm.maxConnections == 0) {
                        if (!this.pm.surgeEnabled || this.pm.totalConnectionCount < this.pm.surgeConnections) {
                            ++this.pm.totalConnectionCount;
                            bl3 = true;
                            if (this.pm.loadGroupEnabled) {
                                this.pm.processAvePoolLoad();
                            }
                        } else {
                            ++this.pm.surgeCounter;
                            if (this.pm.surgeModeAlertEnabled && this.pm.surgeCounter == 1) {
                                AlertController.checkPoint(PoolManager.alertLogger, this.pm, this.gConfigProps.surgeModeAlertConfig);
                            }
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "TotalConnectionCount is " + this.pm.totalConnectionCount);
                        }
                    }
                    // MONITOREXIT : object2
                }
                break block106;
            }
            bl3 = true;
        }
        long l2 = 0L;
        long l3 = 0L;
        if (!bl3) {
            long l4 = l = (long)(this.pm.connectionTimeout * 1000);
            long l5 = 0L;
            Object object3 = this.pm.waiterFreePoolLock;
            // MONITORENTER : object3
            while (true) {
                Object object4;
                block104: {
                    Object object5;
                    int n6;
                    int n7;
                    if (l2 == 0L) {
                        object4 = null;
                        for (n7 = 0; n7 < n2; ++n7) {
                            for (n6 = 0; n6 < n4; ++n6) {
                                if (this.pm.freePool[n6][n7].mcWrapperList.size() <= 0) continue;
                                object5 = this.pm.freePool[n6][n7].freeConnectionLockObject;
                                // MONITORENTER : object5
                                if (this.pm.freePool[n6][n7].mcWrapperList.size() > 0) {
                                    object4 = (com.ibm.ws.j2c.MCWrapper)this.pm.freePool[n6][n7].mcWrapperList.remove(0);
                                    object4.setPoolState(0);
                                    object = this.pm.freePool[n6][n7].getMCWrapperFromMatch(subject, connectionRequestInfo, this._managedFactory, (com.ibm.ws.j2c.MCWrapper)object4);
                                    if (((MCWrapper)object4).do_not_reuse_mcw && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Connection error occurred for this mcw " + object4 + ", mcw will not be reuse");
                                    }
                                    if (object == null) {
                                        if (this.gConfigProps.sendClaimedVictomToGetConnection) {
                                            ((WSManagedConnection)object4.getManagedConnection()).setClaimedVictim();
                                            object = object4;
                                        } else {
                                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                                Tr.debug(tc, "Claiming victim " + object4);
                                            }
                                            if (tc.isDebugEnabled() || this.pm.requestGroupEnabled) {
                                                ++this.numberOfClaimedVictims;
                                                boolean bl4 = false;
                                                boolean bl5 = false;
                                                if (!connectionRequestInfo.equals(object.getCRI())) {
                                                    bl5 = true;
                                                }
                                                Equals equals = new Equals();
                                                equals.setSubjects(subject, object.getSubject());
                                                if (!((Boolean)AccessController.doPrivileged((PrivilegedAction)equals)).booleanValue()) {
                                                    bl4 = true;
                                                }
                                                if (bl5 && bl4) {
                                                    ++this.numberOfClaimedVictims_CRI_Subject_Mismatch;
                                                    this.pm.processPoolRequestStats(13);
                                                } else if (bl5) {
                                                    ++this.numberOfClaimedVictims_CRI_Only_Mismatch;
                                                    this.pm.processPoolRequestStats(11);
                                                } else if (bl4) {
                                                    ++this.numberOfClaimedVictims_Subject_Only_Mismatch;
                                                    this.pm.processPoolRequestStats(12);
                                                } else {
                                                    ++this.numberOfClaimedVictims_MM_Only_Mismatch;
                                                    this.pm.processPoolRequestStats(14);
                                                }
                                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "A Victim has been claimed for connection pool: " + this.gConfigProps.pmiName);
                                                    Tr.debug(tc, "  Total Victim count                                    =  " + Integer.toString(this.numberOfClaimedVictims));
                                                    Tr.debug(tc, "    Victims due to both CRI and Subject Mismatch        =  " + Integer.toString(this.numberOfClaimedVictims_CRI_Subject_Mismatch));
                                                    Tr.debug(tc, "    Victims due to CRI mismatch only                    =  " + Integer.toString(this.numberOfClaimedVictims_CRI_Only_Mismatch));
                                                    Tr.debug(tc, "    Victims due to Subject mismatch only                =  " + Integer.toString(this.numberOfClaimedVictims_Subject_Only_Mismatch));
                                                    Tr.debug(tc, "    Victims due to failed matchManagedConnection() only =  " + Integer.toString(this.numberOfClaimedVictims_MM_Only_Mismatch));
                                                }
                                            }
                                            this.pm.freePool[n6][n7].cleanupAndDestroyMCWrapper((com.ibm.ws.j2c.MCWrapper)object4);
                                            --this.pm.freePool[n6][n7].numberOfConnectionsAssignedToThisFreePool;
                                            this._mcWrapperPool.releaseInstance((com.ibm.ws.j2c.MCWrapper)object4);
                                        }
                                    }
                                    // MONITOREXIT : object5
                                    break;
                                }
                                if (this.pm.loadGroupEnabled) {
                                    this.pm.processAvePoolLoad();
                                }
                                // MONITOREXIT : object5
                            }
                            if (object4 != null) break;
                        }
                        if (object4 != null) break;
                        if (tc.isDebugEnabled()) {
                            if (this.pm.waiterCount == 0) {
                                this.pm.waitersStartedTime = System.currentTimeMillis();
                            }
                            Tr.debug(tc, "Waiters: requests for connections are being queued. Start Time" + this.pm.waitersStartedTime);
                        }
                        ++this.pm.waiterCount;
                        if (this.pm.loadGroupEnabled) {
                            this.pm.processAvePoolLoad();
                        }
                        if (this.pmiData != null) {
                            this.pmiData.beginWaitForManagedConnection();
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "waitStartTime is zero.  waiterCount incremented to " + this.pm.waiterCount);
                        }
                        l2 = System.currentTimeMillis();
                        this.queueRequest(l);
                        l3 = System.currentTimeMillis();
                    }
                    if (this.pm.mcWrapperWaiterList.size() > 0) {
                        object = this.pm.getFreeWaiterConnection(subject, connectionRequestInfo);
                        if (object == null) {
                            object4 = (com.ibm.ws.j2c.MCWrapper)this.pm.mcWrapperWaiterList.remove(0);
                            if (this.gConfigProps.sendClaimedVictomToGetConnection) {
                                ((WSManagedConnection)object4.getManagedConnection()).setClaimedVictim();
                                object = object4;
                                break block104;
                            } else {
                                if (tc.isDebugEnabled() || this.pm.requestGroupEnabled) {
                                    ++this.numberOfClaimedVictims;
                                    n7 = 0;
                                    n6 = 0;
                                    if (!connectionRequestInfo.equals(object4.getCRI())) {
                                        n6 = 1;
                                    }
                                    object5 = new Equals();
                                    ((Equals)object5).setSubjects(subject, object4.getSubject());
                                    if (!((Boolean)AccessController.doPrivileged((PrivilegedAction)object5)).booleanValue()) {
                                        n7 = 1;
                                    }
                                    if (n6 != 0 && n7 != 0) {
                                        ++this.numberOfClaimedVictims_CRI_Subject_Mismatch;
                                        this.pm.processPoolRequestStats(13);
                                    } else if (n6 != 0) {
                                        ++this.numberOfClaimedVictims_CRI_Only_Mismatch;
                                        this.pm.processPoolRequestStats(11);
                                    } else if (n7 != 0) {
                                        ++this.numberOfClaimedVictims_Subject_Only_Mismatch;
                                        this.pm.processPoolRequestStats(12);
                                    } else {
                                        ++this.numberOfClaimedVictims_MM_Only_Mismatch;
                                        this.pm.processPoolRequestStats(14);
                                    }
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, this.pm.gatherClaimVictimStatisticalData());
                                    }
                                }
                                object4.setPoolState(0);
                                this.cleanupAndDestroyMCWrapper((com.ibm.ws.j2c.MCWrapper)object4);
                                this._mcWrapperPool.releaseInstance((com.ibm.ws.j2c.MCWrapper)object4);
                                --this.pm.waiterCount;
                                if (tc.isDebugEnabled() && this.pm.waiterCount == 0) {
                                    this.pm.waitersEndedTime = System.currentTimeMillis();
                                    Tr.debug(tc, "Waiters: requests for connections are no longer being queued. End Time:" + this.pm.waitersEndedTime);
                                    Tr.debug(tc, "Waiters: total time waiter were in queue: " + (this.pm.waitersEndedTime - this.pm.waitersStartedTime));
                                }
                                if (this.pm.loadGroupEnabled) {
                                    this.pm.processAvePoolLoad();
                                }
                                if (this.pmiData == null) break;
                                this.pmiData.endWaitForManagedConnection(l3 - l2);
                                break;
                            }
                        }
                        if (((MCWrapper)object).do_not_reuse_mcw) {
                            object = null;
                            --this.pm.waiterCount;
                            if (tc.isDebugEnabled()) {
                                if (this.pm.waiterCount == 0) {
                                    this.pm.waitersEndedTime = System.currentTimeMillis();
                                }
                                Tr.debug(tc, "Waiters: requests for connections are no longer being queued. End Time:" + this.pm.waitersEndedTime);
                                Tr.debug(tc, "Waiters: total time waiter were in queue: " + (this.pm.waitersEndedTime - this.pm.waitersStartedTime));
                            }
                            if (this.pm.loadGroupEnabled) {
                                this.pm.processAvePoolLoad();
                            }
                            if (this.pmiData == null) break;
                            this.pmiData.endWaitForManagedConnection(l3 - l2);
                            break;
                        }
                    }
                }
                if (object != null) {
                    --this.pm.waiterCount;
                    if (tc.isDebugEnabled() && this.pm.waiterCount == 0) {
                        this.pm.waitersEndedTime = System.currentTimeMillis();
                        Tr.debug(tc, "Waiters: requests for connections are no longer being queued. End Time:" + this.pm.waitersEndedTime);
                        Tr.debug(tc, "Waiters: total time waiter were in queue: " + (this.pm.waitersEndedTime - this.pm.waitersStartedTime));
                    }
                    if (this.pm.loadGroupEnabled) {
                        this.pm.processAvePoolLoad();
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        long l6 = l3 - l2;
                        Tr.debug(tc, "Time waited was " + l6 + " (milliseconds).  waiterCount decremented to " + this.pm.waiterCount);
                    }
                    if (this.pmiData == null) break;
                    this.pmiData.endWaitForManagedConnection(l3 - l2);
                    break;
                }
                object4 = this.pm.poolManagerTotalCountLock;
                // MONITORENTER : object4
                if (this.pm.totalConnectionCount < this.pm.maxConnections) {
                    if (!this.pm.surgeEnabled || this.pm.totalConnectionCount < this.pm.surgeConnections) {
                        ++this.pm.totalConnectionCount;
                        bl3 = true;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Total connection count is " + this.pm.totalConnectionCount);
                        }
                    } else if (l2 != 0L) {
                        long l7 = 10L;
                        long l8 = l3 - l2;
                        l5 += l8;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "waitStartTime is " + l2 + " and timeWaited is " + l8 + " total time waited is " + l5);
                        }
                        if (l - l8 <= l7) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Surge mode, this thread timed out.  We can not create a connection.");
                                Tr.debug(tc, "Total connection count is " + this.pm.totalConnectionCount);
                            }
                        } else {
                            ++this.pm.totalConnectionCount;
                            bl3 = true;
                            --this.pm.surgeCounter;
                            if (this.pm.surgeModeAlertEnabled && this.pm.surgeCounter == 0) {
                                AlertController.checkPoint(PoolManager.alertLogger, this.pm, this.gConfigProps.surgeModeAlertConfig);
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Surge mode, total connection count is " + this.pm.totalConnectionCount);
                            }
                        }
                    }
                }
                if (this.pm.loadGroupEnabled) {
                    this.pm.processAvePoolLoad();
                }
                // MONITOREXIT : object4
                if (bl3) {
                    --this.pm.waiterCount;
                    if (tc.isDebugEnabled() && this.pm.waiterCount == 0) {
                        this.pm.waitersEndedTime = System.currentTimeMillis();
                        Tr.debug(tc, "Waiters: requests for connections are no longer being queued. End Time:" + this.pm.waitersEndedTime);
                        Tr.debug(tc, "Waiters: total time waiter were in queue: " + (this.pm.waitersEndedTime - this.pm.waitersStartedTime));
                    }
                    if (this.pmiData != null) {
                        this.pmiData.endWaitForManagedConnection(l3 - l2);
                    }
                    if (!this.pm.loadGroupEnabled) break;
                    this.pm.processAvePoolLoad();
                    break;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "We didn't find or are not going to create a connection.");
                }
                if (l2 == 0L) continue;
                long l9 = this.pm.connectionTimeout * 1000;
                if (l4 != l9) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Changing connection timeout value from " + l4 + " to " + l9 + " the (orig_waitTimeout - reloeadedTime) is " + (l9 - l4) + " waitTimeout + (orig_waitTimeout - reloeadedTime) is " + (l + (l9 - l4)));
                    }
                    l += l9 - l4;
                    l4 = l9;
                }
                long l10 = 10L;
                long l11 = l3 - l2;
                l5 += l11;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "waitStartTime is " + l2 + " and timeWaited is " + l11 + " waitTimeout is " + l + " total time waited is " + l5);
                }
                if (l - l11 <= l10) {
                    --this.pm.waiterCount;
                    if (tc.isDebugEnabled() && this.pm.waiterCount == 0) {
                        this.pm.waitersEndedTime = System.currentTimeMillis();
                        Tr.debug(tc, "Waiters: requests for connections are no longer being queued. End Time:" + this.pm.waitersEndedTime);
                        Tr.debug(tc, "Waiters: total time waiter were in queue: " + (this.pm.waitersEndedTime - this.pm.waitersStartedTime));
                    }
                    if (this.pm.loadGroupEnabled) {
                        this.pm.processAvePoolLoad();
                    }
                    if (this.pmiData != null) {
                        this.pmiData.endWaitForManagedConnection(l3 - l2);
                        this.pmiData.managedConnectionFault();
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Timeout.  Decremented waiterCount, which is now " + this.pm.waiterCount + " on datasource " + this.gConfigProps.pmiName);
                    }
                    Tr.error(tc, "POOL_MANAGER_EXCP_CCF2_0001_J2CA0045", new Object[]{"createOrWaitForConnection", this.gConfigProps.pmiName});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.debug(tc, "Abnormal exit of queueRequest");
                        Tr.exit(tc, "createOrWaitForConnection");
                    }
                    ConnectionWaitTimeoutException connectionWaitTimeoutException = new ConnectionWaitTimeoutException("Connection not available, Timed out waiting for " + l5);
                    FFDCFilter.processException((Throwable)((Object)connectionWaitTimeoutException), "Max connections reached", "869", this.pm);
                    Object object6 = this.pm.updateToPoolInProgressLockObject;
                    // MONITORENTER : object6
                    --this.pm.activeRequest;
                    // MONITOREXIT : object6
                    this.pm.processConnWaitTOEvent();
                    throw connectionWaitTimeoutException;
                }
                l -= l3 - l2;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "not finished waiting yet.  New waitTimeout is " + l);
                }
                l2 = System.currentTimeMillis();
                this.queueRequest(l);
                l3 = System.currentTimeMillis();
            }
            // MONITOREXIT : object3
        }
        if (object == null) {
            object = this.createManagedConnectionWithMCWrapper(subject, connectionRequestInfo, this._mcWrapperPool, bl2, n5);
            if (object == null) {
                Tr.error(tc, "FREEPOOL_GETFREECONNECTION_ERROR_J2CA1002", new Object[]{object, this.gConfigProps.pmiName});
                ResourceAllocationException resourceAllocationException = new ResourceAllocationException("getFreeConnection: MCWrapper is null.");
                FFDCFilter.processException((Throwable)resourceAllocationException, "com.ibm.ejs.j2c.poolmanager.FreePool.createOrWaitForConnection", "674", new Object[]{this, this.pm});
                Object object7 = this.pm.updateToPoolInProgressLockObject;
                // MONITORENTER : object7
                --this.pm.activeRequest;
                // MONITOREXIT : object7
                throw resourceAllocationException;
            }
            object.setHashMapBucket(n3);
            object.setMCWrapperList(this.mcWrapperList);
            object.setFreePoolBucket(n);
            ++this.numberOfConnectionsAssignedToThisFreePool;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning mcWrapper");
            }
        }
        if (this.pm.gConfigProps.callResourceAdapterStatMethods && (l = l3 - l2) > 0L) {
            ((WSRdbManagedConnectionImpl)object.getManagedConnection()).setManagedConnectionWaitTime(l);
        }
        if (!TraceComponent.isAnyTracingEnabled()) return object;
        if (!tc.isEntryEnabled()) return object;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (object != null) {
                Tr.debug(tc, "Returning mcWrapper " + object);
            } else {
                Tr.debug(tc, "MCWrapper is null");
            }
        }
        Tr.exit(tc, "createOrWaitForConnection");
        return object;
    }

    private int smallestFreePoolBucket(int n, int n2, int n3) {
        int n4;
        int n5 = 0;
        int n6 = 0;
        int n7 = Integer.MAX_VALUE;
        int n8 = n;
        for (n4 = 0; n4 < n2; ++n4) {
            n5 = this.pm.freePool[n3][n4].numberOfConnectionsAssignedToThisFreePool;
            if (n5 > n6) {
                n6 = n5;
            }
            if (n5 >= n7) continue;
            n7 = n5;
            n8 = n4;
        }
        n4 = n6 - n7;
        if (n4 > 0) {
            n = n8;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private com.ibm.ws.j2c.MCWrapper getMCWrapperFromMatch(Subject subject, ConnectionRequestInfo connectionRequestInfo, ManagedConnectionFactory managedConnectionFactory, com.ibm.ws.j2c.MCWrapper mCWrapper) throws ResourceAllocationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getMCWrapperFromMatch" + mCWrapper);
        }
        com.ibm.ws.j2c.MCWrapper mCWrapper2 = null;
        ManagedConnection managedConnection = null;
        HashSet<ManagedConnection> hashSet = new HashSet<ManagedConnection>(1);
        try {
            hashSet.add(mCWrapper.getManagedConnection());
        }
        catch (IllegalStateException illegalStateException) {
            Object object = this.freeConnectionLockObject;
            synchronized (object) {
                this.mcWrapperList.remove(mCWrapper);
                throw illegalStateException;
            }
        }
        Object object = null;
        if (PmiReqMetrics.isComponentEnabled(this.pm.gConfigProps.reqMetricID)) {
            object = PmiReqMetrics.reqStart(this.pm.gConfigProps.reqMetricID, 2, new String[]{"javax.resource.spi.ManagedConnectionFactory", "matchManagedConnections(Set, Subject, ConnectionRequestInfo)"});
        }
        int n = 2;
        try {
            try {
                int n2 = mCWrapper.getPoolState();
                mCWrapper.setPoolState(50);
                managedConnection = managedConnectionFactory.matchManagedConnections(hashSet, subject, connectionRequestInfo);
                mCWrapper.setPoolState(n2);
                n = 0;
            }
            catch (ResourceException n2) {
                FFDCFilter.processException((Throwable)n2, "com.ibm.ejs.j2c.poolmanager.FreePool.getMCWrapperFromMatch", "786", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "datasource " + this.gConfigProps.pmiName + ": ResourceException " + (Object)((Object)n2));
                    Tr.debug(tc, "Throwing ResourceAllocationException...");
                    Tr.debug(tc, "match(), Pool contents ==> " + this);
                }
                ResourceAllocationException resourceAllocationException = new ResourceAllocationException(n2.getMessage(), n2.getErrorCode());
                resourceAllocationException.initCause(n2.getCause());
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "Abnormal exit from method match");
                }
                Object object2 = this.pm.updateToPoolInProgressLockObject;
                synchronized (object2) {
                    --this.pm.activeRequest;
                    throw resourceAllocationException;
                }
            }
            Object var15_14 = null;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            if (!PmiReqMetrics.isComponentEnabled(this.pm.gConfigProps.reqMetricID)) throw throwable;
            Properties properties = null;
            int n3 = PmiReqMetrics.getTranDetailLevel(object, this.pm.gConfigProps.reqMetricID);
            if (n3 == 3) {
                properties = (Properties)this.gConfigProps.raMetaDataProps.clone();
            }
            if (properties == null) {
                PmiReqMetrics.reqStop(object, this.pm.gConfigProps.reqMetricID, 2, n);
                throw throwable;
            }
            PmiReqMetrics.reqStop(object, this.pm.gConfigProps.reqMetricID, 2, n, properties);
            throw throwable;
        }
        if (PmiReqMetrics.isComponentEnabled(this.pm.gConfigProps.reqMetricID)) {
            Properties properties = null;
            int n3 = PmiReqMetrics.getTranDetailLevel(object, this.pm.gConfigProps.reqMetricID);
            if (n3 == 3) {
                properties = (Properties)this.gConfigProps.raMetaDataProps.clone();
            }
            if (properties == null) {
                PmiReqMetrics.reqStop(object, this.pm.gConfigProps.reqMetricID, 2, n);
            } else {
                PmiReqMetrics.reqStop(object, this.pm.gConfigProps.reqMetricID, 2, n, properties);
            }
        }
        if (managedConnection != null) {
            mCWrapper2 = mCWrapper;
        }
        if (!TraceComponent.isAnyTracingEnabled()) return mCWrapper2;
        if (!tc.isEntryEnabled()) return mCWrapper2;
        Tr.exit(tc, "getMCWrapperFromMatch" + mCWrapper2);
        return mCWrapper2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected com.ibm.ws.j2c.MCWrapper createManagedConnectionWithMCWrapper(Subject subject, ConnectionRequestInfo connectionRequestInfo, MCWrapperPool mCWrapperPool, boolean bl, int n) throws ResourceAllocationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createManagedConnectionWithMCWrapper");
        }
        ManagedConnection managedConnection = null;
        com.ibm.ws.j2c.MCWrapper mCWrapper = null;
        try {
            Object object;
            Object object2 = null;
            if (PmiReqMetrics.isComponentEnabled(this.pm.gConfigProps.reqMetricID)) {
                object2 = PmiReqMetrics.reqStart(this.pm.gConfigProps.reqMetricID, 2, new String[]{"javax.resource.spi.ManagedConnectionFactory", "createManagedConnection(Subject, ConnectionRequestInfo)"});
            }
            int n2 = 2;
            if (this.pm.gConfigProps.checkCMXOnce) {
                object = this.pm.gConfigProps.checkCMXOnceLock;
                synchronized (object) {
                    if (this.pm.gConfigProps.checkCMXOnce && this.pm.gConfigProps.isRRA && ((WSManagedConnectionFactoryImpl)this._managedFactory).isEndToEndMonitoringFeatureEnabled()) {
                        ((WSManagedConnectionFactoryImpl)this._managedFactory).setJ2CConfigPropertiesAndStatAccess(this.pm.gConfigProps);
                        this.pm.gConfigProps.setPoolManager(this.pm);
                        this.pm.gConfigProps.callResourceAdapterStatMethods = true;
                    }
                    this.pm.gConfigProps.checkCMXOnce = false;
                }
            }
            try {
                if (this.pm.stuckConnectionSupport) {
                    mCWrapper = mCWrapperPool.getInstance(managedConnection);
                    ((MCWrapper)mCWrapper).setStuckTimeStart();
                    managedConnection = this._managedFactory.createManagedConnection(subject, connectionRequestInfo);
                    try {
                        mCWrapper.setManagedConnection(managedConnection);
                    }
                    catch (NullPointerException nullPointerException) {
                        FFDCFilter.processException((Throwable)nullPointerException, "com.ibm.ejs.j2c.MCWrapperPool.getInstance", "207", this);
                        Tr.error(tc, "MCWRAPPER_GETINSTANCE_ERROR_J2CA0096", nullPointerException);
                        throw new IllegalStateException("Cannot setManagedConnection on null wrapper");
                    }
                } else {
                    managedConnection = this._managedFactory.createManagedConnection(subject, connectionRequestInfo);
                    mCWrapper = mCWrapperPool.getInstance(managedConnection);
                }
                n2 = 0;
                Object var13_22 = null;
                if (this.pm.stuckConnectionSupport) {
                    ((MCWrapper)mCWrapper).setStuckTimeEnd();
                }
            }
            catch (Throwable throwable) {
                Object var13_23 = null;
                if (this.pm.stuckConnectionSupport) {
                    ((MCWrapper)mCWrapper).setStuckTimeEnd();
                }
                if (!PmiReqMetrics.isComponentEnabled(this.pm.gConfigProps.reqMetricID)) throw throwable;
                Properties properties = null;
                int n3 = PmiReqMetrics.getTranDetailLevel(object2, this.pm.gConfigProps.reqMetricID);
                if (n3 == 2 || n3 == 3) {
                    properties = new Properties();
                }
                if (n3 == 3) {
                    properties = (Properties)this.gConfigProps.raMetaDataProps.clone();
                }
                if (properties == null) {
                    PmiReqMetrics.reqStop(object2, this.pm.gConfigProps.reqMetricID, 2, n2);
                    throw throwable;
                }
                PmiReqMetrics.reqStop(object2, this.pm.gConfigProps.reqMetricID, 2, n2, properties);
                throw throwable;
            }
            if (PmiReqMetrics.isComponentEnabled(this.pm.gConfigProps.reqMetricID)) {
                Properties properties = null;
                int n4 = PmiReqMetrics.getTranDetailLevel(object2, this.pm.gConfigProps.reqMetricID);
                if (n4 == 2 || n4 == 3) {
                    properties = new Properties();
                }
                if (n4 == 3) {
                    properties = (Properties)this.gConfigProps.raMetaDataProps.clone();
                }
                if (properties == null) {
                    PmiReqMetrics.reqStop(object2, this.pm.gConfigProps.reqMetricID, 2, n2);
                } else {
                    PmiReqMetrics.reqStop(object2, this.pm.gConfigProps.reqMetricID, 2, n2, properties);
                }
            }
            if (this.pm.gConfigProps.checkManagedConnectionInstanceof) {
                object = this.pm.gConfigProps.checkManagedConnectionInstanceofLock;
                synchronized (object) {
                    if (this.pm.gConfigProps.checkManagedConnectionInstanceof) {
                        block90: {
                            HashSet<ManagedConnection> hashSet = new HashSet<ManagedConnection>();
                            hashSet.add(managedConnection);
                            object2 = null;
                            if (PmiReqMetrics.isComponentEnabled(this.pm.gConfigProps.reqMetricID)) {
                                object2 = PmiReqMetrics.reqStart(this.pm.gConfigProps.reqMetricID, 2, new String[]{"javax.resource.spi.ManagedConnectionFactory", "matchManagedConnections(Set, Subject, ConnectionRequestInfo)"});
                            }
                            n2 = 2;
                            try {
                                try {
                                    int n5 = mCWrapper.getPoolState();
                                    mCWrapper.setPoolState(50);
                                    this._managedFactory.matchManagedConnections(hashSet, subject, connectionRequestInfo);
                                    n2 = 0;
                                    mCWrapper.setPoolState(n5);
                                }
                                catch (NotSupportedException notSupportedException) {
                                    this.gConfigProps.setConnectionPoolingEnabled(false);
                                    Object var17_35 = null;
                                    if (!PmiReqMetrics.isComponentEnabled(this.pm.gConfigProps.reqMetricID)) break block90;
                                    Properties properties = null;
                                    int n6 = PmiReqMetrics.getTranDetailLevel(object2, this.pm.gConfigProps.reqMetricID);
                                    if (n6 == 2 || n6 == 3) {
                                        properties = new Properties();
                                    }
                                    if (n6 == 3) {
                                        properties = (Properties)this.gConfigProps.raMetaDataProps.clone();
                                    }
                                    if (properties == null) {
                                        PmiReqMetrics.reqStop(object2, this.pm.gConfigProps.reqMetricID, 2, n2);
                                        break block90;
                                    } else {
                                        PmiReqMetrics.reqStop(object2, this.pm.gConfigProps.reqMetricID, 2, n2, properties);
                                    }
                                    break block90;
                                }
                                Object var17_34 = null;
                            }
                            catch (Throwable throwable) {
                                Object var17_36 = null;
                                if (!PmiReqMetrics.isComponentEnabled(this.pm.gConfigProps.reqMetricID)) throw throwable;
                                Properties properties2 = null;
                                int n7 = PmiReqMetrics.getTranDetailLevel(object2, this.pm.gConfigProps.reqMetricID);
                                if (n7 == 2 || n7 == 3) {
                                    properties2 = new Properties();
                                }
                                if (n7 == 3) {
                                    properties2 = (Properties)this.gConfigProps.raMetaDataProps.clone();
                                }
                                if (properties2 == null) {
                                    PmiReqMetrics.reqStop(object2, this.pm.gConfigProps.reqMetricID, 2, n2);
                                    throw throwable;
                                }
                                PmiReqMetrics.reqStop(object2, this.pm.gConfigProps.reqMetricID, 2, n2, properties2);
                                throw throwable;
                            }
                            if (PmiReqMetrics.isComponentEnabled(this.pm.gConfigProps.reqMetricID)) {
                                Properties properties = null;
                                int n6 = PmiReqMetrics.getTranDetailLevel(object2, this.pm.gConfigProps.reqMetricID);
                                if (n6 == 2 || n6 == 3) {
                                    properties = new Properties();
                                }
                                if (n6 == 3) {
                                    properties = (Properties)this.gConfigProps.raMetaDataProps.clone();
                                }
                                if (properties == null) {
                                    PmiReqMetrics.reqStop(object2, this.pm.gConfigProps.reqMetricID, 2, n2);
                                } else {
                                    PmiReqMetrics.reqStop(object2, this.pm.gConfigProps.reqMetricID, 2, n2, properties);
                                }
                            }
                        }
                        if (managedConnection instanceof DissociatableManagedConnection) {
                            this.pm.gConfigProps.setSmartHandleSupport(true);
                            this.pm.createParkedConnection = false;
                            this.pm.gConfigProps.setInstanceOfDissociatableManagedConnection(true);
                        }
                        if (managedConnection instanceof SynchronizationProvider) {
                            this.gConfigProps.setConnectionSynchronizationProvider(true);
                        }
                        if (managedConnection instanceof DissociatableManagedConnection) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Managed connection is an instance of DissociatableManagedConnection");
                            }
                            EJBJ2CHandleLink.inactiveConnectionSupport = true;
                            this.pm.gConfigProps.setInstanceOfDissociatableManagedConnection(true);
                        }
                        if (managedConnection instanceof LazyEnlistableManagedConnection) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Managed connection is an instance of LazyEnlistableManagedConnection");
                            }
                            this.pm.gConfigProps.setTransactionResourceRegistration("dynamic");
                            this.pm.gConfigProps.setDynamicEnlistmentSupported(true);
                        }
                        this.pm.writer = new TraceWriter(managedConnection.getClass().getName());
                        this.pm.traceWriter = (TraceWriter)this.pm.writer;
                        this.pm.printWriter = new PrintWriter(this.pm.writer);
                        this.pm.gConfigProps.setCheckManagedConnectionInstanceof(false);
                    }
                }
            }
            if (tc.isDebugEnabled() || this.pm.requestGroupEnabled) {
                ++this.freePoolCreateManagedConnection;
                this.pm.processPoolRequestStats(10);
            }
            mCWrapper.setFatalErrorValue(this.fatalErrorNotificationTime + 1);
            mCWrapper.setSubjectCRIHashCode(n);
            mCWrapper.setSubject(subject);
            mCWrapper.setCRI(connectionRequestInfo);
            mCWrapper.setSupportsReAuth(this.gConfigProps.raSupportsReauthentication);
            mCWrapper.setConnectionSynchronizationProvider(this.gConfigProps.connectionSynchronizationProvider);
            if (this.check_WSRdbManagedConnectionImpl) {
                try {
                    if (((WSRdbManagedConnectionImpl)mCWrapper.getManagedConnection()).isEnlistmentDisabled()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Managed connection isEnlistmentDisabled is true.");
                        }
                        ((MCWrapper)mCWrapper).setEnlistmentDisabled(true);
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Managed connection isEnlistmentDisabled is false.");
                        }
                        ((MCWrapper)mCWrapper).setEnlistmentDisabled(false);
                    }
                }
                catch (ClassCastException classCastException) {
                    this.check_WSRdbManagedConnectionImpl = false;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "pm = ", this.pm);
                Tr.debug(tc, "traceWriter = ", this.pm.traceWriter);
            }
            if (this.pm.traceWriter.isTraceEnabled()) {
                managedConnection.setLogWriter(this.pm.printWriter);
                mCWrapper.setLogWriterSet(true);
            }
            if (this.gConfigProps.isConnectionPoolingEnabled() && this.pm.reapTime > 0 && !this.pm.alarmThreadStarted) {
                object = this.pm.amLockObject;
                synchronized (object) {
                    if (!this.pm.alarmThreadStarted) {
                        if (this.pm.agedTimeout < 1) {
                            if (this.pm.totalConnectionCount > this.pm.minConnections) {
                                if (this.pm.nonDeferredReaperAlarm) {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Creating non-deferrable alarm for reaper");
                                    }
                                    this.pm.am = AlarmManager.createNonDeferrable(this.pm.reapTime * 1000, this.pm);
                                } else {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Creating deferrable alarm for reaper");
                                    }
                                    this.pm.am = AlarmManager.createDeferrable(this.pm.reapTime * 1000, this.pm);
                                }
                                this.pm.alarmThreadStarted = true;
                            }
                        } else if (this.pm.totalConnectionCount > 0) {
                            if (this.pm.nonDeferredReaperAlarm) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Creating non-deferrable alarm for reaper");
                                }
                                this.pm.am = AlarmManager.createNonDeferrable(this.pm.reapTime * 1000, this.pm);
                            } else {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Creating deferrable alarm for reaper");
                                }
                                this.pm.am = AlarmManager.createDeferrable(this.pm.reapTime * 1000, this.pm);
                            }
                            this.pm.alarmThreadStarted = true;
                        }
                    }
                }
            }
            if (this.pmiData != null) {
                this.pmiData.managedConnectionCreated();
            }
        }
        catch (RRAInternalResourceException rRAInternalResourceException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Internal getConnection failure", (Object)rRAInternalResourceException);
            }
            ResourceAllocationException resourceAllocationException = new ResourceAllocationException(rRAInternalResourceException.getMessage(), rRAInternalResourceException.getErrorCode());
            resourceAllocationException.initCause(rRAInternalResourceException.getCause());
            Object object = this.pm.updateToPoolInProgressLockObject;
            synchronized (object) {
                --this.pm.activeRequest;
                throw resourceAllocationException;
            }
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.j2c.poolmanager.FreePool.createManagedConnectionWithMCWrapper", "199", this);
            Object[] objectArray = new Object[]{"createManagedConnectionWithMCWrapper", ConnectorRuntime.exceptionList(resourceException), "ResourceAllocationException", this.gConfigProps.pmiName};
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "POOL_MANAGER_EXCP_CCF2_0002_J2CA0046", objectArray);
            }
            ResourceAllocationException resourceAllocationException = new ResourceAllocationException(resourceException.getMessage(), resourceException.getErrorCode());
            resourceAllocationException.initCause(resourceException.getCause());
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "Abnormal exit from method createManagedConnectionWithMCWrapper");
            }
            Object object = this.pm.updateToPoolInProgressLockObject;
            synchronized (object) {
                --this.pm.activeRequest;
                throw resourceAllocationException;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.j2c.poolmanager.FreePool.createManagedConnectionWithMCWrapper", "545", this);
            Object[] objectArray = new Object[]{"createManagedConnectionWithMCWrapper", ConnectorRuntime.exceptionList(exception), "ResourceAllocationException", this.gConfigProps.pmiName};
            Tr.error(tc, "POOL_MANAGER_EXCP_CCF2_0002_J2CA0046", objectArray);
            ResourceAllocationException resourceAllocationException = new ResourceAllocationException(exception.getMessage());
            resourceAllocationException.initCause((Throwable)exception);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "Abnormal exit from method createManagedConnectionWithMCWrapper");
            }
            Object object = this.pm.updateToPoolInProgressLockObject;
            synchronized (object) {
                --this.pm.activeRequest;
                throw resourceAllocationException;
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return mCWrapper;
        if (!tc.isEntryEnabled()) return mCWrapper;
        Tr.exit(tc, "createManagedConnectionWithMCWrapper " + mCWrapper);
        return mCWrapper;
    }

    protected int getNumberOfConnectionInFreePool() {
        return this.mcWrapperList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCleanupAndDestroyAllFreeConnections() {
        int n;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeCleanupAndDestroyAllFreeConnections");
        }
        for (int i = n = this.mcWrapperList.size() - 1; i >= 0; --i) {
            com.ibm.ws.j2c.MCWrapper mCWrapper = (com.ibm.ws.j2c.MCWrapper)this.mcWrapperList.remove(i);
            mCWrapper.setPoolState(0);
            --this.numberOfConnectionsAssignedToThisFreePool;
            this.cleanupAndDestroyMCWrapper(mCWrapper);
            Object object = this.pm.poolManagerTotalCountLock;
            synchronized (object) {
                --this.pm.totalConnectionCount;
                if (this.pm.loadGroupEnabled) {
                    this.pm.processAvePoolLoad();
                }
                if (this.pm.surgeCounter > 0) {
                    --this.pm.surgeCounter;
                    if (this.pm.surgeModeAlertEnabled && this.pm.surgeCounter == 1) {
                        AlertController.checkPoint(PoolManager.alertLogger, this.pm, this.gConfigProps.surgeModeAlertConfig);
                    }
                }
            }
            this._mcWrapperPool.releaseInstance(mCWrapper);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeCleanupAndDestroyAllFreeConnections");
        }
    }

    protected void nullPMref() {
        this.pm = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "FreePool nulled PM ref");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupAndDestroyAllFreeConnections() {
        int n;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanupAndDestroyAllFreeConnections");
        }
        for (int i = n = this.mcWrapperList.size() - 1; i >= 0; --i) {
            com.ibm.ws.j2c.MCWrapper mCWrapper = (com.ibm.ws.j2c.MCWrapper)this.mcWrapperList.remove(i);
            mCWrapper.setPoolState(0);
            Object object = this.pm.poolManagerTotalCountLock;
            synchronized (object) {
                --this.pm.totalConnectionCount;
                if (this.pm.surgeCounter > 0) {
                    --this.pm.surgeCounter;
                    if (this.pm.surgeModeAlertEnabled && this.pm.surgeCounter == 1) {
                        AlertController.checkPoint(PoolManager.alertLogger, this.pm, this.gConfigProps.surgeModeAlertConfig);
                    }
                }
                if (this.pm.loadGroupEnabled) {
                    this.pm.processAvePoolLoad();
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling cleanup and destroy on MCWrapper " + mCWrapper);
            }
            this.cleanupAndDestroyMCWrapper(mCWrapper);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanupAndDestroyAllFreeConnections");
        }
    }

    protected int getSize() {
        return this.mcWrapperList.size();
    }

    protected MCWrapperList getMCWrapperList() {
        return this.mcWrapperList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FreePool object:");
        stringBuffer.append("  Number of connection in free pool: ");
        Object object = this.freeConnectionLockObject;
        synchronized (object) {
            stringBuffer.append(this.getNumberOfConnectionInFreePool());
            stringBuffer.append(this.nl);
            stringBuffer.append(this.mcWrapperList);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeMCWrapperFromList(com.ibm.ws.j2c.MCWrapper mCWrapper) {
        Object object = this.freeConnectionLockObject;
        synchronized (object) {
            boolean bl = this.mcWrapperList.remove(mCWrapper);
            if (bl) {
                mCWrapper.setPoolState(0);
            }
            if (this.pm.loadGroupEnabled) {
                this.pm.processAvePoolLoad();
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementFatalErrorValue(int n, int n2) {
        if (this.fatalErrorNotificationTime == 0x7FFFFFFE) {
            this.fatalErrorNotificationTime = 0;
            if (n == 0 && n2 == 0) {
                Object object = this.pm.mcToMCWMapLock;
                synchronized (object) {
                    Collection collection = this.pm.mcToMCWMap.values();
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        com.ibm.ws.j2c.MCWrapper mCWrapper = (com.ibm.ws.j2c.MCWrapper)iterator.next();
                        if (mCWrapper.isParkedWrapper()) continue;
                        mCWrapper.setFatalErrorValue(0);
                    }
                }
            }
        } else {
            ++this.fatalErrorNotificationTime;
        }
    }

    protected int getFatalErrorNotificationTime() {
        return this.fatalErrorNotificationTime;
    }

    protected void setFatalErrorNotificationTime(int n) {
        this.fatalErrorNotificationTime = n;
    }

    class Equals
    implements PrivilegedAction {
        Subject _s1;
        Subject _s2;

        Equals() {
        }

        public final void setSubjects(Subject subject, Subject subject2) {
            this._s1 = subject;
            this._s2 = subject2;
        }

        public Object run() {
            boolean bl = false;
            if (this.checkPrivateCredentials(this._s2.getPrivateCredentials())) {
                bl = this.checkPublicCredentials(this._s2.getPublicCredentials());
            }
            return bl;
        }

        private boolean checkPublicCredentials(Set set) {
            boolean bl = false;
            if (this._s1.getPublicCredentials() != set) {
                if (this._s1.getPublicCredentials() != null && set != null) {
                    bl = ((Object)this._s1.getPublicCredentials()).equals(set);
                }
            } else {
                bl = true;
            }
            return bl;
        }

        private boolean checkPrivateCredentials(Set set) {
            boolean bl = false;
            if (this._s1.getPrivateCredentials() != set) {
                if (this._s1.getPrivateCredentials() != null && set != null) {
                    bl = ((Object)this._s1.getPrivateCredentials()).equals(set);
                }
            } else {
                bl = true;
            }
            return bl;
        }
    }
}

