/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.naming.JndiHelper;
import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class J2CJndiHelper {
    private static final TraceComponent tc = Tr.register(J2CJndiHelper.class, "WAS.j2c", "com.ibm.ws.j2c.resources.J2CAMessages");
    Context _startingContext = null;
    HashMap _nameBindings = null;
    List _namesBound = null;
    HashMap _failedNames = null;
    private BindNamesPrivileged _bindNames = null;
    private UnbindNamesPrivileged _unbindNames = null;
    Thread _instanceThread = null;
    static Context _initialContext = null;
    String _instanceThreadOid = null;
    String _oid = null;

    private J2CJndiHelper() {
    }

    public J2CJndiHelper(Context context) {
        this._startingContext = context != null ? context : this.getInitialContext();
        this._instanceThread = Thread.currentThread();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            this._oid = J2CJndiHelper.objectId(this);
            this._instanceThreadOid = RasHelper.getThreadId();
            Tr.debug(tc, this._oid + ": New J2CJndiHelper for context " + J2CJndiHelper.objectId(this._startingContext) + " on thread " + this._instanceThreadOid);
        }
    }

    public Context getInitialContext() {
        block3: {
            if (_initialContext == null) {
                try {
                    _initialContext = new InitialContext();
                }
                catch (NamingException namingException) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, this._oid + ": An unexpected exception occurred getting the initial context: " + namingException + "; see FFDC log, probe ID=155.");
                    FFDCFilter.processException((Throwable)namingException, "com.ibm.ejs.j2c.J2CJndiHelper.getInitialContext", "155", this);
                }
            }
        }
        return _initialContext;
    }

    public static String objectId(Object object) {
        return object == null ? "0x0" : Integer.toHexString(object.hashCode());
    }

    public void addNameBinding(String string, Object object) {
        this.checkMultiThreadUse();
        if (string == null || object == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, this._oid + ": Binding not added because the JNDI name (" + string + ") or binding (" + object + ") is null.");
            }
        } else {
            if (this._nameBindings == null) {
                this._nameBindings = new HashMap(5);
            }
            this._nameBindings.put(string, object);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, this._oid + ": Binding added for JNDI name " + string + ".");
            }
        }
    }

    private final void checkMultiThreadUse() throws IllegalStateException {
        if (this._instanceThread != Thread.currentThread()) {
            throw new IllegalStateException(this._oid + ": Usage error: The current thread (" + RasHelper.getThreadId() + ")" + " differs from the thread that created this instance (" + this._instanceThreadOid + ").");
        }
    }

    public Object removeNameBinding(String string) {
        this.checkMultiThreadUse();
        Object var2_2 = null;
        if (!this.hasNameBindings()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, this._oid + ": No JNDI names to remove.");
            }
        } else {
            var2_2 = this._nameBindings.remove(string);
            if (var2_2 == null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to remove binding for JNDI name " + string + ".");
            }
        }
        return var2_2;
    }

    protected final boolean hasNameBindings() {
        return this._nameBindings != null && this._nameBindings.size() > 0;
    }

    public void bindNames() throws NamingException {
        if (!this.hasNameBindings()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, this._oid + ": No JNDI names to bind.");
            }
        } else {
            this.bindNames(this._nameBindings.keySet().toArray(new String[this._nameBindings.size()]));
        }
    }

    public void bindNames(String[] stringArray) throws NamingException {
        this.checkMultiThreadUse();
        if (stringArray == null || stringArray.length <= 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, this._oid + ": No JNDI names to bind.");
            }
        } else if (this.isGlobalSecurityEnabled()) {
            if (this._bindNames == null) {
                this._bindNames = new BindNamesPrivileged(this);
            }
            this._bindNames.setNames(stringArray);
            try {
                ContextManagerFactory.getInstance().runAsSystem(this._bindNames);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (NamingException)privilegedActionException.getException();
            }
            finally {
                this._bindNames.setNames(null);
            }
        } else {
            this.bindNames1(stringArray);
        }
    }

    public String getFailedName(Exception exception) {
        this.checkMultiThreadUse();
        return this._failedNames == null ? null : this._failedNames.get(exception);
    }

    public void unbindNames() {
        if (!this.hasNamesBound()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, this._oid + ": No JNDI names to unbind.");
            }
        } else {
            this.unbindNames1(this._namesBound.toArray(new String[this._namesBound.size()]));
        }
    }

    private final boolean hasNamesBound() {
        return this._namesBound != null && this._namesBound.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindNames(String[] stringArray) {
        this.checkMultiThreadUse();
        if (stringArray == null || stringArray.length <= 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, this._oid + ": No JNDI names to unbind.");
            }
        } else if (this.isGlobalSecurityEnabled()) {
            if (this._unbindNames == null) {
                this._unbindNames = new UnbindNamesPrivileged(this);
            }
            this._unbindNames.setNames(stringArray);
            try {
                ContextManagerFactory.getInstance().runAsSystem(this._unbindNames);
            }
            catch (PrivilegedActionException privilegedActionException) {
            }
            finally {
                this._unbindNames.setNames(null);
            }
        } else {
            this.unbindNames1(stringArray);
        }
    }

    public void reset() {
        this.checkMultiThreadUse();
        if (this._nameBindings != null) {
            this._nameBindings.clear();
        }
        if (this._namesBound != null) {
            this._namesBound.clear();
        }
        if (this._failedNames != null) {
            this._failedNames.clear();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, this._oid + ": Reset this instance");
        }
    }

    void recursiveRebind(String string, Object object) throws NamingException {
        JndiHelper.recursiveRebind(this._startingContext, string, object);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, this._oid + ": Bound JNDI name " + string + " into the starting context.");
        }
    }

    void unbind(String string) throws NamingException {
        this._startingContext.unbind(string);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, this._oid + ": Unbound JNDI name " + string + " from the starting context.");
        }
    }

    boolean isGlobalSecurityEnabled() {
        return WSSecurityHelper.isGlobalSecurityEnabled();
    }

    protected final void bindNames1(String[] stringArray) throws NamingException {
        if (this._namesBound == null) {
            this._namesBound = new ArrayList();
        }
        String string = null;
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                string = stringArray[i];
                this.recursiveRebind(string, this._nameBindings.get(string));
                this._namesBound.add(string);
            }
        }
        catch (NamingException namingException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, this._oid + ": An unexpected exception occurred binding JNDI name " + string + ": " + namingException + ".");
            }
            if (this._failedNames == null) {
                this._failedNames = new HashMap(3);
            }
            this._failedNames.put(namingException, string);
            throw namingException;
        }
    }

    protected final void unbindNames1(String[] stringArray) {
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i];
            try {
                this.unbind(string);
                if (this._namesBound == null || !this._namesBound.remove(string) || !TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, this._oid + ": Removed binding for JNDI name " + string + ".");
                continue;
            }
            catch (NamingException namingException) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, this._oid + ": An unexpected exception occurred unbinding JNDI name " + string + ": " + namingException + "; see FFDC log, probe ID=490.");
                FFDCFilter.processException((Throwable)namingException, "com.ibm.ejs.j2c.J2CJndiHelper.unbindNames", "490", this);
            }
        }
    }

    final class UnbindNamesPrivileged
    implements PrivilegedExceptionAction {
        J2CJndiHelper _helper = null;
        String[] _names = null;

        public UnbindNamesPrivileged(J2CJndiHelper j2CJndiHelper2) {
            this._helper = j2CJndiHelper2;
        }

        public final void setNames(String[] stringArray) {
            this._names = stringArray;
        }

        public final Object run() throws Exception {
            this._helper.unbindNames1(this._names);
            return null;
        }
    }

    final class BindNamesPrivileged
    implements PrivilegedExceptionAction {
        J2CJndiHelper _helper = null;
        String[] _names = null;

        public BindNamesPrivileged(J2CJndiHelper j2CJndiHelper2) {
            this._helper = j2CJndiHelper2;
        }

        public final void setNames(String[] stringArray) {
            this._names = stringArray;
        }

        public final Object run() throws Exception {
            this._helper.bindNames1(this._names);
            return null;
        }
    }
}

