/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.j2c.RALifeCycleManagerImpl;
import com.ibm.ejs.j2c.RAWrapperImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.j2c.RALifeCycleManagerFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.resource.ResourceException;

public class J2CServerListener
implements PropertyChangeListener {
    private static final TraceComponent _tc = Tr.register(J2CServerListener.class, "WAS.j2c", "com.ibm.ws.j2c.resources.J2CAMessages");
    private static final boolean _deferEndpointActivationEnabled = Boolean.valueOf(System.getProperty("com.ibm.ejs.j2c.J2CServerListener.deferEndpointActivation"));
    private static final boolean _activateEndpointsOnServerStarted;
    private static final boolean _deactivateEndpointsOnServerStopping;
    private static J2CServerListener _instance;
    private static boolean _deferEndpointActivation;
    private static boolean _earlyEndpointDeactivation;
    private static Object _mutex;

    public static J2CServerListener getInstance() {
        if (_instance == null) {
            _instance = new J2CServerListener();
        }
        return _instance;
    }

    private J2CServerListener() {
    }

    public static boolean deferEndpointActivation() {
        return _deferEndpointActivation;
    }

    public static boolean earlyEndpointDeactivation() {
        return _earlyEndpointDeactivation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        block21: {
            Object object;
            String string;
            block20: {
                if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
                    Tr.entry(_tc, "propertyChange", "Server event=" + (String)propertyChangeEvent.getNewValue());
                }
                string = (String)propertyChangeEvent.getNewValue();
                if (_activateEndpointsOnServerStarted) {
                    try {
                        if (string.equals("STARTING")) {
                            _deferEndpointActivation = true;
                            break block20;
                        }
                        if (!string.equals("STARTED")) break block20;
                        _deferEndpointActivation = false;
                        object = _mutex;
                        synchronized (object) {
                            this.resumeInboundRAs();
                        }
                    }
                    catch (Exception exception) {
                        if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                            Tr.debug(_tc, "An unexpected exception occurred processing server event=" + propertyChangeEvent + "; see FFDC probe ID=150");
                        }
                        FFDCFilter.processException(exception, "com.ibm.ejs.j2c.J2CServerListener.propertyChange", "150");
                    }
                }
            }
            if (_deactivateEndpointsOnServerStopping) {
                try {
                    if (string.equals("STOPPING")) {
                        _earlyEndpointDeactivation = true;
                        _deferEndpointActivation = false;
                        object = _mutex;
                        synchronized (object) {
                            this.pauseInboundRAs();
                            break block21;
                        }
                    }
                    if (string.equals("STOPPED")) {
                        _earlyEndpointDeactivation = false;
                    }
                }
                catch (Exception exception) {
                    if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                        Tr.debug(_tc, "An unexpected exception occurred processing server event=" + propertyChangeEvent + "; see FFDC probe ID=175");
                    }
                    FFDCFilter.processException(exception, "com.ibm.ejs.j2c.J2CServerListener.propertyChange", "175");
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.debug(_tc, "deferEndpointActivation=" + _deferEndpointActivation);
            Tr.debug(_tc, "earlyEndpointDeactivation=" + _earlyEndpointDeactivation);
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.exit(_tc, "propertyChange");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeInboundRAs() {
        Hashtable hashtable;
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.entry(_tc, "resumeInboundRAs");
        }
        Hashtable hashtable2 = hashtable = ((RALifeCycleManagerImpl)RALifeCycleManagerFactory.getInstance()).getRaHashtable();
        synchronized (hashtable2) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements() && !_earlyEndpointDeactivation) {
                Object object;
                String string = (String)enumeration.nextElement();
                if (string != null) {
                    object = (RAWrapperImpl)hashtable.get(string);
                    if (object == null || !((RAWrapperImpl)object).getPausedInbound()) continue;
                    try {
                        ((RAWrapperImpl)object).resumeRAInbound();
                    }
                    catch (Exception exception) {
                        if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                            Tr.debug(_tc, "An unexpected exception occurred resuming RA=" + string + "; see FFDC probe ID=125");
                        }
                        FFDCFilter.processException(exception, "com.ibm.ejs.j2c.J2CServerListener.resumeInboundRAs", "125");
                    }
                    continue;
                }
                object = new ResourceException("RAKey is null");
                Tr.error(_tc, "BAD_RAKEY_J2CA0029", object);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.exit(_tc, "resumeInboundRAs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pauseInboundRAs() {
        Hashtable hashtable;
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.entry(_tc, "pauseInboundRAs");
        }
        Hashtable hashtable2 = hashtable = ((RALifeCycleManagerImpl)RALifeCycleManagerFactory.getInstance()).getRaHashtable();
        synchronized (hashtable2) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements() && !_deferEndpointActivation) {
                Object object;
                String string = (String)enumeration.nextElement();
                if (string != null) {
                    object = (RAWrapperImpl)hashtable.get(string);
                    if (object == null || ((RAWrapperImpl)object).getPausedInbound()) continue;
                    try {
                        ((RAWrapperImpl)object).pauseRAInbound();
                    }
                    catch (Exception exception) {
                        if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                            Tr.debug(_tc, "An unexpected exception occurred pausing RA=" + string + "; see FFDC probe ID=225");
                        }
                        FFDCFilter.processException(exception, "com.ibm.ejs.j2c.J2CServerListener.pauseInboundRAs", "225");
                    }
                    continue;
                }
                object = new ResourceException("RAKey is null");
                Tr.error(_tc, "BAD_RAKEY_J2CA0029", object);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.exit(_tc, "pauseInboundRAs");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "Defer endpoint activation enabled=" + _deferEndpointActivationEnabled);
        }
        boolean bl = _activateEndpointsOnServerStarted = _deferEndpointActivationEnabled || Boolean.valueOf(System.getProperty("com.ibm.ejs.j2c.J2CServerListener.activateEndpointsOnServerStarted")) != false;
        if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "Activate endpoints on server started=" + _activateEndpointsOnServerStarted);
        }
        boolean bl2 = _deactivateEndpointsOnServerStopping = _deferEndpointActivationEnabled || Boolean.valueOf(System.getProperty("com.ibm.ejs.j2c.J2CServerListener.deactivateEndpointsOnServerStopping")) != false;
        if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "Deactivate endpoints on server stopping=" + _deactivateEndpointsOnServerStopping);
        }
        _instance = null;
        _deferEndpointActivation = false;
        _earlyEndpointDeactivation = false;
        _mutex = new Object();
    }
}

